<?php
ini_set('display_errors', 0);

/*error_reporting(E_ALL & ~E_NOTICE);
error_reporting(E_ERROR);
ini_set('display_errors', 1);*/

require_once(dirname(__FILE__) . '/Controllers/Controller.php');
require_once(dirname(__FILE__) . '/Controllers/Service.php');
require_once(dirname(__FILE__) . '/Controllers/ServiceSegmentations.php');
require_once(dirname(__FILE__) . '/Model/Reports.php');

$ctrl = new Controller();
$sercive = new Service();
$serviceSegmentations = new ServiceSegmentations();
$report = new Reports();

//HTTP CONNECTION SECURITY LAYER
$ctrl->setFirstSecurityLayer();

$method = $_SERVER['REQUEST_METHOD'];
if($method == 'POST') {
	//HTTP POST DATA SECURITY LAYER

	$ctrl->setSecondSecurityLayer($_POST);

	//WEBSERVICES LAYER
	$action = $ctrl->getHttpPostAction();

	switch($action) {
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//LOGIN WEBSERVICES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Validar token GET
		case 'validateDirectToken':
			$response = $ctrl->validateDirectToken();
			returnResponse($response);
			break;

			// PreLogin
		case 'preLogin':
			$response = $ctrl->preLogin();
			returnResponse($response);
			break;

			// Login
		case 'authenticate':
			$response = $ctrl->loginWeb();
			returnResponse($response);
			break;

			// Refrescar
		case 'refreshToken':
			$response = $ctrl->refreshToken();
			returnResponse($response);
			break;

		/* TTT ESPECIAL 09/02/23 */
			// Petición de respuestas/participantes de encuesta
		/* case 'getAnswersSurvey':
			$response = $ctrl->getAnswersSurvey();
			returnResponse($response);
			break; */
		/* TTT ESPECIAL 09/02/23 */

		case 'getUserAPI':
			$response = $ctrl->getUserAPI();
			returnResponse($response);
			break;

			// Petición de RSC específico
		case 'getRSC':
			$response = $ctrl->getRSC();
			returnResponse($response);
			break;

			// Petición de RSC por lenguaje
		case 'getAllRSCByLenguage':
			$response = $ctrl->getAllRSCByLenguage();
			returnResponse($response);
			break;

			// Ejecutar distribución de licencias
		case 'distributeLicencesByPercentage':
			$response = $ctrl->distributeLicencesByPercentage();
			returnResponse($response);
			break;

			// Petición de avisos de cumplimiento
		case 'getAllAvisosDisableUserAuto':
			$response = $ctrl->getAllAvisosDisableUserAuto();
			returnResponse($response);
			break;

			// Modificación de avisos de cumplimiento
		case 'deleteAllAvisosDisableUserAuto':
			$response = $ctrl->deleteAllAvisosDisableUserAuto();
			returnResponse($response);
			break;

		case 'getColaMisionesPendientes':
			$response = $ctrl->getColaMisionesPendientes();
			returnResponse($response);
			break;

		case 'updateMisionInicioNotificado':
			$response = $ctrl->clientUpdateMisionInicioNotificado();
			returnResponse($response);
			break;

		case 'updateMisionFinNotificado':
			$response = $ctrl->clientUpdateMisionFinNotificado();
			returnResponse($response);
			break;

			// Petición de proyectos
		case 'getProjectsByMision':
			$response = $ctrl->getProjectsByMision();
			returnResponse($response);
			break;

			// Petición de todas las tablas de las preguntas ¿TTT?
		case 'getAnalyticsMuestraToExport':
			$response = $ctrl->getAnalyticsMuestraToExport();
			returnResponse($response);
			break;

			// Petición de misiones
		case 'getAllMisionesByProject':
			$response = $ctrl->getAllMisionesByProject();
			returnResponse($response);
			break;

			// Petición de datos generales por país
		case 'getMainDashboardByContry':
			$response = $ctrl->getMainDashboardByContry();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ÚTILES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de funcionalidades
		case 'getSystemConfig':
			$response = $ctrl->getSystemConfig();
			returnResponse($response);
			break;

		case 'getDomain':
			$response = $ctrl->getDomain();
			returnResponse($response);
			break;

			// Configuración de BOTS para usuarios o grupos
		case 'getBotConfig':
			$response = $ctrl->getBotConfig();
			returnResponse($response);
			break;

			// Configuración de asistente de voz para usuarios o grupos
		case 'getVoiceAssistantConfig':
			$response = $ctrl->getVoiceAssistantConfig();
			returnResponse($response);
			break;

			// Petición de países activos
		case 'getPaisesEnabled':
			$response = $ctrl->getPaisesEnabled();
			returnResponse($response);
			break;

			// Envío de notificaciones múltiples
		case 'postMessageMultiple':
			$response = $ctrl->postMessageMultiple();
			returnResponse($response);
			break;

			// Idiomas
		case 'getIdiomas':
			$response = $ctrl->getIdiomas();
			returnResponse($response);
			break;

			// Paises
		case 'getPaises':
			$response = $ctrl->getPaises();
			returnResponse($response);
			break;

			// Información de un país por su iso
		case 'getPaisByID':
			$response = $ctrl->getPaisByID();
			returnResponse($response);
			break;

			// Borrado de archivo en servidor
		case 'deleteFile':
			$response = $ctrl->deleteFile();
			returnResponse($response);
			break;

			// Borrado de carpeta en servidor
		case 'deleteFolder':
			$response = $ctrl->deleteFolder();
			returnResponse($response);
			break;

			// Número de licencias libres
		case 'getFreeLicences':
			$response = $ctrl->getFreeLicences();
			returnResponse($response);
			break;

			// Actualización de fecha de blog
		case 'setLastVersionControlled':
			$response = $ctrl->setLastVersionControlled();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//USUARIOS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Todos los usuarios
		case 'getAllUsers':
			$response = $ctrl->getAllUsers();
			returnResponse($response);
			break;

			// Usuario por email
		case 'getUserData':
			$response = $ctrl->getUserData();
			returnResponse($response);
			break;

			// Información adicional de usuario
		case 'getUserExtendedInfo':
			$response = $ctrl->getUserExtendedInfo();
			returnResponse($response);
			break;

			// Petición de grupos de usuario
		case 'getUserGroups':
			$response = $ctrl->getUserGroups();
			returnResponse($response);
			break;

			// Añadir usuario nuevo
		case 'newUser':
			$response = $ctrl->newUser();
			returnResponse($response);
			break;

			// Cambiar contraseña
		case 'changePass':
			$response = $ctrl->changePass();
			returnResponse($response);
			break;

			// Detalle de pagos al usuario
		case 'getDetallePagosByUser':
			$response = $ctrl->getDetallePagosByUser();
			returnResponse($response);
			break;

			// Editar usuario
		case 'editUser':
			$response = $ctrl->editUser();
			returnResponse($response);
			break;

			// Comprobación de derecho al olvido
		case 'isUserForgotten':
			$response = $ctrl->isUserForgotten();
			returnResponse($response);
			break;

			// Derecho al olvido
		case 'forgetUser':
			$response = $ctrl->forgetUser();
			returnResponse($response);
			break;

			// Derecho al olvido para CPG
		case 'disabledCPG':
			$response = $ctrl->disabledCPG();
			returnResponse($response);
			break;

			// Importar usuarios desde excel
		case 'importUsers':
			$response = $ctrl->importUsers();
			returnResponse($response);
			break;

			// Activación masiva de usuarios
		case 'activationUsers':
			$response = $ctrl->activationUsers();
			returnResponse($response);
			break;

			// Desactivación masiva de usuarios
		case 'deactivationUsers':
			$response = $ctrl->deactivationUsers();
			returnResponse($response);
			break;

			// Desasignar masiva de usuarios CPG
		case 'dessasignCPG':
			$response = $ctrl->dessasignCPG();
			returnResponse($response);
			break;

			// Petición de respuestas de perfilación
		case 'getPerfPosibleAnswers':
			$response = $ctrl->getPerfPosibleAnswers();
			returnResponse($response);
			break;

		/* TTT ESPECIAL 09/02/23 */
			// Comprobación de usuario para CPG
		/* case 'userExists':
			$response = $ctrl->userExists();
			returnResponse($response);
			break; */
		/* TTT ESPECIAL 09/02/23 */

			// Petición de todas las segmentaciones
		case 'getAllSegmentaciones':
			$response = $ctrl->getAllSegmentaciones();
			returnResponse($response);
			break;

			// Posibles respuestas a una pregunta de encuesta
		case 'getAllPosibleAnswersByQID':
			$response = $ctrl->getAllPosibleAnswersByQID();
			returnResponse($response);
			break;

			// Nueva segmentación
		case 'setSegmentacion':
			$response = $ctrl->setSegmentacion();
			returnResponse($response);
			break;

			// Eliminar segmentación
		case 'deleteSegmentacion':
			$response = $ctrl->deleteSegmentacion();
			returnResponse($response);
			break;

			// Petición de segmentación por ID
		case 'getSegmentacion':
			$response = $ctrl->getSegmentacion();
			returnResponse($response);
			break;

			// Editar segmentación
		case 'updateSegmentacion':
			$response = $ctrl->updateSegmentacion();
			returnResponse($response);
			break;

			// Ejecutar segmentación
		case 'executeSegmentation':
			$response = $ctrl->executeSegmentation();
			returnResponse($response);
			break;

			// Desactivación y consejero = 0 para usuarios con datos incongruentes
		case 'deactivateUnwelcomeCounselor':
			$response = $ctrl->deactivateUnwelcomeCounselor();
			returnResponse($response);
			break;

			// Petición de todas las segmentaciones programadas
		case 'getScheduledSegmentation':
			$response = $ctrl->getScheduledSegmentation();
			returnResponse($response);
			break;

			// Crear segmentación programada
		case 'setScheduledSegmentation':
			$response = $ctrl->setScheduledSegmentation();
			returnResponse($response);
			break;

			// Eliminar segmentaciones programadas
		case 'deleteScheduledSegmentation':
			$response = $ctrl->deleteScheduledSegmentation();
			returnResponse($response);
			break;

			// Editar segmentación programada
		case 'updateScheduledSegmentation':
			$response = $ctrl->updateScheduledSegmentation();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//GRUPOS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Todos los grupos
		case 'getAllGroups':
			$response = $ctrl->getAllGroups();
			returnResponse($response);
			break;

			// Añadir grupo nuevo
		case 'newGroup':
			$response = $ctrl->newGroup();
			returnResponse($response);
			break;

			// Eliminar grupo
		case 'deleteGroup':
			$response = $ctrl->deleteGroup();
			returnResponse($response);
			break;

			// Usuarios pertenecientes a un grupo
		case 'getAllUsersGroup':
			$response = $ctrl->getAllUsersGroup();
			returnResponse($response);
			break;

			// Editar grupo
		case 'editGroup':
			$response = $ctrl->editGroup();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//LISTAS DE DIFUSION
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de Listas de Difusión
		case 'getAllDistributionList':
			$response = $ctrl->getAllDistributionList();
			returnResponse($response);
			break;

			// Crear Lista de Difusión
		case 'createDistributionList':
			$response = $ctrl->createList();
			returnResponse($response);
			break;

			// Eliminar Lista de Difusión
		case 'deleteDistributionList':
			$response = $ctrl->deleteDistributionList();
			returnResponse($response);
			break;

			// Petición de miembros de la Lista de Difusión
		case 'getDistributionListUsers':
			$response = $ctrl->getDistributionListUsers();
			returnResponse($response);
			break;

			// Editar Lista de Difusión
		case 'updateDistributionList':
			$response = $ctrl->updateList();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ROLES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de Roles
		case 'getAllRoles':
			$response = $ctrl->getAllRoles();
			returnResponse($response);
			break;

			// Crear nuevo rol
		case 'newRole':
			$response = $ctrl->newRole();
			returnResponse($response);
			break;

			// Comprobación de rol a eliminar
		case 'roleStatus':
			$response = $ctrl->roleStatus();
			returnResponse($response);
			break;

			// Eliminar rol
		case 'deleteRole':
			$response = $ctrl->deleteRole();
			returnResponse($response);
			break;

			// Petición de rol
		case 'getRole':
			$response = $ctrl->getRole();
			returnResponse($response);
			break;

			// Petición del menu del role
		case 'getCustomMenuAvailableForRole':
			$response = $ctrl->getCustomMenuAvailableForRole();
			returnResponse($response);
			break;

			// Petición del menu del role
		case 'getUserCustomMenuRole':
			$response = $ctrl->getUserCustomMenuRole();
			returnResponse($response);
			break;

			// Editar rol
		case 'editRole':
			$response = $ctrl->editRole();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ANALYTICS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// ASESORES
		case 'getAnalyticsConsejeros':
			$response = $ctrl->getAnalyticsConsejeros();
			returnResponse($response);
			break;

			// Excel de asesores
		case 'getAnalyticsConsejerosToExport':
			$response = $ctrl->getAnalyticsConsejerosToExport();
			returnResponse($response);
			break;

		case 'getAnalyticsConsejerosInfo':
			$response = $ctrl->getAnalyticsConsejerosInfo();
			returnResponse($response);
			break;

		case 'getAnalyticsConsejerosAppVersion':
			$response = $ctrl->getAnalyticsConsejerosAppVersion();
			returnResponse($response);
			break;

			// Comprobación de perfilación de usuario
		case 'getIfUserPerfila':
			$response = $ctrl->getIfUserPerfila();
			returnResponse($response);
			break;

			// Envío de e-mail con numero de solicitud de licencias de asesores
		case 'sendEmailLicences':
			$response = $ctrl->sendEmailLicences();
			returnResponse($response);
			break;

			// CUMPLIMIENTO
		case 'getAnalyticsMisiones':
			$response = $ctrl->getAnalyticsMisiones();
			returnResponse($response);
			break;

			// Petición de Lista de Difusión OK/KO
		case 'getDistributionList':
			$response = $ctrl->getDistributionList();
			returnResponse($response);
			break;

			// Creación de Lista de Difusión OK/KO
		case 'createDistributionListOKKO':
			$response = $ctrl->createDistributionList();
			returnResponse($response);
			break;

			// Actualización de Lista de Difusión OK/KO
		case 'updateDistributionListOKKO':
			$response = $ctrl->updateDistributionList();
			returnResponse($response);
			break;

			// Petición de datos proyecto / misión en el momento
		case 'getSnapAcualMisionCumplimiento':
			$response = $ctrl->getSnapAcualMisionCumplimiento();
			returnResponse($response);
			break;

			// MUESTREO
			// Petición de encuestas
		case 'getAllSurveys':
			$response = $ctrl->getAllSurveys();
			returnResponse($response);
			break;

			// Petición de encuestas con misión
		case 'getAllSurveysWithMissions':
			$response = $ctrl->getAllSurveysWithMissions();
			returnResponse($response);
			break;

			// Petición de preguntas
		case 'getQuestionsSurvey':
			$response = $ctrl->getQuestionsSurvey();
			returnResponse($response);
			break;

			// Petición de gráficas
		case 'getAnalyticsMuestra':
			$response = $ctrl->getAnalyticsMuestra();
			returnResponse($response);
			break;

			// Petición de gráficas para muestreo dinámico
		case 'getAnalyticsMuestraDinamic':
			$response = $ctrl->getAnalyticsMuestraDinamic();
			returnResponse($response);
			break;

			// Petición de gráficas para muestreo dinámico filtrado
		case 'getAnswersSurveyByQueryDinamic':
			$response = $ctrl->getAnswersSurveyByQueryDinamic();
			returnResponse($response);
			break;

			// Petición de opciones para preguntas tipo ':'
		case 'getOptionsFor2PointsTypeQuetsion':
			$response = $ctrl->getOptionsFor2PointsTypeQuetsion();
			returnResponse($response);
			break;

			// Petición datos para generación de mapas en ppt
		case 'getCountryAndParticipation':
			$response = $ctrl->getCountryAndParticipation();
			returnResponse($response);
			break;

			// MUESTREO DETALLADO
		case 'getAnalyticsMuestraToExportByPerfQuestion':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfQuestion();
			returnResponse($response);
			break;

			// Petición de todas las tablas de las preguntas
		case 'getAnalyticsMuestraToExportByPerf':
			$response = $ctrl->getAnalyticsMuestraToExportByPerf();
			returnResponse($response);
			break;

			// MUESTREO DETALLADO MAZ
		case 'getAnalyticsMuestraToExportByPerfQuestionMAZ':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfQuestionMAZ();
			returnResponse($response);
			break;

			// Petición de todas las tablas de las preguntas
		case 'getAnalyticsMuestraToExportByPerfQuestionComaparativo':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfQuestionComaparativo();
			returnResponse($response);
			break;
			
			// Petición de todas las tablas de las preguntas
		case 'getAnalyticsMuestraToExportByPerfComparativo':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfComparativo();
			returnResponse($response);
			break;

			// Petición de todas las tablas de las preguntas
		case 'getAnalyticsMuestraToExportByPerfMAZ':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfMAZ();
			returnResponse($response);
			break;

			// MUESTREO DETALLADO MAZ SEGMENTO
		case 'getAnalyticsMuestraToExportByPerfQuestionMAZSegmento':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfQuestionMAZSegmento();
			returnResponse($response);
			break;

			// Petición de todas las tablas de las preguntas
		case 'getAnalyticsMuestraToExportByPerfMAZSegmento':
			$response = $ctrl->getAnalyticsMuestraToExportByPerfMAZSegmento();
			returnResponse($response);
			break;

			// Comprobación de la integridad de las encuestas
		case 'getIfSurveysAreEquals':
			$response = $ctrl->getIfSurveysAreEquals();
			returnResponse($response);
			break;

			// MUESTREO COMPARATIVO
			// Petición de datos para comparativa
		case 'getAnalyticsMuestraComparativa':
			$response = $ctrl->getAnalyticsMuestraComparativa();
			returnResponse($response);
			break;

			// CONVERSACIONES
			// Petición de Conversaciones
		case 'getAnalyticsConversacion':
			$response = $ctrl->getAnalyticsConversacion();
			returnResponse($response);
			break;

			// Petición de adjunto de Conversaciones
		case 'getAttachedConversation':
			$response = $ctrl->getAttachedConversation();
			returnResponse($response);
			break;

			// INVERSIÓN
			// Petición de Inversión
		case 'getAnalyticsInversion':
			$response = $ctrl->getAnalyticsInversion();
			returnResponse($response);
			break;

			// CATALOGACIÓN ASESORES
			// Catalogaciones
		case 'getCatalogacionesM':
			$response = $ctrl->getCatalogacionesM();
			returnResponse($response);
			break;

			// Petición de catalogación de consejeros
		case 'getCatalogacionesConsejeros':
			$response = $ctrl->getCatalogacionesConsejeros();
			returnResponse($response);
			break;

			// LICENCIAS
		case 'getStatusLicencesDetail':
			$response = $ctrl->getStatusLicencesDetail();
			returnResponse($response);
			break;

			// Exportar excel licencias
		case 'exportStatusLicences':
			$response = $ctrl->exportStatusLicences();
			returnResponse($response);
			break;

			// Petición de pregunta discriminante
		case 'getQuestionDiscriminante':
			$response = $ctrl->getQuestionDiscriminante();
			returnResponse($response);
			break;

			// PERFILACIÓN SIN FINALIZAR
			// Petición de Lista de consejeros sin perfilación
		case 'getAnalyticsConsejerosNoFinPerf':
			$response = $ctrl->getAnalyticsConsejerosNoFinPerf();
			returnResponse($response);
			break;

			// CDP
			// Petición de Lista de CDP - Usuarios
		case 'getDataIntegrationCDP':
			$response = $ctrl->getDataIntegrationCDP();
			returnResponse($response);
			break;

			// Petición de Lista de CDP - Encuestas
		case 'getAnalyticsMuestraToExport_CDP':
			$response = $ctrl->getAnalyticsMuestraToExport_CDP();
			returnResponse($response);
			break;

			// Ejecutar y actualizar CDP - Encuestas
		case 'sendCDPData':
			$response = $ctrl->sendCDPData();
			returnResponse($response);
			break;

			// Ejecutar y actualizar CDP - Encuestas
		case 'sendCDPDataUsers':
			$response = $ctrl->sendCDPDataUsers();
			returnResponse($response);
			break;

			// CUBOS DINÁMICOS
			// Petición de todos los cubos
		case 'getAllBI':
			$response = $ctrl->getAllBI();
			returnResponse($response);
			break;

			// Petición de todos los esquemas
		case 'getBISchemas':
			$response = $ctrl->getBISchemas();
			returnResponse($response);
			break;

			// Petición de todos las tablas por esquema
		case 'getAllSchemaTables':
			$response = $ctrl->getAllSchemaTables();
			returnResponse($response);
			break;

			// Petición de todos los campos de tabla por esquema
		case 'getAllSchemaTablesFields':
			$response = $ctrl->getAllSchemaTablesFields();
			returnResponse($response);
			break;

			// Crear cubo
		case 'setBI':
			$response = $ctrl->setBI();
			returnResponse($response);
			break;

			// Eliminar cubo
		case 'deleteBI':
			$response = $ctrl->deleteBI();
			returnResponse($response);
			break;

			// Petición de cubo por id
		case 'getBI':
			$response = $ctrl->getBI();
			returnResponse($response);
			break;

			// Editar cubo
		case 'editBI':
			$response = $ctrl->editBI();
			returnResponse($response);
			break;

			// Definir filtros
		case 'setBIFiltros':
			$response = $ctrl->setBIFiltros();
			returnResponse($response);
			break;

			// Consultar store procedure
		case 'getBI_SP_Execution':
			$response = $ctrl->getBI_SP_Execution();
			returnResponse($response);
			break;

			// Ejecutar cubo por id
		case 'getBIExecution':
			$response = $ctrl->getBIExecution();
			returnResponse($response);
			break;

			// PASSIVE TRACKING
			// Petición de passive tracking
		case 'getAnalyticsPassiveTracking':
			$response = $ctrl->getAnalyticsPassiveTracking();
			returnResponse($response);
			break;

		case 'getAnalyticsPassiveTrackingExport':
			$response = $ctrl->getAnalyticsPassiveTrackingExport();
			returnResponse($response);
			break;

		case 'getAnalyticsPassiveTrackingDetails':
			$response = $ctrl->getAnalyticsPassiveTrackingDetails();
			returnResponse($response);
			break;

		// Petición de las gráficas para Passive Tracking
		case 'getPassiveTrackingGraphs':
			$response = $ctrl->getPassiveTrackingGraphs();
			returnResponse($response);
			break;

			// STORES
			// Petición de información de stores
		case 'getAppInfoStore':
			$response = $ctrl->getAppInfoStore();
			returnResponse($response);
			break;

			// KPI SURVEYS
			// Petición de KPI surveys
		case 'getAnalyticsKPIS':
			$response = $ctrl->getAnalyticsKPIS();
			returnResponse($response);
			break;

			// Devuelve los tiempos de respuesta de las preguntas de una encuesta
		case 'getSurveyQuestionTimings':
			$response = $ctrl->getSurveyQuestionTimings();
			returnResponse($response);
			break;

			// Devuelve los tiempos de respuesta de los usuarios de una encuesta
		case 'getSurveyUserTimings':
			$response = $ctrl->getSurveyUserTimings();
			returnResponse($response);
			break;

			// PLANTILLAS REPORTES
			// Petición de plantillas para reportes
		case 'getPlantillasReportes':
			$response = $ctrl->getPlantillasReportes();
			returnResponse($response);
			break;

			// Eliminar plantilla/s para reportes
		case 'deletePlantillaReportes':
			$response = $ctrl->deletePlantillaReportes();
			returnResponse($response);
			break;

			// Crear plantilla para reportes
		case 'setPlantillaReportes':
			$response = $ctrl->setPlantillaReportes();
			returnResponse($response);
			break;

			// Petición de plantilla para reportes por id
		case 'getPlantillaReportesByID':
			$response = $ctrl->getPlantillaReportesByID();
			returnResponse($response);
			break;

			// Petición de plantilla para reportes por defecto
		case 'getPlantillaReportesByDefault':
			$response = $ctrl->getPlantillaReportesByDefault();
			returnResponse($response);
			break;

			// Editar plantilla para reportes
		case 'updatePlantillaReportes':
			$response = $ctrl->updatePlantillaReportes();
			returnResponse($response);
			break;

			// Marcar plantilla por defecto
		case 'setPlantillaReportesDefault':
			$response = $ctrl->setPlantillaReportesDefault();
			returnResponse($response);
			break;
			
			// Upload custom font
		case 'setReportCustomFont':
			$response = $ctrl->setReportCustomFont();
			returnResponse($response);
			break;
			
			// get custom font list
		case 'getTemplateReportCustomFont':
			$response = $ctrl->getTemplateReportCustomFont();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//MISIONES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de Misiones
		case 'getAllMisiones':
			$response = $ctrl->getAllMisiones();
			returnResponse($response);
			break;

			// Petición de Misión por stampMision
		case 'getMision':
			$response = $ctrl->getMision();
			returnResponse($response);
			break;

			// Petición de Tipos de Misiones
		case 'getAllTipoMision':
			$response = $ctrl->getMissionTypes();
			returnResponse($response);
			break;

			// Petición de Objetivos por Tipos de Misiones
		case 'getAllTipoMisionObjetivos':
			$response = $ctrl->getAllTipoMisionObjetivos();
			returnResponse($response);
			break;

			// Petición de recordatorios de Misión
		case 'getMisionRemember':
			$response = $ctrl->getMisionRemember();
			returnResponse($response);
			break;

			// Petición de todos los productos
		case 'getAllProducts':
			$response = $ctrl->getAllProducts();
			returnResponse($response);
			break;

			// Comprobar si existe una misión de referidos entre las fechas dadas
		case 'existsMisionBetweenDates':
			$response = $ctrl->existsMisionBetweenDates();
			returnResponse($response);
			break;

			// Crear misión
		case 'createMision':
			$response = $ctrl->createMision();
			returnResponse($response);
			break;

			// Eliminar misión
		case 'dropMision':
			$response = $ctrl->dropMision();
			returnResponse($response);
			break;

			// Petición de objetivos de misión
		case 'getMisionesObjetivos':
			$response = $ctrl->getMisionesObjetivos();
			returnResponse($response);
			break;

			// Añadir el objetivo a la misión y actualizar la fecha de expiracion de la encuesta con la fecha de la mision
		case 'setMisionObjetivoAndUpdateSurveyExpiration':
			$response = $ctrl->setMisionObjetivoAndUpdateSurveyExpiration();
			returnResponse($response);
			break;

			// Editar misión
		case 'updateMision':
			$response = $ctrl->updateMision();
			returnResponse($response);
			break;

			// Petición de misiones
		case 'getAllObjetivosMision':
			$response = $ctrl->getAllObjetivosMision();
			returnResponse($response);
			break;

			// Crear/editar tipo de misión
		case 'setTipoMision':
			$response = $ctrl->setTipoMision();
			returnResponse($response);
			break;

			// Eliminar tipo de misión
		case 'deleteTipoMision':
			$response = $ctrl->deleteTipoMision();
			returnResponse($response);
			break;

			// Petición de usuarios notificados en una misión
		case 'getNumParticipantesNotificados':
			$response = $ctrl->getNumParticipantesNotificados();
			returnResponse($response);
			break;

			// Petición de proyectos por misión
		case 'getMisionesProjects':
			$response = $ctrl->getMisionesProjects();
			returnResponse($response);
			break;

			// Enviar notificación a usuarios no notificados
		case 'sendMisionMessageUsersNotNotified':
			$response = $ctrl->sendMisionMessageUsersNotNotified();
			returnResponse($response);
			break;

			// Enviar notificación misión desde editMision
		case 'postSurveyMisiones':
			$response = $ctrl->postSurveyMisiones();
			returnResponse($response);
			break;

			// Petición de exclusiones por respuesta/pregunta
		case 'getMisionQuestionNoAccomplish':
			$response = $ctrl->getMisionQuestionNoAccomplish();
			returnResponse($response);
			break;

			// Petición de misiones en curso con cupo
		case 'getCMBPMisionesFinCupo':
			$response = $ctrl->getCMBPMisionesFinCupo();
			returnResponse($response);
			break;

			// Petición de mision en curso con cupo
		case 'getCMBPMisionFinCupo':
			$response = $ctrl->getCMBPMisionFinCupo();
			returnResponse($response);
			break;

			// Petición del cumplimiento de una mision en curso
		case 'getCumplimientoMision':
			$response = $ctrl->getCumplimientoMision();
			returnResponse($response);
			break;

			// Petición de Misiones de inicio
		case 'getAllMisionesDeInicio':
			$response = $ctrl->getAllMisionesDeInicio();
			returnResponse($response);
			break;

			// Generar links de mision
		case 'getMissionSurveyLinks':
			$response = $ctrl->getMissionSurveyLinks();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//PRODUCTOS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de productos
		case 'getAllProductsAnaquel':
			$response = $ctrl->getAllProductsAnaquel();
			returnResponse($response);
			break;

			// Petición de imagenes para productos
		case 'viewImagesProducts':
			$response = $ctrl->viewImagesProducts();
			returnResponse($response);
			break;

			// Petición de tipos de misión
		case 'getTipoMisionByType':
			$response = $ctrl->getTipoMisionByType();
			returnResponse($response);
			break;

			// Crear nuevo producto
		case 'insertProductsAnaquel':
			$response = $ctrl->insertProductsAnaquel();
			returnResponse($response);
			break;

			// Eliminar producto
		case 'deleteProductsAnaquel':
			$response = $ctrl->deleteProductsAnaquel();
			returnResponse($response);
			break;

			// Petición de producto por id
		case 'getProductsAnaquelByID':
			$response = $ctrl->getProductsAnaquelByID();
			returnResponse($response);
			break;

			// Editar producto
		case 'updateProductsAnaquel':
			$response = $ctrl->updateProductsAnaquel();
			returnResponse($response);
			break;

			// Añadir criterio a un proyecto de producto por encuesta
		case 'productSetCMBPProjectsTargets':
			$response = $ctrl->productSetCMBPProjectsTargets();
			returnResponse($response);
			break;

			// Añadir criterio a un proyecto de producto por segmentación
		case 'productSetCMBPProjectsTargetsSegmentation':
			$response = $ctrl->productSetCMBPProjectsTargetsSegmentation();
			returnResponse($response);
			break;

			// Añadir criterio a un proyecto de toda la comunidad
		case 'productSetCMBPProjectsTargetsTotal':
			$response = $ctrl->productSetCMBPProjectsTargetsTotal();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//PLANTILLAS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de plantillas
		case 'getAllTemplates':
			$response = $ctrl->getAllTemplates();
			returnResponse($response);
			break;

			// Crear nueva plantilla
		case 'insertTemplate':
			$response = $ctrl->insertTemplate();
			returnResponse($response);
			break;

			// Eliminar plantilla
		case 'deleteTemplate':
			$response = $ctrl->deleteTemplate();
			returnResponse($response);
			break;

			// Petición de plantilla por id
		case 'getTemplatesByID':
			$response = $ctrl->getTemplatesByID();
			returnResponse($response);
			break;

			// Editar plantilla
		case 'updateTemplate':
			$response = $ctrl->updateTemplate();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//PROYECTOS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de proyectos
		case 'getCMBPProjects':
			$response = $ctrl->requestProject();
			returnResponse($response);
			break;

			// Petición de encuestas de perfilación
		case 'getAllSurveysPerfilacion':
			$response = $ctrl->getAllSurveysPerfilacion();
			returnResponse($response);
			break;

			// Petición de objetivos de encuestas de perfilación
		case 'getTargetsSurvey':
			$response = $ctrl->getTargetsSurvey();
			returnResponse($response);
			break;

			// Petición de valores de pregunta de encuesta de perfilación
		case 'getTargetsSurveyByQID':
			$response = $ctrl->getTargetsSurveyByQID();
			returnResponse($response);
			break;

			// Creación de proyecto
		case 'insertCMBPProjects':
			$response = $ctrl->insertCMBPProjects();
			returnResponse($response);
			break;

			// Validación para la creación de proyecto
		case 'spAddFieldsPerf':
			$response = $ctrl->spAddFieldsPerf();
			returnResponse($response);
			break;

			// Eliminar proyecto
		case 'deleteCMBPProjects':
			$response = $ctrl->deleteCMBPProjects();
			returnResponse($response);
			break;

			// Petición de misiones de proyecto
		case 'getCMBPProjectsMisiones':
			$response = $ctrl->getCMBPProjectsMisiones();
			returnResponse($response);
			break;

			// Petición de participantes de proyecto
		case 'getCMBPProjectsParticipantes':
			$response = $ctrl->getCMBPProjectsParticipantes();
			returnResponse($response);
			break;

			// Petición de participantes de proyecto con comprobación de ejecución
		case 'getCMBPProjectsParticipantesValidacion':
			$response = $ctrl->getCMBPProjectsParticipantesValidacion();
			returnResponse($response);
			break;

			// Petición de valores/códigos previos de encuesta de perfilación/proyecto
		case 'getCMBPProjectsTargets':
			$response = $ctrl->getCMBPProjectsTargets();
			returnResponse($response);
			break;

			// Petición de segmentos previos de segmentaciones
		case 'getCMBPProjectsTargetsSegmentation':
			$response = $ctrl->getCMBPProjectsTargetsSegmentation();
			returnResponse($response);
			break;

			// Petición de motivos de expulsión
		case 'getAllMotivosExpulsionProject':
			$response = $ctrl->getAllMotivosExpulsionProject();
			returnResponse($response);
			break;

			// Expulsión de participante
		case 'deleteCMBPProjectsParticipantes':
			$response = $ctrl->deleteCMBPProjectsParticipantes();
			returnResponse($response);
			break;

			// Edición de proyecto
		case 'updateCMBPProjects':
			$response = $ctrl->updateCMBPProjects();
			returnResponse($response);
			break;

			// Petición de grabación de video llamadas de proyecto
		case 'getFilesRecordedByProject':
			$response = $ctrl->getFilesRecordedByProject();
			returnResponse($response);
			break;

			// Petición de respuestas/participantes de encuesta filtrados
		case 'getAnswersSurveyByQuery':
			$response = $ctrl->getAnswersSurveyByQuery();
			returnResponse($response);
			break;

			// Petición de respuestas/participantes de segmentación filtrados
		case 'getAnswersSurveyByQuerySegmentation':
			$response = $ctrl->getAnswersSurveyByQuerySegmentation();
			returnResponse($response);
			break;

			// Ejecución de metodologías en resultados
		case 'executeMethodologiesOnResults':
			$response = $ctrl->executeMethodologiesOnResults();
			returnResponse($response);
			break;

			// Envío de aviso de videollamada
		case 'sendRequest':
			$response = $ctrl->sendRequest();
			returnResponse($response);
			break;

			// Envío de aviso de videollamada
		case 'sendIncomingCall':
			$response = $ctrl->sendIncomingCall();
			returnResponse($response);
			break;

			// Eliminar usuario de video llamada
		case 'moderatorOutUserCall':
			$response = $ctrl->moderatorOutUserCall();
			returnResponse($response);
			break;

			// Usuarios en videollamada
		case 'usersInCall':
			$response = $ctrl->usersInCall();
			returnResponse($response);
			break;

			// Fin de videollamada
		case 'moderatorLeaveCall':
			$response = $ctrl->moderatorLeaveCall();
			returnResponse($response);
			break;

			// Registro de videollamada
		case 'registerCall':
			$response = $ctrl->registerCall();
			returnResponse($response);
			break;

			// Validar misión
		case 'validateMissionMultiple':
			$response = $ctrl->validateMissionMultiple();
			returnResponse($response);
			break;

			// Validar misión múltiple
		case 'validateMission':
			$response = $ctrl->validateMission();
			returnResponse($response);
			break;

			// Rechazar misión
		case 'refuseMission':
			$response = $ctrl->refuseMission();
			returnResponse($response);
			break;

			// Rechazar misión múltiple
		case 'setMisionValidationMultiple':
			$response = $ctrl->setMisionValidationMultiple();
			returnResponse($response);
			break;

			// Misiones validación encuesta
		case 'getSurveyByUser':
			$response = $ctrl->getSurveyByUser();
			returnResponse($response);
			break;

			// Misiones validación pedido
		case 'getOrdersByUser':
			$response = $ctrl->getOrdersByUser();
			returnResponse($response);
			break;

			// Misiones comprobación de validación
		case 'isMisionValidated':
			$response = $ctrl->isMisionValidated();
			returnResponse($response);
			break;

			// Modificación de motivos de expulsión
		case 'deleteAllMotivosExpulsionProject':
			$response = $ctrl->deleteAllMotivosExpulsionProject();
			returnResponse($response);
			break;

			// Guardado de video externo
		case 'setFileRecordedExternal':
			$response = $ctrl->setFileRecordedExternal();
			returnResponse($response);
			break;

			// Petición de imágenes de encuesta con validación
		case 'getSurveysFilesByQuestion':
			$response = $ctrl->getSurveysFilesByQuestion();
			returnResponse($response);
			break;

			// Comprobación de imágenes repetidas de encuesta con validación
		case 'getCompareFilesBySurveys':
			$response = $ctrl->getCompareFilesBySurveys();
			returnResponse($response);
			break;

			// Analizar imagen
		case 'analizaFoto':
			$response = $ctrl->analizaFoto();
			returnResponse($response);
			break;

			// Analizar imagen con OCR
		case 'procesaOCRFotosFolder':
			$response = $ctrl->procesaOCRFotosFolder();
			returnResponse($response);
			break;

			// Información de la imagen analizada
		case 'getFotoAnalizedData':
			$response = $ctrl->getFotoAnalizedData();
			returnResponse($response);
			break;

			// Información de la imagen analizada con OCR
		case 'getImageDataOCRProcessed':
			$response = $ctrl->getImageDataOCRProcessed();
			returnResponse($response);
			break;

			// Corrección de datos OCR
		case 'setImageDataOCRSimilarities':
			$response = $ctrl->setImageDataOCRSimilarities();
			returnResponse($response);
			break;

			// Sacar audio de video
		case 'convertMP4ToWAV':
			$response = $ctrl->convertMP4ToWAV();
			returnResponse($response);
			break;

			// Transcribir audio
		case 'saveTranscriptionInfo':
			$response = $ctrl->saveTranscriptionInfo();
			returnResponse($response);
			break;

			// Petición de transcripción por proyecto e idCall
		case 'getFilesTranscriptionByProject':
			$response = $ctrl->getFilesTranscriptionByProject();
			returnResponse($response);
			break;

			// Añadir documento a proyecto
		case 'insertCMBPProjectsFile':
			$response = $ctrl->insertCMBPProjectsFile();
			returnResponse($response);
			break;

			// Petición de documentos de proyecto
		case 'getCMBPProjectsFiles':
			$response = $ctrl->getCMBPProjectsFiles();
			returnResponse($response);
			break;

			// Eliminar documentos de proyecto
		case 'deleteCMBPProjectsFileById':
			$response = $ctrl->deleteCMBPProjectsFileById();
			returnResponse($response);
			break;

			// Editar descripción de documento de proyecto
		case 'updateCMBPProjectsFilesDesc':
			$response = $ctrl->updateCMBPProjectsFilesDesc();
			returnResponse($response);
			break;

			// Lista de asesores notificados
		case 'getCMBPProjectsMisionesUsersNotif':
			$response = $ctrl->getCMBPProjectsMisionesUsersNotif();
			returnResponse($response);
			break;

			// Petición de asignación de cupo por proyecto / misión
		case 'getDesgloseCuposMision':
			$response = $ctrl->getDesgloseCuposMision();
			returnResponse($response);
			break;
		
		case 'getMissionQuotaBreakdown':
			$response = $ctrl->getMissionQuotaBreakdown();
			returnResponse($response);
			break;

			// Posibles respuestas para las 4 preguntas de perfilación
		case 'getAnalyticsMuestraToExportHeaders':
			$response = $ctrl->getAnalyticsMuestraToExportHeaders();
			returnResponse($response);
			break;

			// Asignacion de porcentaje a misiones de un proyecto
		case 'setCMBPProjectsMisionesCuotaReparto':
			$response = $ctrl->setCMBPProjectsMisionesCuotaReparto();
			returnResponse($response);
			break;

			// Reparto de asesores en misiónes de proyecto
		case 'setRepartoPartProjByMissions':
			$response = $ctrl->setRepartoPartProjByMissions();
			returnResponse($response);
			break;

			// Asesores asignados a mision de proyecto con repartición
		case 'getRepartoPartProjByMissions':
			$response = $ctrl->getRepartoPartProjByMissions();
			returnResponse($response);
			break;

			// Asignar a usuario comercios y articulos
		case 'setUserComerciosItems':
			$response = $ctrl->setUserComerciosItems();
			returnResponse($response);
			break;

			// Comercios y articulos asignados a usuario
		case 'getUserComerciosItems':
			$response = $ctrl->getUserComerciosItems();
			returnResponse($response);
			break;

			// Servicio de petición de datos de evidencias a validar
		case 'servicioParaValidacionDeEvidencias':
			$response = $ctrl->servicioParaValidacionDeEvidencias();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//PAGOS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Todos los pagos
		case 'getPagosPendientes':
			$response = $ctrl->getPagosPendientes();
			returnResponse($response);
			break;

			// Todos los pagos por país
		case 'getPagosPendientesByCountry':
			$response = $ctrl->getPagosPendientesByCountry();
			returnResponse($response);
			break;

			// Importar pagos desde excel
		case 'setPagosRealizados':
			$response = $ctrl->setPagosRealizados();
			returnResponse($response);
			break;

			// Stamps de pagos esportados a excel
		case 'setPagosPendientesExportados':
			$response = $ctrl->setPagosPendientesExportados();
			returnResponse($response);
			break;

			// Enviar notificación de pagos no realizados
		case 'sendNoPaymentNotifications':
			$response = $ctrl->sendNoPaymentNotifications();
			returnResponse($response);
			break;

			// Detalle de pagos
		case 'getDetallePagos':
			$response = $ctrl->getDetallePagos();
			returnResponse($response);
			break;

			// Petición de pagos automatizados
		case 'getScheduledPayment':
			$response = $ctrl->getScheduledPayment();
			returnResponse($response);
			break;

			// Crear pago automatizado
		case 'setScheduledPayment':
			$response = $ctrl->setScheduledPayment();
			returnResponse($response);
			break;

			// Eliminar de pago automatizado
		case 'deleteScheduledPayment':
			$response = $ctrl->deleteScheduledPayment();
			returnResponse($response);
			break;

			// Actualizar pago automatizado
		case 'updateScheduledPayment':
			$response = $ctrl->updateScheduledPayment();
			returnResponse($response);
			break;

			// Validar pagos
		case 'validatePagosRealizados':
			$response = $ctrl->validatePagosRealizados();
			returnResponse($response);
			break;

			// Registrar pagos no cobrables
		case 'setPagosNoCobrables':
			$response = $ctrl->setPagosNoCobrables();
			returnResponse($response);
			break;

			// Subida de archivo de pagos pendientes descargados
		case 'sendExcelDataToServer':
			$response = $ctrl->sendExcelDataToServer();
			returnResponse($response);
			break;

			// Subida de archivo de pagos a validar importado
		case 'uploadImportPaymentsNoProcessed':
			$response = $ctrl->uploadImportPaymentsNoProcessed();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//RECOMPENSAS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Todos los artículos
		case 'getAllRewardsArticles':
			$response = $ctrl->getAllRewardsArticles();
			returnResponse($response);
			break;

			// Artículo nuevo
		case 'setRewardsArticle':
			$response = $ctrl->setRewardsArticle();
			returnResponse($response);
			break;

			// Eliminar artículo
		case 'deleteRewardsArticle':
			$response = $ctrl->deleteRewardsArticle();
			returnResponse($response);
			break;

			// Petición de artículo por ID
		case 'getRewardsArticlesByID':
			$response = $ctrl->getRewardsArticlesByID();
			returnResponse($response);
			break;

			// Actualizar artículo
		case 'updateRewardsArticle':
			$response = $ctrl->updateRewardsArticle();
			returnResponse($response);
			break;

			// Todos los catálogos
		case 'getAllRewardsCatalogs':
			$response = $ctrl->getAllRewardsCatalogs();
			returnResponse($response);
			break;

			// Catálogo nuevo
		case 'setRewardsCatalog':
			$response = $ctrl->setRewardsCatalog();
			returnResponse($response);
			break;

			// Eliminar catálogo
		case 'deleteRewardsCatalog':
			$response = $ctrl->deleteRewardsCatalog();
			returnResponse($response);
			break;

			// Petición de catálogo por ID
		case 'getRewardsCatalogsByID':
			$response = $ctrl->getRewardsCatalogsByID();
			returnResponse($response);
			break;

			// Actualizar catálogo
		case 'updateRewardsCatalog':
			$response = $ctrl->updateRewardsCatalog();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ROTACIONES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		case 'getAllRotacionSurveyQuestions':
			$response = $ctrl->getAllRotacionSurveyQuestions();
			returnResponse($response);
			break;

		case 'deleteRotacionSurveyQuestions':
			$response = $ctrl->deleteRotacionSurveyQuestions();
			returnResponse($response);
			break;

		case 'setRotacionSurveyQuestions':
			$response = $ctrl->setRotacionSurveyQuestions();
			returnResponse($response);
			break;

		case 'getRotacionSurveyQuestions':
			$response = $ctrl->getRotacionSurveyQuestions();
			returnResponse($response);
			break;

		case 'getAllRotacionesSurvey':
			$response = $ctrl->getAllRotacionesSurvey();
			returnResponse($response);
			break;

		case 'getProjectMisionRotaciones':
			$response = $ctrl->getProjectMisionRotaciones();
			returnResponse($response);
			break;

		case 'deleteProjectMisionRotaciones':
			$response = $ctrl->deleteProjectMisionRotaciones();
			returnResponse($response);
			break;

		case 'setProjectMisionRotaciones':
			$response = $ctrl->setProjectMisionRotaciones();
			returnResponse($response);
			break;

		case 'getProjectMisionRotacionesAsigned':
			$response = $ctrl->getProjectMisionRotacionesAsigned();
			returnResponse($response);
			break;

		case 'setUserRotacion':
			$response = $ctrl->setUserRotacion();
			returnResponse($response);
			break;

		case 'getAllRotacionesProject':
			$response = $ctrl->getAllRotacionesProject();
			returnResponse($response);
			break;

		case 'getAllAsignedProjectRotaciones':
			$response = $ctrl->getAllAsignedProjectRotaciones();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//NOTIFICACIONES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todas las notificaciones
		case 'getCMBPNotifications':
			$response = $ctrl->getCMBPNotifications();
			returnResponse($response);
			break;

			// Creación de ID para notificación
		case 'getIdNotifications':
			$response = $ctrl->getIdNotifications();
			returnResponse($response);
			break;

			// Guardar y ejecutar notificación
		case 'setCMBPNotificationsAndExecute':
			$response = $ctrl->setCMBPNotificationsAndExecute();
			returnResponse($response);
			break;

			// Actualizar y ejecutar notificación
		case 'updateCMBPNotificationsAndExecute':
			$response = $ctrl->updateCMBPNotificationsAndExecute();
			returnResponse($response);
			break;

			// Guardado de notificación
		case 'setCMBPNotifications':
			$response = $ctrl->setCMBPNotifications();
			returnResponse($response);
			break;

			// Editar notificación
		case 'updateCMBPNotifications':
			$response = $ctrl->updateCMBPNotifications();
			returnResponse($response);
			break;

			// Ejecutar notificación
		case 'executeNofitication':
			$response = $ctrl->executeNofitication();
			returnResponse($response);
			break;

			// Eliminar notificación
		case 'deleteCMBPNotifications':
			$response = $ctrl->deleteCMBPNotifications();
			returnResponse($response);
			break;

			// Petición de cola de notificaciones programadas
		case 'getCMBPNotificationsServiceProgramadasTimer':
			$response = $ctrl->getCMBPNotificationsServiceProgramadasTimer();
			returnResponse($response);
			break;

			// Petición de periodos de cola de notificaciones cíclicas
		case 'getCMBPNotificationsServiceCiclicas':
			$response = $ctrl->getCMBPNotificationsServiceCiclicas();
			returnResponse($response);
			break;

			// Petición de cola de notificaciones cíclicas
		case 'getCMBPNotificationsServiceCiclicasTimer':
			$response = $ctrl->getCMBPNotificationsServiceCiclicasTimer();
			returnResponse($response);
			break;

			// Notificar a pre-consejeros
		case 'sendReActivationEmail':
			$response = $ctrl->sendReActivationEmail();
			returnResponse($response);
			break;

			// Petición de todos los preconsejeros
		case 'getPreConsejeros':
			$response = $ctrl->getPreConsejeros();
			returnResponse($response);
			break;

			// Petición de consejeros sin clabe
		case 'getConsejerosSinClabe':
			$response = $ctrl->getConsejerosSinClabe();
			returnResponse($response);
			break;

			// Petición de consejeros sin teléfono
		case 'getConsejerosSinTelf':
			$response = $ctrl->getConsejerosSinTelf();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//OPERAR
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de datos de Pops Up
		case 'getAllPopups':
			$response = $ctrl->getAllPopups();
			returnResponse($response);
			break;

			// Guardar, borrar o actualizar PopUps
		case 'setPopups':
			$response = $ctrl->setPopups();
			returnResponse($response);
			break;

			// Usuarios asignados a un PopUp
		case 'getAllPopupsUserAssignment':
			$response = $ctrl->getAllPopupsUserAssignment();
			returnResponse($response);
			break;

			// Asignar usuarios a un PopUp
		case 'setPopupsUserAssignment':
			$response = $ctrl->setPopupsUserAssignment();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ADMINISTRADORES BACKEND
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todos los administradores
		case 'getAllUsersAPI':
			$response = $ctrl->getAllUsersAPI();
			returnResponse($response);
			break;

			// Guardar nuevo administrador
		case 'registerAPIUser':
			$response = $ctrl->registerAPIUser();
			returnResponse($response);
			break;

			// Eliminación de administrador
		case 'dropUserAPI':
			$response = $ctrl->dropUserAPI();
			returnResponse($response);
			break;

			// Países permitidos para administrador
		case 'getUserAPICountries':
			$response = $ctrl->getUserAPICountries();
			returnResponse($response);
			break;

			// Cambiar contraseña de administrador
		case 'resetPasswordAPIUser':
			$response = $ctrl->resetPasswordAPIUser();
			returnResponse($response);
			break;

			// Editar administrador
		case 'updateAPIUser':
			$response = $ctrl->updateAPIUser();
			returnResponse($response);
			break;

			// Petición de roles de Administradores BackEnd
		case 'getAllAdminRolesMenu':
			$response = $ctrl->getAllAdminRolesMenu();
			returnResponse($response);
			break;

			// Crear nuevo rol de Administrador BackEnd
		case 'newAdminRoleMenu':
			$response = $ctrl->newAdminRoleMenu();
			returnResponse($response);
			break;

			// Eliminar rol de Administrador BackEnd
		case 'deleteAdminRoleMenu':
			$response = $ctrl->deleteAdminRoleMenu();
			returnResponse($response);
			break;

			// Petición de permisos de rol de Administrador BackEnd
		case 'getAdminRoleMenu':
			$response = $ctrl->getAdminRoleMenu();
			returnResponse($response);
			break;

			// Petición de permisos de AddOns de rol de Administrador BackEnd
		case 'getUsersRoleAddons':
			$response = $ctrl->getUsersRoleAddons();
			returnResponse($response);
			break;

			// Editar rol de Administrador BackEnd
		case 'editAdminRoleMenu':
			$response = $ctrl->editAdminRoleMenu();
			returnResponse($response);
			break;

			// Petición de AddOns activos
		case 'getAllAddOnsEnabled':
			$response = $ctrl->getAllAddOnsEnabled();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CONSUMO
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todos los items
		case 'getAllItems':
			$response = $ctrl->getAllItems();
			returnResponse($response);
			break;

			// Rellenar incompletos
		case 'getItemUnknownInfoGS1Massive':
			$response = $ctrl->getItemUnknownInfoGS1Massive();
			returnResponse($response);
			break;

			// Crear nuevo item
		case 'setItems':
			$response = $ctrl->setItems();
			returnResponse($response);
			break;

			// Eliminar item
		case 'deleteItems':
			$response = $ctrl->deleteItems();
			returnResponse($response);
			break;

			// Petición de item por id
		case 'getItemsById':
			$response = $ctrl->getItemsById();
			returnResponse($response);
			break;

			// Actualizar item
		case 'updateItems':
			$response = $ctrl->updateItems();
			returnResponse($response);
			break;

			// Guardar excel con items descargados
		case 'sendExcelDataToServerItems':
			$response = $ctrl->sendExcelDataToServerItems();
			returnResponse($response);
			break;

			// Modificar registros a través de archivo
		case 'updateNewItemsFromFile':
			$response = $ctrl->updateNewItemsFromFile();
			returnResponse($response);
			break;

			// Petición de todos los tipos de tiendas
		case 'getAllComerciosType':
			$response = $ctrl->getAllComerciosType();
			returnResponse($response);
			break;

			// Crear nuevo tipo de tienda
		case 'setComercioType':
			$response = $ctrl->setComercioType();
			returnResponse($response);
			break;

			// Eliminar tipo de tienda
		case 'deleteComercioType':
			$response = $ctrl->deleteComercioType();
			returnResponse($response);
			break;

			// Actualizar tipo de tienda
		case 'updateComercioType':
			$response = $ctrl->updateComercioType();
			returnResponse($response);
			break;

			// Petición de todas las tiendas
		case 'getAllComercios':
			$response = $ctrl->getAllComercios();
			returnResponse($response);
			break;

			// Crear nueva tienda
		case 'setComercios':
			$response = $ctrl->setComercios();
			returnResponse($response);
			break;

			// Eliminar tienda
		case 'deleteComercios':
			$response = $ctrl->deleteComercios();
			returnResponse($response);
			break;

			// Petición de tienda por id
		case 'getComerciosById':
			$response = $ctrl->getComerciosById();
			returnResponse($response);
			break;

			// Actualizar tienda
		case 'updateComercios':
			$response = $ctrl->updateComercios();
			returnResponse($response);
			break;

			// Guardar excel con stores descargados
		case 'sendExcelDataToServerStores':
			$response = $ctrl->sendExcelDataToServerStores();
			returnResponse($response);
			break;

			// Modificar registros a través de archivo
		case 'updateNewStoresFromFile':
			$response = $ctrl->updateNewStoresFromFile();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//HTML
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todas las extensiones funcionales
		case 'getAllCustomMenuOption':
			$response = $ctrl->getAllCustomMenuOption();
			returnResponse($response);
			break;

			// Crear extensión funcional
		case 'setCustomMenuOption':
			$response = $ctrl->setCustomMenuOption();
			returnResponse($response);
			break;

			// Eliminar extensión funcional
		case 'deleteCustomMenuById':
			$response = $ctrl->deleteCustomMenuById();
			returnResponse($response);
			break;

			// Editar extensión funcional
		case 'editCustomMenuById':
			$response = $ctrl->editCustomMenuById();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ADDONS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Carga de todos los AddOns
		case 'getAllAddOns':
			$response = $ctrl->getAllAddOns();
			returnResponse($response);
			break;

			// Guardar AddOn nuevo
		case 'setAddOn':
			$response = $ctrl->setAddOn();
			returnResponse($response);
			break;

			// Eliminar AddOn
		case 'deleteAddOn':
			$response = $ctrl->deleteAddOn();
			returnResponse($response);
			break;

			// Actualizar AddOn
		case 'updateAddOn':
			$response = $ctrl->updateAddOn();
			returnResponse($response);
			break;

			// Petición de secciones de AddOn
		case 'getAllAddOnsSection':
			$response = $ctrl->getAllAddOnsSection();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//ASISTENTE DE VOZ
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Carga de todos los diccionarios
		case 'getAllVoiceassistantDictionary':
			$response = $ctrl->getAllVoiceassistantDictionary();
			returnResponse($response);
			break;

			// Carga de todos los hashtags
		case 'getAllHashtag':
			$response = $ctrl->getAllHashtag();
			returnResponse($response);
			break;

			// Guardar diccionario nuevo
		case 'setVoiceassistantDictionary':
			$response = $ctrl->setVoiceassistantDictionary();
			returnResponse($response);
			break;

			// Eliminar diccionario
		case 'deleteVoiceassistantDictionary':
			$response = $ctrl->deleteVoiceassistantDictionary();
			returnResponse($response);
			break;

			// Carga de diccionario por id
		case 'getVoiceassistantDictionaryById':
			$response = $ctrl->getVoiceassistantDictionaryById();
			returnResponse($response);
			break;

			// Carga de registros por id de diccionario
		case 'getAllVoiceassistantDictionaryRegisters':
			$response = $ctrl->getAllVoiceassistantDictionaryRegisters();
			returnResponse($response);
			break;

			// Actualizar diccionario
		case 'updateVoiceassistantDictionary':
			$response = $ctrl->updateVoiceassistantDictionary();
			returnResponse($response);
			break;

			// Carga sinónimos por id de registro
		case 'getAllVoiceassistantDictionarySynonym':
			$response = $ctrl->getAllVoiceassistantDictionarySynonym();
			returnResponse($response);
			break;

			// Carga todos los sinónimos de diccionario
		case 'getAllVoiceassistantDictionarySynonymAll':
			$response = $ctrl->getAllVoiceassistantDictionarySynonymAll();
			returnResponse($response);
			break;

			// Carga de todos los no match
		case 'getAllVoiceassistantNoMatch':
			$response = $ctrl->getAllVoiceassistantNoMatch();
			returnResponse($response);
			break;

			// Actualizar sinónimos y no match
		case 'updateSynonymsNoMatch':
			$response = $ctrl->updateSynonymsNoMatch();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//HASHTAGS
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Guardar hashtag nuevo
		case 'addNewHashtag':
			$response = $ctrl->addNewHashtag();
			returnResponse($response);
			break;

			// Eliminar hashtag
		case 'deleteHashtag':
			$response = $ctrl->deleteHashtag();
			returnResponse($response);
			break;

			// Carga de hashtag por id
		case 'getHashtagByID':
			$response = $ctrl->getHashtagByID();
			returnResponse($response);
			break;

			// Editar hashtag
		case 'updateHashtag':
			$response = $ctrl->updateHashtag();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//AJUSTES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// WELCOME TOUR
			// Set (new y update) secciones Welcome Tour
		case 'setWelcomeTour':
			$response = $ctrl->setWelcomeTour();
			returnResponse($response);
			break;

			// Petición de datos del Welcome Tour
		case 'getWelcomeTour':
			$response = $ctrl->getWelcomeTour();
			returnResponse($response);
			break;

			// DOMINIOS EMBEBIDOS
			// Petición de todos los dominios
		case 'getAllDomains':
			$response = $ctrl->getAllDomains();
			returnResponse($response);
			break;

			// Crear dominio
		case 'newDomain':
			$response = $ctrl->newDomain();
			returnResponse($response);
			break;

			// Eliminar dominio
		case 'deleteDomain':
			$response = $ctrl->deleteDomain();
			returnResponse($response);
			break;

			// Actualizar dominio
		case 'updateDomain':
			$response = $ctrl->updateDomain();
			returnResponse($response);
			break;

			// BOTS
			// Petición de todos los bots
		case 'getAllBots':
			$response = $ctrl->getAllBots();
			returnResponse($response);
			break;

			// Crear bot
		case 'setBot':
			$response = $ctrl->setBot();
			returnResponse($response);
			break;

			// Eliminar bot
		case 'deleteBot':
			$response = $ctrl->deleteBot();
			returnResponse($response);
			break;

			// Actualizar bot
		case 'updateBot':
			$response = $ctrl->updateBot();
			returnResponse($response);
			break;

			// DEFINICIÓN CATALOGACIÓN ASESORES
			// Crear catalogación de asesores
		case 'saveNewCatalogM':
			$response = $ctrl->saveNewCatalogM();
			returnResponse($response);
			break;

			// Actualizar catalogación de asesores
		case 'setCatalogacionM':
			$response = $ctrl->setCatalogacionM();
			returnResponse($response);
			break;

			// SECCIÓN PERFILACIÓN
			// Petición de perfilación por género
		case 'getPerfGenero':
			$response = $ctrl->getPerfGenero();
			returnResponse($response);
			break;

			// Petición de perfilación por estado
		case 'getPerfEstados':
			$response = $ctrl->getPerfEstados();
			returnResponse($response);
			break;

			// Petición de perfilación por edad
		case 'getPerfEdad':
			$response = $ctrl->getPerfEdad();
			returnResponse($response);
			break;

			// Petición de perfilación por PerfSec
		case 'getPerfSec':
			$response = $ctrl->getPerfSec();
			returnResponse($response);
			break;

			// Petición perfilación por PerfRegion
		case 'getPerfRegion':
			$response = $ctrl->getPerfRegion();
			returnResponse($response);
			break;

			// Petición de integración
		case 'getLicenciasDiscriminantes':
			$response = $ctrl->getLicenciasDiscriminantes();
			returnResponse($response);
			break;

			// Nueva perfilación por género
		case 'setPerfGenero':
			$response = $ctrl->setPerfGenero();
			returnResponse($response);
			break;

			// Nueva perfilación por estado
		case 'setPerfEstados':
			$response = $ctrl->setPerfEstados();
			returnResponse($response);
			break;

			// Nueva perfilación por edad
		case 'setPerfEdad':
			$response = $ctrl->setPerfEdad();
			returnResponse($response);
			break;

			// Nueva de perfilación por PerfSec
		case 'setPerfSec':
			$response = $ctrl->setPerfSec();
			returnResponse($response);
			break;

			// Nueva perfilación por PerfRegion
		case 'setPerfRegion':
			$response = $ctrl->setPerfRegion();
			returnResponse($response);
			break;

			// Nueva integración
		case 'setLicenciasDiscriminantes':
			$response = $ctrl->setLicenciasDiscriminantes();
			returnResponse($response);
			break;

			// Eliminar perfilación por género
		case 'deletePerfGenero':
			$response = $ctrl->deletePerfGenero();
			returnResponse($response);
			break;

			// Eliminar perfilación por estado
		case 'deletePerfEstados':
			$response = $ctrl->deletePerfEstados();
			returnResponse($response);
			break;

			// Eliminar perfilación por edad
		case 'deletePerfEdad':
			$response = $ctrl->deletePerfEdad();
			returnResponse($response);
			break;

			// Eliminar de perfilación por PerfSec
		case 'deletePerfSec':
			$response = $ctrl->deletePerfSec();
			returnResponse($response);
			break;

			// Eliminar perfilación por PerfRegion
		case 'deletePerfRegion':
			$response = $ctrl->deletePerfRegion();
			returnResponse($response);
			break;

			// Eliminar integración
		case 'deleteLicenciasDiscriminantes':
			$response = $ctrl->deleteLicenciasDiscriminantes();
			returnResponse($response);
			break;

			// Editar perfilación por género
		case 'editPerfGenero':
			$response = $ctrl->editPerfGenero();
			returnResponse($response);
			break;

			// Editar perfilación por estado
		case 'editPerfEstados':
			$response = $ctrl->editPerfEstados();
			returnResponse($response);
			break;

			// Editar perfilación por edad
		case 'editPerfEdad':
			$response = $ctrl->editPerfEdad();
			returnResponse($response);
			break;

			// Editar de perfilación por PerfSec
		case 'editPerfSec':
			$response = $ctrl->editPerfSec();
			returnResponse($response);
			break;

			// Editar perfilación por PerfRegion
		case 'editPerfRegion':
			$response = $ctrl->editPerfRegion();
			returnResponse($response);
			break;

			// Editar integración
		case 'editLicenciasDiscriminantes':
			$response = $ctrl->editLicenciasDiscriminantes();
			returnResponse($response);
			break;

			// FORMULARIO DE REGISTRO
			// Configuración de registro
		case 'getRegisterConfiguration':
			$response = $ctrl->getRegisterConfiguration();
			returnResponse($response);
			break;

			// Cambiar la configuración de registro
		case 'setRegisterConfiguration':
			$response = $ctrl->setRegisterConfiguration();
			returnResponse($response);
			break;

			// PAÍSES
			// Petición de plantillas de pagos según país
		case 'getTemplatePagosByCountry':
			$response = $ctrl->getTemplatePagosByCountry();
			returnResponse($response);
			break;

			// Petición de tipos de identificación según país
		case 'getPaisesTipoIdentificacion':
			$response = $ctrl->getPaisesTipoIdentificacion();
			returnResponse($response);
			break;

			// Petición de tipos de cuentas según país
		case 'getPaisesTipoCuentas':
			$response = $ctrl->getPaisesTipoCuentas();
			returnResponse($response);
			break;

			// Petición de bancos según país
		case 'getPaisesBancos':
			$response = $ctrl->getPaisesBancos();
			returnResponse($response);
			break;

			// Petición de textos de bienvenida según país
		case 'getWelcomeChatsById':
			$response = $ctrl->getWelcomeChatsById();
			returnResponse($response);
			break;

			// Petición de ponderaciones
		case 'getPonderacionesByCountry':
			$response = $ctrl->getPonderacionesByCountry();
			returnResponse($response);
			break;

			// Exportar a excel ponderaciones
		case 'exportPonderacionesByCountry':
			$response = $ctrl->exportPonderacionesByCountry();
			returnResponse($response);
			break;

			// Actualización de parámetros de países
		case 'updatePaises':
			$response = $ctrl->updatePaises();
			returnResponse($response);
			break;

			// IDIOMAS
			// Actualización de parámetros de idiomas
		case 'updateIdiomas':
			$response = $ctrl->updateIdiomas();
			returnResponse($response);
			break;

			// PERFILES
			// Petición de perfiles
		case 'getProfiles':
			$response = $ctrl->getProfiles();
			returnResponse($response);
			break;

			// Creación de perfil
		case 'setProfile':
			$response = $ctrl->setProfile();
			returnResponse($response);
			break;

			// Eliminar perfil
		case 'deleteProfile':
			$response = $ctrl->deleteProfile();
			returnResponse($response);
			break;

			// Actualizar perfil
		case 'updateProfile':
			$response = $ctrl->updateProfile();
			returnResponse($response);
			break;

			// Petición de algoritmos de perfilación
		case 'getSPSchemaCorporate':
			$response = $ctrl->getSPSchemaCorporate();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CONFIGURACION
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// GENERAL
			// Lanzamiento manual de la llamada a Sercive.php
		case 'service':
			$response = $sercive->startTest();
			echo json_encode($response);
			break;

			// Lanzamiento manual de la llamada a SerciveSegmentations.php
		case 'serviceSegmentations':
			$response = $serviceSegmentations->startTestSegmentations();
			echo json_encode($response);
			break;

			// Peticion de políticas
		case 'getPoliciesByID':
			$response = $ctrl->getPoliciesByID();
			returnResponse($response);
			break;

			// Guardar políticas
		case 'setPolicies':
			$response = $ctrl->setPolicies();
			returnResponse($response);
			break;

			// Configuracion general
		case 'getCMBPConfig':
			$response = $ctrl->getCMBPConfig();
			returnResponse($response);
			break;

			// Actualizar configuración general
		case 'setCMBPConfig':
			$response = $ctrl->setCMBPConfig();
			returnResponse($response);
			break;

			// Pedir relación de perfilación por país
		case 'getSurveyCountry':
			$response = $ctrl->getSurveyCountry();
			returnResponse($response);
			break;

			// Comprobación de existencia del archivo running.txt
		case 'runningTXT':
			$response = [
				'file' => 0,
				'date' => ''
			];

			$directory = dirname(__FILE__) . '/running.txt';

			$exists = file_exists($directory);

			if($exists) {
				$fp = fopen($directory, 'r');
				$date = fgets($fp);
				fclose($fp);

				$response['file'] = 1;
				$response['date'] = $date;
			}

			echo json_encode($response);
			break;

			// Borrado del archivo running.txt
		case 'deleteRunningTXT':
			$response = [
				'status' => 'OK'
			];

			$directory = dirname(__FILE__) . '/running.txt';

			$exists = file_exists($directory);

			if($exists) {
				$deleteCheck = false;
				while(!$deleteCheck) {
					$deleteCheck = unlink($directory);
				}
			}

			echo json_encode($response);
			break;

			// FUNCIONALIDADES APP
			// Actualizar funcionalidades
		case 'setSystemConfig':
			$response = $ctrl->setSystemConfig();
			returnResponse($response);
			break;

			// LOGS
			// Petición de logs
		case 'getCMBPLOG':
			$response = $ctrl->getCMBPLOG();
			returnResponse($response);
			break;

			// Eliminación de todos los logs
		case 'deleteCMBPLOG':
			$response = $ctrl->deleteCMBPLOG();
			returnResponse($response);
			break;

			// Petición de archivos de log de plataforma
		case 'getAPILOG':
			$response = [
				'status' => 'OK',
				'result' => [
					'error' => '',
					'log' => []
				]
			];

			$serviceErr = dirname(__FILE__) . '/log/stcm_service.err';
			$serviceLog = dirname(__FILE__) . '/log/stcm_service.log';

			if(file_exists($serviceErr) && file_exists($serviceLog)) {
				$fp1 = fopen($serviceErr, 'r');
				$error = fgets($fp1);
				fclose($fp1);

				$response['result']['error'] = $error;

				$fp2 = fopen($serviceLog, 'r');
				while(!feof($fp2)) {
					$reg = fgets($fp2);
					array_push($response['result']['log'], $reg);
				}
				fclose($fp2);
			} else {
				$response['result'] = '00';
			}

			echo json_encode($response);
			break;

			// RSC
			// Petición de RSC completo
		case 'getAllRSC':
			$response = $ctrl->getAllRSC();
			returnResponse($response);
			break;

			// Importar RSC
		case 'importRSC':
			$response = $ctrl->importRSC();
			returnResponse($response);
			break;

			// Sincronizar RSC
		case 'synchronizeRSC':
			$response = $ctrl->synchronizeRSC();
			returnResponse($response);
			break;

			// Nuevo RSC
		case 'setRSC':
			$response = $ctrl->setRSC();
			returnResponse($response);
			break;

			// Editar RSC
		case 'updateRSC':
			$response = $ctrl->updateRSC();
			returnResponse($response);
			break;

		case 'getAllWordsExcludedCloud':
			$response = $ctrl->getAllWordsExcludedCloud();
			returnResponse($response);
			break;

		case 'setWordsExcludedCloud':
			$response = $ctrl->setWordsExcludedCloud();
			returnResponse($response);
			break;

		case 'deleteAllWordsExcludedCloud':
			$response = $ctrl->deleteAllWordsExcludedCloud();
			returnResponse($response);
			break;

		case 'deleteWordExcludedCloudByID':
			$response = $ctrl->deleteWordExcludedCloudByID();
			returnResponse($response);
			break;

		case 'updateWordExcludedCloudByID':
			$response = $ctrl->updateWordExcludedCloudByID();
			returnResponse($response);
			break;

			// Petición de desglose de uso de Google API
		case 'getDetallePeticionesAPI_Google':
			$response = $ctrl->getDetallePeticionesAPI_Google();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//MULTI TENANT
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todos los tenants
		case 'getAllTenants':
			$response = $ctrl->getAllTenants();
			returnResponse($response);
			break;

			// Crear nuevo tenant
		case 'setTenant':
			$response = $ctrl->setTenant();
			returnResponse($response);
			break;

			// Eliminar tenant
		case 'deleteTenant':
			$response = $ctrl->deleteTenant();
			returnResponse($response);
			break;

			// Petición de tenant por id
		case 'getTenantById':
			$response = $ctrl->getTenantById();
			returnResponse($response);
			break;

			// Actualizar Tenant
		case 'updateTenant':
			$response = $ctrl->updateTenant();
			returnResponse($response);
			break;

			// Petición de licencias del tenant
		case 'getSocialLabsLicencesByTenant':
			$response = $ctrl->getSocialLabsLicencesByTenant();
			returnResponse($response);
			break;

			// Guardado de licencias del tenant
		case 'setSocialLabsLicencesByTenant':
			$response = $ctrl->setSocialLabsLicencesByTenant();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CPG
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todos los CPG
		case 'getAllCPG':
			$response = $ctrl->getAllCPG();
			returnResponse($response);
			break;

			// Crear nuevo CPG
		case 'setCPG':
			$response = $ctrl->setCPG();
			returnResponse($response);
			break;

			// Eliminar CPG
		case 'deleteCPG':
			$response = $ctrl->deleteCPG();
			returnResponse($response);
			break;

			// Petición de CPG por id
		case 'getCPGById':
			$response = $ctrl->getCPGById();
			returnResponse($response);
			break;

			// Actualizar CPG
		case 'updateCPG':
			$response = $ctrl->updateCPG();
			returnResponse($response);
			break;

			// Petición de licencias del CPG
		case 'getSocialLabsLicencesByCPG':
			$response = $ctrl->getSocialLabsLicencesByCPG();
			returnResponse($response);
			break;

			// Guardado de licencias del CPG
		case 'setSocialLabsLicencesByCPG':
			$response = $ctrl->setSocialLabsLicencesByCPG();
			returnResponse($response);
			break;

			// Petición de detalle de licencias usadas
		case 'getSocialLabsLicencesDetailByCPG':
			$response = $ctrl->getSocialLabsLicencesDetailByCPG();
			returnResponse($response);
			break;

			// Petición licencias asignadas por país
		case 'getLicencesByCountry':
			$response = $ctrl->getLicencesByCountry();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CLIENTES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Petición de todos los clientes
		case 'getAllClientes':
			$response = $ctrl->getAllClientes();
			returnResponse($response);
			break;

			// Crear nuevo cliente
		case 'setCliente':
			$response = $ctrl->setCliente();
			returnResponse($response);
			break;

			// Eliminar cliente
		case 'deleteCliente':
			$response = $ctrl->deleteCliente();
			returnResponse($response);
			break;

			// Petición de cliente por id
		case 'getClienteById':
			$response = $ctrl->getClienteById();
			returnResponse($response);
			break;

			// Actualizar cliente
		case 'updateCliente':
			$response = $ctrl->updateCliente();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//MANTENIMIENTO SISTEMA
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Información de tablas
		case 'getDBMaintenanceInfo':
			$response = $ctrl->getDBMaintenanceInfo();
			returnResponse($response);
			break;

			// Petición de años para archivar
		case 'getYearsToArchiveOfmsg':
			$response = $ctrl->getYearsToArchiveOfmsg();
			returnResponse($response);
			break;

			// Archivar / Desarchivar - ofmsg / ofmsg_h
		case 'archiveOfmsgFromDate':
			$response = $ctrl->archiveOfmsgFromDate();
			returnResponse($response);
			break;

			// Archivar / Desarchivar - ofmsg / ofmsg_h por año
		case 'archiveOfmsgFromFullYear':
			$response = $ctrl->archiveOfmsgFromFullYear();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//REPORTES a través de misiones (permanentes)
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Generar reporte multimedia
		case 'getMultimediaReport':
			$response = $ctrl->getMultimediaReport();
			returnResponse($response);
			break;

			// Generar reporte en excel
		case 'generateExcelReport':
			$response = $ctrl->generateExcelReport();
			returnResponse($response);
			break;

			// Generar excel de wordcloud
		case 'generateWordcloudExcel':
			$response = $ctrl->generateWordcloudExcel();
			returnResponse($response);
			break;

			// Generar datos de reporte
		case 'generatePermanentReportData':
			$response = $ctrl->generatePermanentReportData();
			returnResponse($response);
			break;

			// Generar powerpoint completo
		case 'generatePermanentPowerpointWithWordcloud':
			$response = $ctrl->generatePermanentPowerpointWithWordcloud();
			returnResponse($response);
			break;

			// Generar word completo
		case 'generatePermanentWordWithWordcloud':
			$response = $ctrl->generatePermanentWordWithWordcloud();
			returnResponse($response);
			break;

			// Descargar reportes permanentes
		case 'downloadPermanentReports':
			$response = $ctrl->downloadPermanentReports();
			returnResponse($response);
			break;

			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//REPORTES
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Generar powerpoint dinámico
		case 'generateDinamicReport':
			$response = $ctrl->generateDinamicReport();
			returnResponse($response);
			break;

			// Generar reporte en word
		case 'generateWord':
			$response = $ctrl->generateWord();
			returnResponse($response);
			break;

			// Crear reporte en word
		case 'printWord':
			$response = $ctrl->printWord();
			returnResponse($response);
			break;

			// Borrar archivos word
		case 'deleteWord':
			$response = $ctrl->deleteWord();
			returnResponse($response);
			break;

			// Script execSocialTools
		case 'execSocialTools':
			$response = $ctrl->execSocialTools();
			returnResponse($response);
			break;

			// Peticion de todas las gráficas para reporte en .ppt
		case 'requestAllGraphs':
			$response = $ctrl->requestAllGraphs();
			returnResponse($response);
			break;

			// Crear reporte en .ppt
		case 'printPpt':
			$response = $ctrl->printPpt();
			returnResponse($response);
			break;

			// Crear reporte en .ppt perfilación
		case 'printPptPerf':
			$response = $ctrl->printPptPerf();
			returnResponse($response);
			break;

			// Borrar archivos .ppt
		case 'deletePpt':
			$response = $ctrl->deleteWord();
			returnResponse($response);
			break;

			// Generar reporte en excel
		case 'generateExcel':
			$response = $ctrl->generateExcel();
			returnResponse($response);
			break;

			// Generar reporte en excel comparativo
		case 'generateExcelComparativo':
			$response = $ctrl->generateExcelComparativo();
			returnResponse($response);
			break;

			// Generar multimedia
		case 'getImagesSurvey':
			$response = $ctrl->getImagesSurvey();
			returnResponse($response);
			break;

			// Borrar archivos multimedia
		case 'deleteFilesUser':
			$response = $ctrl->deleteFilesUser();
			returnResponse($response);
			break;

			// Generar reporte comparativo en word
		case 'requestComparativeWord':
			$response = $ctrl->requestComparativeWord();
			returnResponse($response);
			break;

			// Crear reporte comparativo en word
		case 'printComparativeWord':
			$response = $ctrl->printComparativeWord();
			returnResponse($response);
			break;

			// Generar gráficas de reporte comparativo
		case 'requestComparativeAllGraphs':
			$response = $ctrl->requestComparativeAllGraphs();
			returnResponse($response);
			break;

			// Crear reporte en .ppt muestreo comparativo
		case 'printPptComparative':
			$response = $ctrl->printPptComparative();
			returnResponse($response);
			break;

			// Eliminar excel
		case 'deleteFileExcel':
			$response = $ctrl->deleteFileExcel();
			returnResponse($response);
			break;

		case 'generateWordComparativo':
			$response = $ctrl->generateWordComparativo();
			returnResponse($response);
			break;

		case 'reports':
			$response = $ctrl->getDataReports();
			returnResponse($response);
			break;

		case 'printReports':
			$response = $ctrl->printReports();
			returnResponse($response);
			break;

		case 'getAllCustomers':
			$response = $ctrl->getAllCustomers();
			returnResponse($response);
			break;

		case 'getAllCustomerDetails':
			$response = $ctrl->getAllCustomerDetails();
			returnResponse($response);
			break;

		case 'setAllCustomerDetails':
			$response = $ctrl->setAllCustomerDetails();
			returnResponse($response);
			break;


			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CHAT BOT
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
		case 'getVoiceAssistantResult':
			$response = $ctrl->sendMessageToBotVoiceAssistant();
			returnResponse($response);
			break;

		case 'sendBotMessage':
			$response = $ctrl->sendBotMessage();
			returnResponse($response);
			break;

		case 'SendMessageAdminBot':
			$response = $ctrl->SendMessageAdminBot();
			returnResponse($response);
			break;
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			//CHAT
			//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
			// Configuración de plataforma de chat
		case 'getPlatformConfig_SaaS':
			$response = $ctrl->getPlatformConfig_SaaS();
			returnResponse($response);
			break;

		case 'getChatList_SaaS':
			$response = $ctrl->getChatList_SaaS();
			returnResponse($response);
			break;

			// Petición de todos los asesores
		case 'getUsers_SaaS':
			$response = $ctrl->getUsers_SaaS();
			returnResponse($response);
			break;

			// Petición de los asesores por búsqueda
		case 'getUsersSearch_SaaS':
			$response = $ctrl->getUsersSearch_SaaS();
			returnResponse($response);
			break;

		case 'setUserConfigNotif_SaaS':
			$response = $ctrl->setUserConfigNotif_SaaS();
			returnResponse($response);
			break;

		case 'createDistributionList_SaaS':
			$response = $ctrl->createDistributionList_SaaS();
			returnResponse($response);
			break;

		case 'createGroup_SaaS':
			$response = $ctrl->createGroup_SaaS();
			returnResponse($response);
			break;

		case 'getChatContent_SaaS':
			$response = $ctrl->getChatContent_SaaS();
			returnResponse($response);
			break;

		case 'getChatGroupContent_SaaS':
			$response = $ctrl->getChatGroupContent_SaaS();
			returnResponse($response);
			break;

			// Datos de contacto
		case 'getInfoContacto_SaaS':
			$response = $ctrl->getInfoContacto_SaaS();
			returnResponse($response);
			break;

			// Datos de grupo
		case 'getInfoGroup_SaaS':
			$response = $ctrl->getInfoGroup_SaaS();
			returnResponse($response);
			break;

			// Silenciar contacto
		case 'muteChat_SaaS':
			$response = $ctrl->muteChat_SaaS();
			returnResponse($response);
			break;

			// Bloquear contacto
		case 'bloquearContacto_SaaS':
			$response = $ctrl->bloquearContacto_SaaS();
			returnResponse($response);
			break;

			// Remuneraciones de contacto
		case 'getDetallePagosByUserWithPoints_SaaS':
			$response = $ctrl->getDetallePagosByUserWithPoints_SaaS();
			returnResponse($response);
			break;

			// Salir de grupo
		case 'takeOutFromGroup_SaaS':
			$response = $ctrl->takeOutFromGroup_SaaS();
			returnResponse($response);
			break;

			// Actualizar grupo
		case 'updateInfoGroup_SaaS':
			$response = $ctrl->updateInfoGroup_SaaS();
			returnResponse($response);
			break;

			// Añadir contactos a grupo
		case 'addToGroup_SaaS':
			$response = $ctrl->addToGroup_SaaS();
			returnResponse($response);
			break;

			// Limpiar conversación grupal
		case 'cleanChatGroupContent_SaaS':
			$response = $ctrl->cleanChatGroupContent_SaaS();
			returnResponse($response);
			break;
			
			// Enviar mensaje a contacto
		case 'postMessage_SaaS':
			$response = $ctrl->postMessage_SaaS();
			returnResponse($response);
			break;

			// Enviar mensaje a grupo
		case 'postMessageGroup_SaaS':
			$response = $ctrl->postMessageGroup_SaaS();
			returnResponse($response);
			break;	

			// Registrar token Firebase
		case 'setTokenDeviceForPush_SaaS':
			$response = $ctrl->setTokenDeviceForPush_SaaS();
			returnResponse($response);
			break;

			// Cambiar avatar de perfil
		case 'updateUserAvatar_SaaS':
			$response = $ctrl->updateUserAvatar_SaaS();
			returnResponse($response);
			break;

			// Marcar como vistos los mensajes de contacto
		case 'markAsReaded_SaaS':
			$response = $ctrl->markAsReaded_SaaS();
			returnResponse($response);
			break;

			// Marcar como vistos los mensajes de grupo
		case 'markAsReadedGroup_SaaS':
			$response = $ctrl->markAsReadedGroup_SaaS();
			returnResponse($response);
			break;

		case 'muteChatGroup_SaaS':
			$response = $ctrl->muteChatGroup_SaaS();
			returnResponse($response);
			break;

			// Recepción de mensajes pendientes de contacto
		case 'getPendingMessages_SaaS':
			$response = $ctrl->getPendingMessages_SaaS();
			returnResponse($response);
			break;

			// Recepción de mensajes pendientes de grupo
		case 'getPendingMessagesGroup_SaaS':
			$response = $ctrl->getPendingMessagesGroup_SaaS();
			returnResponse($response);
			break;

			// Reenviar mensajes
		case 'resendMessage_SaaS':
			$response = $ctrl->resendMessage_SaaS();
			returnResponse($response);
			break;

			// Responder mensajes a contact
		case 'answerMessage_SaaS':
			$response = $ctrl->answerMessage_SaaS();
			returnResponse($response);
			break;

			// Responder mensajes a grupo
		case 'answerMessageGroup_SaaS':
			$response = $ctrl->answerMessageGroup_SaaS();
			returnResponse($response);
			break;

			// Eliminar un chat de la lista de contactos
		case 'deleteChatFromList_SaaS':
			$response = $ctrl->deleteChatFromList_SaaS();
			returnResponse($response);
			break;

			// Eliminar un chat grupal de la lista de contactos
		case 'deleteChatGroupFromList_SaaS':
			$response = $ctrl->deleteChatGroupFromList_SaaS();
			returnResponse($response);
			break;

			// Cambiar el administrador de un grupo
		case 'changeAdminGroup_SaaS':
			$response = $ctrl->changeAdminGroup_SaaS();
			returnResponse($response);
			break;

			// Petición de mensajes anteriores para contacto
		case 'loadPreviousMessages_SaaS':
			$response = $ctrl->loadPreviousMessages_SaaS();
			returnResponse($response);
			break;

			// Petición de mensajes anteriores para grupo
		case 'loadPreviousMessagesGroup_SaaS':
			$response = $ctrl->loadPreviousMessagesGroup_SaaS();
			returnResponse($response);
			break;
			
		// Obtener los documentos enviados en una chat 1:1
		case 'getChatMedia_SaaS':
			$response = $ctrl->getChatMedia_SaaS();
			returnResponse($response);
			break;
			// Obtener los documentos enviados de un grupo
		case 'getChatGroupMedia_SaaS':
			$response = $ctrl->getChatGroupMedia_SaaS();
			returnResponse($response);
			break;

			// Editar mensaje
		case 'editMessage_SaaS':
			$response = $ctrl->editMessage_SaaS();
			returnResponse($response);
			break;

			// Listas de distribución por administrador
		case 'getAllDistributionListByAdmin_SaaS':
			$response = $ctrl->getAllDistributionListByAdmin_SaaS();
			returnResponse($response);
			break;

			// Mensajes enviados por el administrador a una lista de distribución
		case 'getChatDistibutionListContent_SaaS':
			$response = $ctrl->getChatDistibutionListContent_SaaS();
			returnResponse($response);
			break;

			// Enviar mensaje a lista de distribución
		case 'postMessageList_SaaS':
			$response = $ctrl->postMessageList_SaaS();
			returnResponse($response);
			break;

			// Información de la lista de distribución
		case 'getDistibutionListInfo_SaaS':
			$response = $ctrl->getDistibutionListInfo_SaaS();
			returnResponse($response);
			break;
		
		case 'initChatbotSession_SaaS':
			$response = $ctrl->initChatbotSession_SaaS();
			returnResponse($response);
			break;

		case 'updateChatbotSession_SaaS':
			$response = $ctrl->updateChatbotSession_SaaS();
			returnResponse($response);
			break;

		case 'getChatbotSession_SaaS':
			$response = $ctrl->getChatbotSession_SaaS();
			returnResponse($response);
			break;
		
			// getIfQuestionsAreEquals
		case 'getIfQuestionsAreEquals':
			$response = $ctrl->getIfQuestionsAreEquals();
			returnResponse($response);
			break;

			// getAnalyticsDiferenciasSignificativas
		case 'getAnalyticsDiferenciasSignificativas':
			$response = $ctrl->getAnalyticsDiferenciasSignificativas();
			returnResponse($response);
			break;

		default:
			header('HTTP/1.1 404 Not Found');
			exit();
	}
} else {
	header('HTTP/1.1 404 Not Found');
	exit();
}

function returnResponse($response) {
	if(!isset($response)) {
		$response['status'] = 'KO';
		$response['result'] = 'Server ERROR';
	}
	echo json_encode($response);
}