<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class AdministradoresController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Roles permitidos para administrador
	public function getAllAdminRolesMenu($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'cpgUser' => $client['cpgUser']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Guardar nuevo administrador
	public function registerAPIUser($client) {
		// Comprobar si existe este usuario
		$url = CONSTANTS::SERVERAPI . 'userAPIExists';
		$params = [
			'token' => $client['token'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status == 'OK') {
			if($resultPOST->result == 'User API not exists') {
				$url = CONSTANTS::SERVERAPI . $client['action'];
				$params = [
					'token' => $client['token'],
					'email' => $client['email'],
					'mustResetPass' => $client['mustResetPass'],
					'enabled' => $client['enabled'],
					'username' => $client['username'],
					'userapellidos' => $client['userapellidos'],
					'userapellidos2' => $client['userapellidos2'],
					'empresa' => $client['empresa'],
					'departamento' => $client['departamento'],
					'country' => $client['country'],
					'lenguage' => $client['lenguage'],
					'idTenant' => $client['idTenant'],
					'idCPG' => $client['idCPG'],
					'passwordAPI' => $client['passwordAPI'],
					'role' => $client['role'],
					'appUser' => $client['appUser'],
					'idCliente' => $client['idCliente']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}

				// Guardar lista de países permitidos
				$country = explode(',', $client['countries']);
				$url = CONSTANTS::SERVERAPI . 'setUserAPICountries';
				$params = [
					'token' => $client['token'],
					'email' => $client['email'],
					'country' => json_encode($country)
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}

				// Notificación en log
				$type = 'New admin user';
				$service = $client['userAdmin'];
				$event = 'New admin user: ' . $client['email'];
				$this->utilesController->setCMBPLOG($client['token'], $type, $service, $event, '', '1');

				$response['status'] = 'OK';
				$response['result'] = 'OK';
				$response['exist'] = false;
				return $response;
			} else {
				$response['status'] = 'OK';
				$response['result'] = 'User API exists';
				$response['exist'] = true;
				return $response;
			}
		} else {
			$response['status'] = 'KO';
			return $response;
		}
	}

	// Eliminación de administrador
	public function dropUserAPI($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['adminUsers'] != '[]') {
			foreach($client['adminUsers'] as $adminUser) {
				$params = [
					'token' => $client['token'],
					'email' => $adminUser['email']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = ['status' => 'OK'];
		}

		return $resultPOST;
	}

	// Países permitidos para administrador
	public function getUserAPICountries($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Cambiar contraseña de administrador
	public function resetPasswordAPIUser($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'passwordAPI' => $client['passwordAPI']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar administrador
	public function updateAPIUser($client) {
		$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
		$params = [
			'token' => $client['token']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$maxSize = $resultPOST->result[0]->upload_max_filesize_bytes;

		$url = CONSTANTS::SERVERAPI . $client['action'];

		// Cambio de avatar
		if(isset($client['changeAvatar']) && $client['changeAvatar'] == 'true') {
			if($_FILES['file']['size'] <= $maxSize) {
				$type = $_FILES['file']['type'];
				$type_Array = explode('/', $type);
				$tempName = 'tempName.' . $type_Array[1];

				// Creación de carpeta de usuario
				$filepath = CONSTANTS::PATH_EXPORT_WORD . '/avatar/' . $client['email'];
				if(!file_exists($filepath)) {
					$createFile = $this->utilesController->createDirectory($filepath);

					if($createFile['status'] == 'KO') {
						return $createFile;
					}
				}

				// Mover imagen a carpeta de usuario
				if(!move_uploaded_file($_FILES['file']['tmp_name'], $filepath . '/' . $tempName)) {
					$response['status'] = 'KO';
					return $response;
				}

				// Cambiar imagen
				$originalImage = $filepath . '/' . $tempName;
				$outputImage = $filepath . '/avatar.jpg';
				$quality = 100;
				$convert = $this->utilesController->convertImageJPG($originalImage, $outputImage, $quality);

				if($convert == 1) {
					// Borrar imagen original
					unlink($originalImage);
				} else {
					$response['status'] = 'KO';
					return $response;
				}
			}
		}

		$params = [
			'token' => $client['token'],
			'mustResetPass' => $client['mustResetPass'],
			'enabled' => $client['enabled'],
			'email' => $client['email'],
			'username' => $client['username'],
			'userapellidos' => $client['userapellidos'],
			'userapellidos2' => $client['userapellidos2'],
			'empresa' => $client['empresa'],
			'departamento' => $client['departamento'],
			'country' => $client['country'],
			'lenguage' => $client['lenguage'],
			'idTenant' => $client['idTenant'],
			'role' => $client['role'],
			'appUser' => $client['appUser'],
			'idCliente' => $client['idCliente']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK' || $resultPOST->result == 'Not free licences.') {
			return $resultPOST;
		}

		// Guardar lista de países permitidos
		$country = explode(',', $client['countries']);
		$url = CONSTANTS::SERVERAPI . 'setUserAPICountries';
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'country' => json_encode($country)
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($client['enabledOld'] == '0' && $client['enabled'] == '1') {
			// Notificación en log
			$type = 'Activation admin user';
			$service = $client['userAdmin'];
			$event = 'Activation admin user: ' . $client['email'];
			$this->utilesController->setCMBPLOG($client['token'], $type, $service, $event, '', '1');
		}

		return $resultPOST;
	}

	public function newAdminRoleMenu($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role'],
			'backendshowcommunity' => $client['backendshowcommunity'],
			'usuarios' => $client['usuarios'],
			'addUsers' => $client['addUsers'],
			'usuarios_importar' => $client['usuarios_importar'],
			'roles' => $client['roles'],
			'segmentaciones' => $client['segmentaciones'],
			'editsegmentations' => $client['editsegmentations'],
			'segmentaciones_automatizadas' => $client['segmentaciones_automatizadas'],
			'grupos' => $client['grupos'],
			'difusion' => $client['difusion'],
			'backendshownotificaciones' => $client['backendshownotificaciones'],
			'notificaciones' => $client['notificaciones'],
			'notificaciones_consejeros' => $client['notificaciones_consejeros'],
			'notificaciones_consejeros_telf' => $client['notificaciones_consejeros_telf'],
			'notificaciones_pre_consejeros' => $client['notificaciones_pre_consejeros'],
			'notificaciones_cola' => $client['notificaciones_cola'],
			'backendshowoperations' => $client['backendshowoperations'],
			'collapse_productos' => $client['collapse_productos'],
			'productos' => $client['productos'],
			'collapse_proyectos' => $client['collapse_proyectos'],
			'proyectos' => $client['proyectos'],
			'expulsion' => $client['expulsion'],
			'collapse_misiones' => $client['collapse_misiones'],
			'misiones' => $client['misiones'],
			'misiones_type' => $client['misiones_type'],
			'cumplimiento' => $client['cumplimiento'],
			'misiones_cola' => $client['misiones_cola'],
			'misiones_urls' => $client['misiones_urls'],
			'alta_misiones' => $client['alta_misiones'],
			'edicion_misiones' => $client['edicion_misiones'],
			'borrado_misiones' => $client['borrado_misiones'],
			'collapse_encuestas' => $client['collapse_encuestas'],
			'generador_encuestas' => $client['generador_encuestas'],
			'rotaciones' => $client['rotaciones'],
			'templates' => $client['templates'],
			'backendshowanalytics' => $client['backendshowanalytics'],
			'collapse_analyticcomunidad' => $client['collapse_analyticcomunidad'],
			'asesores' => $client['asesores'],
			'word_cloud' => $client['word_cloud'],
			'conversaciones' => $client['conversaciones'],
			'catalogacion' => $client['catalogacion'],
			'licencias' => $client['licencias'],
			'perfilacionsinfinalizar' => $client['perfilacionsinfinalizar'],
			'stores' => $client['stores'],
			'collapse_muestreo' => $client['collapse_muestreo'],
			'muestreo' => $client['muestreo'],
			'muestreo_dinamico' => $client['muestreo_dinamico'],
			'muestreodetallado' => $client['muestreodetallado'],
			'muestreodetallado_maz' => $client['muestreodetallado_maz'],
			'muestreodetallado_maz_seg' => $client['muestreodetallado_maz_seg'],
			'muestreodetalladocomparativo' => $client['muestreodetalladocomparativo'],
			'muestreocomparativo' => $client['muestreocomparativo'],
			'collapse_operativo' => $client['collapse_operativo'],
			'cumplimientos' => $client['cumplimientos'],
			'inversion' => $client['inversion'],
			'kpi_surveys' => $client['kpi_surveys'],
			'cdp' => $client['cdp'],
			'cubos' => $client['cubos'],
			'passiveTracking' => $client['passiveTracking'],
			'diferenciassignificativas' => $client['diferenciassignificativas'],
			'plantillas_reportes' => $client['plantillas_reportes'],
			'backendshowrewards' => $client['backendshowrewards'],
			'collapse_pagos' => $client['collapse_pagos'],
			'pagos' => $client['pagos'],
			'pagos_archivo' => $client['pagos_archivo'],
			'pagos_detalle' => $client['pagos_detalle'],
			'pagos_automatizados' => $client['pagos_automatizados'],
			'collapse_catalogorecompensas' => $client['collapse_catalogorecompensas'],
			'articulos_catalogo' => $client['articulos_catalogo'],
			'catalogos' => $client['catalogos'],
			'backendshowConsumo' => $client['backendshowConsumo'],
			'backendshowitems' => $client['backendshowitems'],
			'show_all_items' => '1',
			'backendshowStores' => $client['backendshowStores'],
			'show_all_stores' => $client['show_all_stores'],
			'show_stores_type' => $client['show_stores_type'],
			'backendshowintegraciones' => $client['backendshowintegraciones'],
			'html' => $client['html'],
			'addons' => $client['addons'],
			'voiceAssistant' => $client['voiceAssistant'],
			'hashtags' => $client['hashtag'],
			'backendshowtenants' => $client['backendshowtenants'],
			'tenant' => $client['tenant'],
			'tenant_licenses' => $client['tenant_licenses'],
			'backendshowcpg' => $client['backendshowcpg'],
			'cpg' => $client['cpg'],
			'cpg_licenses' => $client['cpg_licenses'],
			'backendshowclients' => $client['backendshowclients'],
			'show_all_clients' => $client['show_all_clients'],
			'backendshowajustes' => $client['backendshowajustes'],
			'welcometour' => $client['welcometour'],
			'dominios_embebidos' => $client['dominios_embebidos'],
			'bots' => $client['bots'],
			'definicion_catalogacion_asesores' => $client['definicion_catalogacion_asesores'],
			'perfilacion' => $client['perfilacion'],
			'formulario_registro' => $client['formulario_registro'],
			'paises' => $client['paises'],
			'idiomas' => $client['idiomas'],
			'perfiles' => $client['perfiles'],
			'exclusiones_wordcloud' => $client['exclusiones_wordcloud'],
			'collapse_administradores' => $client['collapse_administradores'],
			'administradores_backend' => $client['administradores_backend'],
			'roles_backend' => $client['roles_backend'],
			'collapse_configuracion' => $client['collapse_configuracion'],
			'configuracion' => $client['configuracion'],
			'funcionalidades_app' => $client['funcionalidades_app'],
			'logs' => $client['logs'],
			'rsc' => $client['rsc'],
			'table_information' => $client['table_information'],
			'pop_ups' => $client['pop_ups']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Formato de permisos
		$values = [];
		foreach($client['addOnPermissions'] as $addOnPermission) {
			$idAddon = $addOnPermission['idAddon'];
			$idSection = $addOnPermission['idSection'];
			$visible = $addOnPermission['visible'];
			if($idAddon == '' || $idSection == '') {
				continue;
			}

			$value = $idAddon . '#' . $idSection . '#' . $visible;
			array_push($values, $value);
		}

		if(count($values) > 0) {
			// Nuevos
			$url = CONSTANTS::SERVERAPI . 'setUsersRoleAddons';
			$params = [
				'token' => $client['token'],
				'role' => $client['role'],
				'values' => json_encode($values)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}

	// Eliminar rol de Administrador BackEnd
	public function deleteAdminRoleMenu($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['adminRoles'] != '[]') {
			foreach($client['adminRoles'] as $adminRol) {
				$params = [
					'token' => $client['token'],
					'role' => $adminRol['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = ['status' => 'OK'];
		}

		if(isset($client['userAdmin'])) {
			// Notificación en log
			$type = 'Elimination of roles';
			$service = $client['userAdmin'];
			$event = $client['userAdmin'] . ' borró roles con usuarios administradores asignados';
			$this->utilesController->setCMBPLOG($client['token'], $type, $service, $event, '', '1');
		}

		return $resultPOST;
	}

	// Petición de permisos de rol de Administrador BackEnd
	public function getAdminRoleMenu($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de permisos de AddOns de rol de Administrador BackEnd
	public function getUsersRoleAddons($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar rol de Administrador BackEnd
	public function editAdminRoleMenu($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'role' => $client['role'],
			'backendshowcommunity' => $client['backendshowcommunity'],
			'usuarios' => $client['usuarios'],
			'addUsers' => $client['addUsers'],
			'usuarios_importar' => $client['usuarios_importar'],
			'roles' => $client['roles'],
			'segmentaciones' => $client['segmentaciones'],
			'editsegmentations' => $client['editsegmentations'],
			'segmentaciones_automatizadas' => $client['segmentaciones_automatizadas'],
			'grupos' => $client['grupos'],
			'difusion' => $client['difusion'],
			'backendshownotificaciones' => $client['backendshownotificaciones'],
			'notificaciones' => $client['notificaciones'],
			'notificaciones_consejeros' => $client['notificaciones_consejeros'],
			'notificaciones_consejeros_telf' => $client['notificaciones_consejeros_telf'],
			'notificaciones_pre_consejeros' => $client['notificaciones_pre_consejeros'],
			'notificaciones_cola' => $client['notificaciones_cola'],
			'backendshowoperations' => $client['backendshowoperations'],
			'collapse_productos' => $client['collapse_productos'],
			'productos' => $client['productos'],
			'collapse_proyectos' => $client['collapse_proyectos'],
			'proyectos' => $client['proyectos'],
			'expulsion' => $client['expulsion'],
			'collapse_misiones' => $client['collapse_misiones'],
			'misiones' => $client['misiones'],
			'misiones_type' => $client['misiones_type'],
			'cumplimiento' => $client['cumplimiento'],
			'misiones_cola' => $client['misiones_cola'],
			'misiones_urls' => $client['misiones_urls'],
			'alta_misiones' => $client['alta_misiones'],
			'edicion_misiones' => $client['edicion_misiones'],
			'borrado_misiones' => $client['borrado_misiones'],
			'collapse_encuestas' => $client['collapse_encuestas'],
			'generador_encuestas' => $client['generador_encuestas'],
			'rotaciones' => $client['rotaciones'],
			'templates' => $client['templates'],
			'backendshowanalytics' => $client['backendshowanalytics'],
			'collapse_analyticcomunidad' => $client['collapse_analyticcomunidad'],
			'asesores' => $client['asesores'],
			'word_cloud' => $client['word_cloud'],
			'conversaciones' => $client['conversaciones'],
			'catalogacion' => $client['catalogacion'],
			'licencias' => $client['licencias'],
			'perfilacionsinfinalizar' => $client['perfilacionsinfinalizar'],
			'stores' => $client['stores'],
			'collapse_muestreo' => $client['collapse_muestreo'],
			'muestreo' => $client['muestreo'],
			'muestreo_dinamico' => $client['muestreo_dinamico'],
			'muestreodetallado' => $client['muestreodetallado'],
			'muestreodetallado_maz' => $client['muestreodetallado_maz'],
			'muestreodetallado_maz_seg' => $client['muestreodetallado_maz_seg'],
			'muestreodetalladocomparativo' => $client['muestreodetalladocomparativo'],
			'muestreocomparativo' => $client['muestreocomparativo'],
			'collapse_operativo' => $client['collapse_operativo'],
			'cumplimientos' => $client['cumplimientos'],
			'inversion' => $client['inversion'],
			'kpi_surveys' => $client['kpi_surveys'],
			'tiempo_respuesta' => $client['tiempo_respuesta'],
			'cdp' => $client['cdp'],
			'cubos' => $client['cubos'],
			'passiveTracking' => $client['passiveTracking'],
			'diferenciassignificativas' => $client['diferenciassignificativas'],
			'plantillas_reportes' => $client['plantillas_reportes'],
			'backendshowrewards' => $client['backendshowrewards'],
			'collapse_pagos' => $client['collapse_pagos'],
			'pagos' => $client['pagos'],
			'pagos_archivo' => $client['pagos_archivo'],
			'pagos_detalle' => $client['pagos_detalle'],
			'pagos_automatizados' => $client['pagos_automatizados'],
			'collapse_catalogorecompensas' => $client['collapse_catalogorecompensas'],
			'articulos_catalogo' => $client['articulos_catalogo'],
			'catalogos' => $client['catalogos'],
			'backendshowConsumo' => $client['backendshowConsumo'],
			'backendshowitems' => $client['backendshowitems'],
			'show_all_items' => '1',
			'backendshowStores' => $client['backendshowStores'],
			'show_all_stores' => $client['show_all_stores'],
			'show_stores_type' => $client['show_stores_type'],
			'backendshowintegraciones' => $client['backendshowintegraciones'],
			'html' => $client['html'],
			'addons' => $client['addons'],
			'voiceAssistant' => $client['voiceAssistant'],
			'hashtags' => $client['hashtag'],
			'backendshowtenants' => $client['backendshowtenants'],
			'tenant' => $client['tenant'],
			'tenant_licenses' => $client['tenant_licenses'],
			'backendshowcpg' => $client['backendshowcpg'],
			'cpg' => $client['cpg'],
			'cpg_licenses' => $client['cpg_licenses'],
			'backendshowclients' => $client['backendshowclients'],
			'show_all_clients' => $client['show_all_clients'],
			'backendshowajustes' => $client['backendshowajustes'],
			'welcometour' => $client['welcometour'],
			'dominios_embebidos' => $client['dominios_embebidos'],
			'bots' => $client['bots'],
			'definicion_catalogacion_asesores' => $client['definicion_catalogacion_asesores'],
			'perfilacion' => $client['perfilacion'],
			'formulario_registro' => $client['formulario_registro'],
			'paises' => $client['paises'],
			'idiomas' => $client['idiomas'],
			'perfiles' => $client['perfiles'],
			'exclusiones_wordcloud' => $client['exclusiones_wordcloud'],
			'collapse_administradores' => $client['collapse_administradores'],
			'administradores_backend' => $client['administradores_backend'],
			'roles_backend' => $client['roles_backend'],
			'collapse_configuracion' => $client['collapse_configuracion'],
			'configuracion' => $client['configuracion'],
			'funcionalidades_app' => $client['funcionalidades_app'],
			'logs' => $client['logs'],
			'rsc' => $client['rsc'],
			'table_information' => $client['table_information'],
			'pop_ups' => $client['pop_ups']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Borrado
		foreach($client['addOnPermissionsOld'] as $addOnPermissionsOld) {
			$idAddonOld = $addOnPermissionsOld['idAddon'];
			$idSectionOld = $addOnPermissionsOld['idSection'];
			$clear = true;

			foreach($client['addOnPermissions'] as $addOnPermission) {
				if($idAddonOld == $addOnPermission['idAddon'] && $idSectionOld == $addOnPermission['idSection']) {
					$clear = false;
				}
			}

			if($clear) {
				$url = CONSTANTS::SERVERAPI . 'deleteUsersRoleAddons';
				$params = [
					'token' => $client['token'],
					'role' => $client['role'],
					'idAddon' => $idAddonOld,
					'idSection' => $idSectionOld
				];

				$resultPOSTClear = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOSTClear->status == 'KO') {
					return $resultPOSTClear;
				}
			}
		}

		// Nuevas y ediciones
		$values = [];
		foreach($client['addOnPermissions'] as $addOnPermission) {
			$idAddon = $addOnPermission['idAddon'];
			$idSection = $addOnPermission['idSection'];
			$visible = $addOnPermission['visible'];

			if($idAddon == '') {
				continue;
			}

			$newEdit = true;
			foreach($client['addOnPermissionsOld'] as $addOnPermissionOld) {
				if($addOnPermissionOld['idAddon'] == $idAddon && $addOnPermissionOld['idSection'] == $idSection && $addOnPermissionOld['visible'] == $visible) {
					$newEdit = false;
				}
			}

			if($newEdit) {
				// Nueva/Editar
				$value = $idAddon . '#' . $idSection . '#' . $visible;
				array_push($values, $value);
			}
		}

		if(count($values) > 0) {
			// Nuevos
			$url = CONSTANTS::SERVERAPI . 'setUsersRoleAddons';
			$params = [
				'token' => $client['token'],
				'role' => $client['role'],
				'values' => json_encode($values)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}
}