<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class AsistenteVozController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Guardar diccionario nuevo
	public function setVoiceassistantDictionary($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'description' => $client['description'],
			'country' => $client['country'],
			'sistema' => $client['sistema']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// ID del nuevo diccionario creado
		$idDictionary = $resultPOST->id;

		// Crear registros
		$text = [];
		// Registros importados
		$importedRecords = [];
		$size = count($client['registers']);
		for($i = 0; $i < $size; $i++) {
			if($client['registers'][$i]['descripcion'] !== '' && $client['registers'][$i]['respuesta'] !== '') {
				$answer = $client['registers'][$i]['respuesta'];
				if($client['registers'][$i]['tipo'] === 'hashtag') {
					$answer = $client['registers'][$i]['idHash'];
				}
				$obj = (object)[
					'text' => $client['registers'][$i]['descripcion'],
					'type' => $client['registers'][$i]['tipo'],
					'answer' => $answer
				];

				if($client['registers'][$i]['idDictionaryImp'] !== '') {
					array_push($importedRecords, $i);
				}

				array_push($text, $obj);
			}
		}

		// Guardar registros
		if(count($text) > 0) {
			$url = CONSTANTS::SERVERAPI . 'setVoiceassistantDictionaryRegister';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $idDictionary,
				'text' => json_encode($text)
			];

			$resultPOST_reg = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST_reg->status != 'OK') {
				return $resultPOST_reg;
			}

			$registersId = $resultPOST_reg->id;
		}

		// Importar sinónimos
		$size = count($importedRecords);
		if($size > 0) {
			for($i = 0; $i < $size; $i++) {
				// Petición de los sinónimos a importar
				$url = CONSTANTS::SERVERAPI . 'getAllVoiceassistantDictionarySynonym';
				$params = [
					'token' => $client['token'],
					'idDictionary' => $client['registers'][$importedRecords[$i]]['idDictionaryImp'],
					'idLine' => $client['registers'][$importedRecords[$i]]['idLineImp']
				];

				$resultPOSTGetSin = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOSTGetSin->status != 'OK') {
					return $resultPOSTGetSin;
				}

				$sinSize = count($resultPOSTGetSin->result);
				if($sinSize > 0) {
					$setSynonym = [];
					for($j = 0; $j < $sinSize; $j++) {
						$obj = (object)[
							'text' => $resultPOSTGetSin->result[$j]->text
						];

						array_push($setSynonym, $obj);
					}

					// Guardado de sinónimos importados
					$url = CONSTANTS::SERVERAPI . 'setVoiceassistantDictionarySynonym';
					$params = [
						'token' => $client['token'],
						'idDictionary' => $idDictionary,
						'idLine' => $registersId[$importedRecords[$i]],
						'text' => json_encode($setSynonym)
					];

					$resultPOSTSetSin = $this->utilesController->sendCurlPOST($url, $params);

					if($resultPOSTSetSin->status != 'OK') {
						return $resultPOSTSetSin;
					}
				}
			}
		}

		return $resultPOST;
	}

	// Eliminar diccionario
	public function deleteVoiceassistantDictionary($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['dictionaries'] != '[]') {
			foreach($client['dictionaries'] as $dictionary) {
				$params = [
					'token' => $client['token'],
					'idDictionary' => $dictionary['idDictionary']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = ['status' => 'OK'];
		}

		return $resultPOST;
	}

	// Carga de diccionario por id
	public function getVoiceassistantDictionaryById($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idDictionary' => $client['idDictionary']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Carga de registros por id de diccionario
	public function getAllVoiceassistantDictionaryRegisters($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idDictionary' => $client['idDictionary']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar diccionario
	public function updateVoiceassistantDictionary($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idDictionary' => $client['idDictionary'],
			'description' => $client['description'],
			'country' => $client['country'],
			'sistema' => $client['sistema']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Crear registros
		$text = [];
		// Registros importados
		$importedRecords = [];
		$textUpdate = [];
		$size = count($client['registers']);
		for($i = 0; $i < $size; $i++) {
			// Registros nuevos
			if($client['registers'][$i]['descripcion'] !== '' && $client['registers'][$i]['respuesta'] !== '' && $client['registers'][$i]['idLine'] === '') {
				$answer = $client['registers'][$i]['respuesta'];
				if($client['registers'][$i]['tipo'] === 'hashtag') {
					$answer = $client['registers'][$i]['idHash'];
				}
				$obj = (object)[
					'text' => $client['registers'][$i]['descripcion'],
					'type' => $client['registers'][$i]['tipo'],
					'answer' => $answer
				];

				if($client['registers'][$i]['idDictionaryImp'] !== '') {
					array_push($importedRecords, $i);
				}

				array_push($text, $obj);
			}

			// Registros a actualizar
			if($client['registers'][$i]['descripcion'] !== '' && $client['registers'][$i]['respuesta'] !== '' && $client['registers'][$i]['state'] === 'update') {
				$answer = $client['registers'][$i]['respuesta'];
				if($client['registers'][$i]['tipo'] === 'hashtag') {
					$answer = $client['registers'][$i]['idHash'];
				}
				$obj = (object)[
					'idLine' => $client['registers'][$i]['idLine'],
					'text' => $client['registers'][$i]['descripcion'],
					'type' => $client['registers'][$i]['tipo'],
					'answer' => $answer
				];

				array_push($textUpdate, $obj);
			}
		}

		// Guardar registros
		if(count($text) > 0) {
			$url = CONSTANTS::SERVERAPI . 'setVoiceassistantDictionaryRegister';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'text' => json_encode($text)
			];

			$resultPOST_reg = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST_reg->status != 'OK') {
				return $resultPOST_reg;
			}

			$registersId = $resultPOST_reg->id;
		}

		// Importar sinónimos
		$size = count($importedRecords);
		if($size > 0) {
			for($i = 0; $i < $size; $i++) {
				// Petición de los sinónimos a importar
				$url = CONSTANTS::SERVERAPI . 'getAllVoiceassistantDictionarySynonym';
				$params = [
					'token' => $client['token'],
					'idDictionary' => $client['registers'][$importedRecords[$i]]['idDictionaryImp'],
					'idLine' => $client['registers'][$importedRecords[$i]]['idLineImp']
				];

				$resultPOSTGetSin = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOSTGetSin->status != 'OK') {
					return $resultPOSTGetSin;
				}

				$sinSize = count($resultPOSTGetSin->result);
				if($sinSize > 0) {
					$setSynonym = [];
					for($j = 0; $j < $sinSize; $j++) {
						$obj = (object)[
							'text' => $resultPOSTGetSin->result[$j]->text
						];

						array_push($setSynonym, $obj);
					}

					// Guardado de sinónimos importados
					$url = CONSTANTS::SERVERAPI . 'setVoiceassistantDictionarySynonym';
					$params = [
						'token' => $client['token'],
						'idDictionary' => $client['idDictionary'],
						'idLine' => $registersId[$importedRecords[$i]],
						'text' => json_encode($setSynonym)
					];

					$resultPOSTSetSin = $this->utilesController->sendCurlPOST($url, $params);

					if($resultPOSTSetSin->status != 'OK') {
						return $resultPOSTSetSin;
					}
				}
			}
		}

		// Actualizar registros
		if(count($textUpdate) > 0) {
			$url = CONSTANTS::SERVERAPI . 'updateVoiceassistantDictionaryRegister';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'text' => json_encode($textUpdate)
			];

			$resultPOST_upd = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST_upd->status != 'OK') {
				return $resultPOST_upd;
			}
		}

		// Borrar registros
		$idLineDelete = [];
		if($client['idLineDelete'] !== '[]') {
			foreach($client['idLineDelete'] as $value) {
				$obj = (object)[
					'idLine' => $value
				];

				array_push($idLineDelete, $obj);
			}
		}

		if(count($idLineDelete) > 0) {
			$url = CONSTANTS::SERVERAPI . 'deleteVoiceassistantDictionaryRegister';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'text' => json_encode($idLineDelete)
			];

			$resultPOST_del = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST_del->status != 'OK') {
				return $resultPOST_del;
			}
		}

		return $resultPOST;
	}

	// Carga sinónimos por id de registro
	public function getAllVoiceassistantDictionarySynonym($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idDictionary' => $client['idDictionary'],
			'idLine' => $client['idLine']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Carga todos los sinónimos de diccionario
	public function getAllVoiceassistantDictionarySynonymAll($client) {
		$url = CONSTANTS::SERVERAPI . 'getAllVoiceassistantDictionarySynonym';
		$params = [
			'token' => $client['token'],
			'idDictionary' => $client['idDictionary']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar sinónimos y no match
	public function updateSynonymsNoMatch($client) {
		$result = [
			'status' => 'OK',
			'result' => 'OK'
		];

		$setSynonym = [];
		$updateSynonym = [];
		$size = count($client['synonymsData']);
		for($i = 0; $i < $size; $i++) {
			if($client['synonymsData'][$i]['status'] == 'new') {
				$obj = (object)[
					'text' => $client['synonymsData'][$i]['text']
				];

				array_push($setSynonym, $obj);
			} else if($client['synonymsData'][$i]['status'] == 'update') {
				$obj = (object)[
					'idSynonym' => $client['synonymsData'][$i]['idSynonymous'],
					'text' => $client['synonymsData'][$i]['text']
				];

				array_push($updateSynonym, $obj);
			}
		}

		// Nuevos sinónimos
		if(count($setSynonym) > 0) {
			$url = CONSTANTS::SERVERAPI . 'setVoiceassistantDictionarySynonym';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'idLine' => $client['idLine'],
				'text' => json_encode($setSynonym)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Actualizar sinónimos
		if(count($updateSynonym) > 0) {
			$url = CONSTANTS::SERVERAPI . 'updateVoiceassistantDictionarySynonym';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'idLine' => $client['idLine'],
				'text' => json_encode($updateSynonym)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Borrar sinónimos
		if($client['synonymsDelete'] != '[]') {
			$deleteSynonym = [];
			$delSizeSyn = count($client['synonymsDelete']);
			for($j = 0; $j < $delSizeSyn; $j++) {
				$obj = (object)[
					'idSynonym' => $client['synonymsDelete'][$j]
				];

				array_push($deleteSynonym, $obj);
			}

			$url = CONSTANTS::SERVERAPI . 'deleteVoiceassistantDictionarySynonym';
			$params = [
				'token' => $client['token'],
				'idDictionary' => $client['idDictionary'],
				'idLine' => $client['idLine'],
				'text' => json_encode($deleteSynonym)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Borrar no match
		if($client['noMatchDataSynonim'] != '[]') {
			$noMatchDataSynonim = [];
			$delSizeNM = count($client['noMatchDataSynonim']);
			for($j = 0; $j < $delSizeNM; $j++) {
				$obj = (object)[
					'idNoMatch' => $client['noMatchDataSynonim'][$j]
				];

				array_push($noMatchDataSynonim, $obj);
			}

			$url = CONSTANTS::SERVERAPI . 'deleteVoiceassistantNoMatch';
			$params = [
				'token' => $client['token'],
				'text' => json_encode($noMatchDataSynonim)
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		return $result;
	}
}