<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class ClientsController {

	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	public function getAllCustomers($client) {
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	public function getAllCustomerDetails($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'id' => $client['id']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function setAllCustomerDetails($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'licencias' => json_encode($client['licencias']),
			'total' => $client['total'],
			'GoogleMapsAPI' => $client['GoogleMapsAPI'],
			'AzureTranscriptionAPI' => $client['AzureTranscriptionAPI'],
			'AzureImageAPI' => $client['AzureImageAPI'],
			'AzureTranslatorAPI' => $client['AzureTranslatorAPI'],
			'TwilioSMSAPI' => $client['TwilioSMSAPI']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}