<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class CommunitymanagementController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	public function getChatList_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'stamp' => $client['stamp'],
			'onlyEnabled' => $client['onlyEnabled'],
			'limit' => $client['limit'],
			'page' => $client['page']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de todos los asesores
	public function getUsers_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'onlyEnabled' => $client['onlyEnabled'],
			'fullMode' => $client['fullMode'],
			'limit' => $client['limit'],
			'page' => $client['page']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de los asesores por búsqueda
	public function getUsersSearch_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'onlyEnabled' => $client['onlyEnabled'],
			'fullMode' => $client['fullMode'],
			'searchWord' => $client['searchWord']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function setUserConfigNotif_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'type' => $client['type'],
			'mute' => $client['mute']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Listas de distribución por administrador
	public function getAllDistributionListByAdmin_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Mensajes enviados por el administrador a una lista de distribución
	public function getChatDistibutionListContent_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'idList' => $client['idList']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function createDistributionList_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'admin' => $client['admin'],
			'activa' => $client['activa'],
			'description' => $client['description'],
			'destinatarios' => json_encode($client['destinatarios'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar mensaje a lista de distribución
	public function postMessageList_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);
			$file = curl_file_create($tmpfile, $_FILES['file']['type'], $filename);

			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'idlist' => $client['idlist'],
				'message' => $client['message'],
				'file' => $file
			];
		} else {
			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'idlist' => $client['idlist'],
				'message' => $client['message']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Información de la lista de distribución
	public function getDistibutionListInfo_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idList' => $client['idList']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function initChatbotSession_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'chatbotEmail' => $client['chatbotEmail']
		];
		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		return $resultPOST;
	}

	public function updateChatbotSession_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'admin' => $client['admin'],
			'chatbot' => $client['chatbot'],
			'user' => $client['user'],
			'administrate' => $client['administrate']
		];
		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		return $resultPOST;
	}

	public function getChatbotSession_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'admin' => $client['admin'],
			'chatbot' => $client['chatbot'],
			'user' => $client['user'],
		];
		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		return $resultPOST;
	}

	public function createGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);

			$params = [
				'token' => $client['token'],
				'groupAdmin' => $client['groupAdmin'],
				'groupName' => $client['groupName'],
				'participants' => json_encode($client['participants']),
				'file' => curl_file_create($tmpfile, $_FILES['file']['type'], $filename)
			];
		} else {
			$params = [
				'token' => $client['token'],
				'groupAdmin' => $client['groupAdmin'],
				'groupName' => $client['groupName'],
				'participants' => json_encode($client['participants'])
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function getChatContent_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function getChatGroupContent_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupID' => $client['groupID'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->result == 'Group ID especificated not exists.') {
			$resultPOST->status = 'OK';
			$resultPOST->inGroup = false;
		}

		return $resultPOST;
	}

	// Datos de contacto
	public function getInfoContacto_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'jid' => $client['jid']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Datos de grupo
	public function getInfoGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupID' => $client['groupID'],
			'groupName' => $client['groupName']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Silenciar contacto
	public function muteChat_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB'],
			'mute' => $client['mute']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Bloquear contacto
	public function bloquearContacto_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'userBloqueado' => $client['userBloqueado'],
			'value' => $client['value']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Remuneraciones de contacto
	public function getDetallePagosByUserWithPoints_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'user' => $client['user'],
			'idTenantApp' => $client['idTenantApp'],
			'idCPGApp' => $client['idCPGApp']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Salir de grupo
	public function takeOutFromGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupId' => $client['groupId'],
			'participants' => json_encode($client['participants'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	public function updateInfoGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);

			$params = [
				'token' => $client['token'],
				'groupID' => $client['groupID'],
				'groupName' => $client['groupName'],
				'description' => json_encode($client['description']),
				'file' => curl_file_create($tmpfile, $_FILES['file']['type'], $filename),
				'removeAvatar' => $client['removeAvatar']
			];
		} else {
			$params = [
				'token' => $client['token'],
				'groupID' => $client['groupID'],
				'groupName' => $client['groupName'],
				'description' => json_encode($client['description']),
				'removeAvatar' => $client['removeAvatar']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Añadir contactos a grupo
	public function addToGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupId' => $client['groupId'],
			'participants' => json_encode($client['participants'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}


	// Limpiar conversación grupal 
	public function cleanChatGroupContent_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupID' => $client['groupID'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar mensaje a contacto
	public function postMessage_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);
			$file = curl_file_create($tmpfile, $_FILES['file']['type'], $filename);

			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'to' => json_encode($client['to']),
				'message' => $client['message'],
				'file' => $file
			];
		} else {
			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'to' => json_encode($client['to']),
				'message' => $client['message']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Enviar mensaje a grupo
	public function postMessageGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);
			$file = curl_file_create($tmpfile, $_FILES['file']['type'], $filename);

			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'groupID' => $client['groupID'],
				'message' => $client['message'],
				'file' => $file
			];
		} else {
			$params = [
				'token' => $client['token'],
				'from' => $client['from'],
				'groupID' => $client['groupID'],
				'message' => $client['message']
			];
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Registrar token Firebase
	public function setTokenDeviceForPush_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'platform' => $client['platform'],
			'deviceId' => $client['deviceId']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Cambiar avatar de perfil
	public function updateUserAvatar_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'setDefaultAvatar' => $client['setDefaultAvatar']
		];

		if(isset($_FILES['file'])) {
			$tmpfile = $_FILES['file']['tmp_name'];
			$filename = basename($_FILES['file']['name']);
			$params['file'] = curl_file_create($tmpfile, $_FILES['file']['type'], $filename);
		}

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Marcar como vistos los mensajes de contacto
	public function markAsReaded_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Marcar como vistos los mensajes de grupo
	public function markAsReadedGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'groupID' => $client['groupID']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Silenciar chat grupal
	public function muteChatGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupID' => $client['groupID'],
			'email' => $client['email'],
			'mute' => $client['mute']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}


	// Recepción de mensajes pendientes de contacto
	public function getPendingMessages_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB'],
			'stamp' => $client['stamp']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Recepción de mensajes pendientes de grupo
	public function getPendingMessagesGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'groupID' => $client['groupID'],
			'stamp' => $client['stamp']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Reenviar mensajes
	public function resendMessage_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => json_encode($client['userB']),
			'messages' => json_encode($client['messages'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Responder mensaje a contacto
	public function answerMessage_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'from' => $client['from'],
			'to' => json_encode($client['to']),
			'message' => $client['message'],
			'answerUid' => $client['answerUid']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Responder mensaje a grupo
	public function answerMessageGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'from' => $client['from'],
			'groupID' => $client['groupID'],
			'message' => $client['message'],
			'answerUid' => $client['answerUid']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar un chat de la lista de contactos
	public function deleteChatFromList_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar un chat grupal de la lista de contactos
	public function deleteChatGroupFromList_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'groupID' => $client['groupID']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Cambiar el administrador de un grupo
	public function changeAdminGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'groupID' => $client['groupID'],
			'email' => $client['email'],
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de mensajes anteriores para contacto
	public function loadPreviousMessages_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB'],
			'stamp' => $client['stamp']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de mensajes anteriores para grupo
	public function loadPreviousMessagesGroup_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'groupID' => $client['groupID'],
			'stamp' => $client['stamp']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar mensaje
	public function editMessage_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'uid' => $client['uid'],
			'message' => $client['message']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Obtener los documentos enviados en una chat 1:1
	public function getChatMedia_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'userA' => $client['userA'],
			'userB' => $client['userB']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Obtener los documentos enviados de un grupo
	public function getChatGroupMedia_SaaS($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'email' => $client['email'],
			'groupID' => $client['groupID']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Obtener mensaje para Voice Assistant
	public function sendMessageToBotVoiceAssistant($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
	
		$params = [
			'token' => $client['token'],
			'idTenant' => $client['idTenant'],
			'idCPG' => $client['idCPG'],
			'text' => $client['text'],
			'idDictionary' => $client['idDictionary']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
	// Enviar Bot Message
	public function sendBotMessage($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
	
		$params = [
			'token' => $client['token'],
			'to' => $client['to'],
			'from' => $client['from'],
			'message' => $client['message']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
	// Enviar BotAdmin Message
	public function SendMessageAdminBot($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
	
		$params = [
			'token' => $client['token'],
			'to' => $client['to'],
			'from' => $client['from'],
			'message' => $client['message']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
	
}