<?php
require_once(dirname(__FILE__) . '/../customConfig/Constants.php');
include_once(dirname(__FILE__) . '/SecurityManager.php');
include_once(dirname(__FILE__) . '/../Model/AnalyticGraph.php');
include_once(dirname(__FILE__) . '/../Model/GenerateWord.php');
include_once(dirname(__FILE__) . '/../Model/GeneratePpt.php');
include_once(dirname(__FILE__) . '/../Model/generateExcel.php');
include_once(dirname(__FILE__) . '/../Model/ReportsWord.php');
include_once(dirname(__FILE__) . '/../Model/ReportsPpt.php');
include_once(dirname(__FILE__) . '/../Model/ReportsExcel.php');
include_once(dirname(__FILE__) . '/../Model/ReportsImages.php');
include_once(dirname(__FILE__) . '/../Model/PreviewTables.php');

// CONTROLADORES
include_once(dirname(__FILE__) . '/UtilesController.php');
include_once(dirname(__FILE__) . '/UsuariosController.php');
include_once(dirname(__FILE__) . '/GruposController.php');
include_once(dirname(__FILE__) . '/ListasDifusionController.php');
include_once(dirname(__FILE__) . '/RolesController.php');
include_once(dirname(__FILE__) . '/AnalyticsController.php');
include_once(dirname(__FILE__) . '/MisionesController.php');
include_once(dirname(__FILE__) . '/ProductosController.php');
include_once(dirname(__FILE__) . '/TemplatesController.php');
include_once(dirname(__FILE__) . '/ProyectosController.php');
include_once(dirname(__FILE__) . '/PagosController.php');
include_once(dirname(__FILE__) . '/RecompensasController.php');
include_once(dirname(__FILE__) . '/NotificacionesController.php');
include_once(dirname(__FILE__) . '/OperarController.php');
include_once(dirname(__FILE__) . '/AdministradoresController.php');
include_once(dirname(__FILE__) . '/ItemsController.php');
include_once(dirname(__FILE__) . '/HTMLController.php');
include_once(dirname(__FILE__) . '/AddOnsController.php');
include_once(dirname(__FILE__) . '/AsistenteVozController.php');
include_once(dirname(__FILE__) . '/HashtagsController.php');
include_once(dirname(__FILE__) . '/RotacionesController.php');
include_once(dirname(__FILE__) . '/AjustesController.php');
include_once(dirname(__FILE__) . '/ConfiguracionController.php');
include_once(dirname(__FILE__) . '/TenantController.php');
include_once(dirname(__FILE__) . '/CPGController.php');
include_once(dirname(__FILE__) . '/CustomersController.php');
include_once(dirname(__FILE__) . '/MantenimientoController.php');
include_once(dirname(__FILE__) . '/ClientsController.php');
include_once(dirname(__FILE__) . '/CommunityManagementController.php');
include_once(dirname(__FILE__) . '/MissionsReportController.php');

include_once(dirname(__FILE__) . '/../Utils/Debugger.php');

set_time_limit(CONSTANTS::SET_TIME_LIMIT);

class Controller {
	private $client;
	private $postData;
	private $securityManager;
	private $utilesController;
	private $usuariosController;
	private $gruposController;
	private $rotacionesController;
	private $listasDifusionController;
	private $rolesController;
	private $analyticsController;
	private $misionesController;
	private $productosController;
	private $templatesController;
	private $proyectosController;
	private $pagosController;
	private $recompensasController;
	private $notificacionesController;
	private $operarController;
	private $administradoresController;
	private $itemsController;
	private $htmlController;
	private $addOnsController;
	private $asistenteVozController;
	private $hashtagsController;
	private $ajustesController;
	private $configuracionController;
	private $tenantController;
	private $cpgController;
	private $customersController;
	private $mantenimientoController;
	private $clientsController;
	private $communityManagementController;
	private $rolesAdminBackend;
	private $optionsCPGMaster;
	private $globalMultitenant;
	private $globalMulticpg;
	private $mainAdminCPG;
	private $mainAdminSL;
	private $idCPG;
	private $missionsReport;
	private $globalWorkingwithClients;

	function __construct() {
		$this->client = null;
		$this->postData = null;
		$this->securityManager = new SecurityManager();
		$this->utilesController = new UtilesController();
		$this->usuariosController = new UsuariosController();
		$this->gruposController = new GruposController();
		$this->listasDifusionController = new ListasDifusionController();
		$this->rolesController = new RolesController();
		$this->analyticsController = new AnalyticsController();
		$this->misionesController = new MisionesController();
		$this->productosController = new ProductosController();
		$this->templatesController = new TemplatesController();
		$this->proyectosController = new ProyectosController();
		$this->pagosController = new PagosController();
		$this->recompensasController = new RecompensasController();
		$this->notificacionesController = new NotificacionesController();
		$this->operarController = new OperarController();
		$this->administradoresController = new AdministradoresController();
		$this->itemsController = new ItemsController();
		$this->htmlController = new HTMLController();
		$this->addOnsController = new AddOnsController();
		$this->asistenteVozController = new AsistenteVozController();
		$this->hashtagsController = new HashtagsController();
		$this->rotacionesController = new RotacionesController();
		$this->ajustesController = new AjustesController();
		$this->configuracionController = new ConfiguracionController();
		$this->tenantController = new TenantController();
		$this->cpgController = new CPGController();
		$this->customersController = new CustomersController();
		$this->mantenimientoController = new MantenimientoController();
		$this->clientsController = new ClientsController();
		$this->communityManagementController = new CommunitymanagementController();
		$this->rolesAdminBackend = [];
		$this->optionsCPGMaster = [];
		$this->globalMultitenant = false;
		$this->globalMulticpg = false;
		$this->mainAdminCPG = false;
		$this->mainAdminSL = false;
		$this->idCPG = 0;
		$this->missionsReport = new MissionsReportController();
		$this->globalWorkingwithClients = false;
	}

	public function setFirstSecurityLayer() {
		$this->securityManager->setFirstSecurityLayer();
	}

	public function setSecondSecurityLayer($postData) {
		$this->postData = $this->securityManager->setSecondSecurityLayer($postData);
	}

	public function getHttpPostAction() {
		return $this->postData['action'];
	}

	public function returnException($e, $function) {
		$service = new Service();
		$error = $function . ': Excepción capturada: ' . $e->getMessage();
		$service->ErrorToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE_ERROR, $error);
		return (object)['status' => $error];
	}

	public function sendCurlPOST($url, $params) {
		try {
			// Get cURL resource
			$curl = curl_init();
			// Set some options - we are passing in a useragent too here
			curl_setopt_array($curl, [
				CURLOPT_RETURNTRANSFER => 1,
				CURLOPT_URL => $url,
				CURLOPT_POST => 1,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_POSTFIELDS => $params,
				CURLOPT_SSL_VERIFYPEER => false
			]);
			// Send the request & save response to $resp
			$resp = curl_exec($curl);
			// curl error
			if(curl_errno($curl)) {
				$service = new Service();
				$error = 'CURL Error:' . curl_error($curl);
				$service->ErrorToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE_ERROR, $error);
			}
			// Close request to clear up some resources
			curl_close($curl);

			$response = json_decode($resp);

			// Control de errores cuando no es 'KO'
			if($response == NULL) {
				$nombre_archivo = CONSTANTS::REGISTER_LOGS_SERVICE_PATH . 'curl_errors.log';

				if($archivo = fopen($nombre_archivo, 'a')) {
					fwrite($archivo, date('Y-m-d H:i:s') . "\t|| " . $url . " \n" . strip_tags($resp) . " \n");
					fclose($archivo);
				}
			} else {
				// Registro de errores
				if($response->status != 'OK') {
					if(isset($response->result)) {
						$result = $response->result;
					} else {
						$result = 'ERROR';
					}

					if($result == 'Not authorized or session token has expired') {
						$response->result = '##change##';
					} else {
						$serviceName = str_replace(CONSTANTS::SERVERAPI, '', $url);
						$this->setCMBPLOG($params['token'], 'SERVICE', $serviceName, $result, '', '1');
					}
				}
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//LOGIN WEBSERVICES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Iconos del navegador
	public function svgIcons($type) {
		switch($type) {
			case 'user':
				return '
					<svg class="bi bi-person" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M13 14s1 0 1-1-1-4-6-4-6 3-6 4 1 1 1 1h10zm-9.995-.944v-.002.002zM3.022 13h9.956a.274.274 0 00.014-.002l.008-.002c-.001-.246-.154-.986-.832-1.664C11.516 10.68 10.289 10 8 10c-2.29 0-3.516.68-4.168 1.332-.678.678-.83 1.418-.832 1.664a1.05 1.05 0 00.022.004zm9.974.056v-.002.002zM8 7a2 2 0 100-4 2 2 0 000 4zm3-2a3 3 0 11-6 0 3 3 0 016 0z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'groups':
				return '
					<svg class="bi bi-people" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1h8zm-7.995-.944v-.002.002zM7.022 13h7.956a.274.274 0 00.014-.002l.008-.002c-.002-.264-.167-1.03-.76-1.72C13.688 10.629 12.718 10 11 10c-1.717 0-2.687.63-3.24 1.276-.593.69-.759 1.457-.76 1.72a1.05 1.05 0 00.022.004zm7.973.056v-.002.002zM11 7a2 2 0 100-4 2 2 0 000 4zm3-2a3 3 0 11-6 0 3 3 0 016 0zM6.936 9.28a5.88 5.88 0 00-1.23-.247A7.35 7.35 0 005 9c-4 0-5 3-5 4 0 .667.333 1 1 1h4.216A2.238 2.238 0 015 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816zM4.92 10c-1.668.02-2.615.64-3.16 1.276C1.163 11.97 1 12.739 1 13h3c0-1.045.323-2.086.92-3zM1.5 5.5a3 3 0 116 0 3 3 0 01-6 0zm3-2a2 2 0 100 4 2 2 0 000-4z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'notifications':
				return '
					<svg class="bi bi-bell" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path d="M8 16a2 2 0 002-2H6a2 2 0 002 2z" />
						<path fill-rule="evenodd" d="M8 1.918l-.797.161A4.002 4.002 0 004 6c0 .628-.134 2.197-.459 3.742-.16.767-.376 1.566-.663 2.258h10.244c-.287-.692-.502-1.49-.663-2.258C12.134 8.197 12 6.628 12 6a4.002 4.002 0 00-3.203-3.92L8 1.917zM14.22 12c.223.447.481.801.78 1H1c.299-.199.557-.553.78-1C2.68 10.2 3 6.88 3 6c0-2.42 1.72-4.44 4.005-4.901a1 1 0 111.99 0A5.002 5.002 0 0113 6c0 .88.32 4.2 1.22 6z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'operations':
				return '
					<svg class="bi bi-flag" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M3.5 1a.5.5 0 01.5.5v13a.5.5 0 01-1 0v-13a.5.5 0 01.5-.5z" clip-rule="evenodd" />
						<path fill-rule="evenodd" d="M3.762 2.558C4.735 1.909 5.348 1.5 6.5 1.5c.653 0 1.139.325 1.495.562l.032.022c.391.26.646.416.973.416.168 0 .356-.042.587-.126a8.89 8.89 0 00.593-.25c.058-.027.117-.053.18-.08.57-.255 1.278-.544 2.14-.544a.5.5 0 01.5.5v6a.5.5 0 01-.5.5c-.638 0-1.18.21-1.734.457l-.159.07c-.22.1-.453.205-.678.287A2.719 2.719 0 019 9.5c-.653 0-1.139-.325-1.495-.562l-.032-.022c-.391-.26-.646-.416-.973-.416-.833 0-1.218.246-2.223.916a.5.5 0 11-.515-.858C4.735 7.909 5.348 7.5 6.5 7.5c.653 0 1.139.325 1.495.562l.032.022c.391.26.646.416.973.416.168 0 .356-.042.587-.126.187-.068.376-.153.593-.25.058-.027.117-.053.18-.08.456-.204 1-.43 1.64-.512V2.543c-.433.074-.83.234-1.234.414l-.159.07c-.22.1-.453.205-.678.287A2.719 2.719 0 019 3.5c-.653 0-1.139-.325-1.495-.562l-.032-.022c-.391-.26-.646-.416-.973-.416-.833 0-1.218.246-2.223.916a.5.5 0 01-.554-.832l.04-.026z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'analytics':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bar-chart-line" viewBox="0 0 16 16">
						<path d="M11 2a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12h.5a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1H1v-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3h1V7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7h1V2zm1 12h2V2h-2v12zm-3 0V7H7v7h2zm-5 0v-3H2v3h2z"/>
					</svg>
				';
				break;
			case 'rewards':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-gift" viewBox="0 0 16 16">
						<path d="M3 2.5a2.5 2.5 0 0 1 5 0 2.5 2.5 0 0 1 5 0v.006c0 .07 0 .27-.038.494H15a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a1.5 1.5 0 0 1-1.5 1.5h-11A1.5 1.5 0 0 1 1 14.5V7a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h2.038A2.968 2.968 0 0 1 3 2.506V2.5zm1.068.5H7v-.5a1.5 1.5 0 1 0-3 0c0 .085.002.274.045.43a.522.522 0 0 0 .023.07zM9 3h2.932a.56.56 0 0 0 .023-.07c.043-.156.045-.345.045-.43a1.5 1.5 0 0 0-3 0V3zM1 4v2h6V4H1zm8 0v2h6V4H9zm5 3H9v8h4.5a.5.5 0 0 0 .5-.5V7zm-7 8V7H2v7.5a.5.5 0 0 0 .5.5H7z"/>
					</svg>
				';
				break;
			case 'items':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-basket" viewBox="0 0 16 16">
						<path d="M5.757 1.071a.5.5 0 0 1 .172.686L3.383 6h9.234L10.07 1.757a.5.5 0 1 1 .858-.514L13.783 6H15a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1v4.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 13.5V9a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h1.217L5.07 1.243a.5.5 0 0 1 .686-.172zM2 9v4.5A1.5 1.5 0 0 0 3.5 15h9a1.5 1.5 0 0 0 1.5-1.5V9H2zM1 7v1h14V7H1zm3 3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 4 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 6 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3A.5.5 0 0 1 8 10zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5zm2 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0v-3a.5.5 0 0 1 .5-.5z"/>
					</svg>
				';
				break;
			case 'integrations':
				return '
					<svg class="bi bi-code-slash" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M4.854 4.146a.5.5 0 010 .708L1.707 8l3.147 3.146a.5.5 0 01-.708.708l-3.5-3.5a.5.5 0 010-.708l3.5-3.5a.5.5 0 01.708 0zm6.292 0a.5.5 0 000 .708L14.293 8l-3.147 3.146a.5.5 0 00.708.708l3.5-3.5a.5.5 0 000-.708l-3.5-3.5a.5.5 0 00-.708 0zm-.999-3.124a.5.5 0 01.33.625l-4 13a.5.5 0 01-.955-.294l4-13a.5.5 0 01.625-.33z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'tenants':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-house-door" viewBox="0 0 16 16">
						<path d="M8.354 1.146a.5.5 0 0 0-.708 0l-6 6A.5.5 0 0 0 1.5 7.5v7a.5.5 0 0 0 .5.5h4.5a.5.5 0 0 0 .5-.5v-4h2v4a.5.5 0 0 0 .5.5H14a.5.5 0 0 0 .5-.5v-7a.5.5 0 0 0-.146-.354L13 5.793V2.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.293L8.354 1.146zM2.5 14V7.707l5.5-5.5 5.5 5.5V14H10v-4a.5.5 0 0 0-.5-.5h-3a.5.5 0 0 0-.5.5v4H2.5z"/>
					</svg>
				';
				break;
			case 'cpg':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-box-seam" viewBox="0 0 16 16">
						<path d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"/>
					</svg>
				';
				break;
			case 'customers':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-person-lines-fill" viewBox="0 0 16 16">
						<path d="M6 8a3 3 0 1 0 0-6 3 3 0 0 0 0 6zm-5 6s-1 0-1-1 1-4 6-4 6 3 6 4-1 1-1 1H1zM11 3.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5zm.5 2.5a.5.5 0 0 0 0 1h4a.5.5 0 0 0 0-1h-4zm2 3a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2zm0 3a.5.5 0 0 0 0 1h2a.5.5 0 0 0 0-1h-2z"/>
					</svg>
				';
				break;
			case 'ajustes':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-wrench" viewBox="0 0 16 16">
						<path d="M.102 2.223A3.004 3.004 0 0 0 3.78 5.897l6.341 6.252A3.003 3.003 0 0 0 13 16a3 3 0 1 0-.851-5.878L5.897 3.781A3.004 3.004 0 0 0 2.223.1l2.141 2.142L4 4l-1.757.364L.102 2.223zm13.37 9.019l.528.026.287.445.445.287.026.529L15 13l-.242.471-.026.529-.445.287-.287.445-.529.026L13 15l-.471-.242-.529-.026-.287-.445-.445-.287-.026-.529L11 13l.242-.471.026-.529.445-.287.287-.445.529-.026L13 11l.471.242z"/>
					</svg>
				';
				break;
			case 'configuracion':
				return '
					<svg class="bi bi-gear" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path fill-rule="evenodd" d="M8.837 1.626c-.246-.835-1.428-.835-1.674 0l-.094.319A1.873 1.873 0 014.377 3.06l-.292-.16c-.764-.415-1.6.42-1.184 1.185l.159.292a1.873 1.873 0 01-1.115 2.692l-.319.094c-.835.246-.835 1.428 0 1.674l.319.094a1.873 1.873 0 011.115 2.693l-.16.291c-.415.764.42 1.6 1.185 1.184l.292-.159a1.873 1.873 0 012.692 1.116l.094.318c.246.835 1.428.835 1.674 0l.094-.319a1.873 1.873 0 012.693-1.115l.291.16c.764.415 1.6-.42 1.184-1.185l-.159-.291a1.873 1.873 0 011.116-2.693l.318-.094c.835-.246.835-1.428 0-1.674l-.319-.094a1.873 1.873 0 01-1.115-2.692l.16-.292c.415-.764-.42-1.6-1.185-1.184l-.291.159A1.873 1.873 0 018.93 1.945l-.094-.319zm-2.633-.283c.527-1.79 3.065-1.79 3.592 0l.094.319a.873.873 0 001.255.52l.292-.16c1.64-.892 3.434.901 2.54 2.541l-.159.292a.873.873 0 00.52 1.255l.319.094c1.79.527 1.79 3.065 0 3.592l-.319.094a.873.873 0 00-.52 1.255l.16.292c.893 1.64-.902 3.434-2.541 2.54l-.292-.159a.873.873 0 00-1.255.52l-.094.319c-.527 1.79-3.065 1.79-3.592 0l-.094-.319a.873.873 0 00-1.255-.52l-.292.16c-1.64.893-3.433-.902-2.54-2.541l.159-.292a.873.873 0 00-.52-1.255l-.319-.094c-1.79-.527-1.79-3.065 0-3.592l.319-.094a.873.873 0 00.52-1.255l-.16-.292c-.892-1.64.902-3.433 2.541-2.54l.292.159a.873.873 0 001.255-.52l.094-.319z" clip-rule="evenodd" />
						<path fill-rule="evenodd" d="M8 5.754a2.246 2.246 0 100 4.492 2.246 2.246 0 000-4.492zM4.754 8a3.246 3.246 0 116.492 0 3.246 3.246 0 01-6.492 0z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'adminbackend':
				return '
					<svg class="bi bi-people-circle" width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
						<path d="M13.468 12.37C12.758 11.226 11.195 10 8 10s-4.757 1.225-5.468 2.37A6.987 6.987 0 008 15a6.987 6.987 0 005.468-2.63z" />
						<path fill-rule="evenodd" d="M8 9a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd" />
						<path fill-rule="evenodd" d="M8 1a7 7 0 100 14A7 7 0 008 1zM0 8a8 8 0 1116 0A8 8 0 010 8z" clip-rule="evenodd" />
					</svg>
				';
				break;
			case 'gestion_clientes':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-lock2" viewBox="0 0 16 16">
						<path d="M8 5a1 1 0 0 1 1 1v1H7V6a1 1 0 0 1 1-1zm2 2.076V6a2 2 0 1 0-4 0v1.076c-.54.166-1 .597-1 1.224v2.4c0 .816.781 1.3 1.5 1.3h3c.719 0 1.5-.484 1.5-1.3V8.3c0-.627-.46-1.058-1-1.224z"/>
						<path d="M4 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H4zm0 1h8a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1z"/>
					</svg>
				';
				break;
			case 'download':
				return '
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-arrow-down" viewBox="0 0 16 16">
						<path d="M8.5 6.5a.5.5 0 0 0-1 0v3.793L6.354 9.146a.5.5 0 1 0-.708.708l2 2a.5.5 0 0 0 .708 0l2-2a.5.5 0 0 0-.708-.708L8.5 10.293V6.5z"/>
						<path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5v2z"/>
					</svg>
				';
				break;
		}

		return '';
	}

	public function checkPermission($section) {
		if(empty($this->rolesAdminBackend)) {
			return true;
		}

		if($this->idCPG != '0' && in_array($section, $this->optionsCPGMaster)) {
			if($this->mainAdminCPG == '1' && $section == 'roles_backend') {
				// Master admin cpg
				return true;
			} else {
				return false;
			}
		}

		if(($section == 'gestion_clientes' || $section == 'clientes') && $this->mainAdminSL == true) {
			// Administradores SL
			return true;
		}

		if($section == 'notificaciones/consejeros') {
			$section = 'notificaciones_consejeros';
		}

		foreach($this->rolesAdminBackend as $key => $value) {
			if($key == $section) {
				if($value == '1') {
					return true;
				} else {
					return false;
				}
			}
		}
	}

	// Sección de icono, primer nivel
	public function MenuElementFirstLevel($href, $id, $rsc, $icon) {
		return '
			<a id="' . $id . '" href="#' . $href . '" class="list-group-link navFirstElement" type="button" data-toggle="collapse" data-target=".' . $href . '" aria-expanded="false" aria-controls="' . $href . '">
				<li class="list-group-item menu-level1">' .
					$this->svgIcons($icon)
					. '<span idRSC="' . $rsc . '">' . $rsc . '</span>
					<span class="menu-arrow">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
							<path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
						</svg>
					</span>
				</li>
			</a>
		';
	}

	// Sección de icono navegador pequeño, primer nivel
	public function MenuElementFirstLevelMini($href, $id, $rsc, $icon) {
		return '
			<a id="' . $id . '_mini" href="#' . $href . '" class="list-group-link navFirstElement" type="button" data-toggle="collapse" data-target=".' . $href . '" aria-expanded="false" aria-controls="' . $href . '" title="' . $rsc . '">
				<li class="list-group-item menu-level1 c-pointer">
					<span>'
						. $this->svgIcons($icon) .
					'</span>
				</li>
			</a>
		';
	}

	// Segundo nivel o subsecciones de tercer nivel del navegador
	public function MenuElementSecondLevel($id, $parent, $object, $type = 'div', $dataParent = 'accordionExample') {
		if($type == 'span') {
			$level = '3';
		} else {
			$level = '2 single-level2';
		}

		$template = '
			<' . $type . ' id="' . $id . '" class="' . $id . ' collapse" aria-labelledby="' . $parent . '" data-parent="#' . $dataParent . '">
				<ul class="list-group">
		';

		foreach($object as $opt) {
			if(isset($opt->suboptions)) {
				// Si el segundo nivel tiene subsecciones
				$template .= $this->MenuElementSecondLevelWithChilds($opt->href, $opt->id, $opt->rsc, $opt->suboptions);
			} else {
				// Si no las tiene
				$template .= $this->MenuElementThirdLevel($opt->href, $opt->rsc, $level);
			}
		}

		$template .= '
				</ul>
			</' . $type . '>
		';

		return $template;
	}

	// Segundo nivel o subsecciones de tercer nivel del navegador pequeño
	public function MenuElementSecondLevelMini($id, $parent, $object, $type = 'div', $dataParent = 'accordionExample_mini') {
		if($type == 'span') {
			$level = '3-mini';
		} else {
			$level = '2-mini single-level2';
		}

		$template = '
			<' . $type . ' id="' . $id . '_mini" class="' . $id . ' collapse" aria-labelledby="' . $parent . '" data-parent="#' . $dataParent . '">
				<ul class="list-group">
		';

		foreach($object as $opt) {
			if(isset($opt->suboptions)) {
				// Si el segundo nivel tiene subsecciones
				$template .= $this->MenuElementSecondLevelWithChildsMini($opt->href, $opt->id, $opt->rscMini, $opt->rsc, $opt->suboptions);
			} else {
				// Si no las tiene
				$template .= $this->MenuElementThirdLevelMini($opt->href, $opt->rscMini, $opt->rsc, $level);
			}
		}

		$template .= '
				</ul>
			</' . $type . '>
		';

		return $template;
	}

	// Elemento de segundo nivel con subsecciones
	public function MenuElementSecondLevelWithChilds($href, $id, $rsc, $suboptions) {
		if(!$this->checkPermission($href)) return '';
		$template = '
			<a id="' . $id . '" class="list-group-link link-section section collapsed navSecondElement" data-toggle="collapse" data-target=".' . $href . '" aria-expanded="false" aria-controls="' . $href . '">
				<li class="list-group-item sub-options menu-level2">
					<span idRSC="' . $rsc . '">' . $rsc . '</span>
					<span class="menu-arrow">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
							<path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
						</svg>
					</span>
				</li>
			</a>
		';

		// Subsecciones, se crean con la misma función que los elementos de segundo nivel
		$template .= $this->MenuElementSecondLevel($href, $id, $suboptions, 'span', $id);

		return $template;
	}

	// Elemento de segundo nivel con subsecciones en navegador pequeño
	public function MenuElementSecondLevelWithChildsMini($href, $id, $rsc, $title, $suboptions) {
		if(!$this->checkPermission($href)) return '';
		$template = '
			<a id="' . $id . '_mini" class="list-group-link link-section section collapsed navSecondElement" data-toggle="collapse" data-target=".' . $href . '" aria-expanded="false" aria-controls="' . $href . '" title="' . $title . '">
				<div class="selectMenuElemSingle">
					<div class="selectMenuElemSingleSub"></div>
				</div>

				<li class="list-group-item sub-options menu-level2-mini c-pointer">
					<span idRSC="' . $rsc . '">' . $rsc . '</span>
				</li>
			</a>
		';

		// Subsecciones, se crean con la misma función que los elementos de segundo nivel
		$template .= $this->MenuElementSecondLevelMini($href, $id, $suboptions, 'span', $id);

		return $template;
	}

	// Elementos de segundo nivel sin subsecciones
	public function MenuElementThirdLevel($href, $rsc, $level) {
		if(!$this->checkPermission($href)) {
			return '';
		} else if($level == '3') {
			return '
				<a href="#!' . $href . '" class="link-section">
					<div class="selectMenuElemSingle"></div>

					<li class="list-group-item sub-options menu-level' . $level . '"><span idRSC="' . $rsc . '">' . $rsc . '</span></li>
				</a>
			';
		} else {
			return '
				<a href="#!' . $href . '" class="link-section">
					<div class="selectMenuElemSingle"></div>

					<li class="list-group-item sub-options menu-level' . $level . '" idRSC="' . $rsc . '">' . $rsc . '</li>
				</a>
			';
		}
	}

	// Elementos de segundo nivel sin subsecciones del navegador pequeño
	public function MenuElementThirdLevelMini($href, $rsc, $title, $level) {
		if(!$this->checkPermission($href)) {
			return '';
		} else if($level == '3-mini') {
			return '
				<a href="#!' . $href . '" class="link-section" title="' . $title . '">
					<div class="selectMenuElemSingle">
						<div class="selectMenuElemSingleSub"></div>
					</div>
					
					<li class="list-group-item sub-options menu-level' . $level . '">
						<span idRSC="' . $rsc . '">' . $rsc . '</span>
					</li>
				</a>
			';
		} else {
			return '
				<a href="#!' . $href . '" class="link-section" title="' . $title . '">
					<div class="selectMenuElemSingle"></div>

					<li class="list-group-item sub-options menu-level' . $level . '">
						<span idRSC="' . $rsc . '">' . $rsc . '</span>
					</li>
				</a>
			';
		}
	}

	// Arrays de objetos con todas las opciones del menú del navegador
	public function renderMenu() {
		// Navegador grande
		$sectionsHTML = '';
		// Navegador pequeño
		$sectionsHTMLMini = '';

		// COMUNIDAD
		$options = [
			(object)[
				'href' => 'usuarios',
				'rsc' => 'RSC2', // Usuarios
				'rscMini' => 'RSC2529' // U/U
			],
			(object)[
				'href' => 'usuarios_importar',
				'rsc' => 'RSC325', // Gestión masiva
				'rscMini' => 'RSC2530' // GM/MM
			],
			(object)[
				'href' => 'roles',
				'rsc' => 'RSC17', // Roles
				'rscMini' => 'RSC2543' // R/R
			],
			// (object)[
			// 	'href' => 'segmentaciones',
			// 	'rsc' => 'RSC1741', // Segmentaciones
			// 	'rscMini' => 'RSC2531', // S/S
			// 	'id' => 'subheading_1_1',
			// 	'suboptions' => [
			// 		(object)[
			// 			'href' => 'editsegmentations',
			// 			'rsc' => 'RSC1910', // Editar segmentaciones
			// 			'rscMini' => 'RSC2532' // ES/ES
			// 		],
			// 		(object)[
			// 			'href' => 'segmentaciones_automatizadas',
			// 			'rsc' => 'RSC1973', // Programar
			// 			'rscMini' => 'RSC2533' // P/P
			// 		]
			// 	]
			// ],
			(object)[
				'href' => 'grupos',
				'rsc' => 'RSC6', // Grupos
				'rscMini' => 'RSC2534' // G/G
			],
			(object)[
				'href' => 'difusion',
				'rsc' => 'RSC12', // Listas de difusion
				'rscMini' => 'RSC2535' // LD/ML
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowcommunity')) {
			$sectionsHTML .= '
				<span id="backendshowcommunity">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_comunidad', 'heading_1', 'RSC2044', 'groups')
					. $this->MenuElementSecondLevel('collapse_comunidad', 'heading_1', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowcommunityMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_comunidad', 'heading_1', 'RSC2044', 'groups')
					. $this->MenuElementSecondLevelMini('collapse_comunidad', 'heading_1', $options) .
				'</span>
			';
		}

		// NOTIFICACIONES
		$options = [
			(object)[
				'href' => 'notificaciones',
				'rsc' => 'RSC9', // Ver todas
				'rscMini' => 'RSC2536' // VT/SA
			],
			(object)[
				'href' => 'notificaciones/consejeros',
				'rsc' => 'RSC24', // Notificar sin CLABE
				'rscMini' => 'RSC2537' // NSC/NWC
			],
			(object)[
				'href' => 'notificaciones_consejeros_telf',
				'rsc' => 'RSC2171', // Notificar sin TELÉFONO
				'rscMini' => 'RSC2538' // NST/NWP
			],
			(object)[
				'href' => 'notificaciones_pre_consejeros',
				'rsc' => 'RSC1876', // Notificar a pre-consejeros
				'rscMini' => 'RSC2539' // NPC/NPC
			],
			(object)[
				'href' => 'notificaciones_cola',
				'rsc' => 'RSC1835', // Cola notificaciones
				'rscMini' => 'RSC2540' // CN/NQ
			],
			(object)[
				'href' => 'pop_ups',
				'rsc' => 'RSC2234', // Pop Ups
				'rscMini' => 'RSC2541' // PU/PU
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshownotificaciones')) {
			$sectionsHTML .= '
				<span id="backendshownotificaciones">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_notificaciones', 'heading_2', 'RSC11', 'notifications')
					. $this->MenuElementSecondLevel('collapse_notificaciones', 'heading_2', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshownotificacionesMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_notificaciones', 'heading_2', 'RSC11', 'notifications')
					. $this->MenuElementSecondLevelMini('collapse_notificaciones', 'heading_2', $options) .
				'</span>
			';
		}

		// OPERAR
		$options = [
			(object)[
				'href' => 'collapse_productos',
				'rsc' => 'RSC2048', // Productos
				'rscMini' => 'RSC2533', // P/P
				'id' => 'subheading_3_1',
				'suboptions' => [
					(object)[
						'href' => 'productos',
						'rsc' => 'RSC3', // Ver todos
						'rscMini' => 'RSC2536' // VT/SA
					],
					(object)[
						'href' => 'templates',
						'rsc' => 'RSC2049', // Plantillas
						'rscMini' => 'RSC2542' // P/T
					]
				]
			],
			(object)[
				'href' => 'collapse_proyectos',
				'rsc' => 'RSC10', // Proyectos
				'rscMini' => 'RSC2533', // P/P
				'id' => 'subheading_3_1',
				'suboptions' => [
					(object)[
						'href' => 'proyectos',
						'rsc' => 'RSC3', // Ver todos
						'rscMini' => 'RSC2536' // VT/SA
					],
					(object)[
						'href' => 'expulsion',
						'rsc' => 'RSC23', // Motivos expulsion
						'rscMini' => 'RSC2544' // ME/RE
					]
				]
			],
			(object)[
				'href' => 'collapse_misiones',
				'rsc' => 'RSC14', // Misiones
				'rscMini' => 'RSC2545', // M/M
				'id' => 'subheading_3_2',
				'suboptions' => [
					(object)[
						'href' => 'misiones',
						'rsc' => 'RSC9', // Ver todas
						'rscMini' => 'RSC2536' // VT/SA
					],
					(object)[
						'href' => 'misiones_type',
						'rsc' => 'RSC26', // Tipo misión
						'rscMini' => 'RSC2546' // TM/MT
					],
					(object)[
						'href' => 'cumplimiento',
						'rsc' => 'RSC28', // Control cumplimiento
						'rscMini' => 'RSC2547' // CC/CC
					],
					(object)[
						'href' => 'misiones_cola',
						'rsc' => 'RSC960', // Cola misiones
						'rscMini' => 'RSC2548' // CM/QQ
					],
					(object)[
						'href' => 'misiones_urls',
						'rsc' => 'RSC2746', // Generar URLs
						'rscMini' => 'RSC2747' // URLs
					]
				]
			],
			(object)[
				'href' => 'collapse_encuestas',
				'rsc' => 'RSC13', // Formulario encuestas
				'rscMini' => 'RSC2549', // FE/SF
				'id' => 'subheading_3_3',
				'suboptions' => [
					(object)[
						'href' => 'generador_encuestas',
						'rsc' => 'RSC25', // Generador de encuestas
						'rscMini' => 'RSC2550' // GE/SG
					],
					(object)[
						'href' => 'rotaciones',
						'rsc' => 'RSC1404', // Rotaciones
						'rscMini' => 'RSC2543' // R/R
					]
				]
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowoperations')) {
			$sectionsHTML .= '
				<span id="backendshowoperations">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_operar', 'heading_3', 'RSC2045', 'operations')
					. $this->MenuElementSecondLevel('collapse_operar', 'heading_3', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowoperationsMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_operar', 'heading_3', 'RSC2045', 'operations')
					. $this->MenuElementSecondLevelMini('collapse_operar', 'heading_3', $options) .
				'</span>
			';
		}

		// ANALYTICS
		$options = [
			(object)[
				'href' => 'collapse_analyticcomunidad',
				'rsc' => 'RSC2044', // Comunidad
				'rscMini' => 'RSC2551', // C/C
				'id' => 'subheading_4_1',
				'suboptions' => [
					(object)[
						'href' => 'asesores',
						'rsc' => 'RSC32', // Asesores
						'rscMini' => 'RSC2552' // A/A
					],
					(object)[
						'href' => 'word_cloud',
						'rsc' => 'RSC34', // Word Cloud
						'rscMini' => 'RSC2553' // WC/WC
					],
					(object)[
						'href' => 'conversaciones',
						'rsc' => 'RSC36', // Conversaciones
						'rscMini' => 'RSC2551' // C/C
					],
					(object)[
						'href' => 'catalogacion',
						'rsc' => 'RSC39', // Catalogacion Asesores
						'rscMini' => 'RSC2554' // CA/CC
					],
					(object)[
						'href' => 'licencias',
						'rsc' => 'RSC519', // Licencias
						'rscMini' => 'RSC2555' // L/L
					],
					(object)[
						'href' => 'perfilacionsinfinalizar',
						'rsc' => 'RSC611', // Perfilacion sin finalizar
						'rscMini' => 'RSC2556' // PSF/UP
					],
					(object)[
						'href' => 'stores',
						'rsc' => 'RSC1804', // Stores
						'rscMini' => 'RSC2531' // S/S
					]
				]
			],
			(object)[
				'href' => 'collapse_muestreo',
				'rsc' => 'RSC35', // Muestreo
				'rscMini' => 'RSC2557', // M/S
				'id' => 'subheading_4_2',
				'suboptions' => [
					(object)[
						'href' => 'muestreo',
						'rsc' => 'RSC35', // Muestreo
						'rscMini' => 'RSC2557' // M/S
					],
					(object)[
						'href' => 'muestreo_dinamico',
						'rsc' => 'RSC2426', // Muestreo Dinámico
						'rscMini' => 'RSC2558' // MD/SD
					],
					(object)[
						'href' => 'muestreodetallado',
						'rsc' => 'RSC963', // Muestreo Detallado
						'rscMini' => 'RSC2558' // MD/SD
					],
					(object)[
						'href' => 'muestreodetallado_maz',
						'rsc' => 'RSC1796', // Detallado por países
						'rscMini' => 'RSC2559' // DP/DC
					],
					(object)[
						'href' => 'muestreodetallado_maz_seg',
						'rsc' => 'RSC1874', // Detallado segmentaciones
						'rscMini' => 'RSC2560' // DS/DS
					],
					(object)[
						'href' => 'muestreodetalladocomparativo',
						'rsc' => 'RSC2361', // Detalladao comparativo
						'rscMini' => 'RSC2561' // DC/DC
					],
					(object)[
						'href' => 'muestreocomparativo',
						'rsc' => 'RSC45', // Muestreo Comparativo
						'rscMini' => 'RSC2562' // MC/SC
					]
				]
			],
			(object)[
				'href' => 'collapse_operativo',
				'rsc' => 'RSC2047', // Operativo
				'rscMini' => 'RSC2563', // O/O
				'id' => 'subheading_4_3',
				'suboptions' => [
					(object)[
						'href' => 'cumplimientos',
						'rsc' => 'RSC33', // Cumplimiento
						'rscMini' => 'RSC2551' // C/C
					],
					(object)[
						'href' => 'inversion',
						'rsc' => 'RSC37', // Inversión
						'rscMini' => 'RSC2564' // I/I
					],
					(object)[
						'href' => 'kpi_surveys',
						'rsc' => 'RSC1831', // KPI Surveys
						'rscMini' => 'RSC2565' // KS/KS
					],
					(object)[
						'href' => 'tiempo_respuesta',
						'rsc' => 'RSC2753', // Tiempo de respuesta
						'rscMini' => 'RSC2754' // TR/TR
					]
				]
			],
			(object)[
				'href' => 'cdp',
				'rsc' => 'RSC612', // CDP
				'rscMini' => 'RSC612' // CDP/CDP
			],
			(object)[
				'href' => 'cubos',
				'rsc' => 'RSC1065', // Cubos Dinámicos
				'rscMini' => 'RSC2566' // CD/DC
			],
			(object)[
				'href' => 'passiveTracking',
				'rsc' => 'RSC1271', // Passive Tracking
				'rscMini' => 'RSC2567' // PT/PT
			],
			(object)[
				'href' => 'diferenciassignificativas',
				'rsc' => 'RSC2346', // Diferencias significativas
				'rscMini' => 'RSC2568' // DS/SD
			],
			(object)[
				'href' => 'plantillas_reportes',
				'rsc' => 'RSC2347', // Plantillas reportes
				'rscMini' => 'RSC2529' // PR/RT
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowanalytics')) {
			$sectionsHTML .= '
				<span id="backendshowanalytics">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_analytics', 'heading_4', 'RSC18', 'analytics')
					. $this->MenuElementSecondLevel('collapse_analytics', 'heading_4', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowanalyticsMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_analytics', 'heading_4', 'RSC18', 'analytics')
					. $this->MenuElementSecondLevelMini('collapse_analytics', 'heading_4', $options) .
				'</span>
			';
		}

		// REMUNERACIONES
		$options = [
			(object)[
				'href' => 'collapse_pagos',
				'rsc' => 'RSC16', // Pagos
				'rscMini' => 'RSC2533', // P/P
				'id' => 'subheading_5_1',
				'suboptions' => [
					(object)[
						'href' => 'pagos',
						'rsc' => 'RSC30', // Pagos pendientes
						'rscMini' => 'RSC2570' // PP/PP
					],
					(object)[
						'href' => 'pagos_archivo',
						'rsc' => 'RSC31', // Validar pagos
						'rscMini' => 'RSC2571' // VP/VP
					],
					(object)[
						'href' => 'pagos_detalle',
						'rsc' => 'RSC504', // Detalle
						'rscMini' => 'RSC2572' // D/D
					],
					(object)[
						'href' => 'pagos_automatizados',
						'rsc' => 'RSC1330', // Envíos automatizados
						'rscMini' => 'RSC2573' // EA/AS
					]
				]
			],
			(object)[
				'href' => 'collapse_catalogorecompensas',
				'rsc' => 'RSC2050', // Recompensas
				'rscMini' => 'RSC2543', // R/R
				'id' => 'subheading_5_2',
				'suboptions' => [
					(object)[
						'href' => 'articulos_catalogo',
						'rsc' => 'RSC1892', // Artículos
						'rscMini' => 'RSC2552' // A/A
					],
					(object)[
						'href' => 'catalogos',
						'rsc' => 'RSC1885', // Catálogos
						'rscMini' => 'RSC2551' // C/C
					]
				]
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowrewards')) {
			$sectionsHTML .= '
				<span id="backendshowrewards">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_recompensas', 'heading_5', 'RSC1901', 'rewards')
					. $this->MenuElementSecondLevel('collapse_recompensas', 'heading_5', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowrewardsMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_recompensas', 'heading_5', 'RSC1901', 'rewards')
					. $this->MenuElementSecondLevelMini('collapse_recompensas', 'heading_5', $options) .
				'</span>
			';
		}

		// CONSUMO
		$options = [
			(object)[
				'href' => 'show_all_items',
				'rsc' => 'RSC1892', // Artículos
				'rscMini' => 'RSC2552', // A/A
			],
			(object)[
				'href' => 'backendshowStores',
				'rsc' => 'RSC2473', // Tiendas
				'rscMini' => 'RSC2574', // T/S
				'id' => 'subheading_14_2',
				'suboptions' => [
					(object)[
						'href' => 'show_all_stores',
						'rsc' => 'RSC9', // Ver todas
						'rscMini' => 'RSC2536' // VT/SA
					],
					(object)[
						'href' => 'show_stores_type',
						'rsc' => 'RSC2475', // Tipos de tiendas
						'rscMini' => 'RSC2575' // TT/TS
					]
				]
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowConsumo')) {
			$sectionsHTML .= '
				<span id="backendshowConsumo">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_items', 'heading_14', 'RSC618', 'items')
					. $this->MenuElementSecondLevel('collapse_items', 'heading_14', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowConsumoMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_items', 'heading_14', 'RSC618', 'items')
					. $this->MenuElementSecondLevelMini('collapse_items', 'heading_14', $options) .
				'</span>
			';
		}

		// EXTENSIONES
		$options = [
			(object)[
				'href' => 'html',
				'rsc' => 'RSC44', // HTML
				'rscMini' => 'RSC2576' // H/H
			],
			(object)[
				'href' => 'addons',
				'rsc' => 'RSC1246', // AddOns
				'rscMini' => 'RSC2577' // AO/AO
			],
			(object)[
				'href' => 'voiceAssistant',
				'rsc' => 'RSC2393', // Asistente de voz
				'rscMini' => 'RSC2578' // AV/VA
			],
			(object)[
				'href' => 'hashtag',
				'rsc' => 'RSC2416', // Webhooks
				'rscMini' => 'RSC2579' // WH/WH
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowintegraciones') && $this->idCPG == '0') {
			$sectionsHTML .= '
				<span id="backendshowintegraciones">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_extensiones', 'heading_6', 'RSC22', 'integrations')
					. $this->MenuElementSecondLevel('collapse_extensiones', 'heading_6', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowintegracionesMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_extensiones', 'heading_6', 'RSC22', 'integrations')
					. $this->MenuElementSecondLevelMini('collapse_extensiones', 'heading_6', $options) .
				'</span>
			';
		}

		// MULTITENANT
		$options = [
			(object)[
				'href' => 'tenant',
				'rsc' => 'RSC3', // Ver todos
				'rscMini' => 'RSC2536' // VT/SA
			],
			(object)[
				'href' => 'tenant_licenses',
				'rsc' => 'RSC519', // Licencias
				'rscMini' => 'RSC2555' // L/L
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowtenants') && $this->globalMultitenant == true && $this->idCPG == '0') {
			$sectionsHTML .= '
				<span id="backendshowtenants">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_Tenants', 'heading_7', 'RSC1539', 'tenants')
					. $this->MenuElementSecondLevel('collapse_Tenants', 'heading_7', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowtenantsMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_Tenants', 'heading_7', 'RSC1539', 'tenants')
					. $this->MenuElementSecondLevelMini('collapse_Tenants', 'heading_7', $options) .
				'</span>
			';
		}

		// CPG
		$options = [
			(object)[
				'href' => 'cpg',
				'rsc' => 'RSC3', // Ver todos
				'rscMini' => 'RSC2536' // VT/SA
			],
			(object)[
				'href' => 'cpg_licenses',
				'rsc' => 'RSC519', // Licencias
				'rscMini' => 'RSC2555' // L/L
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowcpg') && $this->globalMulticpg == true) {
			$sectionsHTML .= '
				<span id="backendshowcpg">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_CPG', 'heading_8', 'RSC1716', 'cpg')
					. $this->MenuElementSecondLevel('collapse_CPG', 'heading_8', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowcpgMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_CPG', 'heading_8', 'RSC1716', 'cpg')
					. $this->MenuElementSecondLevelMini('collapse_CPG', 'heading_8', $options) .
				'</span>
			';
		}

		// CLIENTES
		$options = [
			(object)[
				'href' => 'show_all_clients',
				'rsc' => 'RSC3', // Ver todos
				'rscMini' => 'RSC2536' // VT/SA
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowclients') && $this->globalWorkingwithClients == true) {
			$sectionsHTML .= '
				<span id="backendshowclients">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_customers', 'heading_13', 'RSC2363', 'customers')
					. $this->MenuElementSecondLevel('collapse_customers', 'heading_13', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowclientsMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_customers', 'heading_13', 'RSC2363', 'customers')
					. $this->MenuElementSecondLevelMini('collapse_customers', 'heading_13', $options) .
				'</span>
			';
		}

		// ADMINISTRADORES
		$options = [
			(object)[
				'href' => 'administradores_backend',
				'rsc' => 'RSC3', // Ver todos
				'rscMini' => 'RSC2536' // VT/SA
			],
			(object)[
				'href' => 'roles_backend',
				'rsc' => 'RSC17', // Roles
				'rscMini' => 'RSC2543' // R/R
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('collapse_administradores')) {
			$sectionsHTML .= '
				<span id="backendshowadminsbackend">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_administradores', 'heading_9', 'RSC21', 'adminbackend')
					. $this->MenuElementSecondLevel('collapse_administradores', 'heading_9', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowadminsbackendMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_administradores', 'heading_9', 'RSC21', 'adminbackend')
					. $this->MenuElementSecondLevelMini('collapse_administradores', 'heading_9', $options) .
				'</span>
			';
		}

		// AJUSTES
		$options = [
			(object)[
				'href' => 'welcometour',
				'rsc' => 'RSC2134', // Welcome Tour
				'rscMini' => 'RSC2580' // WT/WT
			],
			(object)[
				'href' => 'dominios_embebidos',
				'rsc' => 'RSC42', // Dominios embebidos
				'rscMini' => 'RSC2581' // DE/ED
			],
			(object)[
				'href' => 'bots',
				'rsc' => 'RSC43', // Bots
				'rscMini' => 'RSC2582' // B/B
			],
			(object)[
				'href' => 'definicion_catalogacion_asesores',
				'rsc' => 'RSC38', // Definir catalogación
				'rscMini' => 'RSC2583' // DC/CD
			],
			(object)[
				'href' => 'perfilacion',
				'rsc' => 'RSC515', // Sección perfilación
				'rscMini' => 'RSC2584' // SP/PS
			],
			(object)[
				'href' => 'formulario_registro',
				'rsc' => 'RSC1520', // Formulario de registro
				'rscMini' => 'RSC2585' // FR/RF
			],
			(object)[
				'href' => 'paises',
				'rsc' => 'RSC549', // Paises
				'rscMini' => 'RSC2586' // P/C
			],
			(object)[
				'href' => 'idiomas',
				'rsc' => 'RSC551', // Idiomas
				'rscMini' => 'RSC2587' // I/L
			],
			(object)[
				'href' => 'perfiles',
				'rsc' => 'RSC553', // Perfiles
				'rscMini' => 'RSC2533' // P/P
			],
			(object)[
				'href' => 'exclusiones_wordcloud',
				'rsc' => 'RSC1838', // Exclusiones WordCloud
				'rscMini' => 'RSC2588' // EW/WE
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('backendshowajustes')) {
			$sectionsHTML .= '
				<span id="backendshowajustes">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_ajustes', 'heading_10', 'RSC1354', 'ajustes')
					. $this->MenuElementSecondLevel('collapse_ajustes', 'heading_10', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowajustesMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_ajustes', 'heading_10', 'RSC1354', 'ajustes')
					. $this->MenuElementSecondLevelMini('collapse_ajustes', 'heading_10', $options) .
				'</span>
			';
		}

		// CONFIGURACION
		$options = [
			(object)[
				'href' => 'configuracion',
				'rsc' => 'RSC41', // General
				'rscMini' => 'RSC2534' // G/G
			],
			(object)[
				'href' => 'funcionalidades_app',
				'rsc' => 'RSC623', // Funcionalidades
				'rscMini' => 'RSC2589' // F/F
			],
			(object)[
				'href' => 'logs',
				'rsc' => 'RSC19', // Logs
				'rscMini' => 'RSC2555' // L/L
			],
			(object)[
				'href' => 'rsc',
				'rsc' => 'RSC466', // Diccionario de recursos
				'rscMini' => 'RSC2590' // DR/DR
			],
			(object)[
				'href' => 'table_information',
				'rsc' => 'RSC1942', // Mantenimiento sistema
				'rscMini' => 'RSC2591' // MS/SM
			]
		];
		// Comprobación de permisos
		if($this->checkPermission('collapse_configuracion') && $this->idCPG == '0') {
			$sectionsHTML .= '
				<span id="backendshowconfiguracion">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevel('collapse_configuracion', 'heading_11', 'RSC20', 'configuracion')
					. $this->MenuElementSecondLevel('collapse_configuracion', 'heading_11', $options) .
				'</span>
			';

			$sectionsHTMLMini .= '
				<span id="backendshowconfiguracionMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('collapse_configuracion', 'heading_11', 'RSC20', 'configuracion')
					. $this->MenuElementSecondLevelMini('collapse_configuracion', 'heading_11', $options) .
				'</span>
			';
		}

		// GESTION CLIENTES
		$serverUrl = str_replace('/', '', str_replace('https:', '', CONSTANTS::SERVERAPI));
		if($serverUrl == 'stcm.sociallabs.biz') {
			$options = [
				(object)[
					'href' => 'clientes',
					'rsc' => 'RSC3', // Ver todos
					'rscMini' => 'RSC2536' // VT/SA
				]
			];
			// Comprobación de permisos
			if($this->checkPermission('gestion_clientes') && $this->mainAdminSL == true) {
				$sectionsHTML .= '
					<span id="backendshowgestionclientes">
						<div class="selectMenuElem"></div>'
						. $this->MenuElementFirstLevel('gestion_clientes', 'heading_12', 'RSC2242', 'gestion_clientes')
						. $this->MenuElementSecondLevel('gestion_clientes', 'heading_12', $options) .
					'</span>
				';

				$sectionsHTMLMini .= '
				<span id="backendshowgestionclientesMini">
					<div class="selectMenuElem"></div>'
					. $this->MenuElementFirstLevelMini('gestion_clientes', 'heading_12', 'RSC2242', 'gestion_clientes')
					. $this->MenuElementSecondLevelMini('gestion_clientes', 'heading_12', $options) .
				'</span>
			';
			}
		}

		return ['sectionsHTML' => $sectionsHTML, 'sectionsHTMLMini' => $sectionsHTMLMini];
	}

	// Validar token GET
	public function validateDirectToken() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// PreLogin
	public function preLogin() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Login
	public function loginWeb() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'email' => $client['email'],
				'password' => $client['password']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status === 'OK' && !isset($resultPOST->result->mustResetPass)) {
				$this->globalMulticpg = $resultPOST->result->globalMulticpg;
				$this->globalWorkingwithClients = $resultPOST->result->globalWorkingwithClients;
				$this->globalMultitenant = $resultPOST->result->globalMultitenant;
				$this->mainAdminCPG = $resultPOST->result->mainAdminCPG;
				$this->mainAdminSL = $resultPOST->result->mainAdminSL;
				$this->rolesAdminBackend = count($resultPOST->result->roleAdminBackend) == 0 ? new stdClass() : $resultPOST->result->roleAdminBackend[0];

				// Subsecciones que solo se mostraran si se tienen permiso y es un CPG
				$this->optionsCPGMaster = ['roles', 'notificaciones/consejeros', 'expulsion', 'cumplimiento', 'licencias', 'cpg_licenses', 'welcometour', 'dominios_embebidos', 'bots', 'definicion_catalogacion_asesores', 'perfilacion', 'formulario_registro', 'idiomas', 'perfiles', 'exclusiones_wordcloud'];

				$resultPOST->result->multiTenant = $this->rolesAdminBackend->backendshowtenants; // Control de funcionalidad multitenant
				$this->idCPG = $this->rolesAdminBackend->idCPG; // ID de CPG

				$sectionsHTMLArray = $this->renderMenu();
				$sectionsHTML = $sectionsHTMLArray['sectionsHTML'];
				$sectionsHTMLMini = $sectionsHTMLArray['sectionsHTMLMini'];
			}
			$resultPOST->result->sectionsHTML = $sectionsHTML;
			$resultPOST->result->sectionsHTMLMini = $sectionsHTMLMini;

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Login
	public function refreshToken() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'email' => $client['email'],
				'password' => $client['password']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Perfil Usuario
	public function getUserAPI() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token'],
				'email' => $client['email']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			// Terminación por error
			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$avatar = CONSTANTS::PATH_EXPORT_WORD . '/avatar/' . $client['email'] . '/avatar.jpg';
			if(file_exists($avatar)) {
				$resultPOST->result['avatar'] = true;
			} else {
				$resultPOST->result['avatar'] = false;
			}

			// get the tenant info.
			$url = CONSTANTS::SERVERAPI . 'getTenantById';
			$params = [
				'token' => $client['token'],
				'idTenant' => $resultPOST->result[0]->idTenant
			];

			$resultPOSTTenant = $this->sendCurlPOST($url, $params);

			// Terminación por error
			if($resultPOSTTenant->status != 'OK') {
				return $resultPOSTTenant;
			}

			$resultPOST->result['tenantInfo'] = $resultPOSTTenant->result;

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Petición de RSC por lenguaje
	public function getAllRSCByLenguage() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];

			$params = [
				'token' => $client['token'],
				'lenguage' => $client['lenguage'],
				'system' => $client['system']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	public function setCMBPLOG($token, $typeEvent, $callerEvent, $text, $swlOrig) {
		try {
			if($typeEvent == 'SERVICE') {
				return true;
			}

			$url = CONSTANTS::SERVERAPI . 'setCMBPLOG';
			$params = [
				'token' => $token,
				'TypeEvent' => $typeEvent,
				'CallerEvent' => $callerEvent,
				'LogEvent' => $text,
				'SQLQuery' => $swlOrig
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status == 'OK') {
				return true;
			} else {
				return false;
			}
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return false;
		}
	}

	// Petición de datos generales por país
	public function getMainDashboardByContry() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getMainDashboardByContry($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ÚTILES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Opciones de menu
	public function getSystemConfig() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	public function getDomain() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Configuración de BOTS para usuarios o grupos
	public function getBotConfig() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getBotConfig($client);

		return $resultPOST;
	}

	// Configuración de asistente de voz para usuarios o grupos
	public function getVoiceAssistantConfig() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getVoiceAssistantConfig($client);

		return $resultPOST;
	}

	// Petición de países activos
	public function getPaisesEnabled() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Envío de notificaciones múltiples
	public function postMessageMultiple($data = null, $token = null) {
		$client = $this->postData;
		$resultPOST = $this->utilesController->postMessageMultiple($client, $data, $token);

		return $resultPOST;
	}

	// Idiomas
	public function getIdiomas() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getIdiomas($client);

		return $resultPOST;
	}

	// Paises
	public function getPaises() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getPaises($client);

		return $resultPOST;
	}

	// Información de un país por su iso
	public function getPaisByID() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getPaisByID($client);

		return $resultPOST;
	}

	// Borrar un archivo en servidor
	public function deleteFile() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->deleteFile($client);

		return $resultPOST;
	}

	// Borrar una carpeta en servidor
	public function deleteFolder() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->deleteFolder($client);

		return $resultPOST;
	}

	// Número de licencias libres
	public function getFreeLicences() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getFreeLicences($client);

		return $resultPOST;
	}

	// Actualización de fecha de blog
	public function setLastVersionControlled() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->setLastVersionControlled($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//USUARIOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Todos los usuarios
	public function getAllUsers() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getAllUsers($client);

		return $resultPOST;
	}

	// Usuario por email
	public function getUserData() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getUserData($client);

		return $resultPOST;
	}

	// Información adicional de usuario
	public function getUserExtendedInfo() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getUserExtendedInfo($client);

		return $resultPOST;
	}

	// Petición de grupos de usuario
	public function getUserGroups() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getUserGroups($client);

		return $resultPOST;
	}

	// Añadir usuario nuevo
	public function newUser() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->newUser($client);

		return $resultPOST;
	}

	// Cambiar contraseña
	public function changePass() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->changePass($client);

		return $resultPOST;
	}

	// Detalle de pagos al usuario
	public function getDetallePagosByUser() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getDetallePagosByUser($client);

		return $resultPOST;
	}

	// Editar usuario
	public function editUser() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->editUser($client);

		return $resultPOST;
	}

	// Comprobación de derecho al olvido
	public function isUserForgotten() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->isUserForgotten($client);

		return $resultPOST;
	}

	// Derecho al olvido
	public function forgetUser() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->forgetUser($client);

		return $resultPOST;
	}

	// Desasignar CPG
	public function disabledCPG() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->disabledCPG($client);

		return $resultPOST;
	}

	// Importar usuarios desde excel
	public function importUsers() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->importUsers($client);

		return $resultPOST;
	}

	// Activación masiva de usuarios
	public function activationUsers() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->activationUsers($client);

		return $resultPOST;
	}

	// Desactivación masiva de usuarios
	public function deactivationUsers() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->deactivationUsers($client);

		return $resultPOST;
	}

	// Desasignar masiva de usuarios CPG
	public function dessasignCPG() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->dessasignCPG($client);

		return $resultPOST;
	}

	// Petición de respuestas de perfilación
	public function getPerfPosibleAnswers() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getPerfPosibleAnswers($client);

		return $resultPOST;
	}

	/* TTT ESPECIAL 09/02/23 */
	// Comprobación de usuario para CPG
	/* public function userExists() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->userExists($client);

		return $resultPOST;
	} */
	/* TTT ESPECIAL 09/02/23 */

	// Petición de todas las segmentaciones
	public function getAllSegmentaciones() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Posibles respuestas a una pregunta de encuesta
	public function getAllPosibleAnswersByQID() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getAllPosibleAnswersByQID($client);

		return $resultPOST;
	}

	// Nueva segmentación
	public function setSegmentacion() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->setSegmentacion($client);

		return $resultPOST;
	}

	// Eliminar segmentación
	public function deleteSegmentacion() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->deleteSegmentacion($client);

		return $resultPOST;
	}

	// Petición de segmentación por ID
	public function getSegmentacion() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->getSegmentacion($client);

		return $resultPOST;
	}

	// Editar segmentación
	public function updateSegmentacion() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->updateSegmentacion($client);

		return $resultPOST;
	}

	// Ejecutar segmentación
	public function executeSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->executeSegmentation($client);

		return $resultPOST;
	}

	// Desactivación y consejero = 0 para usuarios con datos incongruentes
	public function deactivateUnwelcomeCounselor() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->deactivateUnwelcomeCounselor($client);

		return $resultPOST;
	}

	// Petición de todas las segmentaciones programadas
	public function getScheduledSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear segmentación programada
	public function setScheduledSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->setScheduledSegmentation($client);

		return $resultPOST;
	}

	// Eliminar segmentaciones programadas
	public function deleteScheduledSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->deleteScheduledSegmentation($client);

		return $resultPOST;
	}

	// Editar segmentación programada
	public function updateScheduledSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->usuariosController->updateScheduledSegmentation($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//GRUPOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Todos los grupos
	public function getAllGroups() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Añadir grupo nuevo
	public function newGroup() {
		$client = $this->postData;
		$resultPOST = $this->gruposController->newGroup($client);

		return $resultPOST;
	}

	// Eliminar grupo
	public function deleteGroup() {
		$client = $this->postData;
		$resultPOST = $this->gruposController->deleteGroup($client);

		return $resultPOST;
	}

	// Usuarios pertenecientes a un grupo
	public function getAllUsersGroup() {
		$client = $this->postData;
		$resultPOST = $this->gruposController->getAllUsersGroup($client);

		return $resultPOST;
	}

	// Editar grupo
	public function editGroup() {
		$client = $this->postData;
		$resultPOST = $this->gruposController->editGroup($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//LISTAS DE DIFUSION
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de Listas de Difusión
	public function getAllDistributionList() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear Lista de Difusión
	public function createList() {
		$client = $this->postData;
		$resultPOST = $this->listasDifusionController->createList($client);

		return $resultPOST;
	}

	// Eliminar Listas de Difusión
	public function deleteDistributionList() {
		$client = $this->postData;
		$resultPOST = $this->listasDifusionController->deleteDistributionList($client);

		return $resultPOST;
	}

	// Petición de miembros de la Lista de Difusión
	public function getDistributionListUsers($idlist = null) {
		$client = $this->postData;
		$resultPOST = $this->listasDifusionController->getDistributionListUsers($client, $idlist);

		return $resultPOST;
	}

	// Editar Lista de Difusión
	public function updateList() {
		$client = $this->postData;
		$resultPOST = $this->listasDifusionController->updateList($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ROLES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de Roles
	public function getAllRoles() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo rol
	public function newRole() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->newRole($client);

		return $resultPOST;
	}

	// Comprobación de rol a eliminar
	public function roleStatus() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->roleStatus($client);

		return $resultPOST;
	}

	// Eliminar Rol
	public function deleteRole() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->deleteRole($client);

		return $resultPOST;
	}

	// Petición de rol
	public function getRole() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->getRole($client);

		return $resultPOST;
	}

	public function getCustomMenuAvailableForRole() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	public function getUserCustomMenuRole() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->getUserCustomMenuRole($client);

		return $resultPOST;
	}

	// Editar rol
	public function editRole() {
		$client = $this->postData;
		$resultPOST = $this->rolesController->editRole($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ANALYTICS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// ASESORES
	public function getAnalyticsConsejeros() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConsejeros($client);

		return $resultPOST;
	}

	// Excel de asesores
	public function getAnalyticsConsejerosToExport() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConsejerosToExport($client);

		return $resultPOST;
	}

	public function getAnalyticsConsejerosInfo() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConsejerosInfo($client);

		return $resultPOST;
	}

	public function getAnalyticsConsejerosAppVersion() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConsejerosAppVersion($client);

		return $resultPOST;
	}

	// Comprobación de perfilación de usuario
	public function getIfUserPerfila() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getIfUserPerfila($client);

		return $resultPOST;
	}

	// Envío de e-mail con numero de solicitud de licencias de asesores
	public function sendEmailLicences() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->sendEmailLicences($client);

		return $resultPOST;
	}

	// CUMPLIMIENTO
	public function getAnalyticsMisiones() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMisiones($client);

		return $resultPOST;
	}

	// Petición de Lista de Difusión OK/KO
	public function getDistributionList() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getDistributionList($client);

		return $resultPOST;
	}

	// Creación de Lista de Difusión OK/KO
	public function createDistributionList() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->createDistributionList($client);

		return $resultPOST;
	}

	// Actualización de Lista de Difusión OK/KO
	public function updateDistributionList() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->updateDistributionList($client);

		return $resultPOST;
	}

	// Petición de datos proyecto / misión en el momento
	public function getSnapAcualMisionCumplimiento() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getSnapAcualMisionCumplimiento($client);

		return $resultPOST;
	}

	// MUESTREO
	// Petición de encuestas
	public function getAllSurveys() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de encuestas con misión
	public function getAllSurveysWithMissions() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getAllSurveysWithMissions($client);

		return $resultPOST;
	}

	// Petición de preguntas
	public function getQuestionsSurvey() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getQuestionsSurvey($client);

		return $resultPOST;
	}

	// Petición de gráficas
	public function getAnalyticsMuestra() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestra($client);

		return $resultPOST;
	}

	// Petición de gráficas para muestreo dinámico
	public function getAnalyticsMuestraDinamic() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraDinamic($client);

		return $resultPOST;
	}

	// Petición de gráficas para muestreo dinámico filtrado
	public function getAnswersSurveyByQueryDinamic() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnswersSurveyByQueryDinamic($client);

		return $resultPOST;
	}

	// Petición de opciones para preguntas tipo ':'
	public function getOptionsFor2PointsTypeQuetsion() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getOptionsFor2PointsTypeQuetsion($client);

		return $resultPOST;
	}

	// MUESTREO DETALLADO
	public function getAnalyticsMuestraToExportByPerfQuestion() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfQuestion($client);

		return $resultPOST;
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExportByPerf() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerf($client);

		return $resultPOST;
	}

	// MUESTREO DETALLADO MAZ
	public function getAnalyticsMuestraToExportByPerfQuestionMAZ() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfQuestionMAZ($client);

		return $resultPOST;
	}

	// MUESTREO DETALLADO MAZ SEGMENTO
	public function getAnalyticsMuestraToExportByPerfQuestionMAZSegmento() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfQuestionMAZSegmento($client);

		return $resultPOST;
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExportByPerfQuestionComaparativo() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfQuestionComaparativo($client);

		return $resultPOST;
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExportByPerfComparativo() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfComparativo($client);

		return $resultPOST;
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExportByPerfMAZ() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfMAZ($client);

		return $resultPOST;
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExportByPerfMAZSegmento() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExportByPerfMAZSegmento($client);

		return $resultPOST;
	}

	// Comprobación de la integridad de las encuestas
	public function getIfSurveysAreEquals() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getIfSurveysAreEquals($client);

		return $resultPOST;
	}

	// MUESTREO COMPARATIVO
	// Petición de gráficas para comparativa
	public function getAnalyticsMuestraComparativa() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraComparativa($client);

		return $resultPOST;
	}

	// CONVERSACIONES
	// Petición de Conversaciones
	public function getAnalyticsConversacion() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConversacion($client);

		return $resultPOST;
	}

	// Petición de adjunto de Conversaciones
	public function getAttachedConversation() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAttachedConversation($client);

		return $resultPOST;
	}

	// INVERSIÓN
	// Petición de Inversión
	public function getAnalyticsInversion() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsInversion($client);

		return $resultPOST;
	}

	// CATALOGACIÓN ASESORES
	// Catalogaciones
	public function getCatalogacionesM() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de catalogación de consejeros
	public function getCatalogacionesConsejeros() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getCatalogacionesConsejeros($client);

		return $resultPOST;
	}

	// LICENCIAS
	public function getStatusLicencesDetail() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getStatusLicencesDetail($client);

		return $resultPOST;
	}

	// Exportacion excel licencias
	public function exportStatusLicences() {
		$client = $this->postData;
		$data = $client['data'];
		$rsc = $client['rsc'];

		$excel = new GenerateExcel();

		$response = $excel->licences($data, $rsc);

		return $response;
	}

	// Petición de pregunta discriminante
	public function getQuestionDiscriminante() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// PERFILACIÓN SIN FINALIZAR
	// Petición de Lista de consejeros sin perfilación
	public function getAnalyticsConsejerosNoFinPerf() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsConsejerosNoFinPerf($client);

		return $resultPOST;
	}

	// CDP
	// Petición de Lista de CDP - Usuarios
	public function getDataIntegrationCDP() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getDataIntegrationCDP($client);

		return $resultPOST;
	}

	// Petición de Lista de CDP - Encuestas
	public function getAnalyticsMuestraToExport_CDP() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsMuestraToExport_CDP($client);

		return $resultPOST;
	}

	// Ejecutar y actualizar CDP - Encuestas
	public function sendCDPData() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->sendCDPData($client);

		return $resultPOST;
	}

	// Ejecutar y actualizar CDP - Encuestas
	public function sendCDPDataUsers() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->sendCDPDataUsers($client);

		return $resultPOST;
	}

	// CUBOS DINÁMICOS
	// Petición de todos los cubos
	public function getAllBI() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de todos los esquemas
	public function getBISchemas() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de todos las tablas por esquema
	public function getAllSchemaTables() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAllSchemaTables($client);

		return $resultPOST;
	}

	// Petición de todos los campos de tabla por esquema
	public function getAllSchemaTablesFields() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAllSchemaTablesFields($client);

		return $resultPOST;
	}

	// Crear cubo
	public function setBI($intern = false) {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->setBI($client, $intern);

		return $resultPOST;
	}

	// Eliminar cubo
	public function deleteBI($intern = false) {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->deleteBI($client, $intern);

		return $resultPOST;
	}

	// Petición de cubo por id
	public function getBI() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getBI($client);

		return $resultPOST;
	}

	// Editar cubo
	public function editBI() {
		$intern = true;
		$resultPOSTDel = $this->deleteBI($intern);

		if($resultPOSTDel->status == 'KO') {
			return $resultPOSTDel;
		}

		$resultPOSTCre = $this->setBI($intern);
		return $resultPOSTCre;
	}

	// Definir filtros
	public function setBIFiltros() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->setBIFiltros($client);

		return $resultPOST;
	}

	// Consultar store procedure
	public function getBI_SP_Execution() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getBI_SP_Execution($client);

		return $resultPOST;
	}

	// Ejecutar cubo por id
	public function getBIExecution() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getBIExecution($client);

		return $resultPOST;
	}

	// PASSIVE TRACKING
	// Petición de passive tracking
	public function getAnalyticsPassiveTracking() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsPassiveTracking($client);

		return $resultPOST;
	}

	public function getAnalyticsPassiveTrackingExport() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsPassiveTrackingExport($client);

		return $resultPOST;
	}

	public function getAnalyticsPassiveTrackingDetails() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsPassiveTrackingDetails($client);

		return $resultPOST;
	}

	public function getPassiveTrackingGraphs() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getPassiveTrackingGraphs($client);

		return $resultPOST;
	}

	// STORES
	// Petición de información de stores
	public function getAppInfoStore() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAppInfoStore($client);

		return $resultPOST;
	}

	// KPI SURVEYS
	// Petición de KPI surveys
	public function getAnalyticsKPIS() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsKPIS($client);

		return $resultPOST;
	}

	// Devuelve los tiempos de respuesta de las preguntas de una encuesta
	public function getSurveyQuestionTimings() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getSurveyQuestionTimings($client);

		return $resultPOST;
	}

	// Devuelve los tiempos de respuesta de los usuarios de una encuesta
	public function getSurveyUserTimings() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getSurveyUserTimings($client);

		return $resultPOST;
	}

	// PLANTILLAS REPORTES
	// Petición de plantillas para reportes
	public function getPlantillasReportes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Eliminar plantilla/s para reportes
	public function deletePlantillaReportes() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->deletePlantillaReportes($client);

		return $resultPOST;
	}

	// Crear plantilla para reportes
	public function setPlantillaReportes() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->setPlantillaReportes($client);

		return $resultPOST;
	}

	// Petición de plantilla para reportes por id
	public function getPlantillaReportesByID() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getPlantillaReportesByID($client);

		return $resultPOST;
	}

	// Petición de plantilla para reportes por defecto
	public function getPlantillaReportesByDefault() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Editar plantilla para reportes
	public function updatePlantillaReportes() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->updatePlantillaReportes($client);

		return $resultPOST;
	}

	// Marcar plantilla por defecto
	public function setPlantillaReportesDefault() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->setPlantillaReportesDefault($client);

		return $resultPOST;
	}

	// Upload custom font
	public function setReportCustomFont() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->setReportCustomFont($client);

		return $resultPOST;
	}

	// get custom font list
	public function getTemplateReportCustomFont() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getTemplateReportCustomFont($client);

		return $resultPOST;
	}

	///////////////////////

	/* TTT ESPECIAL 09/02/23 */
	// Petición de respuestas/participantes de encuesta
	/* public function getAnswersSurvey() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];

			$params = [
				'token' => $client['token'],
				'survey' => $client['survey'],
				'maxRows' => $client['maxRows']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	} */
	/* TTT ESPECIAL 09/02/23 */

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//MISIONES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de Misiones
	public function getAllMisiones($token = null) {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getAllMisiones($client, $token);

		return $resultPOST;
	}

	// Petición de Misión por stampMision
	public function getMision($token = null, $stampMision = null) {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMision($client, $token, $stampMision);

		return $resultPOST;
	}

	// Petición de Tipos de Misiones
	public function getMissionTypes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de Objetivos por Tipos de Misiones
	public function getAllTipoMisionObjetivos() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getAllTipoMisionObjetivos($client);

		return $resultPOST;
	}

	// Petición de recordatorios de Misión
	public function getMisionRemember() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMisionRemember($client);

		return $resultPOST;
	}

	// Petición de todos los productos
	public function getAllProducts() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Comprobar si existe una misión de referidos entre las fechas dadas
	public function existsMisionBetweenDates() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->existsMisionBetweenDates($client);

		return $resultPOST;
	}

	// Crear misión
	public function createMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->createMision($client);

		return $resultPOST;
	}

	// Eliminar misión
	public function dropMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->dropMision($client);

		return $resultPOST;
	}

	// Petición de objetivos de misión
	public function getMisionesObjetivos($data = null, $serviceExecution = null) {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMisionesObjetivos($client, $data, $serviceExecution);

		return $resultPOST;
	}

	// Añadir el objetivo a la misión y actualizar la fecha de expiracion de la encuesta con la fecha de la mision
	public function setMisionObjetivoAndUpdateSurveyExpiration() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->setMisionObjetivoAndUpdateSurveyExpiration($client);

		return $resultPOST;
	}

	// Editar misión
	public function updateMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->updateMision($client);

		return $resultPOST;
	}

	// Petición de objetivos de misiones
	public function getAllObjetivosMision() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear/editar tipo de misión
	public function setTipoMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->setTipoMision($client);

		return $resultPOST;
	}

	// Eliminar tipo de misión
	public function deleteTipoMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->deleteTipoMision($client);

		return $resultPOST;
	}

	// Petición de avisos de cumplimiento
	public function getAllAvisosDisableUserAuto() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Modificación de avisos de cumplimiento
	public function deleteAllAvisosDisableUserAuto() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->deleteAllAvisosDisableUserAuto($client);

		return $resultPOST;
	}

	// Petición de cola de misiones
	public function getColaMisionesPendientes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Actualización de inicio de misión
	public function clientUpdateMisionInicioNotificado() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->clientUpdateMisionInicioNotificado($client);

		return $resultPOST;
	}

	// Actualización de fin de misión
	public function clientUpdateMisionFinNotificado() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->clientUpdateMisionFinNotificado($client);

		return $resultPOST;
	}

	// Petición de usuarios notificados en una misión
	public function getNumParticipantesNotificados() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getNumParticipantesNotificados($client);

		return $resultPOST;
	}

	// Petición de proyectos por misión
	public function getMisionesProjects() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMisionesProjects($client);

		return $resultPOST;
	}

	// Enviar notificación a usuarios no notificados
	public function sendMisionMessageUsersNotNotified() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->sendMisionMessageUsersNotNotified($client);

		return $resultPOST;
	}

	// Petición de exclusiones por respuesta/pregunta
	public function getMisionQuestionNoAccomplish() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMisionQuestionNoAccomplish($client);

		return $resultPOST;
	}

	// Petición de misiones en curso con cupo
	public function getCMBPMisionesFinCupo() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de mision en curso con cupo
	public function getCMBPMisionFinCupo() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getCMBPMisionFinCupo($client);

		return $resultPOST;
	}

	// Petición de mision en curso sin cupo
	public function getCumplimientoMision() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getCumplimientoMision($client);

		return $resultPOST;
	}

	// Petición de Misiones de inicio
	public function getAllMisionesDeInicio() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Generar links de mision
	public function getMissionSurveyLinks() {
		$client = $this->postData;
		$resultPOST = $this->misionesController->getMissionSurveyLinks($client);

		return $resultPOST;
	}

	///////////////////////

	public function getCMBPMisionesParticipantes($token, $idMission, $idProject) {
		try {
			$url = CONSTANTS::SERVERAPI . 'getCMBPMisionesParticipantes';
			$params = [
				'token' => $token,
				'mision' => $idMission,
				'idProject' => $idProject
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	public function getAllMisionesByProject() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token'],
				'project' => $client['project']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PRODUCTOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de productos
	public function getAllProductsAnaquel() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de imagenes para productos
	public function viewImagesProducts() {
		$client = $this->postData;
		$resultPOST = $this->productosController->viewImagesProducts($client);

		return $resultPOST;
	}

	// Petición de tipos de misión
	public function getTipoMisionByType() {
		$client = $this->postData;
		$resultPOST = $this->productosController->getTipoMisionByType($client);

		return $resultPOST;
	}

	// Crear nuevo producto
	public function insertProductsAnaquel() {
		$client = $this->postData;
		$resultPOST = $this->productosController->insertProductsAnaquel($client);

		return $resultPOST;
	}

	// Eliminar producto
	public function deleteProductsAnaquel() {
		$client = $this->postData;
		$resultPOST = $this->productosController->deleteProductsAnaquel($client);

		return $resultPOST;
	}

	// Petición de producto por id
	public function getProductsAnaquelByID() {
		$client = $this->postData;
		$resultPOST = $this->productosController->getProductsAnaquelByID($client);

		return $resultPOST;
	}

	// Editar producto
	public function updateProductsAnaquel() {
		$client = $this->postData;
		$resultPOST = $this->productosController->updateProductsAnaquel($client);

		return $resultPOST;
	}

	// Añadir criterio a un proyecto de producto por encuesta
	public function productSetCMBPProjectsTargets() {
		$client = $this->postData;
		$resultPOST = $this->productosController->productSetCMBPProjectsTargets($client);

		return $resultPOST;
	}

	// Añadir criterio a un proyecto de producto por segmentación
	public function productSetCMBPProjectsTargetsSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->productosController->productSetCMBPProjectsTargetsSegmentation($client);

		return $resultPOST;
	}

	// Añadir criterio a un proyecto de toda la comunidad
	public function productSetCMBPProjectsTargetsTotal() {
		$client = $this->postData;
		$resultPOST = $this->productosController->productSetCMBPProjectsTargetsTotal($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PLANTILLAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de plantillas
	public function getAllTemplates() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nueva plantilla
	public function insertTemplate() {
		$client = $this->postData;
		$resultPOST = $this->templatesController->insertTemplate($client);

		return $resultPOST;
	}

	// Eliminar plantilla
	public function deleteTemplate() {
		$client = $this->postData;
		$resultPOST = $this->templatesController->deleteTemplate($client);

		return $resultPOST;
	}

	// Petición de plantilla por id
	public function getTemplatesByID() {
		$client = $this->postData;
		$resultPOST = $this->templatesController->getTemplatesByID($client);

		return $resultPOST;
	}

	// Editar plantilla
	public function updateTemplate() {
		$client = $this->postData;
		$resultPOST = $this->templatesController->updateTemplate($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PROYECTOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de proyectos
	public function requestProject() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->requestProject($client);

		return $resultPOST;
	}

	// Petición de encuestas de perfilación
	public function getAllSurveysPerfilacion() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de objetivos de encuestas de perfilación
	public function getTargetsSurvey() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getTargetsSurvey($client);

		return $resultPOST;
	}

	// Petición de valores de pregunta de encuesta de perfilación
	public function getTargetsSurveyByQID() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getTargetsSurveyByQID($client);

		return $resultPOST;
	}

	// Creación de proyecto
	public function insertCMBPProjects() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->insertCMBPProjects($client);

		return $resultPOST;
	}

	// Validación para la creación de proyecto
	public function spAddFieldsPerf() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->spAddFieldsPerf($client);

		return $resultPOST;
	}

	// Eliminar proyecto
	public function deleteCMBPProjects() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->deleteCMBPProjects($client);

		return $resultPOST;
	}

	// Petición de misiones de proyecto
	public function getCMBPProjectsMisiones($token = null, $idProyect = null) {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsMisiones($client, $token, $idProyect);

		return $resultPOST;
	}

	// Petición de participantes de proyecto
	public function getCMBPProjectsParticipantes() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsParticipantes($client);

		return $resultPOST;
	}

	// Petición de participantes de proyecto con comprobación de ejecución
	public function getCMBPProjectsParticipantesValidacion() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsParticipantesValidacion($client);

		return $resultPOST;
	}

	// Petición de valores/códigos previos de encuesta de perfilación/proyecto
	public function getCMBPProjectsTargets() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsTargets($client);

		return $resultPOST;
	}

	// Petición de segmentos previos de segmentaciones
	public function getCMBPProjectsTargetsSegmentation() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsTargetsSegmentation($client);

		return $resultPOST;
	}

	// Petición de motivos de expulsión
	public function getAllMotivosExpulsionProject() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Expulsión de participante
	public function deleteCMBPProjectsParticipantes() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->deleteCMBPProjectsParticipantes($client);

		return $resultPOST;
	}

	// Edición de proyecto
	public function updateCMBPProjects() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->updateCMBPProjects($client);

		return $resultPOST;
	}

	// Petición de grabación de video llamadas de proyecto
	public function getFilesRecordedByProject() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getFilesRecordedByProject($client);

		return $resultPOST;
	}

	// Petición de respuestas/participantes de encuesta filtrados
	public function getAnswersSurveyByQuery() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getAnswersSurveyByQuery($client);

		return $resultPOST;
	}

	// Petición de respuestas/participantes de segmentación filtrados
	public function getAnswersSurveyByQuerySegmentation() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getAnswersSurveyByQuerySegmentation($client);

		return $resultPOST;
	}

	// Ejecución de metodologías en resultados
	public function executeMethodologiesOnResults() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->executeMethodologiesOnResults($client);

		return $resultPOST;
	}

	// Envío de aviso de videollamada
	public function sendRequest() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->sendRequest($client);

		return $resultPOST;
	}

	// Envío de aviso de videollamada
	public function sendIncomingCall() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->sendIncomingCall($client);

		return $resultPOST;
	}

	// Eliminar usuario de video llamada
	public function moderatorOutUserCall() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->moderatorOutUserCall($client);

		return $resultPOST;
	}

	// Usuarios en videollamada
	public function usersInCall() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->usersInCall($client);

		return $resultPOST;
	}

	// Fin de videollamada
	public function moderatorLeaveCall() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->moderatorLeaveCall($client);

		return $resultPOST;
	}

	// Registro de videollamada
	public function registerCall() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->registerCall($client);

		return $resultPOST;
	}

	// Validar misión
	public function validateMission() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->validateMission($client);

		return $resultPOST;
	}

	// Validar misión múltiple
	public function validateMissionMultiple() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->validateMissionMultiple($client);

		return $resultPOST;
	}

	// Rechazar misión
	public function refuseMission() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->refuseMission($client);

		return $resultPOST;
	}

	// Rechazar misión múltiple
	public function setMisionValidationMultiple() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setMisionValidationMultiple($client);

		return $resultPOST;
	}

	// Misiones validación encuesta
	public function getSurveyByUser() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getSurveyByUser($client);

		return $resultPOST;
	}

	// Misiones validación pedido
	public function getOrdersByUser() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getOrdersByUser($client);

		return $resultPOST;
	}

	// Misiones comprobación de validación
	public function isMisionValidated() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->isMisionValidated($client);

		return $resultPOST;
	}

	// Modificación de motivos de expulsión
	public function deleteAllMotivosExpulsionProject() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->deleteAllMotivosExpulsionProject($client);

		return $resultPOST;
	}

	// Guardado de video externo
	public function setFileRecordedExternal() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setFileRecordedExternal($client);

		return $resultPOST;
	}

	// Petición de imágenes de encuesta con validación
	public function getSurveysFilesByQuestion() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getSurveysFilesByQuestion($client);

		return $resultPOST;
	}

	// Comprobación de imágenes repetidas de encuesta con validación
	public function getCompareFilesBySurveys() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCompareFilesBySurveys($client);

		return $resultPOST;
	}

	// Analizar imagen
	public function analizaFoto() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->analizaFoto($client);

		return $resultPOST;
	}

	// Analizar imagen con OCR
	public function procesaOCRFotosFolder() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->procesaOCRFotosFolder($client);

		return $resultPOST;
	}

	// Información de la imagen analizada
	public function getFotoAnalizedData() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getFotoAnalizedData($client);

		return $resultPOST;
	}

	// Información de la imagen analizada con OCR
	public function getImageDataOCRProcessed() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getImageDataOCRProcessed($client);

		return $resultPOST;
	}

	// Corrección de datos OCR
	public function setImageDataOCRSimilarities() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setImageDataOCRSimilarities($client);

		return $resultPOST;
	}

	// Sacar audio de video
	public function convertMP4ToWAV() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->convertMP4ToWAV($client);

		return $resultPOST;
	}

	// Transcribir audio
	public function saveTranscriptionInfo() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->saveTranscriptionInfo($client);

		return $resultPOST;
	}

	// Petición de transcripción por proyecto e idCall
	public function getFilesTranscriptionByProject() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getFilesTranscriptionByProject($client);

		return $resultPOST;
	}

	// Añadir documento a proyecto
	public function insertCMBPProjectsFile() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->insertCMBPProjectsFile($client);

		return $resultPOST;
	}

	// Petición de documentos de proyecto
	public function getCMBPProjectsFiles() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsFiles($client);

		return $resultPOST;
	}

	// Eliminar documentos de proyecto
	public function deleteCMBPProjectsFileById() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->deleteCMBPProjectsFileById($client);

		return $resultPOST;
	}

	// Editar descripción de documento de proyecto
	public function updateCMBPProjectsFilesDesc() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->updateCMBPProjectsFilesDesc($client);

		return $resultPOST;
	}

	// Lista de asesores notificados
	public function getCMBPProjectsMisionesUsersNotif() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getCMBPProjectsMisionesUsersNotif($client);

		return $resultPOST;
	}

	// Petición de asignación de cupo por proyecto / misión
	public function getDesgloseCuposMision() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getDesgloseCuposMision($client);

		return $resultPOST;
	}

	// Petición de asignación de cupo por proyecto / misión
	public function getMissionQuotaBreakdown() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getMissionQuotaBreakdown($client);

		return $resultPOST;
	}

	// Posibles respuestas para las 4 preguntas de perfilación
	public function getAnalyticsMuestraToExportHeaders() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getAnalyticsMuestraToExportHeaders($client);

		return $resultPOST;
	}

	// Asignacion de porcentaje a misiones de un proyecto
	public function setCMBPProjectsMisionesCuotaReparto() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setCMBPProjectsMisionesCuotaReparto($client);

		return $resultPOST;
	}

	// Reparto de asesores en misiónes de proyecto
	public function setRepartoPartProjByMissions() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setRepartoPartProjByMissions($client);

		return $resultPOST;
	}

	// Asesores asignados a mision de proyecto con repartición
	public function getRepartoPartProjByMissions() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getRepartoPartProjByMissions($client);

		return $resultPOST;
	}

	// Asignar a usuario comercios y articulos
	public function setUserComerciosItems() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->setUserComerciosItems($client);

		return $resultPOST;
	}

	// Comercios y articulos asignados a usuario
	public function getUserComerciosItems() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->getUserComerciosItems($client);

		return $resultPOST;
	}

	// Servicio de petición de datos de evidencias a validar
	public function servicioParaValidacionDeEvidencias() {
		$client = $this->postData;
		$resultPOST = $this->proyectosController->servicioParaValidacionDeEvidencias($client);

		return $resultPOST;
	}

	///////////////////////

	// Envío de notificación de proyecto // Service.php
	public function getCMBPProjectsMisionesNotificaciones($token, $idMission, $idProject) {
		try {
			$url = CONSTANTS::SERVERAPI . 'getCMBPProjectsMisionesNotificaciones';
			$params = [
				'token' => $token,
				'idmision' => $idMission,
				'project' => $idProject
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	// Envío de notificación de proyecto // Service.php
	public function setCMBPProjectsMisionesNotificaciones($token, $idMission, $idProject, $users) {
		try {
			$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsMisionesNotificaciones';
			$params = [
				'token' => $token,
				'idmision' => $idMission,
				'project' => $idProject,
				'users' => json_encode($users)
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	public function getProjectsByMision() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . 'getProjectsByMision';
			$params = [
				'token' => $client['token'],
				'idmision' => $client['idmision']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			// Terminación por error
			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			// Búsqueda de datos de proyectos a los que pertenece la misión
			$result = [
				'status' => 'OK',
				'result' => []
			];
			foreach($resultPOST->result as $projectInc) {
				$resultPOSTProjects = $this->proyectosController->requestProject($client, $projectInc->idProject);

				if(count($resultPOSTProjects->result) > 0) {
					array_push($result['result'], $resultPOSTProjects->result[0]);
				}
			}

			return $result;
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	// Petición de todas las tablas de las preguntas
	public function getAnalyticsMuestraToExport() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token'],
				'survey' => $client['survey'],
				'numPreguntasPerfilacionEnAnalyticMostreo' => $client['numPreguntasPerfilacionEnAnalyticMostreo'],
				'mision' => $client['idmision'],
				'project' => $client['project']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status === 'OK') {
				// crear nuevo previewtable
				$previewTables = new PreviewTables();
				// formatear la respuesta
				$response = $previewTables->formatAnswer($resultPOST);
				$response['status'] = 'OK';

				return $response;
			} else {
				return $resultPOST;
			}
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	// Eliminar Encuesta de proyecto
	public function deleteCMBPProjectsSurveys($id) {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsSurveys';

			$params = [
				'token' => $client['token'],
				'id' => $id
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			} else {
				$resultPOST = $this->SaveCMBPProjectsSurveys($id, true);
			}

			return $resultPOST;
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	// Guardar encuesta de proyecto
	public function SaveCMBPProjectsSurveys($id, $update) {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsSurveys';

			$params = [
				'token' => $client['token'],
				'idProject' => $id,
				'sid' => '',
				'surveyls_title' => '',
				'datecreated' => '',
				'active' => '',
				'perfilacion' => ''
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return 'ERROR';
		}
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//PAGOS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Todos los pagos
	public function getPagosPendientes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Todos los pagos por país
	public function getPagosPendientesByCountry() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->getPagosPendientesByCountry($client);

		return $resultPOST;
	}

	// Importar pagos desde excel
	public function setPagosRealizados() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->setPagosRealizados($client);

		return $resultPOST;
	}

	// Stamps de pagos esportados a excel
	public function setPagosPendientesExportados() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->setPagosPendientesExportados($client);

		return $resultPOST;
	}

	// Enviar notificación de pagos no realizados
	public function sendNoPaymentNotifications() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->sendNoPaymentNotifications($client);

		return $resultPOST;
	}

	// Detalle de pagos
	public function getDetallePagos() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->getDetallePagos($client);

		return $resultPOST;
	}

	// Petición de pagos automatizados
	public function getScheduledPayment() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear pago automatizado
	public function setScheduledPayment() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->setScheduledPayment($client);

		return $resultPOST;
	}

	// Eliminar de pago automatizado
	public function deleteScheduledPayment() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->deleteScheduledPayment($client);

		return $resultPOST;
	}

	// Actualizar pago automatizado
	public function updateScheduledPayment() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->updateScheduledPayment($client);

		return $resultPOST;
	}

	// Validar pagos
	public function validatePagosRealizados() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->validatePagosRealizados($client);

		return $resultPOST;
	}

	// Registrar pagos no cobrables
	public function setPagosNoCobrables() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->setPagosNoCobrables($client);

		return $resultPOST;
	}

	// Subida de archivo de pagos pendientes descargados
	public function sendExcelDataToServer() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->sendExcelDataToServer($client);

		return $resultPOST;
	}

	// Subida de archivo de pagos a validar importado
	public function uploadImportPaymentsNoProcessed() {
		$client = $this->postData;
		$resultPOST = $this->pagosController->uploadImportPaymentsNoProcessed($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//RECOMPENSAS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Todos los artículos
	public function getAllRewardsArticles() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Artículo nuevo
	public function setRewardsArticle() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->setRewardsArticle($client);

		return $resultPOST;
	}

	// Eliminar artículo
	public function deleteRewardsArticle() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->deleteRewardsArticle($client);

		return $resultPOST;
	}

	// Petición de artículo por ID
	public function getRewardsArticlesByID() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->getRewardsArticlesByID($client);

		return $resultPOST;
	}

	// Actualizar artículo
	public function updateRewardsArticle() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->updateRewardsArticle($client);

		return $resultPOST;
	}

	// Todos los catálogos
	public function getAllRewardsCatalogs() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Catálogo nuevo
	public function setRewardsCatalog() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->setRewardsCatalog($client);

		return $resultPOST;
	}

	// Eliminar catálogo
	public function deleteRewardsCatalog() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->deleteRewardsCatalog($client);

		return $resultPOST;
	}

	// Petición de catálogo por ID
	public function getRewardsCatalogsByID() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->getRewardsCatalogsByID($client);

		return $resultPOST;
	}

	// Actualizar catálogo
	public function updateRewardsCatalog() {
		$client = $this->postData;
		$resultPOST = $this->recompensasController->updateRewardsCatalog($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ROTACIONES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Todos los grupos
	public function getAllRotacionSurveyQuestions() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	public function deleteRotacionSurveyQuestions() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->deleteRotacionSurveyQuestions($client);

		return $resultPOST;
	}

	public function setRotacionSurveyQuestions() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->setRotacionSurveyQuestions($client);

		return $resultPOST;
	}

	public function getRotacionSurveyQuestions() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getRotacionSurveyQuestions($client);

		return $resultPOST;
	}

	public function getAllRotacionesSurvey() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getAllRotacionesSurvey($client);

		return $resultPOST;
	}

	public function getProjectMisionRotaciones() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getProjectMisionRotaciones($client);

		return $resultPOST;
	}

	public function deleteProjectMisionRotaciones() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->deleteProjectMisionRotaciones($client);

		return $resultPOST;
	}

	public function setProjectMisionRotaciones() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->setProjectMisionRotaciones($client);

		return $resultPOST;
	}

	public function getProjectMisionRotacionesAsigned() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getProjectMisionRotacionesAsigned($client);

		return $resultPOST;
	}

	public function setUserRotacion() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->setUserRotacion($client);

		return $resultPOST;
	}

	public function getAllRotacionesProject() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getAllRotacionesProject($client);

		return $resultPOST;
	}

	public function getAllAsignedProjectRotaciones() {
		$client = $this->postData;
		$resultPOST = $this->rotacionesController->getAllAsignedProjectRotaciones($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//NOTIFICACIONES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todas las notificaciones
	public function getCMBPNotifications($id = null, $token = null) {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->getCMBPNotifications($client, $id, $token);

		return $resultPOST;
	}

	// Creación de ID para notificación
	public function getIdNotifications() {
		$date = new DateTime();
		$id = intval($date->format('YnjHisv'));

		$resultPOST = [
			'status' => 'OK',
			'result' => $id
		];

		return $resultPOST;
	}

	// Guardar y ejecutar notificación
	public function setCMBPNotificationsAndExecute() {
		$client = $this->postData;
		$notification = $this->setCMBPNotifications();

		if($notification->status == 'OK') {
			$result = $this->executeNofitication($client['id'], $client['token']);
			return $result;
		} else {
			return $notification;
		}
	}

	// Actualizar y ejecutar notificación
	public function updateCMBPNotificationsAndExecute() {
		$client = $this->postData;
		$notification = $this->updateCMBPNotifications();

		if($notification->status == 'OK') {
			$result = $this->executeNofitication($client['id'], $client['token']);
			return $result;
		} else {
			return $notification;
		}
	}

	// Guardado de notificación
	public function setCMBPNotifications() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->setCMBPNotifications($client);

		return $resultPOST;
	}

	// Editar notificación
	public function updateCMBPNotifications() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->updateCMBPNotifications($client);

		return $resultPOST;
	}

	// Ejecutar notificación
	public function executeNofitication($id = null, $token = null, $serviceExecution = null) {
		if(isset($this->postData)) {
			$client = $this->postData;
		} else {
			$client['token'] = $token;
		}

		$resultPOST = $this->notificacionesController->executeNofitication($client, $id, $token, $serviceExecution);

		return $resultPOST;
	}

	// Actualizar Notificación despues de ejecución de notificaciones
	public function updateCMBPNotificationsExecution($id, $date, $obs1, $obs2, $token, $idTenant, $idCPG) {
		$resultPOST = $this->notificacionesController->updateCMBPNotificationsExecution($id, $date, $obs1, $obs2, $token, $idTenant, $idCPG);

		return $resultPOST;
	}

	// Ejecutar notificación Schedule Payments
	public function executeNofiticationSchedulePayments($id = null, $token = null) {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->executeNofiticationSchedulePayments($client, $id, $token);

		return $resultPOST;
	}

	// Eliminar notificación
	public function deleteCMBPNotifications() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->deleteCMBPNotifications($client);

		return $resultPOST;
	}

	// Enviar notificación a usuario
	public function PostMessageToUser($data, $token = null) {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->PostMessageToUser($client, $data, $token);

		return $resultPOST;
	}

	// Enviar encuesta a usuario o lista
	public function postSurvey($data, $token = null, $textToNotify = '', $isMision = '0') {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->postSurvey($client, $data, $token, $textToNotify, $isMision);

		return $resultPOST;
	}

	// Enviar encuesta a usuario o lista (Desde el apartado de edición de misiones (JS))
	public function postSurveyMisiones() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->postSurveyMisiones($client);

		return $resultPOST;
	}

	// Enviar encuesta a pregunta cerrada a usuario o lista
	public function PostQuestionMultiple($data, $token = null) {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->PostQuestionMultiple($client, $data, $token);

		return $resultPOST;
	}

	// Petición de cola de notificaciones programadas
	public function getCMBPNotificationsServiceProgramadasTimer() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de cola de notificaciones cíclicas
	public function getCMBPNotificationsServiceCiclicasTimer() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->getCMBPNotificationsServiceCiclicasTimer($client);

		return $resultPOST;
	}

	// Notificar a pre-consejeros
	public function sendReActivationEmail() {
		$client = $this->postData;
		$resultPOST = $this->notificacionesController->sendReActivationEmail($client);

		return $resultPOST;
	}

	// Petición de todos los preconsejeros
	public function getPreConsejeros() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de consejeros sin clabe
	public function getConsejerosSinClabe() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];

			$params = [
				'token' => $client['token'],
				'admin' => $client['admin'],
				'country' => $client['country']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Petición de consejeros sin teléfono
	public function getConsejerosSinTelf() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];

			$params = [
				'token' => $client['token'],
				'admin' => $client['admin'],
				'country' => $client['country']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	///////////////////////

	// Service.php
	public function updateMisionInicioNotificado($token, $idProject, $mission, $value, $idTenant, $idCPG) {
		try {
			$url = CONSTANTS::SERVERAPI . 'updateMisionInicioNotificado';
			$params = [
				'token' => $token,
				'idProject' => $idProject,
				'mision' => $mission,
				'Value' => $value,
				'idTenant' => $idTenant,
				'idCPG' => $idCPG
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status == 'OK') {
				return true;
			} else {
				return false;
			}
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return false;
		}
	}

	// Service.php
	public function updateMisionFinNotificado($token, $idProject, $mission, $value, $idTenant, $idCPG) {
		try {
			$url = CONSTANTS::SERVERAPI . 'updateMisionFinNotificado';
			$params = [
				'token' => $token,
				'idProject' => $idProject,
				'mision' => $mission,
				'Value' => $value,
				'idTenant' => $idTenant,
				'idCPG' => $idCPG
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status == 'OK') {
				return true;
			} else {
				return false;
			}
		} catch(\Throwable $e) {
			$this->returnException($e, __FUNCTION__);
			return false;
		}
	}

	// Service.php
	public function enableReferrals($token) {
		try {
			$url = CONSTANTS::SERVERAPI . 'enableReferrals';
			$params = [
				'token' => $token
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Service.php
	public function disableReferrals($token) {
		try{
			$url = CONSTANTS::SERVERAPI . 'disableReferrals';
			$params = [
				'token' => $token
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Service.php
	public function getCMBPNotificationsServiceCiclicas($token = null) {
		try {
			$client = $this->postData;
			if(!isset($token)) {
				$token = $client['token'];
			}
			$url = CONSTANTS::SERVERAPI . 'getCMBPNotificationsServiceCiclicas';
			$params = [
				'token' => $token
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	public function getCMBPNotificationsServiceSchedulePayments($token = null) {
		try {
			$client = $this->postData;
			if(!isset($token)) {
				$token = $client['token'];
			}
			$url = CONSTANTS::SERVERAPI . 'getCMBPNotificationsServiceSchedulePayments';
			$params = [
				'token' => $token
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	public function postGroupList($data) {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . 'postSurvey';
			$params = [
				'token' => $client['token'],
				'from' => $data['from'],
				'emailsToSend' => $data['emailsToSend'],
				'message' => $data['message'],
				'idlist' => $data['idlist'],
				'misionStamp' => ''
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//OPERAR
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de datos de Pops Up
	public function getAllPopups() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Guardar, borrar o actualizar PopUps
	public function setPopups() {
		$client = $this->postData;
		$resultPOST = $this->operarController->setPopups($client);

		return $resultPOST;
	}

	// Usuarios asignados a un PopUp
	public function getAllPopupsUserAssignment() {
		$client = $this->postData;
		$resultPOST = $this->operarController->getAllPopupsUserAssignment($client);

		return $resultPOST;
	}

	// Asignar usuarios a un PopUp
	public function setPopupsUserAssignment() {
		$client = $this->postData;
		$resultPOST = $this->operarController->setPopupsUserAssignment($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ADMINISTRADORES BACKEND
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todos los administradores
	public function getAllUsersAPI() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Guardar nuevo administrador
	public function registerAPIUser() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->registerAPIUser($client);

		return $resultPOST;
	}

	// Eliminación de administrador
	public function dropUserAPI() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->dropUserAPI($client);

		return $resultPOST;
	}

	// Países permitidos para administrador
	public function getUserAPICountries() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->getUserAPICountries($client);

		return $resultPOST;
	}

	// Cambiar contraseña de administrador
	public function resetPasswordAPIUser() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->resetPasswordAPIUser($client);

		return $resultPOST;
	}

	// Editar administrador
	public function updateAPIUser() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->updateAPIUser($client);

		return $resultPOST;
	}

	// Petición de roles de Administradores BackEnd
	public function getAllAdminRolesMenu() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->getAllAdminRolesMenu($client);

		return $resultPOST;
	}

	// Crear nuevo rol de Administrador BackEnd
	public function newAdminRoleMenu() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->newAdminRoleMenu($client);

		return $resultPOST;
	}

	// Eliminar rol de Administrador BackEnd
	public function deleteAdminRoleMenu() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->deleteAdminRoleMenu($client);

		return $resultPOST;
	}

	// Petición de permisos de rol de Administrador BackEnd
	public function getAdminRoleMenu() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->getAdminRoleMenu($client);

		return $resultPOST;
	}

	// Petición de permisos de AddOns de rol de Administrador BackEnd
	public function getUsersRoleAddons() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->getUsersRoleAddons($client);

		return $resultPOST;
	}

	// Editar rol de Administrador BackEnd
	public function editAdminRoleMenu() {
		$client = $this->postData;
		$resultPOST = $this->administradoresController->editAdminRoleMenu($client);

		return $resultPOST;
	}

	// Petición de AddOns activos
	public function getAllAddOnsEnabled() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CONSUMO
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todos los items
	public function getAllItems() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Rellenar incompletos
	public function getItemUnknownInfoGS1Massive() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo item
	public function setItems() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->setItems($client);

		return $resultPOST;
	}

	// Eliminar item
	public function deleteItems() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->deleteItems($client);

		return $resultPOST;
	}

	// Petición de item por id
	public function getItemsById() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->getItemsById($client);

		return $resultPOST;
	}

	// Actualizar item
	public function updateItems() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->updateItems($client);

		return $resultPOST;
	}

	// Guardar excel con items descargados
	public function sendExcelDataToServerItems() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->sendExcelDataToServerItems($client);

		return $resultPOST;
	}

	// Modificar registros a través de archivo
	public function updateNewItemsFromFile() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->updateNewItemsFromFile($client);

		return $resultPOST;
	}

	// Petición de todos los tipos de tiendas
	public function getAllComerciosType() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo tipo de tienda
	public function setComercioType() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->setComercioType($client);

		return $resultPOST;
	}

	// Eliminar tipo de tienda
	public function deleteComercioType() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->deleteComercioType($client);

		return $resultPOST;
	}

	// Actualizar tipo de tienda
	public function updateComercioType() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->updateComercioType($client);

		return $resultPOST;
	}

	// Petición de todas las tiendas
	public function getAllComercios() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nueva tienda
	public function setComercios() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->setComercios($client);

		return $resultPOST;
	}

	// Eliminar tienda
	public function deleteComercios() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->deleteComercios($client);

		return $resultPOST;
	}

	// Petición de tienda por id
	public function getComerciosById() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->getComerciosById($client);

		return $resultPOST;
	}

	// Actualizar tienda
	public function updateComercios() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->updateComercios($client);

		return $resultPOST;
	}

	// Guardar excel con stores descargados
	public function sendExcelDataToServerStores() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->sendExcelDataToServerStores($client);

		return $resultPOST;
	}

	// Modificar registros a través de archivo
	public function updateNewStoresFromFile() {
		$client = $this->postData;
		$resultPOST = $this->itemsController->updateNewStoresFromFile($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//HTML
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todas las extensiones funcionales
	public function getAllCustomMenuOption() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear extensión funcional
	public function setCustomMenuOption() {
		$client = $this->postData;
		$resultPOST = $this->htmlController->setCustomMenuOption($client);

		return $resultPOST;
	}

	// Eliminar extensión funcional
	public function deleteCustomMenuById() {
		$client = $this->postData;
		$resultPOST = $this->htmlController->deleteCustomMenuById($client);

		return $resultPOST;
	}

	// Editar extensión funcional
	public function editCustomMenuById() {
		$client = $this->postData;
		$resultPOST = $this->htmlController->editCustomMenuById($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ADDONS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Carga de todos los AddOns
	public function getAllAddOns() {
		$client = $this->postData;
		$resultPOST = $this->addOnsController->getAllAddOns($client);

		return $resultPOST;
	}

	// Guardar AddOn nuevo
	public function setAddOn() {
		$client = $this->postData;
		$resultPOST = $this->addOnsController->setAddOn($client);

		return $resultPOST;
	}

	// Eliminar AddOn
	public function deleteAddOn() {
		$client = $this->postData;
		$resultPOST = $this->addOnsController->deleteAddOn($client);

		return $resultPOST;
	}

	// Actualizar AddOn
	public function updateAddOn() {
		$client = $this->postData;
		$resultPOST = $this->addOnsController->updateAddOn($client);

		return $resultPOST;
	}

	// Petición de secciones de AddOn
	public function getAllAddOnsSection() {
		$client = $this->postData;
		$resultPOST = $this->addOnsController->getAllAddOnsSection($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//ASISTENTE DE VOZ
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Carga de todos los diccionarios
	public function getAllVoiceassistantDictionary() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Carga de todos los hashtags
	public function getAllHashtag() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Guardar diccionario nuevo
	public function setVoiceassistantDictionary() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->setVoiceassistantDictionary($client);

		return $resultPOST;
	}

	// Eliminar diccionario
	public function deleteVoiceassistantDictionary() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->deleteVoiceassistantDictionary($client);

		return $resultPOST;
	}

	// Carga de diccionario por id
	public function getVoiceassistantDictionaryById() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->getVoiceassistantDictionaryById($client);

		return $resultPOST;
	}

	// Carga de registros por id de diccionario
	public function getAllVoiceassistantDictionaryRegisters() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->getAllVoiceassistantDictionaryRegisters($client);

		return $resultPOST;
	}

	// Actualizar diccionario
	public function updateVoiceassistantDictionary() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->updateVoiceassistantDictionary($client);

		return $resultPOST;
	}

	// Carga sinónimos por id de registro
	public function getAllVoiceassistantDictionarySynonym() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->getAllVoiceassistantDictionarySynonym($client);

		return $resultPOST;
	}

	// Carga todos los sinónimos de diccionario
	public function getAllVoiceassistantDictionarySynonymAll() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->getAllVoiceassistantDictionarySynonymAll($client);

		return $resultPOST;
	}

	// Carga de todos los no match
	public function getAllVoiceassistantNoMatch() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Actualizar sinónimos y no match
	public function updateSynonymsNoMatch() {
		$client = $this->postData;
		$resultPOST = $this->asistenteVozController->updateSynonymsNoMatch($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//HASHTAGS
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Guardar hashtag nuevo
	public function addNewHashtag() {
		$client = $this->postData;
		$resultPOST = $this->hashtagsController->addNewHashtag($client);

		return $resultPOST;
	}

	// Eliminar hashtag
	public function deleteHashtag() {
		$client = $this->postData;
		$resultPOST = $this->hashtagsController->deleteHashtag($client);

		return $resultPOST;
	}

	// Carga de hashtag por id
	public function getHashtagByID() {
		$client = $this->postData;
		$resultPOST = $this->hashtagsController->getHashtagByID($client);

		return $resultPOST;
	}

	// Editar hashtag
	public function updateHashtag() {
		$client = $this->postData;
		$resultPOST = $this->hashtagsController->updateHashtag($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//AJUSTES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// WELCOME TOUR
	// Set (new y update) Welcome Tour
	public function setWelcomeTour() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setWelcomeTour($client);

		return $resultPOST;
	}

	// Petición de datos del Welcome Tour
	public function getWelcomeTour() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// DOMINIOS EMBEBIDOS
	// Petición de todos los dominios
	public function getAllDomains() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear dominio
	public function newDomain() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->newDomain($client);

		return $resultPOST;
	}

	// Eliminar dominio
	public function deleteDomain() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deleteDomain($client);

		return $resultPOST;
	}

	// Actualizar dominio
	public function updateDomain() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updateDomain($client);

		return $resultPOST;
	}

	// BOTS
	// Petición de todos los bots
	public function getAllBots() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear bot
	public function setBot() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setBot($client);

		return $resultPOST;
	}

	// Eliminar bot
	public function deleteBot() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deleteBot($client);

		return $resultPOST;
	}

	// Actualizar bot
	public function updateBot() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updateBot($client);

		return $resultPOST;
	}

	// DEFINICIÓN CATALOGACIÓN ASESORES
	// Crear catalogación de asesores
	public function saveNewCatalogM() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->saveNewCatalogM($client);

		return $resultPOST;
	}

	// Actualizar catalogación de asesores
	public function setCatalogacionM() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setCatalogacionM($client);

		return $resultPOST;
	}

	// SECCIÓN PERFILACIÓN
	// Petición de perfilación por género
	public function getPerfGenero() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de perfilación por estado
	public function getPerfEstados() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de perfilación por edad
	public function getPerfEdad() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de perfilación por PerfSec
	public function getPerfSec() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de perfilación por PerfRegion
	public function getPerfRegion() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de integración
	public function getLicenciasDiscriminantes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Nueva perfilación por género
	public function setPerfGenero() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setPerfGenero($client);

		return $resultPOST;
	}

	// Nueva perfilación por estado
	public function setPerfEstados() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setPerfEstados($client);

		return $resultPOST;
	}

	// Nueva perfilación por edad
	public function setPerfEdad() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setPerfEdad($client);

		return $resultPOST;
	}

	// Nueva perfilación por PerfSec
	public function setPerfSec() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setPerfSec($client);

		return $resultPOST;
	}

	// Nueva perfilación por PerfRegion
	public function setPerfRegion() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setPerfRegion($client);

		return $resultPOST;
	}

	// Nueva integración
	public function setLicenciasDiscriminantes() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setLicenciasDiscriminantes($client);

		return $resultPOST;
	}

	// Eliminar perfilación por género
	public function deletePerfGenero() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deletePerfGenero($client);

		return $resultPOST;
	}

	// Eliminar perfilación por estado
	public function deletePerfEstados() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deletePerfEstados($client);

		return $resultPOST;
	}

	// Eliminar perfilación por edad
	public function deletePerfEdad() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deletePerfEdad($client);

		return $resultPOST;
	}

	// Eliminar perfilación por PerfSec
	public function deletePerfSec() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deletePerfSec($client);

		return $resultPOST;
	}

	// Eliminar perfilación por PerfRegion
	public function deletePerfRegion() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deletePerfRegion($client);

		return $resultPOST;
	}

	// Eliminar integración
	public function deleteLicenciasDiscriminantes() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deleteLicenciasDiscriminantes($client);

		return $resultPOST;
	}

	// Editar perfilación por género
	public function editPerfGenero() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editPerfGenero($client);

		return $resultPOST;
	}

	// Editar perfilación por estado
	public function editPerfEstados() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editPerfEstados($client);

		return $resultPOST;
	}

	// Editar perfilación por edad
	public function editPerfEdad() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editPerfEdad($client);

		return $resultPOST;
	}

	// Editar perfilación por PerfSec
	public function editPerfSec() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editPerfSec($client);

		return $resultPOST;
	}

	// Editar perfilación por PerfRegion
	public function editPerfRegion() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editPerfRegion($client);

		return $resultPOST;
	}

	// Editar integración
	public function editLicenciasDiscriminantes() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->editLicenciasDiscriminantes($client);

		return $resultPOST;
	}

	// FORMULARIO DE REGISTRO
	// Configuración de registro
	public function getRegisterConfiguration() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Cambiar la configuración de registro
	public function setRegisterConfiguration() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setRegisterConfiguration($client);

		return $resultPOST;
	}

	// PAÍSES
	// Petición de plantillas de pagos según país
	public function getTemplatePagosByCountry() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getTemplatePagosByCountry($client);

		return $resultPOST;
	}

	// Petición de tipos de identificación según país
	public function getPaisesTipoIdentificacion() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getPaisesTipoIdentificacion($client);

		return $resultPOST;
	}

	// Petición de tipos de cuentas según país
	public function getPaisesTipoCuentas() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getPaisesTipoCuentas($client);

		return $resultPOST;
	}

	// Petición de bancos según país
	public function getPaisesBancos() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getPaisesBancos($client);

		return $resultPOST;
	}

	// Petición de textos de bienvenida según país
	public function getWelcomeChatsById() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getWelcomeChatsById($client);

		return $resultPOST;
	}

	// Petición de ponderaciones
	public function getPonderacionesByCountry() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->getPonderacionesByCountry($client);

		return $resultPOST;
	}

	// Exportar a excel ponderaciones
	public function exportPonderacionesByCountry() {
		$client = $this->postData;
		$data = $client['data'];
		$rsc = $client['rsc'];

		$excel = new GenerateExcel();

		$response = $excel->ponderacionesByCountry($data, $rsc);

		return $response;
	}

	// Actualización de parámetros de países
	public function updatePaises() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updatePaises($client);

		return $resultPOST;
	}

	// IDIOMAS
	// Actualización de parámetros de idiomas
	public function updateIdiomas() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updateIdiomas($client);

		return $resultPOST;
	}

	// PERFILES
	// Petición de perfiles
	public function getProfiles() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Creación de perfil
	public function setProfile() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setProfile($client);

		return $resultPOST;
	}

	// Eliminar perfil
	public function deleteProfile() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deleteProfile($client);

		return $resultPOST;
	}

	// Actualizar perfil
	public function updateProfile() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updateProfile($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CONFIGURACION
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// GENERAL
	// Peticion de políticas
	public function getPoliciesByID() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->getPoliciesByID($client);

		return $resultPOST;
	}

	// Guardar políticas
	public function setPolicies() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->setPolicies($client);

		return $resultPOST;
	}

	// Configuracion general
	public function getCMBPConfig() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->getCMBPConfig($client);

		return $resultPOST;
	}

	// Actualizar configuración general
	public function setCMBPConfig() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->setCMBPConfig($client);

		return $resultPOST;
	}

	// Pedir relación de perfilación por país
	public function getSurveyCountry() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// FUNCIONALIDADES APP
	// Actualizar funcionalidades
	public function setSystemConfig() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->setSystemConfig($client);

		return $resultPOST;
	}

	// LOGS
	// Petición de logs
	public function getCMBPLOG() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->getCMBPLOG($client);

		return $resultPOST;
	}

	// Eliminación de todos los logs
	public function deleteCMBPLOG() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// RSC
	// Petición de RSC específico
	public function getRSC() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->getRSC($client);

		return $resultPOST;
	}

	// Petición de RSC completo
	public function getAllRSC() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Importar RSC
	public function importRSC() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->importRSC($client);

		return $resultPOST;
	}

	// Sincronizar RSC
	public function synchronizeRSC() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->synchronizeRSC($client);

		return $resultPOST;
	}

	// Nuevo RSC
	public function setRSC() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->setRSC($client);

		return $resultPOST;
	}

	// Editar RSC
	public function updateRSC() {
		$client = $this->postData;
		$resultPOST = $this->configuracionController->updateRSC($client);

		return $resultPOST;
	}

	///////////////////////

	// Ejecutar distribución de licencias
	public function distributeLicencesByPercentage() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Petición exclusiones wordcloud
	public function getAllWordsExcludedCloud() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Nueva exclusión wordcloud
	public function setWordsExcludedCloud() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->setWordsExcludedCloud($client);

		return $resultPOST;
	}

	// Borrar todas las exclusiones wordcloud
	public function deleteAllWordsExcludedCloud() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Borrar exclusión por id
	public function deleteWordExcludedCloudByID() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->deleteWordExcludedCloudByID($client);

		return $resultPOST;
	}

	// Editar exclusión por id
	public function updateWordExcludedCloudByID() {
		$client = $this->postData;
		$resultPOST = $this->ajustesController->updateWordExcludedCloudByID($client);

		return $resultPOST;
	}

	// Petición algoritmos de perfilación
	public function getSPSchemaCorporate() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de desglose de uso de Google API
	public function getDetallePeticionesAPI_Google() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//MULTI TENANT
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todos los tenants
	public function getAllTenants() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo tenant
	public function setTenant() {
		$client = $this->postData;
		$resultPOST = $this->tenantController->setTenant($client);

		return $resultPOST;
	}

	// Eliminar tenant
	public function deleteTenant() {
		$client = $this->postData;
		$resultPOST = $this->tenantController->deleteTenant($client);

		return $resultPOST;
	}

	// Petición de tenant por id
	public function getTenantById() {
		$client = $this->postData;
		$resultPOST = $this->tenantController->getTenantById($client);

		return $resultPOST;
	}

	// Actualizar Tenant
	public function updateTenant() {
		$client = $this->postData;
		$resultPOST = $this->tenantController->updateTenant($client);

		return $resultPOST;
	}

	// Petición de licencias del tenant
	public function getSocialLabsLicencesByTenant() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Guardado de licencias del tenant
	public function setSocialLabsLicencesByTenant() {
		$client = $this->postData;
		$resultPOST = $this->tenantController->setSocialLabsLicencesByTenant($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CPG
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todos los CPG
	public function getAllCPG() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo CPG
	public function setCPG() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->setCPG($client);

		return $resultPOST;
	}

	// Eliminar CPG
	public function deleteCPG() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->deleteCPG($client);

		return $resultPOST;
	}

	// Petición de CPG por id
	public function getCPGById() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->getCPGById($client);

		return $resultPOST;
	}

	// Actualizar CPG
	public function updateCPG() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->updateCPG($client);

		return $resultPOST;
	}

	// Petición de licencias del CPG
	public function getSocialLabsLicencesByCPG() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Guardado de licencias del CPG
	public function setSocialLabsLicencesByCPG() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->setSocialLabsLicencesByCPG($client);

		return $resultPOST;
	}

	// Petición de detalle de licencias usadas
	public function getSocialLabsLicencesDetailByCPG() {
		$client = $this->postData;
		$resultPOST = $this->cpgController->getSocialLabsLicencesDetailByCPG($client);

		return $resultPOST;
	}

	// Petición licencias asignadas por país
	public function getLicencesByCountry() {
		$client = $this->postData;

		// Especial para este servicio
		$resultPOST = ['status' => 'OK', 'result' => ''];
		$resultPOST['result'] = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CLIENTES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Petición de todos los clientes
	public function getAllClientes() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Crear nuevo cliente
	public function setCliente() {
		$client = $this->postData;
		$resultPOST = $this->customersController->setCliente($client);

		return $resultPOST;
	}

	// Eliminar cliente
	public function deleteCliente() {
		$client = $this->postData;
		$resultPOST = $this->customersController->deleteCliente($client);

		return $resultPOST;
	}

	// Petición de cliente por id
	public function getClienteById() {
		$client = $this->postData;
		$resultPOST = $this->customersController->getClienteById($client);

		return $resultPOST;
	}

	// Actualizar cliente
	public function updateCliente() {
		$client = $this->postData;
		$resultPOST = $this->customersController->updateCliente($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//MANTENIMIENTO SISTEMA
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Información de tablas
	public function getDBMaintenanceInfo() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Petición de años para archivar
	public function getYearsToArchiveOfmsg() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	// Archivar / Desarchivar - ofmsg / ofmsg_h
	public function archiveOfmsgFromDate() {
		$client = $this->postData;
		$resultPOST = $this->mantenimientoController->archiveOfmsgFromDate($client);

		return $resultPOST;
	}

	// Archivar / Desarchivar - ofmsg / ofmsg_h por año
	public function archiveOfmsgFromFullYear() {
		$client = $this->postData;
		$resultPOST = $this->mantenimientoController->archiveOfmsgFromFullYear($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//REPORTES a través de misiones (permanentes)
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Generar reporte multimedia
	public function getMultimediaReport() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->getMultimediaReport($client);

		return $resultPOST;
	}

	// Generar reporte en excel
	public function generateExcelReport() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->generateExcelReport($client);

		return $resultPOST;
	}

	// Generar excel de wordcloud
	public function generateWordcloudExcel() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->generateWordcloudExcel($client);

		return $resultPOST;
	}

	// Generar datos de reporte
	public function generatePermanentReportData() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->generatePermanentReportData($client);

		return $resultPOST;
	}

	// Generar powerpoint completo
	public function generatePermanentPowerpointWithWordcloud() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->generatePermanentPowerpointWithWordcloud($client);

		return $resultPOST;
	}

	// Generar word completo
	public function generatePermanentWordWithWordcloud() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->generatePermanentWordWithWordcloud($client);

		return $resultPOST;
	}

	// Descargar reportes permanentes
	public function downloadPermanentReports() {
		$client = $this->postData;
		$resultPOST = $this->missionsReport->downloadPermanentReports($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//REPORTES
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Generar powerpoint dinámico
	public function generateDinamicReport() {
		$client = $this->postData;

		$analyticGraph = new GeneratePpt();

		$response = $analyticGraph->generateDinamicReport($client);

		return $response;
	}

	public function hextorgb($hex) {
		list($r, $g, $b) = sscanf($hex, '#%02x%02x%02x');
		return [$r, $g, $b];
	}

	// Generar reporte en word
	public function generateWord() {
		$client = $this->postData;

		$response = $this->requestAllGraphs();
		if(is_null($response['result']) || count($response['result'][0]['data']) == 0) {
			$response['result'] = [];
			$response['status'] = 'KO';
			return $response;
		}

		if($response['perf']) {
			$analyticGraph = new GenerateWord();
			$client = $this->postData;
			$colors = $client['colorsHex'];
			$user = $client['user'];
			$typeColors = $client['typeColors'];
			$timestamp = $client['timestamp'];
			$idTenant = $client['idTenant'];
			$response['word'] = $analyticGraph->printWordPerf($response, $colors, $user, $typeColors, $timestamp, $idTenant);
			$response['status'] = 'OK';
			return $response;
		} else if(isset($client['permanent']) && $client['permanent']) {
			$analyticGraph = new GenerateWord();
			$client = $this->postData;
			$colors = $client['colorsHex'];
			$user = $client['user'];
			$typeColors = $client['typeColors'];
			$timestamp = $client['timestamp'];
			$idTenant = $client['idTenant'];
			$response['word'] = $analyticGraph->printWordPermanent($response, $colors, $user, $typeColors, $idTenant, $client['survey'], $client['stampMision'], $client['project']);
			$response['status'] = 'OK';
			return $response;
		} else {
			$response['status'] = 'OK';
			return $response;
		}
	}

	// Crear reporte en word
	public function printWord() {
		$client = $this->postData;

		$data = $client['data'];
		$wc = $client['wordCloud'];
		$questions = $client['questions'][0];
		$colors = $client['colorsHex'];
		$user = $client['user'];
		$typeColors = $client['typeColors'];
		$generalCharts = $client['generalCharts'];
		$token = $client['token'];
		$timestamp = $client['timestamp'];
		$isWc = $client['isWc'];
		$isWord = $client['isWord'];
		$idTenant = $client['idTenant'];

		$analyticGraph = new GenerateWord();
		$response['word'] = $analyticGraph->printWord($data, $wc, $colors, $user, $questions, $typeColors, $generalCharts, $token, $timestamp, $isWc, $isWord, $idTenant);
		$response['status'] = 'OK';
		return $response;
	}

	// Borrar archivos word ¿y .ppt?
	public function deleteWord() {
		$client = $this->postData;
		$filename = $client['filename'];
		unlink('Downloads/' . $filename);
	}

	// Script execSocialTools
	public function execSocialTools() {
		try {
			$client = $this->postData;
			$url = CONSTANTS::SERVERAPI . $client['action'];
			$params = [
				'token' => $client['token'],
				'tool' => '1,2'
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			return $resultPOST;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Peticion de todas las gráficas para reporte en word y .ppt
	public function requestAllGraphs() {
		try {
			$client = $this->postData;

			// Ver método 'generatePermanentReportData' en MissionsReportController.php

			// Array de preguntas a excluir
			$questionIdOutArray = explode(',', $client['questionIdOut']);

			// Petición de todos los datos de la encuesta y creación de estructura de datos
			$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
			$params = [
				'token' => $client['token'],
				'survey' => $client['survey'],
				'numPreguntasPerfilacionEnAnalyticMostreo' => $client['param4'],
				'mision' => $client['idmision'],
				'project' => $client['project']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			// Registro de errores
			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			// ¿Es pregunta de respuesta multiple?
			$isTypeM = [];
			// Posibles respuestas
			$labels = [];
			// Respuestas de asesores
			$allQuestData = [];
			// Response WordCloud
			$response['wordCloud'] = [];
			// Response tipo de pregunta
			$response['typeQuestion'] = [];
			// ID de pregunta
			$response['questionID'] = [];
			// OCR de pregunta
			$response['ocr'] = [];
			// Todas las preguntas
			$allQuestions = [];
			// Control tipo de preguntas
			$controlPreguntas = ['6', 'A', 'B', 'C', 'E', 'F', 'H', 'K'];
			// Control códigos de respuesta - (TODO: Ampliar / Cambiar por expresión regular)
			$codigos = ['A1', 'A2', 'A3', 'A4', 'A5', 'A6', 'A7', 'A8', 'A9', 'A10', 'A15', 'A16', 'A17', 'A18', 'A19', 'A20'];
			// Control título preguntas tipo 'R'
			$titleTypeR = '';

			// Preguntas
			foreach($resultPOST->questions as $question) {
				if(in_array($question->id, $questionIdOutArray)) {
					continue;
				}

				if($question->type == 'C' && $question->parent_type == 'Y') {
					continue;
				}

				// --- Generación de datos para Wordclouds ---
				// Para poder generar un wordcloud se tiene que hacer una llamada previamente al servicio
				// 'getAnalyticsMuestra' para que genere los datos relacionados con el wordcloud
				if($question->type == 'S' || ($question->type == 'T' && $question->type_parent == '') || $question->type == 'U') {
					$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestra';
					$params = [
						'token' => $client['token'],
						'survey' => $client['survey'],
						'pregunta' => $question->qid,
						'numPreguntasPerfilacionEnAnalyticMostreo' => $client['param4']
					];
					// Este result no se utiliza para nada más
					$phantomResult = $this->sendCurlPOST($url, $params);

					// Registro de errores
					if($phantomResult->status != 'OK') {
						return $phantomResult;
					}
				}

				// Anotación: Control Preguntas tipo 'R' - Pendiente para Revisar/Construcción de datos
				if($question->type == 'R') {
					$idRControlOut = $question->sid . 'X' . $question->gid . 'X' . $question->qid;
					$idR = $question->sid . 'X' . $question->gid . 'X' . $question->qid . '1';
					if(in_array($idRControlOut, $questionIdOutArray)) {
						continue;
					}

					if($titleTypeR != $question->title) {
						$titleTypeR = $question->title;
						array_push($allQuestions, $question->question);
						$labels[$idR] = [$question->answer];
					} else {
						array_push($labels[$idR], $question->answer);
						continue;
					}
				}

				// Control preguntas con SQ
				if(strpos(strval($question->id), 'SQ') == true && !in_array($question->type, $controlPreguntas) && $question->type !== 'C') {
					$preguntaAEliminar = explode('SQ', $question->id);
					if(in_array($preguntaAEliminar[0], $questionIdOutArray)) {
						continue;
					} else {
						array_push($labels[$preguntaAEliminar[0]], trim($question->question));
					}
				}

				// Control preguntas tipo '6', 'A', 'B', 'C', 'E', 'F', 'H', 'K'
				if(strpos(strval($question->id), 'SQ') == true && in_array($question->type, $controlPreguntas)) {
					if(in_array($question->id, $questionIdOutArray)) {
						continue;
					} else {
						array_push($labels[$question->id], trim($question->question));
					}
				}

				// Control de preguntas de respuesta múltiple
				if(strpos(strval($question->id), 'SQ') == false || in_array($question->type, $controlPreguntas)) {
					if($question->type != 'R') {
						array_push($allQuestions, $question->question);
						$labels[$question->id] = [];
					}

					if($question->type == 'M') {
						array_push($isTypeM, 'si');
					} else {
						array_push($isTypeM, 'no');
					}

					array_push($response['typeQuestion'], $question->type);
					array_push($response['questionID'], $question->id);
					array_push($response['ocr'], $question->qidTieneCaptureOCR);

					// Wordclouds y labels
					switch($question->type) {
						case 'C':
							$sQuestionId = $question->id;
							$labels[$sQuestionId] = ['YES', 'NO', 'UNCERTAIN'];
							array_push($response['wordCloud'], 'no');
							break;
						case 'Y':
							$sQuestionId = $question->id;
							$labels[$sQuestionId] = ['YES', 'NO'];
							array_push($response['wordCloud'], 'no');
							break;
						case 'N':
							$sQuestionId = $question->id;
							if(count($labels[$sQuestionId]) == 0) {
								foreach($resultPOST->result[0] as $userNLabels) {
									if($userNLabels->$sQuestionId != null && $userNLabels->$sQuestionId != '' && (int)$userNLabels->$sQuestionId != 0) {
										array_push($labels[$sQuestionId], (int)$userNLabels->$sQuestionId);
									}
								}
								$labels[$sQuestionId] = array_unique($labels[$sQuestionId]);
							}
							array_push($response['wordCloud'], 'no');
							break;
						case 'T':
						case 'U':
						case 'Q':
						case 'S':
							array_push($response['wordCloud'], 'yes');
							break;
						case '|':
						case '7':
						case 'J':
							array_push($response['wordCloud'], 'image');
							break;
						case 'R':
							array_push($response['wordCloud'], 'no');
							break;
						default:
							array_push($response['wordCloud'], 'no');
							break;
					}
				}

				$allAnswersByQuestion = [];
				$sQuestionId = $question->id;

				if(strpos(strval($sQuestionId), 'SQ') != true || in_array($question->type, $controlPreguntas)) {
					$allQuestData[$sQuestionId] = [];
				}

				// Por cada pregunta, se recogen las respuestas de cada usuario del 'result'
				foreach($resultPOST->result[0] as $userAnswer) {
					// Control respuestas por código
					if(in_array($userAnswer->$sQuestionId, $codigos)) {
						if($question->type != 'R') {
							if($userAnswer->$sQuestionId != null) {
								// Para las respuestas que tengan código
								foreach($resultPOST->answers as $respuesta) {
									if($respuesta->id == $sQuestionId && $userAnswer->$sQuestionId == $respuesta->answer_code) {
										$oAnswer = $respuesta->answer;
										$oAnswerother = $respuesta->answer;
										$oTipoPregunta = $respuesta->type;
										if(is_float($oAnswer) == true) {
											$oAnswer = (int)$oAnswer;
											$oAnswerother = (int)$respuesta->answer;
										}
										$oMuestra['answer'] = trim($oAnswer);
										$oMuestra['answerothers'] = trim($oAnswerother);
										$oMuestra['tipoPregunta'] = $oTipoPregunta;
										break;
									}
								}
							}
						} else {
							// Control respuestas por código de preguntas tipo 'R'
							if($userAnswer->$sQuestionId != null) {
								foreach($resultPOST->questions as $questionData) {
									if($questionData->answer_code == $userAnswer->$sQuestionId && $questionData->title == $titleTypeR) {
										$oMuestra['answer'] = trim($questionData->answer);
										$oMuestra['answerothers'] = trim($questionData->answer);
										$oMuestra['tipoPregunta'] = $questionData->type_parent;
										break;
									}
								}
							}
						}
					} else {
						// Control preguntas SQ que no sean del tipo '6', 'A', 'B', 'C', 'E', 'F', 'H', 'K'
						if(strpos(strval($question->id), 'SQ') == true && !in_array($question->type, $controlPreguntas)) {
							if($userAnswer->$sQuestionId != null) {
								foreach($resultPOST->questions as $questionData) {
									if($questionData->id == $sQuestionId) {
										$oMuestra['answer'] = trim($questionData->question);
										$oMuestra['answerothers'] = trim($questionData->question);
										if(is_float($oMuestra['answer']) == true) {
											$oMuestra['answer'] = (int)$oMuestra['answer'];
											$oMuestra['answerothers'] = (int)$oMuestra['answerothers'];
										}
										$oMuestra['tipoPregunta'] = $questionData->type_parent;
										break;
									}
								}
							}
						} else if(strpos(strval($question->id), 'SQ') == true && in_array($question->type, $controlPreguntas) && $question->type !== 'C') {
							// Control preguntas SQ tipo '6', 'A', 'B', 'C', 'E', 'F', 'H', 'K'
							if($userAnswer->$sQuestionId != null) {
								foreach($resultPOST->answers as $respuesta) {
									if($respuesta->id == $sQuestionId && $userAnswer->$sQuestionId == $respuesta->answer_code) {
										$oAnswer = $respuesta->answer;
										$oAnswerother = $respuesta->answer;
										$oTipoPregunta = $respuesta->type;
										if($oTipoPregunta == null) {
											$oTipoPregunta = '';
										}
										if(is_float($oAnswer) == true) {
											$oAnswer = (int)$oAnswer;
											$oAnswerother = (int)$respuesta->answer;
										}
										$oMuestra['answer'] = trim($oAnswer);
										$oMuestra['answerothers'] = trim($oAnswerother);
										$oMuestra['tipoPregunta'] = $oTipoPregunta;
										break;
									}
								}
							}
						} else {
							if($userAnswer->$sQuestionId != null) {
								$oAnswer = $userAnswer->$sQuestionId;
								$oAnswerother = $userAnswer->$sQuestionId;
								$oTipoPregunta = $question->type;
								if($oTipoPregunta == null) {
									$oTipoPregunta = '';
								}
								if(is_float($oAnswer) == true) {
									$oAnswer = (int)$oAnswer;
									$oAnswerother = (int)$oAnswerother;
								}
								$oMuestra['answer'] = trim($oAnswer);
								$oMuestra['answerothers'] = trim($oAnswerother);
								$oMuestra['tipoPregunta'] = $oTipoPregunta;
							}
						}
					}

					if($userAnswer->$sQuestionId != null) {
						$oMuestra['userEmail'] = $userAnswer->token;
						$oMuestra['user'] = $userAnswer->token;
						$oMuestra['perf001'] = $userAnswer->perf001;
						$oMuestra['perf002'] = $userAnswer->perf002;
						if($userAnswer->perf002Range != null && $userAnswer->perf002Range != '') {
							$oMuestra['perf002Range'] = $userAnswer->perf002Range;
						} else {
							$oMuestra['perf002Range'] = 0;
						}
						$oMuestra['perf003'] = $userAnswer->perf003;
						$oMuestra['perf004'] = $userAnswer->perf004;
						$oMuestra['perf004'] = $userAnswer->perf004Range;
						$oMuestra['question'] = $sQuestionId;
						$oMuestra['survey'] = $client['survey'];
						$oMuestra['surveyDesc'] = $client['namePoll'];
						array_push($allAnswersByQuestion, (object)$oMuestra);
					}
				}

				// En el caso de preguntas SQ que no sean del tipo '6', 'A', 'B', 'C', 'E', 'F', 'H' o 'K', se agrupan todos los datos en la pregunta padre
				if(strpos(strval($sQuestionId), 'SQ') == true && !in_array($question->type, $controlPreguntas)) {
					$preguntaSinSQ = explode('SQ', $sQuestionId);
					foreach($allAnswersByQuestion as $val) {
						array_push($allQuestData[$preguntaSinSQ[0]], $val);
					}
				} else {
					foreach($allAnswersByQuestion as $val) {
						array_push($allQuestData[$sQuestionId], $val);
					}
				}
			}

			// Añadido para Gráfica de NSE
			$numPerf = $client['param4'];

			if($client['isPerf'] == 1) {
				$response['perf'] = true;
			} else {
				$response['perf'] = false;
			}

			$allGender['labels'] = [];
			$allGender['values'] = [];
			$allAge['labels'] = [];
			$allAge['values'] = [];
			$allAgeRange['labels'] = [];
			$allAgeRange['values'] = [];
			$allStates['labels'] = [];
			$allStates['values'] = [];
			$allNSE['labels'] = [];
			$allNSE['values'] = [];

			foreach($resultPOST->answers as $answer) {
				if(in_array($answer->id, $questionIdOutArray)) {
					continue;
				}

				// Para saltar las respuestas que tengan código = '0'
				if($answer->answer_code == '0') {
					continue;
				}

				array_push($labels[$answer->id], trim($answer->answer));
			}

			$response['result'] = [];
			$response['questions'] = [];
			$iTypeM = 0;
			foreach($allQuestData as $key => $value) {
				$analyticGraph = new AnalyticGraph();
				if($isTypeM[$iTypeM] == 'si') {
					$typeM = true;
				} else {
					$typeM = false;
				}

				if($response['perf']) {
					$result = $analyticGraph->dataFormatOptionsPerf($value, $labels[$key], $typeM);
				} else {
					$type = '';
					$result = $analyticGraph->dataFormatOptions($value, $labels[$key], $typeM, $type, $numPerf);
					// Preparar array global
				}

				array_push($response['result'], $result);
				$iTypeM++;
			}
			array_push($response['questions'], $allQuestions);

			if(!$response['perf']) {
				// Sacar porcentajes generales
				$resume = [
					'gender' => [],
					'age' => [],
					'ageRange' => [],
					'states' => [],
					'nse' => []
				];

				$totalDiv = 0;

				foreach($response['result'] as $totalChart) {
					// Comprobar si alguien ha contestado
					if(count($totalChart['data']) > 0) {
						$totalDiv++;
					}

					// Edad
					$dataResume = $totalChart['age']['datasets']['data'];
					$labelsResume = $totalChart['age']['labels'];
					$n = count($labelsResume);
					for($j = 0; $j < $n; $j++) {
						$key = array_key_exists($labelsResume[$j], $resume['age']);
						if(!$key) {
							$resume['age'][$labelsResume[$j]] = $dataResume[$j];
						} else {
							$resume['age'][$labelsResume[$j]] += $dataResume[$j];
						}
					}

					// Rango de Edad
					$dataResume = $totalChart['ageRange']['datasets']['data'];
					$labelsResume = $totalChart['ageRange']['labels'];

					$n = count($labelsResume);
					for($j = 0; $j < $n; $j++) {
						$key = array_key_exists($labelsResume[$j], $resume['ageRange']);
						if(!$key) {
							$resume['ageRange'][$labelsResume[$j]] = $dataResume[$j];
						} else {
							$resume['ageRange'][$labelsResume[$j]] += $dataResume[$j];
						}
					}

					// Estado
					$dataResume = $totalChart['states']['datasets']['data'];
					$labelsResume = $totalChart['states']['labels'];
					$n = count($labelsResume);
					for($j = 0; $j < $n; $j++) {
						$key = array_key_exists($labelsResume[$j], $resume['states']);
						if(!$key) {
							$resume['states'][$labelsResume[$j]] = $dataResume[$j];
						} else {
							$resume['states'][$labelsResume[$j]] += $dataResume[$j];
						}
					}

					// Genero
					$dataResume = $totalChart['gender']['datasets']['data'];
					$labelsResume = $totalChart['gender']['labels'];
					$n = count($labelsResume);
					for($j = 0; $j < $n; $j++) {
						$key = array_key_exists($labelsResume[$j], $resume['gender']);
						if(!$key) {
							$resume['gender'][$labelsResume[$j]] = $dataResume[$j];
						} else {
							$resume['gender'][$labelsResume[$j]] += $dataResume[$j];
						}
					}

					// NSE
					$dataResume = $totalChart['nse']['datasets']['data'];
					$labelsResume = $totalChart['nse']['labels'];
					$n = count($labelsResume);
					for($j = 0; $j < $n; $j++) {
						$key = array_key_exists($labelsResume[$j], $resume['nse']);
						if(!$key) {
							$resume['nse'][$labelsResume[$j]] = $dataResume[$j];
						} else {
							$resume['nse'][$labelsResume[$j]] += $dataResume[$j];
						}
					}
				}

				if($totalDiv > 0) {
					foreach($resume['age'] as $key => $value) {
						$resume['age'][$key] = round(($resume['age'][$key] / $totalDiv), 1);
					}

					foreach($resume['ageRange'] as $key => $value) {
						$resume['ageRange'][$key] = round(($resume['ageRange'][$key] / $totalDiv), 1);
					}

					foreach($resume['gender'] as $key => $value) {
						$resume['gender'][$key] = round(($resume['gender'][$key] / $totalDiv), 1);
					}

					foreach($resume['states'] as $key => $value) {
						$resume['states'][$key] = round(($resume['states'][$key] / $totalDiv), 1);
					}

					foreach($resume['nse'] as $key => $value) {
						$resume['nse'][$key] = round(($resume['nse'][$key] / $totalDiv), 1);
					}

					$total = [
						'gender' => [
							'labels' => [],
							'value' => []
						],
						'age' => [
							'labels' => [],
							'value' => []
						],
						'ageRange' => [
							'labels' => [],
							'value' => []
						],
						'states' => [
							'labels' => [],
							'value' => []
						],
						'nse' => [
							'labels' => [],
							'value' => []
						]
					];

					foreach($resume['age'] as $key => $value) {
						array_push($total['age']['labels'], $key);
						array_push($total['age']['value'], $value);
					}
					foreach($resume['ageRange'] as $key => $value) {
						array_push($total['ageRange']['labels'], $key);
						array_push($total['ageRange']['value'], $value);
					}
					foreach($resume['gender'] as $key => $value) {
						array_push($total['gender']['labels'], $key);
						array_push($total['gender']['value'], $value);
					}
					foreach($resume['states'] as $key => $value) {
						array_push($total['states']['labels'], $key);
						array_push($total['states']['value'], $value);
					}
					foreach($resume['nse'] as $key => $value) {
						array_push($total['nse']['labels'], $key);
						array_push($total['nse']['value'], $value);
					}
					$response['resume'] = $total;
				}
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Crear reporte en .ppt
	public function printPpt() {
		try {
			$client = $this->postData;

			$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			$fontFamily = $resultPOST->result[0]->FontAnalytics;

			$images = $client['graphs'];
			$data = $client['data'];
			$questions = $client['questionsPpt'];
			$wc = $client['wcPpt'];
			$generalCharts = $client['generalCharts'];
			$user = $client['user'];
			$token = $client['token'];
			$timestamp = $client['timestamp'];
			$isWc = $client['isWc'];
			$analyticGraph = new GeneratePpt();
			$response['status'] = 'OK';
			$idTenant = $client['idTenant'];
			$genderData = $client['genderData'];
			$response['ppt'] = $analyticGraph->printPowerPointImages($images, $data, $questions, $wc, $user, $generalCharts, $token, $timestamp, $isWc, $fontFamily, $idTenant, $genderData);

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Crear reporte en .ppt perfilación
	public function printPptPerf() {
		$client = $this->postData;
		$images = $client['images'];
		$data = $client['data'];
		$questions = $client['questionsPpt'];
		$user = $client['user'];
		$timestamp = $client['timestamp'];
		$analyticGraph = new GeneratePpt();
		$response['status'] = 'OK';
		$idTenant = $client['idTenant'];
		$response['ppt'] = $analyticGraph->printPowerPointImagesPerf($images, $data, $questions, $user, $timestamp, $idTenant);

		return $response;
	}

	// Borrar archivos .ppt
	public function deletePpt() {
		$client = $this->postData;
		$filename = $client['filename'];
		unlink('Downloads/' . $filename);
	}

	// Generar reporte en excel
	public function generateExcel() {
		try {
			$client = $this->postData;

			$token = $client['token'];
			$survey = $client['survey'];
			$nperf = $client['numPreguntasPerfilacionEnAnalyticMostreo'];
			$user = $client['user'];
			$name = $client['name'];
			$timestamp = $client['timestamp'];
			// Obtenemos data
			$controller = new Controller;

			$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
			$params = [
				'token' => $token,
				'survey' => $survey,
				'numPreguntasPerfilacionEnAnalyticMostreo' => $nperf,
				'mision' => $client['idmision'],
				'project' => $client['project']
			];

			$resultPOST = $controller->sendCurlPOST($url, $params);

			$response = [
				'status' => 'OK',
				'response' => ''
			];

			if($resultPOST->status == 'OK') {
				$permanent = false;

				$excel = new GenerateExcel();
			} else {
				$response['status'] = 'KO';
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Generar reporte en excel comparativo
	public function generateExcelComparativo() {
		try {
			$client = $this->postData;

			$surveys = explode(',', $client['survey']);
			$missions = explode(',', $client['idMissionsArray']);
			$projects = explode(',', $client['idProjectsArray']);

			$questions = [];
			$answers = [];
			$result = [];

			$count = 0;
			foreach($surveys as $survey) {
				$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
				$params = [
					'token' => $client['token'],
					'survey' => $survey,
					'numPreguntasPerfilacionEnAnalyticMostreo' => $client['numPreguntasPerfilacionEnAnalyticMostreo'],
					'mision' => $missions[$count],
					'project' => $projects[$count]
				];

				$resultPOST = $this->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				} else {
					array_push($questions, $resultPOST->questions);
					array_push($answers, $resultPOST->answers);
					array_push($result, $resultPOST->result);
				}

				$count++;
			}

			$data = [
				'answers' => $answers,
				'questions' => $questions,
				'result' => $result
			];

			// Preguntas
			$questionsSize = count($data['questions']);

			$arrayCountQuestions = [];
			foreach($data['questions'] as $questions) {
				array_push($arrayCountQuestions, count($questions));
			}

			$maxSizeQ = max($arrayCountQuestions);
			$arrayQuestions = [];
			for($i = 0; $i < $maxSizeQ; $i++) {
				for($x = 0; $x < $questionsSize; $x++) {
					if($i < $arrayCountQuestions[$x]) {
						array_push($arrayQuestions, $data['questions'][$x][$i]);
					}
				}
			}

			// Posibles respuestas
			$answersSize = count($data['answers']);

			$arrayCountAnswers = [];
			foreach($data['answers'] as $answers) {
				array_push($arrayCountAnswers, count($answers));
			}

			$maxSizeA = max($arrayCountAnswers);
			$arrayAnswers = [];
			for($i = 0; $i < $maxSizeA; $i++) {
				for($x = 0; $x < $answersSize; $x++) {
					if($arrayCountAnswers[$x] <= $maxSizeA) {
						array_push($arrayAnswers, $data['answers'][$x][$i]);
					}
				}
			}

			$arrayResults = [];
			foreach($data['result'] as $resultUsers) {
				foreach($resultUsers as $result) {
					foreach($result as $keyUser => $userAnswers) {
						if(array_key_exists($keyUser, $arrayResults)) {
							foreach($userAnswers as $key => $value) {
								$arrayResults[$keyUser]->$key = $value;
							}
						} else {
							$arrayResults[$keyUser] = $userAnswers;
						}
					}
				}
			}

			$resultPOST->questions = $arrayQuestions;
			$resultPOST->answers = $arrayAnswers;
			$resultPOST->result = $arrayResults;

			$user = $client['user'];
			$name = str_replace(',', '-', $client['name']);
			$timestamp = $client['timestamp'];
			$nperf = $client['numPreguntasPerfilacionEnAnalyticMostreo'];
			$excelDataOpt = $client['excelDataOpt'];
			$headersExcel = $client['headersExcel'];

			$response = [
				'status' => 'OK',
				'response' => ''
			];

			if($resultPOST->status == 'OK') {
				$excel = new GenerateExcel();
				$response['status'] = 'OK';
				$response['response'] = $excel->printExcelComparativo($resultPOST, $user, $name, $timestamp, $nperf, $excelDataOpt, $headersExcel, $questionsSize, $client['questionIdOut'], $client['consumo']);
			} else {
				$response['status'] = 'KO';
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Generar multimedia
	public function getImagesSurvey() {
		try {
			$client = $this->postData;

			$timestamp = $client['timestamp'];
			$idSurvey = $client['survey'];
			$user = $client['user'];

			$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
			$params = [
				'token' => $client['token'],
				'numPreguntasPerfilacionEnAnalyticMostreo' => 0,
				'survey' => $idSurvey,
				'mision' => $client['idmision'],
				'project' => $client['project']
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$surveys = [];
			$questOrder = [];
			foreach($resultPOST->questions as $questions) {
				if($questions->type == '|' || $questions->type == '7' || $questions->type == 'J') {
					array_push($surveys, $questions->id);
					$questOrder[$questions->id] = 'Q' . $questions->question_order;
				}
			}

			if(count($surveys) > 0) {
				$images = [];
				foreach($surveys as $survey) {
					$images[$survey] = [];
					foreach($resultPOST->result as $element) {
						foreach($element as $result) {
							if(isset($result->$survey)) {
								$image = json_decode($result->$survey);
								if(isset($image[0])) {
									$data = [
										'name' => $image[0]->filename,
										'ext' => $image[0]->ext,
										'user' => $result->token,
										'rechazada' => $result->rechazada
									];
									array_push($images[$survey], $data);
								}
							}
						}
					}
				}
			};

			// Carpeta donde guardar los elementos a comprimir dependiendo de la llamada
			$folderZip = CONSTANTS::PATH_EXPORT_WORD . '/' . $user . '/';

			if(!file_exists($folderZip)) { // Si no existe, se crea
				$createFile = $this->utilesController->createDirectory($folderZip);

				if($createFile['status'] == 'KO') {
					return 'The folder has not been created';
				}
			}

			// Objeto ZIP
			$zip = new ZipArchive();
			$zip->open($folderZip . $timestamp . '_Analitics_Mostreo.zip', ZipArchive::CREATE);

			$response = [];
			if(count($images) > 0) {
				foreach($images as $key => $value) {
					// Carpeta donde guardar los elementos a comprimir
					$folder = CONSTANTS::PATH_EXPORT_WORD . '/' . $user . '/' . $questOrder[$key];

					if(!file_exists($folder)) { // Si no existe, se crea
						$createFile = $this->utilesController->createDirectory($folder);

						if($createFile['status'] == 'KO') {
							return 'The folder has not been created';
						}
					}

					foreach($value as $image) {
						$serverUrl = $folder . '/' . $image['user'] . '.' . $image['ext'];

						// Ruta de imagen
						$url = CONSTANTS::SERVERSURVEYSINTERNAL . '/upload/surveys/' . $idSurvey . '/files/' . $image['name'];
						// Ruta de imagen local
						// $url = CONSTANTS::SERVERSURVEYS . 'upload/surveys/' . $idSurvey . '/files/' . $image['name'];

						// Copia en servidor
						$command = 'cp -rf ' . $url . ' ' . $serverUrl;
						$shell_result_output = shell_exec(escapeshellcmd($command));
						// Copia en local
						// copy($url, $serverUrl);

						// Destino
						if($image['rechazada'] == '1') {
							$destination = 'multimedia/' . $questOrder[$key] . '/rejected/' . $image['user'] . '.' . $image['ext'];
						} else {
							$destination = 'multimedia/' . $questOrder[$key] . '/' . $image['user'] . '.' . $image['ext'];
						}

						$zip->addFile($serverUrl, $destination);
					}
				}
				$response['status'] = 'OK';
				$response['result'] = 'Images generated';
			} else {
				$response['status'] = 'KO';
				$response['result'] = 'noimages';
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Borrar archivos multimedia
	public function deleteFilesUser() {
		$client = $this->postData;
		$user = $client['user'];

		function deleteDirectory($dir) {
			if(!$dh = @opendir($dir)) return;
			while(false !== ($current = readdir($dh))) {
				if($current != '.' && $current != '..') {
					if(!@unlink($dir . '/' . $current))
						deleteDirectory($dir . '/' . $current);
				}
			}
			closedir($dh);
			@rmdir($dir);
		}

		deleteDirectory(CONSTANTS::PATH_EXPORT_WORD . '/' . $user);

		$response['status'] = 'OK';
		$response['result'] = 'OK';

		return $response;
	}

	// Generar reporte comparativo en word
	public function requestComparativeWord() {
		$response = $this->requestComparativeAllGraphs();
		return $response;
	}

	// Generar gráficas de reporte comparativo
	public function requestComparativeAllGraphs() {
		try {
			$client = $this->postData;

			// Array de preguntas a excluir
			$questionIdOutArray = explode(',', $client['questionIdOut']);

			$survey = explode(',', $client['survey']);

			// Calcular el numero de preguntas por enquesta
			$total_surveys = (count($survey) - 1);
			$url = CONSTANTS::SERVERAPI . 'getQuestionsSurvey';

			$params = [
				'token' => $client['token'],
				'survey' => $survey[$total_surveys]
			];

			$resultPOST = $this->sendCurlPOST($url, $params);

			// Registro de errores
			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			// Control para preguntas múltiples de tipo 'H', 'K' y 'F'
			$sQuestions = [];
			$size = count($resultPOST->result);
			for($i = 0; $i < $size; $i++) {
				if(in_array($resultPOST->result[$i]->columnName, $questionIdOutArray)) {
					continue;
				}

				if($resultPOST->result[$i]->type === 'H' || $resultPOST->result[$i]->type === 'K' || $resultPOST->result[$i]->type === 'F') {
					// Posibles valores
					foreach($resultPOST->result[$i]->valuesSQ as $valuesSQ) {
						// Array 'columname' | Añadido a nombre
						$valuesSQArray = explode('|', $valuesSQ);
						$questionSQ = (object)[
							'columnName' => $valuesSQArray[0],
							'sid' => $resultPOST->result[$i]->sid,
							'gid' => $resultPOST->result[$i]->gid,
							'qid2' => $resultPOST->result[$i]->qid2,
							'group_order' => $resultPOST->result[$i]->group_order,
							'group_name' => $resultPOST->result[$i]->group_name,
							'description' => $resultPOST->result[$i]->description,
							'title' => $resultPOST->result[$i]->title,
							'question' => $resultPOST->result[$i]->question . ' - ' . $valuesSQArray[1],
							'question_order' => $resultPOST->result[$i]->question_order,
							'type' => $resultPOST->result[$i]->type
						];

						if(in_array($questionSQ->columnName, $questionIdOutArray)) {
							continue;
						}

						array_push($sQuestions, $questionSQ);
					}
				} else {
					array_push($sQuestions, $resultPOST->result[$i]);
				}
			}

			// array con todas las encuestas
			$allQuestData = [];
			$isTypeM = [];
			$labels = [];
			$question = [];
			$response['wordCloud'] = [];
			$surveys = '[';
			$surveys .= $client['survey'];
			$surveys .= ']';
			$i = 0;
			$response['result'] = [];
			$idPreg = [];

			foreach ($sQuestions as $graph) {
				// sacar todas las id de preguntas
				array_push($idPreg, $graph->columnName);
				array_push($question, $graph->question);

				$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraComparativa';
				$params = [
					'token' => $client['token'],
					'surveys' => $surveys,
					'pregunta' => $graph->title,
					'numPreguntasPerfilacionEnAnalyticMostreo' => $client['numPregPerf']
				];

				$resultPOST2 = $this->sendCurlPOST($url, $params);

				if($resultPOST2->status === 'OK') {
					if($i == 0) {
						$response['encuestas'] = [];
						foreach($resultPOST2->result as $value) {
							array_push($response['encuestas'], $value[0]->surveyDesc);
						}
					}

					$allQuestData[$graph->columnName] = $resultPOST2->result;
					$url = CONSTANTS::SERVERAPI . 'getAllPosibleAnswersByQID';
					$qidArray = explode('X', $graph->columnName);
					$qid = array_pop($qidArray);

					$params = [
						'token' => $client['token'],
						'qid' => $qid,
						'survey' => $survey[$total_surveys],
						'title' => $graph->title,
						'Pregunta' => $graph->columnName
					];

					$resultPOST3 = $this->sendCurlPOST($url, $params);

					$labels[$graph->columnName] = [];
					$isTypeM = [];
					if($resultPOST3->status === 'OK') {
						if($resultPOST3->type == 'M') {
							array_push($isTypeM, 'si');
						} else {
							array_push($isTypeM, 'no');
						}

						switch($resultPOST3->type) {
							case '!':
							case 'F':
							case 'G':
							case 'K':
							case 'L':
							case 'N':
							case 'Y':
								foreach($resultPOST3->result as $value) {
									array_push($labels[$graph->columnName], $value->answer);
								}
								array_push($response['wordCloud'], 'no');
							break;

							case 'M':
								foreach($resultPOST3->result as $value) {
									array_push($labels[$graph->columnName], $value->question);
								}
								array_push($response['wordCloud'], 'no');
							break;

							case 'Q':
							case 'S':
							case 'T':
								$labels[$graph->columnName] = [];
								array_push($response['wordCloud'], 'yes');
							break;

							case '|':
							case '7':
							case 'J':
								$labels[$graph->columnName] = [];
								array_push($response['wordCloud'], 'image');
							break;

							case '5':
								$array = $resultPOST3->result;
								array_multisort($array);
								foreach($array as $value) {
									array_push($labels[$graph->columnName], $value->answer);
								}
								array_push($response['wordCloud'], 'no');
							break;

							default:
								foreach($resultPOST3->result as $value) {
									array_push($labels[$graph->columnName], $value->answer);
								}
								array_push($response['wordCloud'], 'no');
							break;
						}
					} else {
						$response['status'] = 'KO';
						return $response;
					}
					$response['result'][$i] = [];

					$response['questions'] = [];
					$iTypeM = 0;
					foreach($resultPOST2->result as $value) {
						$key = $idPreg[$i];
						$data = $value;
						if(count($data) == 0) {
							array_push($response['result'][$i], null);
						} else {
							if($isTypeM[$iTypeM] == 'si') {
								$typeM = true;
							} else {
								$typeM = false;
							}
							$analyticGraph = new AnalyticGraph();
							$analiticResult = $analyticGraph->dataFormatOptionsPpt($data, $labels[$key], $typeM);
							array_push($response['result'][$i], $analiticResult);
						}
						$iTypeM++;
					}
					array_push($response['questions'], $question);

					$i++;
				} else {
					$response['status'] = 'KO';
					return $response;
				}
			}

			// Sacar porcentajes generales
			// Crear array general
			$resume = [];
			$n = $total_surveys + 1;
			for($v = 0; $v < $n; $v++) {
				$estructure = [
					'gender' => [],
					'age' => [],
					'states' => []
				];
				array_push($resume, $estructure);
			}
			// Iteramos para cada pregunta
			foreach($response['result'] as $totalChart) {
				// Separamos por el total de encuestas
				for($v = 0; $v < $n; $v++) {
					if(!is_null($totalChart[$v])) {
						// Edad
						$dataResume = $totalChart[$v]['age']['datasets']['data'];
						$labelsResume = $totalChart[$v]['age']['labels'];
						$nl = count($labelsResume);
						for($j = 0; $j < $nl; $j++) {
							$key = array_key_exists($labelsResume[$j], $resume[$v]['age']);
							if(!$key) {
								$resume[$v]['age'][$labelsResume[$j]] = $dataResume[$j];
							} else {
								$resume[$v]['age'][$labelsResume[$j]] += $dataResume[$j];
							}
						}

						// Estado
						$dataResume = $totalChart[$v]['states']['datasets']['data'];
						$labelsResume = $totalChart[$v]['states']['labels'];
						$nl = count($labelsResume);
						for($j = 0; $j < $nl; $j++) {
							$key = array_key_exists($labelsResume[$j], $resume[$v]['states']);
							if(!$key) {
								$resume[$v]['states'][$labelsResume[$j]] = $dataResume[$j];
							} else {
								$resume[$v]['states'][$labelsResume[$j]] += $dataResume[$j];
							}
						}

						// Genero
						$dataResume = $totalChart[$v]['gender']['datasets']['data'];
						$labelsResume = $totalChart[$v]['gender']['labels'];
						$nl = count($labelsResume);
						for($j = 0; $j < $nl; $j++) {
							$key = array_key_exists($labelsResume[$j], $resume[$v]['gender']);
							if(!$key) {
								$resume[$v]['gender'][$labelsResume[$j]] = $dataResume[$j];
							} else {
								$resume[$v]['gender'][$labelsResume[$j]] += $dataResume[$j];
							}
						}
					}
				}
			}

			$nSurveys = $total_surveys + 1;
			$nQuestions = [];
			for($i = 0; $i < $nSurveys; $i++) {
				array_push($nQuestions, 0);
			}

			foreach($response['result'] as $row) {
				$i = 0;
				foreach($row as $counter) {
					if(!is_null($counter)) {
						$nQuestions[$i] += 1;
					}
					$i++;
				}
			}

			// Calculamos la media del porcentaje
			for($x = 0; $x < $n; $x++) {
				foreach($resume[$x]['age'] as $key => $value) {
					$resume[$x]['age'][$key] = round($resume[$x]['age'][$key] / $nQuestions[$x], 1);
				}

				foreach($resume[$x]['gender'] as $key => $value) {
					$resume[$x]['gender'][$key] = round($resume[$x]['gender'][$key] / $nQuestions[$x], 1);
				}

				foreach($resume[$x]['states'] as $key => $value) {
					$resume[$x]['states'][$key] = round($resume[$x]['states'][$key] / $nQuestions[$x], 1);
				}
			}

			$total = [
				'gender' => [],
				'age' => [],
				'states' => []
			];

			// Agrupar datos para separar por series
			$n = count($resume);
			for($i = 0; $i < $n; $i++) {
				foreach($resume[$i]['gender'] as $key => $value) {
					$exist = array_key_exists($key, $total['gender']);
					if($exist) {
						array_push($total['gender'][$key], $value);
					} else {
						$zeros = [];
						for($x = 0; $x < $i; $x++) {
							array_push($zeros, 0);
						}
						array_push($zeros, $value);
						$total['gender'][$key] = $zeros;
					}
				}
				foreach($resume[$i]['age'] as $key => $value) {
					$exist = array_key_exists($key, $total['age']);
					if($exist) {
						array_push($total['age'][$key], $value);
					} else {
						$zeros = [];
						for($x = 0; $x < $i; $x++) {
							array_push($zeros, 0);
						}
						array_push($zeros, $value);
						$total['age'][$key] = $zeros;
					}
				}
				foreach($resume[$i]['states'] as $key => $value) {
					$exist = array_key_exists($key, $total['states']);
					if($exist) {
						array_push($total['states'][$key], $value);
					} else {
						$zeros = [];
						for($x = 0; $x < $i; $x++) {
							array_push($zeros, 0);
						}
						array_push($zeros, $value);
						$total['states'][$key] = $zeros;
					}
				}
			}

			ksort($total['age']);
			ksort($total['states']);

			$resume = [
				'gender' => [
					'labels' => [],
					'values' => []
				],
				'age' => [
					'labels' => [],
					'values' => []
				],
				'states' => [
					'labels' => [],
					'values' => []
				]
			];

			foreach($total['age'] as $key => $value) {
				array_push($resume['age']['labels'], $key);
				array_push($resume['age']['values'], $value);
			}
			foreach($total['gender'] as $key => $value) {
				array_push($resume['gender']['labels'], $key);
				array_push($resume['gender']['values'], $value);
			}
			foreach($total['states'] as $key => $value) {
				array_push($resume['states']['labels'], $key);
				array_push($resume['states']['values'], $value);
			}

			$response['resume'] = $resume;
			$response['status'] = 'OK';
			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Crear reporte comparativo en word
	public function printComparativeWord() {
		$client = $this->postData;

		$data = $client['data'];
		$encuestas = $client['encuestas'];
		$questions = $client['questions'];
		$wc = $client['wordCloud'];
		$colors = $client['colorsHex'];
		$user = $client['user'];
		$generalCharts = $client['generalCharts'];
		$paramsWc = $client['paramsWc'];
		$token = $client['token'];
		$timestamp = $client['timestamp'];
		$isWc = $client['isWc'];
		$isWord = $client['isWord'];
		$idTenant = $client['idTenant'];

		$analyticGraph = new GenerateWord();
		$response['word'] = $analyticGraph->printWordComparative2($data, $encuestas, $questions, $wc, $colors, $user, $generalCharts, $paramsWc, $token, $timestamp, $isWord, $isWc, $idTenant);
		$response['status'] = 'OK';

		return $response;
	}

	// Crear reporte en .ppt muestreo comparativo
	public function printPptComparative() {
		$client = $this->postData;

		$images = $client['graphs'];
		$data = $client['data'];
		$questions = $client['questionsPpt'];
		$wc = $client['wcPpt'];
		$generalCharts = $client['generalCharts'];
		$user = $client['user'];
		$paramsWc = $client['paramsWc'];
		$encuestas = $client['encuestasPpt'];
		$token = $client['token'];
		$timestamp = $client['timestamp'];
		$isWc = $client['isWc'];
		$idTenant = $client['idTenant'];

		$analyticGraph = new GeneratePpt();
		$response['ppt'] = $analyticGraph->printPowerPointImagesComparative($images, $data, $questions, $wc, $user, $encuestas, $paramsWc, $generalCharts, $token, $timestamp, $isWc, $idTenant);
		$response['status'] = 'OK';

		return $response;
	}

	// Eliminar excel
	public function deleteFileExcel() {
		$client = $this->postData;
		$filename = $client['filename'];

		unlink(CONSTANTS::PATH_EXPORT_WORD . '/' . $filename);

		return true;
	}

	public function generateWordComparativo() {
		try {
			$client = $this->postData;
			$survey = explode(',', $client['survey']);
			$total_surveys = (count($survey) - 1);
			$url = CONSTANTS::SERVERAPI . 'getQuestionsSurvey';
			$params = [
				'token' => $client['token'],
				'survey' => $survey[0]
			];
			$resultPOST = $this->sendCurlPOST($url, $params);
			$result = $resultPOST->result;
			$title = [];
			$qid = [];
			$data = [];
			$labels = [];
			$questions = [];
			$wordCloud = [];
			$name = [];
			// Obtener qid y id de todas las preguntas
			$j = 0;
			foreach($result as $row) {
				array_push($questions, $row->question);
				array_push($title, $row->title);
				$explode = array_pop(explode('X', $row->columnName));
				array_push($qid, $explode);

				if($j == 0) {
					break;
				}
				$j++;
			}

			$i = 0;

			foreach($title as $compSurvey) {
				set_time_limit(0);

				$surveys = '[';
				$surveys .= $client['survey'];
				$surveys .= ']';
				$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraComparativa';
				$params = [
					'token' => $client['token'],
					'surveys' => $surveys,
					'pregunta' => $compSurvey,
					'numPreguntasPerfilacionEnAnalyticMostreo' => 3
				];

				$result = $this->sendCurlPOST($url, $params);

				// Registro de errores
				if($result->status != 'OK') {
					return $result;
				}

				$result = $result->result;

				foreach($result as $key => $row) {
					array_push($name, $row[0]->surveyDesc);

					array_push($data, $row);
				}

				$url = CONSTANTS::SERVERAPI . 'getAllPosibleAnswersByQID';
				$params = [
					'token' => $client['token'],
					'qid' => $qid[$i]
				];

				$result = $this->sendCurlPOST($url, $params);

				// Registro de errores
				if($result->status != 'OK') {
					return $result;
				}

				foreach($result->result as $answer) {
					array_push($labels, $answer->answer);
				}

				if(empty($labels)) {
					$result = true;
					array_push($wordCloud, $result);
				} else {
					$result = false;
					array_push($wordCloud, $result);
				}

				$i++;
			}

			$name_surveys = [];
			for($i = 0; $i <= $total_surveys; $i++) {
				array_push($name_surveys, $name[$i]);
			}

			$idTenant = $client['idTenant'];

			$report = new GenerateWord();
			$response['word'] = $report->printWordComparative($name_surveys, $questions, $data, $labels, $client['colorsHex'], $wordCloud, $idTenant);
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	public function getDataReports() {
		$client = $this->postData;

		$token = $client['token'];
		$survey = $client['survey'];
		$perf = $client['perf'];

		$report = new Reports();
		$response = $report->getData($token, $survey, $perf);

		return $response;
	}

	public function printReports() {
		try {
			$client = $this->postData;

			$token = $client['token'];
			$survey = $client['survey'];
			$perf = $client['perf'];
			$data = $client['data'];
			$colors = $client['colors'];
			$task = $client['task'];
			$user = $client['user'];
			$name = $client['name'];
			$fontName = $client['fntName'];

			$response = [
				'filename' => '',
				'word' => true,
				'ppt' => true,
				'excel' => true,
				'wc' => true,
				'images' => true
			];

			// Crear nombre zip
			$fecha = date_create();
			$timestamp = date_timestamp_get($fecha);
			$zipName = $timestamp . '_Analitics_Mostreo.zip';

			$response['filename'] = $zipName;

			if($task['word']) {
				$wordReport = new ReportsWord();
				$response['word'] = $wordReport->generateReport($data, $colors, $name, $user, $zipName);
			}

			if($task['ppt']) {
				$pptReport = new ReportsPpt();
				$response['ppt'] = $pptReport->generateReport($data, $user, $survey, $token, $name, $zipName, $fontName);
			}

			if($task['excel']) {
				$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
				$params = [
					'token' => $token,
					'survey' => $survey,
					'numPreguntasPerfilacionEnAnalyticMostreo' => $perf,
					'mision' => $client['idmision'],
					'project' => $client['project']
				];

				$resultPOST = $this->sendCurlPOST($url, $params);

				// Registro de errores
				if($resultPOST->status == 'KO') {
					if(isset($resultPOST->result)) {
						$result = $resultPOST->result;
					} else {
						$result = 'ERROR';
					}
					$this->utilesController->setCMBPLOG($token, 'SERVICE', 'getAnalyticsMuestraToExport', $result, '', '1');
				}

				$excel = new ReportsExcel();
				$response['excel'] = $excel->printExcel($resultPOST, $user, $name, $zipName);
			}

			if($task['wc']) {
				$dataWC = [];
				$i = 0;
				foreach($data['questions'] as $key => $value) {
					if($value['wc']) {
						$sanit = htmlspecialchars($value['question']);
						$sanit = trim($sanit);
						$sanit = preg_replace("/[\r\n|\n|\r]+/", ' ', $sanit);
						$params = [
							'title' => $i . '-' . $sanit,
							'pregunta' => $key,
							'survey' => strval($survey)
						];
						array_push($dataWC, $params);
					}

					$i++;
				}
				$excel = new ReportsExcel();
				$response['wc'] = $excel->counterWords($dataWC, $user, $token, $zipName);
			}

			if($task['images']) {
				$imageReport = new ReportsImages();
				$response['images'] = $imageReport->getImages($token, $survey, $user, $zipName);
			}

			return $response;
		} catch(\Throwable $e) {
			return $this->returnException($e, __FUNCTION__);
		}
	}

	// Devuelve los paises con sus estados + participación por estado
	public function getCountryAndParticipation() {
		$client = $this->postData;

		$token = $client['token'];
		$idSurvey = $client['idSurvey'];
		$numPregPerf = $client['numPreguntasPerfilacionEnAnalyticMostreo'];

		$url = CONSTANTS::SERVERAPI . 'getAnalyticsMuestraToExport';
		$params = [
			'token' => $token,
			'survey' => $idSurvey,
			'numPreguntasPerfilacionEnAnalyticMostreo' => $numPregPerf,
			'mision' => $client['idmision'],
			'project' => $client['project']
		];

		$resultPOST = $this->sendCurlPOST($url, $params);

		$result = $resultPOST->result;
		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Por cada usuario se recogen sus datos de pais y estado
		$estados = [];
		foreach($result as $user) {
            if (is_array($user) && !empty($user)) {
                $user = $user[0];
            } else {
                $user = new \stdClass();
            }
			$country = property_exists($user, 'questionPais') ? $user->questionPais : "";
            $estado = property_exists($user, 'perf001') ? $user->perf001 : "";
			
            array_push($estados, [$country, $estado]);
		}

		$response3['countryAndParticipation'] = $estados;
		$response3['status'] = 'OK';

		return $response3;
	}

	public function getAllCustomers() {
		$client = $this->postData;
		$resultPOST = $this->clientsController->getAllCustomers($client);

		return $resultPOST;
	}

	public function getAllCustomerDetails() {
		$client = $this->postData;
		$resultPOST = $this->clientsController->getAllCustomerDetails($client);

		return $resultPOST;
	}

	public function setAllCustomerDetails() {
		$client = $this->postData;
		$resultPOST = $this->clientsController->setAllCustomerDetails($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CHATBOT
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	
	public function sendMessageToBotVoiceAssistant() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->sendMessageToBotVoiceAssistant($client);

		return $resultPOST;
	}

	public function sendBotMessage() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->sendBotMessage($client);

		return $resultPOST;
	}

	public function SendMessageAdminBot() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->SendMessageAdminBot($client);

		return $resultPOST;
	}

	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	//CHAT
	//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
	// Configuración de plataforma de chat
	public function getPlatformConfig_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->utilesController->basicOneParameterService($client);

		return $resultPOST;
	}

	public function getChatList_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getChatList_SaaS($client);

		return $resultPOST;
	}

	// Petición de todos los asesores
	public function getUsers_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getUsers_SaaS($client);

		return $resultPOST;
	}

	// Petición de los asesores por búsqueda
	public function getUsersSearch_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getUsersSearch_SaaS($client);

		return $resultPOST;
	}

	public function setUserConfigNotif_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->setUserConfigNotif_SaaS($client);

		return $resultPOST;
	}

	public function createDistributionList_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->createDistributionList_SaaS($client);

		return $resultPOST;
	}

	public function createGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->createGroup_SaaS($client);

		return $resultPOST;
	}

	public function getChatContent_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getChatContent_SaaS($client);

		return $resultPOST;
	}

	public function getChatGroupContent_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getChatGroupContent_SaaS($client);

		return $resultPOST;
	}

	// Datos de contacto
	public function getInfoContacto_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getInfoContacto_SaaS($client);

		return $resultPOST;
	}

	// Datos de grupo
	public function getInfoGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getInfoGroup_SaaS($client);

		return $resultPOST;
	}

	// Silenciar contacto
	public function muteChat_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->muteChat_SaaS($client);

		return $resultPOST;
	}

	// Bloquear contacto
	public function bloquearContacto_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->bloquearContacto_SaaS($client);

		return $resultPOST;
	}

	// Remuneraciones de contacto
	public function getDetallePagosByUserWithPoints_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getDetallePagosByUserWithPoints_SaaS($client);

		return $resultPOST;
	}

	// Salir de grupo
	public function takeOutFromGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->takeOutFromGroup_SaaS($client);

		return $resultPOST;
	}

	// Actualizar grupo
	public function updateInfoGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->updateInfoGroup_SaaS($client);

		return $resultPOST;
	}

	// Añadir contactos a grupo
	public function addToGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->addToGroup_SaaS($client);

		return $resultPOST;
	}

	// Limpiar conversación grupal 
	public function cleanChatGroupContent_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->cleanChatGroupContent_SaaS($client);

		return $resultPOST;
	}

	// Enviar mensaje a contacto
	public function postMessage_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->postMessage_SaaS($client);

		return $resultPOST;
	}

	// Enviar mensaje a grupo
	public function postMessageGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->postMessageGroup_SaaS($client);

		return $resultPOST;
	}

	// Registrar token Firebase
	public function setTokenDeviceForPush_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->setTokenDeviceForPush_SaaS($client);

		return $resultPOST;
	}

	// Cambiar avatar de perfil
	public function updateUserAvatar_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->updateUserAvatar_SaaS($client);

		return $resultPOST;
	}

	// Marcar como vistos los mensajes de contacto
	public function markAsReaded_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->markAsReaded_SaaS($client);

		return $resultPOST;
	}

	// Marcar como vistos los mensajes de grupo
	public function markAsReadedGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->markAsReadedGroup_SaaS($client);

		return $resultPOST;
	}

	// Silenciar chat grupal
	public function muteChatGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->muteChatGroup_SaaS($client);

		return $resultPOST;
	}

	// Recepción de mensajes pendientes de contacto
	public function getPendingMessages_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getPendingMessages_SaaS($client);

		return $resultPOST;
	}

	// Recepción de mensajes pendientes de grupo
	public function getPendingMessagesGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getPendingMessagesGroup_SaaS($client);

		return $resultPOST;
	}

	// Reenviar mensajes
	public function resendMessage_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->resendMessage_SaaS($client);

		return $resultPOST;
	}

	// Responder mensajes a contacto
	public function answerMessage_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->answerMessage_SaaS($client);

		return $resultPOST;
	}

	// Responder mensajes a grupo
	public function answerMessageGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->answerMessageGroup_SaaS($client);

		return $resultPOST;
	}

	// Eliminar un chat de la lista de contactos
	public function deleteChatFromList_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->deleteChatFromList_SaaS($client);

		return $resultPOST;
	}

	// Eliminar un chat grupal de la lista de contactos
	public function deleteChatGroupFromList_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->deleteChatGroupFromList_SaaS($client);

		return $resultPOST;
	}

	// Cambiar el administrador de un grupo
	public function changeAdminGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->changeAdminGroup_SaaS($client);

		return $resultPOST;
	}

	// Petición de mensajes anteriores para contacto
	public function loadPreviousMessages_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->loadPreviousMessages_SaaS($client);

		return $resultPOST;
	}

	// Petición de mensajes anteriores para grupo
	public function loadPreviousMessagesGroup_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->loadPreviousMessagesGroup_SaaS($client);

		return $resultPOST;
	}

	// Editar mensaje
	public function editMessage_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->editMessage_SaaS($client);

		return $resultPOST;
	}

		// Obtener los documentos enviados en una chat 1:1
		public function getChatMedia_SaaS() {
			$client = $this->postData;
			$resultPOST = $this->communityManagementController->getChatMedia_SaaS($client);
	
			return $resultPOST;
		}
	
		// Obtener los documentos enviados de un grupo
		public function getChatGroupMedia_SaaS() {
			$client = $this->postData;
			$resultPOST = $this->communityManagementController->getChatGroupMedia_SaaS($client);
	
			return $resultPOST;
		}

	// Listas de distribución por administrador
	public function getAllDistributionListByAdmin_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getAllDistributionListByAdmin_SaaS($client);

		return $resultPOST;
	}

	// Mensajes enviados por el administrador a una lista de distribución
	public function getChatDistibutionListContent_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getChatDistibutionListContent_SaaS($client);

		return $resultPOST;
	}

	// Enviar mensaje a lista de distribución
	public function postMessageList_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->postMessageList_SaaS($client);

		return $resultPOST;
	}

	// Información de la lista de distribución
	public function getDistibutionListInfo_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getDistibutionListInfo_SaaS($client);

		return $resultPOST;
	}

	public function initChatbotSession_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->initChatbotSession_SaaS($client);

		return $resultPOST;
	}

	public function updateChatbotSession_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->updateChatbotSession_SaaS($client);

		return $resultPOST;
	}

	public function getChatbotSession_SaaS() {
		$client = $this->postData;
		$resultPOST = $this->communityManagementController->getChatbotSession_SaaS($client);

		return $resultPOST;
	}

	// getIfQuestionsAreEquals
	public function getIfQuestionsAreEquals() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getIfQuestionsAreEquals($client);

		return $resultPOST;
	}

	// getAnalyticsDiferenciasSignificativas
	public function getAnalyticsDiferenciasSignificativas() {
		$client = $this->postData;
		$resultPOST = $this->analyticsController->getAnalyticsDiferenciasSignificativas($client);

		return $resultPOST;
	}
}