<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class CustomersController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Crear nuevo cliente
	public function setCliente($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'country' => $client['country'],
			'lenguage' => $client['lenguage'],
			'activo' => $client['activo'],
			'razonSocial' => $client['razonSocial'],
			'nombreComercial' => $client['nombreComercial'],
			'identFiscal' => $client['identFiscal'],
			'direccion' => $client['direccion'],
			'poblacion' => $client['poblacion'],
			'provincia' => $client['provincia'],
			'cp' => $client['cp'],
			'telefono' => $client['telefono'],
			'web' => $client['web'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar cliente
	public function deleteCliente($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['customers'] != '[]') {
			foreach($client['customers'] as $customer) {
				$params = [
					'token' => $client['token'],
					'idCustomer' => $customer['idCustomer']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Petición de cliente por id
	public function getClienteById($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idCustomer' => $client['idCustomer']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar cliente
	public function updateCliente($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idCustomer' => $client['idCustomer'],
			'country' => $client['country'],
			'lenguage' => $client['lenguage'],
			'activo' => $client['activo'],
			'razonSocial' => $client['razonSocial'],
			'nombreComercial' => $client['nombreComercial'],
			'identFiscal' => $client['identFiscal'],
			'direccion' => $client['direccion'],
			'poblacion' => $client['poblacion'],
			'provincia' => $client['provincia'],
			'cp' => $client['cp'],
			'telefono' => $client['telefono'],
			'web' => $client['web'],
			'email' => $client['email']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}