<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class HTMLController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Crear extensión funcional
	public function setCustomMenuOption($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$roles = '';
		$i = 1;
		$n = count($client['roles']);
		foreach($client['roles'] as $role) {
			$roles .= $role;
			if($i < $n) {
				$roles .= ',';
			}
			$i++;
		}
		$params = [
			'token' => $client['token'],
			'option' => $client['option'],
			'url' => $client['url'],
			'parent' => $client['parent'],
			'roles' => $roles,
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar extensión funcional
	public function deleteCustomMenuById($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['extensions'] != '[]') {
			foreach($client['extensions'] as $extension) {
				$params = [
					'token' => $client['token'],
					'option' => $extension['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Editar extensión funcional
	public function editCustomMenuById($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$roles = '';
		$i = 1;
		$n = count($client['roles']);
		foreach($client['roles'] as $role) {
			$roles .= $role;
			if($i < $n) {
				$roles .= ',';
			}
			$i++;
		}
		$params = [
			'token' => $client['token'],
			'option' => $client['option'],
			'optiontext' => $client['optiontext'],
			'url' => $client['url'],
			'parent' => $client['parent'],
			'roles' => $roles,
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}