<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class ListasDifusionController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Eliminar Listas de Difusión
	public function deleteDistributionList($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['lists'] != '[]') {
			foreach($client['lists'] as $list) {
				$params = [
					'token' => $client['token'],
					'idlist' => $list['idlist']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Crear Lista de Difusión
	public function createList($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'admin' => $client['admin'],
			'activa' => $client['activa'],
			'description' => $client['description'],
			'destinatarios' => json_encode($client['destinatarios']),
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de miembros de la Lista de Difusión
	public function getDistributionListUsers($client, $idlist) {
		if(!isset($idlist)) {
			$idlist = $client['idlist'];
		}

		$url = CONSTANTS::SERVERAPI . 'getDistributionListUsers';
		$params = [
			'token' => $client['token'],
			'idlist' => $idlist
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar Lista de Difusión
	public function updateList($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'admin' => $client['admin'],
			'idlist' => $client['idlist'],
			'activa' => $client['activa'],
			'description' => $client['description'],
			'destinatarios' => json_encode($client['destinatarios']),
			'country' => $client['country']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}