<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class MantenimientoController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Archivar / Desarchivar - ofmsg / ofmsg_h
	public function archiveOfmsgFromDate($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'fechaInicio' => $client['fechaInicio'],
			'fechaFin' => $client['fechaFin'],
			'sentido' => $client['sentido']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Archivar / Desarchivar - ofmsg / ofmsg_h por año
	public function archiveOfmsgFromFullYear($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'year' => $client['year'],
			'sentido' => $client['sentido']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}