<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class ProductosController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Petición de imagenes para productos
	public function viewImagesProducts($client) {
		$dir = CONSTANTS::PATH_EXPORT_WORD . '/products/default_img';
		$files = scandir($dir);
		$resultPOST = (object)['status' => '', 'result' => ''];

		if($files) {
			$resultPOST->status = 'OK';
			$resultPOST->result = $files;
		} else {
			$resultPOST->status = 'KO';
			$resultPOST->result = 'Image file could not be accessed';
		}

		return $resultPOST;
	}

	// Petición de tipos de misión
	public function getTipoMisionByType($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'survey' => $client['survey'],
			'isVideocall' => $client['isVideocall'],
			'isPassiveTracking' => $client['isPassiveTracking']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Crear nuevo producto
	public function insertProductsAnaquel($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'name' => $client['name'],
			'description' => $client['description'],
			'image' => $client['image'],
			'template' => $client['template'],
			'country' => $client['country'],
			'isSurvey' => $client['isSurvey'],
			'isPassiveTracking' => $client['isPassiveTracking'],
			'isVideocall' => $client['isVideocall'],
			'type' => $client['type']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar producto
	public function deleteProductsAnaquel($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idProduct' => $client['idProduct']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Petición de producto por id
	public function getProductsAnaquelByID($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idProduct' => $client['idProduct']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Editar producto
	public function updateProductsAnaquel($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'idProduct' => $client['idProduct'],
			'name' => $client['name'],
			'description' => $client['description'],
			'image' => $client['image'],
			'template' => $client['template'],
			'country' => $client['country'],
			'isSurvey' => $client['isSurvey'],
			'isPassiveTracking' => $client['isPassiveTracking'],
			'isVideocall' => $client['isVideocall'],
			'type' => $client['type']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Añadir criterio a un proyecto de producto por encuesta
	public function productSetCMBPProjectsTargets($client) {
		// Eliminar criterios anteriores si es el caso de editar
		if(isset($client['delete']) && $client['delete'] == '1') {
			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargets';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargetsSegmentation';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Añadir valores al proyecto
		$url = CONSTANTS::SERVERAPI . 'updateCMBPProjectsFromStepByStep';
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'sidPerfilacion' => implode(',', $client['sidPerfilacion']),
			'IdPerfilacion' => implode(',', $client['IdPerfilacionDesc']),
			'IdPerfilacionDesc' => implode(',', $client['IdPerfilacionDesc']),
			'sidRelations' => $client['sidRelations'],
			'inclusivo' => $client['inclusivo'],
			'useSegmentation' => $client['useSegmentation'],
			'sidRelationsSegmentation' => $client['sidRelationsSegmentation'],
			'IdSegmentacion' => $client['IdSegmentacion'],
			'IdSegmentacionDesc' => $client['IdSegmentacionDesc'],
			'targetTotalPanel' => isset($client['targetTotalPanel']) ? $client['targetTotalPanel'] : '0'
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsTargets';

		foreach($client['targetsSurvey'] as $targetsSurvey) {
			$k = 0;
			$launch = 100;
			// $projectsTargetsArray: ["order#columname#value#valuecode"]
			$size = count($targetsSurvey);
			$projectsTargetsArray = '[';
			for($i = 0; $i < $size; $i++) {
				if($targetsSurvey[$i]['type'] == 'T') {
					//
				} else if($targetsSurvey[$i]['type'] != 'K') {
					$value = implode(',', $targetsSurvey[$i]['value']);
					$code = implode(',', $targetsSurvey[$i]['code']);
					$string = $k . '#' . $targetsSurvey[$i]['columnName'] . '#' . strval($value) . '#' . strval($code);
					$projectsTargetsArray .= '"' . $string . '",';
					$k++;
				} else {
					$sizeK = count($targetsSurvey[$i]['valuesSQ']);
					for($j = 0; $j < $sizeK; $j++) {
						$columnNameKArray = explode('|', $targetsSurvey[$i]['valuesSQ'][$j]);
						$columnNameK = $columnNameKArray[0];
						$value = implode(',', $targetsSurvey[$i]['value'][$columnNameK]);
						$code = implode(',', $targetsSurvey[$i]['code'][$columnNameK]);
						$string = $k . '#' . $columnNameK . '#' . $value . '#' . $code;
						$projectsTargetsArray .= '"' . $string . '",';
						$k++;
					}
				}

				// Envío cada 100
				if($k >= $launch) {
					$projectsTargetsArray = substr($projectsTargetsArray, 0, -1);
					$projectsTargetsArray .= ']';

					$params = [
						'token' => $client['token'],
						'id' => $client['id'],
						'projectsTargetsArray' => $projectsTargetsArray
					];

					$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

					if($resultPOST->status != 'OK') {
						return $resultPOST;
					}

					$projectsTargetsArray = '[';
					$launch += 100;
				}
			}

			if($projectsTargetsArray != '[') {
				$projectsTargetsArray = substr($projectsTargetsArray, 0, -1);
			}
			$projectsTargetsArray .= ']';

			if($projectsTargetsArray != '[]') {
				$params = array(
					'token' => $client['token'],
					'id' => $client['id'],
					'projectsTargetsArray' => $projectsTargetsArray
				);

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				return $resultPOST;
			} else {
				return $resultPOST;
			}
		}
	}

	// Añadir criterio a un proyecto de producto por segmentación
	public function productSetCMBPProjectsTargetsSegmentation($client) {
		// Eliminar criterios anteriores si es el caso de editar
		if(isset($client['delete']) && $client['delete'] == '1') {
			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargets';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargetsSegmentation';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Añadir valores al proyecto
		$url = CONSTANTS::SERVERAPI . 'updateCMBPProjectsFromStepByStep';
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'sidPerfilacion' => $client['sidPerfilacion'],
			'IdPerfilacion' => $client['IdPerfilacionDesc'],
			'IdPerfilacionDesc' => $client['IdPerfilacionDesc'],
			'sidRelations' => $client['sidRelations'],
			'inclusivo' => $client['inclusivo'],
			'useSegmentation' => $client['useSegmentation'],
			'sidRelationsSegmentation' => implode(',', $client['sidRelationsSegmentation']),
			'IdSegmentacion' => implode(',', $client['IdSegmentacion']),
			'IdSegmentacionDesc' => implode(',', $client['IdSegmentacionDesc']),
			'targetTotalPanel' => isset($client['targetTotalPanel']) ? $client['targetTotalPanel'] : '0'
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$url = CONSTANTS::SERVERAPI . 'setCMBPProjectsTargetsSegmentation';

		// $projectsTargetsArray: ["order#idSegmentation#nameSegmentation#nameSegment#enabled"]
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'projectsTargetsArray' => json_encode($client['segSegmentations'])
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		return $resultPOST;
	}

	// Añadir criterio a un proyecto de toda la comunidad
	public function productSetCMBPProjectsTargetsTotal($client) {
		// Eliminar criterios anteriores si es el caso de editar
		if(isset($client['delete']) && $client['delete'] == '1') {
			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargets';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$url = CONSTANTS::SERVERAPI . 'deleteCMBPProjectsTargetsSegmentation';
			$params = [
				'token' => $client['token'],
				'id' => $client['id']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}
		}

		// Añadir valores al proyecto
		$url = CONSTANTS::SERVERAPI . 'updateCMBPProjectsFromStepByStep';
		$params = [
			'token' => $client['token'],
			'id' => $client['id'],
			'sidPerfilacion' => $client['sidPerfilacion'],
			'IdPerfilacion' => $client['IdPerfilacionDesc'],
			'IdPerfilacionDesc' => $client['IdPerfilacionDesc'],
			'sidRelations' => $client['sidRelations'],
			'inclusivo' => $client['inclusivo'],
			'useSegmentation' => $client['useSegmentation'],
			'sidRelationsSegmentation' => implode(',', $client['sidRelationsSegmentation']),
			'IdSegmentacion' => implode(',', $client['IdSegmentacion']),
			'IdSegmentacionDesc' => implode(',', $client['IdSegmentacionDesc']),
			'targetTotalPanel' => $client['targetTotalPanel']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}
}