<?php
include_once(dirname(__FILE__) . '/UtilesController.php');

class RecompensasController {
	private $utilesController;

	function __construct() {
		$this->utilesController = new UtilesController();
	}

	// Artículo nuevo
	public function setRewardsArticle($client) {
		// Ruta de imágenes de artículos por defecto
		$articlePath = CONSTANTS::PATH_EXPORT_WORD . '/articulos/';

		// Ruta web stcm.const.downloads + 'articulos/'
		$articleWebPath = $client['path'];

		$imgPrincipal = $articleWebPath . 'articulo.png';
		$img = '["1#' . $imgPrincipal . '"]';

		// Países/Artículos
		$countryArray = explode(',', $client['country']);
		$country = json_encode($countryArray);

		if($country == '[""]') {
			$country = '';
		}

		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'articulo' => $client['articulo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipal,
			'img' => $img,
			'country' => $country
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$codArt = $resultPOST->id;

		// Ruta de artículo
		$articlePathDir = $articlePath . $codArt;

		// Ruta web stcm.const.downloads + 'articulos/'
		$articleWebPathDir = $client['path'] . $codArt;

		// Carpeta de artículo
		if(!file_exists($articlePathDir)) {
			$createFile = $this->utilesController->createDirectory($articlePathDir);

			if($createFile['status'] == 'KO') {
				return $createFile;
			}
		}

		// Imágenes
		if(isset($_FILES) && count($_FILES) > 0) {
			$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$maxSize = $resultPOST->result[0]->upload_max_filesize_bytes;

			if(isset($_FILES['imgPrincipal'])) {
				if($_FILES['imgPrincipal']['size'] <= $maxSize) {
					$type = $_FILES['imgPrincipal']['type'];
					$type_Array = explode('/', $type);

					// Mover imagen a carpeta de artículo
					if(!move_uploaded_file($_FILES['imgPrincipal']['tmp_name'], $articlePath . $codArt . '/' . $codArt . '_00.' . $type_Array[1])) {
						$response['status'] = 'KO';
						return $response;
					}

					// Ruta de la imagen
					$imgPrincipalUpdate = $articleWebPath . $codArt . '/' . $codArt . '_00.' . $type_Array[1];
				} else {
					// imagen por defecto
					$origin = $imgPrincipal;
					$destiny = $articlePathDir . '/articulo.png';

					copy($origin, $destiny);

					$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
				}
			} else {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $articlePathDir . '/articulo.png';

				copy($origin, $destiny);

				$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
			}

			$i = 1;
			$imgUpdateArray = [];
			foreach($_FILES as $key => $value) {
				if($key == 'imgPrincipal') {
					continue;
				} else {
					if($_FILES[$key]['size'] <= $maxSize) {
						$type = $_FILES[$key]['type'];
						$type_Array = explode('/', $type);

						// Mover imagen a carpeta de artículo
						if(!move_uploaded_file($_FILES[$key]['tmp_name'], $articlePath . $codArt . '/' . $codArt . '_' . $i . '.' . $type_Array[1])) {
							$response['status'] = 'KO';
							return $response;
						}

						// Ruta de la imagen
						$img = $i . '#' . $articleWebPath . $codArt . '/' . $codArt . '_' . $i . '.' . $type_Array[1];
						array_push($imgUpdateArray, $img);

						$i++;
					} else {
						// imagen por defecto
						$origin = $imgPrincipal;
						$destiny = $articlePathDir . '/articulo.png';

						copy($origin, $destiny);

						$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
					}
				}
			}

			if(count($imgUpdateArray) > 0) {
				$imgUpdate = json_encode($imgUpdateArray);
			} else {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $articlePathDir . '/articulo.png';

				copy($origin, $destiny);

				$imgUpdate = '["1#' . $articleWebPathDir . '/articulo.png"]';
			}
		} else {
			// imagen por defecto
			$origin = $imgPrincipal;
			$destiny = $articlePathDir . '/articulo.png';

			copy($origin, $destiny);

			$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
			$imgUpdate = '["1#' . $articleWebPathDir . '/articulo.png"]';
		}

		// Actualizar rutas de imágenes
		$url = CONSTANTS::SERVERAPI . 'updateRewardsArticle';
		$params = [
			'token' => $client['token'],
			'codArt' => $codArt,
			'articulo' => $client['articulo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipalUpdate,
			'img' => $imgUpdate,
			'country' => $country
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Eliminar artículo
	public function deleteRewardsArticle($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['codArt'] != '[]') {
			foreach($client['codArt'] as $codArt) {
				$params = [
					'token' => $client['token'],
					'codArt' => $codArt['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}

				// Eliminar archivos y carpeta
				$folderName = CONSTANTS::PATH_EXPORT_WORD . '/articulos/' . $codArt['id'] . '/*';
				$files = glob($folderName);
				foreach($files as $file) {
					if(is_file($file)) {
						unlink($file);
					}
				}
				rmdir(CONSTANTS::PATH_EXPORT_WORD . '/articulos/' . $codArt['id']);
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Petición de artículo por ID
	public function getRewardsArticlesByID($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'codArt' => $client['codArt']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar artículo
	public function updateRewardsArticle($client) {
		// Ruta de imágenes de artículos por defecto
		$articlePath = CONSTANTS::PATH_EXPORT_WORD . '/articulos/';

		// Ruta web stcm.const.downloads + 'articulos/'
		$articleWebPath = $client['path'];

		$imgPrincipal = $articleWebPath . 'articulo.png';
		$img = '["1#' . $imgPrincipal . '"]';

		// Países/Artículos
		$countryArray = explode(',', $client['country']);
		$country = json_encode($countryArray);

		if($country == '[""]') {
			$country = '';
		}

		$imgControl = explode(',', $client['imgControl']);

		$codArt = $client['codArt'];

		// Ruta de artículo
		$articlePathDir = $articlePath . $codArt;

		// Ruta web stcm.const.downloads + 'articulos/'
		$articleWebPathDir = $client['path'] . $codArt;

		// Carpeta de artículo
		if(!file_exists($articlePathDir)) {
			$createFile = $this->utilesController->createDirectory($articlePathDir);

			if($createFile['status'] == 'KO') {
				return $createFile;
			}
		}

		// Imágenes
		if(isset($_FILES) && count($_FILES) > 0) {
			$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$maxSize = $resultPOST->result[0]->upload_max_filesize_bytes;

			if(isset($_FILES['imgPrincipal'])) {
				if($_FILES['imgPrincipal']['size'] <= $maxSize) {
					$type = $_FILES['imgPrincipal']['type'];
					$type_Array = explode('/', $type);

					// Mover imagen a carpeta de artículo
					if(!move_uploaded_file($_FILES['imgPrincipal']['tmp_name'], $articlePath . $codArt . '/' . $codArt . '_00.' . $type_Array[1])) {
						$response['status'] = 'KO';
						return $response;
					}

					// Ruta de la imagen
					$imgPrincipalUpdate = $articleWebPath . $codArt . '/' . $codArt . '_00.' . $type_Array[1];
				} else {
					if($client['mainPictureControl'] == 'new') {
						// imagen por defecto
						$origin = $imgPrincipal;
						$destiny = $articlePathDir . '/articulo.png';

						copy($origin, $destiny);

						$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
					}
				}
			} else {
				if($client['mainPictureControl'] == 'new') {
					// imagen por defecto
					$origin = $imgPrincipal;
					$destiny = $articlePathDir . '/articulo.png';

					copy($origin, $destiny);

					$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
				} else {
					$imgPrincipalUpdate = $client['mainPictureControl'];
				}
			}

			$i = 1;
			$imgUpdateArray = [];
			foreach($_FILES as $key => $value) {
				if($key == 'imgPrincipal') {
					continue;
				} else {
					// Control de imágenes subidas
					$control = $codArt . '_' . $i;
					$size = count($imgControl);
					for($j = 0; $j < $size; $j++) {
						if(strpos($imgControl[$j], $control) !== false) {
							$img = $i . '#' . $imgControl[$j];
							array_push($imgUpdateArray, $img);
							$i++;
							$control = $codArt . '_' . $i;
						}
					}

					if($_FILES[$key]['size'] <= $maxSize) {
						$type = $_FILES[$key]['type'];
						$type_Array = explode('/', $type);

						// Mover imagen a carpeta de artículo
						if(!move_uploaded_file($_FILES[$key]['tmp_name'], $articlePath . $codArt . '/' . $codArt . '_' . $i . '.' . $type_Array[1])) {
							$response['status'] = 'KO';
							return $response;
						}

						// Ruta de la imagen
						$img = $i . '#' . $articleWebPath . $codArt . '/' . $codArt . '_' . $i . '.' . $type_Array[1];
						array_push($imgUpdateArray, $img);

						$i++;
					} else {
						// imagen por defecto
						$origin = $imgPrincipal;
						$destiny = $articlePathDir . '/articulo.png';

						copy($origin, $destiny);

						$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
					}
				}
			}

			// Control de imágenes subidas
			$control = $codArt . '_' . $i;
			$size = count($imgControl);
			for($j = 0; $j < $size; $j++) {
				if(strpos($imgControl[$j], $control) !== false) {
					$img = $i . '#' . $imgControl[$j];
					array_push($imgUpdateArray, $img);
					$i++;
					$control = $codArt . '_' . $i;
				}
			}

			if(count($imgUpdateArray) > 0) {
				$imgUpdate = json_encode($imgUpdateArray);
			} else {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $articlePathDir . '/articulo.png';

				copy($origin, $destiny);

				$imgUpdate = '["1#' . $articleWebPathDir . '/articulo.png"]';
			}
		} else {
			if($client['mainPictureControl'] == 'new') {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $articlePathDir . '/articulo.png';

				copy($origin, $destiny);

				$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
			} else {
				$imgPrincipalUpdate = $client['mainPictureControl'];
			}

			$imgUpdateArray = [];
			$size = count($imgControl);
			if($size > 0) {
				$i = 1;
				for($j = 0; $j < $size; $j++) {
					if($imgControl[$j] !== 'new') {
						$img = $i . '#' . $imgControl[$j];
						array_push($imgUpdateArray, $img);
						$i++;
					} else if($imgControl[$j] === 'new' && $j === 0) {
						$destiny = $articleWebPathDir . '/articulo.png';
						$img = '1#' . $destiny;
						array_push($imgUpdateArray, $img);
					}
				}

				$imgUpdate = json_encode($imgUpdateArray);
			} else {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $articlePathDir . '/articulo.png';

				copy($origin, $destiny);

				$imgPrincipalUpdate = $articleWebPathDir . '/articulo.png';
				$imgUpdate = '["1#' . $articleWebPathDir . '/articulo.png"]';
			}
		}

		// Actualizar rutas de imágenes
		$url = CONSTANTS::SERVERAPI . 'updateRewardsArticle';
		$params = [
			'token' => $client['token'],
			'codArt' => $codArt,
			'articulo' => $client['articulo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipalUpdate,
			'img' => $imgUpdate,
			'country' => $country
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Catálogo nuevo
	public function setRewardsCatalog($client) {
		// Ruta de imágenes de catálogos por defecto
		$cataloguePath = CONSTANTS::PATH_EXPORT_WORD . '/catalogos/';

		// Ruta web stcm.const.downloads + 'catalogos/'
		$catalogueWebPath = $client['path'];

		$imgPrincipal = $catalogueWebPath . 'catalogo.png';

		// Países activos
		$countryArray = explode(',', $client['country']);
		$country = json_encode($countryArray);

		if($country == '[""]') {
			$country = '';
		}

		if($client['fechaInicio'] == '') {
			$client['fechaInicio'] = '2000-01-01';
		}

		if($client['fechaFin'] == '') {
			$client['fechaFin'] = '2100-12-31';
		}

		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'catalogo' => $client['catalogo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipal,
			'country' => $country,
			'fechaInicio' => $client['fechaInicio'],
			'fechaFin' => $client['fechaFin']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		$codCatalog = $resultPOST->id;

		// Ruta de artículo
		$cataloguePathDir = $cataloguePath . $codCatalog;

		// Ruta web stcm.const.downloads + 'catalogos/'
		$catalogueWebPathDir = $client['path'] . $codCatalog;

		// Carpeta de artículo
		if(!file_exists($cataloguePathDir)) {
			$createFile = $this->utilesController->createDirectory($cataloguePathDir);

			if($createFile['status'] == 'KO') {
				return $createFile;
			}
		}

		// Imágenes
		if(isset($_FILES) && count($_FILES) > 0) {
			$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$maxSize = $resultPOST->result[0]->upload_max_filesize_bytes;

			if(isset($_FILES['imgPrincipal'])) {
				if($_FILES['imgPrincipal']['size'] <= $maxSize) {
					$type = $_FILES['imgPrincipal']['type'];
					$type_Array = explode('/', $type);

					// Mover imagen a carpeta de artículo
					if(!move_uploaded_file($_FILES['imgPrincipal']['tmp_name'], $cataloguePath . $codCatalog . '/' . $codCatalog . '_00.' . $type_Array[1])) {
						$response['status'] = 'KO';
						return $response;
					}

					// Ruta de la imagen
					$imgPrincipalUpdate = $catalogueWebPathDir . '/' . $codCatalog . '_00.' . $type_Array[1];
				} else {
					// imagen por defecto
					$origin = $imgPrincipal;
					$destiny = $cataloguePathDir . '/catalogo.png';

					copy($origin, $destiny);

					$imgPrincipalUpdate = $catalogueWebPathDir . '/catalogo.png';
				}
			} else {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $cataloguePathDir . '/catalogo.png';

				copy($origin, $destiny);

				$imgPrincipalUpdate = $catalogueWebPathDir . '/catalogo.png';
			}
		} else {
			// imagen por defecto
			$origin = $imgPrincipal;
			$destiny = $cataloguePathDir . '/catalogo.png';

			copy($origin, $destiny);

			$imgPrincipalUpdate = $catalogueWebPathDir . '/catalogo.png';
		}

		// Actualizar rutas de imágenes
		$url = CONSTANTS::SERVERAPI . 'updateRewardsCatalog';
		$params = [
			'token' => $client['token'],
			'codCatalog' => $codCatalog,
			'catalogo' => $client['catalogo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipalUpdate,
			'country' => $country,
			'fechaInicio' => $client['fechaInicio'],
			'fechaFin' => $client['fechaFin']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Artículos
		$articlesArray = explode(',', $client['articles']);
		$articles = json_encode($articlesArray);

		if($articles != '[""]') {
			// Añadir artículos a catálogo
			$url = CONSTANTS::SERVERAPI . 'addItemsRewardsCatalog';
			$params = [
				'token' => $client['token'],
				'codCatalog' => $codCatalog,
				'articulos' => $articles
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}

	// Eliminar catálogo
	public function deleteRewardsCatalog($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];

		if($client['codCatalog'] != '[]') {
			foreach($client['codCatalog'] as $codCatalog) {
				$params = [
					'token' => $client['token'],
					'codCatalog' => $codCatalog['id']
				];

				$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

				if($resultPOST->status != 'OK') {
					return $resultPOST;
				}

				// Eliminar archivos y carpeta
				$folderName = CONSTANTS::PATH_EXPORT_WORD . '/catalogos/' . $codCatalog['id'] . '/*';
				$files = glob($folderName);
				foreach($files as $file) {
					if(is_file($file)) {
						unlink($file);
					}
				}
				rmdir(CONSTANTS::PATH_EXPORT_WORD . '/catalogos/' . $codCatalog['id']);
			}
		} else {
			$resultPOST = [
				'status' => 'OK'
			];
		}

		return $resultPOST;
	}

	// Petición de catálogo por ID
	public function getRewardsCatalogsByID($client) {
		$url = CONSTANTS::SERVERAPI . $client['action'];
		$params = [
			'token' => $client['token'],
			'codCatalog' => $client['codCatalog']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		return $resultPOST;
	}

	// Actualizar catálogo
	public function updateRewardsCatalog($client) {
		// Ruta de imágenes de catálogos por defecto
		$cataloguePath = CONSTANTS::PATH_EXPORT_WORD . '/catalogos/';

		// Ruta web stcm.const.downloads + 'catalogos/'
		$catalogueWebPath = $client['path'];

		$imgPrincipal = $catalogueWebPath . 'catalogo.png';

		// Países/Artículos
		$countryArray = explode(',', $client['country']);
		$country = json_encode($countryArray);

		if($country == '[""]') {
			$country = '';
		}

		if($client['fechaInicio'] == '') {
			$client['fechaInicio'] = '2000-01-01';
		}

		if($client['fechaFin'] == '') {
			$client['fechaFin'] = '2100-12-31';
		}

		$codCatalog = $client['codCatalog'];

		// Imágenes
		if(isset($_FILES) && count($_FILES) > 0) {
			$url = CONSTANTS::SERVERAPI . 'getCMBPConfig';
			$params = [
				'token' => $client['token']
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

			if($resultPOST->status != 'OK') {
				return $resultPOST;
			}

			$maxSize = $resultPOST->result[0]->upload_max_filesize_bytes;

			if(isset($_FILES['imgPrincipal'])) {
				if($_FILES['imgPrincipal']['size'] <= $maxSize) {
					$type = $_FILES['imgPrincipal']['type'];
					$type_Array = explode('/', $type);

					// Mover imagen a carpeta de artículo
					if(!move_uploaded_file($_FILES['imgPrincipal']['tmp_name'], $cataloguePath . $codCatalog . '/' . $codCatalog . '_00.' . $type_Array[1])) {
						$response['status'] = 'KO';
						return $response;
					}

					// Ruta de la imagen
					$imgPrincipalUpdate = $catalogueWebPath . $codCatalog . '/' . $codCatalog . '_00.' . $type_Array[1];
				} else {
					if($client['mainPictureControl'] == 'new') {
						// imagen por defecto
						$origin = $imgPrincipal;
						// Ruta de catálogo
						$destiny = $cataloguePath . $codCatalog . '/catalogo.png';

						copy($origin, $destiny);

						$imgPrincipalUpdate = $catalogueWebPath . $codCatalog . '/catalogo.png';
					}
				}
			} else {
				if($client['mainPictureControl'] == 'new') {
					// imagen por defecto
					$origin = $imgPrincipal;
					// Ruta de catálogo
					$destiny = $cataloguePath . $codCatalog . '/catalogo.png';

					copy($origin, $destiny);

					$imgPrincipalUpdate = $catalogueWebPath . $codCatalog . '/catalogo.png';
				} else {
					$imgPrincipalUpdate = $client['mainPictureControl'];
				}
			}
		} else {
			if($client['mainPictureControl'] == 'new') {
				// imagen por defecto
				$origin = $imgPrincipal;
				$destiny = $cataloguePath . $codCatalog . '/catalogo.png';

				copy($origin, $destiny);

				$imgPrincipalUpdate = $catalogueWebPath . $codCatalog . '/catalogo.png';
			} else {
				$imgPrincipalUpdate = $client['mainPictureControl'];
			}
		}

		// Actualizar
		$url = CONSTANTS::SERVERAPI . 'updateRewardsCatalog';
		$params = [
			'token' => $client['token'],
			'codCatalog' => $codCatalog,
			'catalogo' => $client['catalogo'],
			'descripcion' => $client['descripcion'],
			'enabled' => $client['enabled'],
			'imgPrincipal' => $imgPrincipalUpdate,
			'country' => $country,
			'fechaInicio' => $client['fechaInicio'],
			'fechaFin' => $client['fechaFin']
		];

		$resultPOST = $this->utilesController->sendCurlPOST($url, $params);

		// Registro de errores
		if($resultPOST->status != 'OK') {
			return $resultPOST;
		}

		// Añadir artículos
		$addArticleArray = explode(',', $client['addArticle']);
		$addArticle = json_encode($addArticleArray);

		if($addArticle != '[""]') {
			$url = CONSTANTS::SERVERAPI . 'addItemsRewardsCatalog';
			$params = [
				'token' => $client['token'],
				'codCatalog' => $codCatalog,
				'articulos' => $addArticle
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		// Eliminar artículos
		$deleteArticleArray = explode(',', $client['deleteArticle']);
		$deleteArticle = json_encode($deleteArticleArray);

		if($deleteArticle != '[""]') {
			$url = CONSTANTS::SERVERAPI . 'deleteItemsRewardsCatalog';
			$params = [
				'token' => $client['token'],
				'codCatalog' => $codCatalog,
				'articulos' => $deleteArticle
			];

			$resultPOST = $this->utilesController->sendCurlPOST($url, $params);
		}

		return $resultPOST;
	}
}