<?php
require_once(dirname(__FILE__) . '/../customConfig/Constants.php');

class ServiceMisionesIndefinidas {
	private $token;
	private $controller;

	function __construct() {
		$this->token = 'HtDFjQYeyfFb9e27n9URgFw27b9en9URg11Fw664ey11664ey11WJ9P27aGLOKmFh';
		$this->controller = new Controller;
	}

	public function startTestMisionesIndefinidas() {
		try {
			// Ejecutar el servicio de segmentaciones programadas
			$response = $this->startService();

			return $response;
		} catch(Exception $e) {
			//Gestión de excepciones
			$errorFile = dirname(__FILE__) . '/runningSegmentationsError.txt';
			$date = date('Y-m-d H:i:s');
			$exceptionString =	' EXCEPTION OCURRED: ' . $e->getMessage() . "\r\n" .
								'	-Exception Code: ' . $e->getCode() . "\r\n" .
								'	-Exception Line: ' . $e->getLine() . "\r\n" .
								'	-Exception Trace: ' . "\r\n" . $e->getTraceAsString() . "\r\n";
			//escribir la excepción en el errorfile
			file_put_contents($errorFile, $date . $exceptionString . '---------------------------------' . "\r\n", FILE_APPEND);
			//lanzar un log en el server para registrarlo
			$this->controller->setCMBPLOG($this->token, 'SERVICE_SEGMENTATIONS_EXCEPTION', 'service segmentations exception', $exceptionString, '');
		}
	}

	public function startService() {
		try {
			// Llamar a las ejecuciones de schedule_segmentation
			$startServiceMisionesIndefinidas = $this->startServiceMisionesIndefinidas(false);

			return $startServiceMisionesIndefinidas;
		} catch(Exception $e) {
			$error = __FUNCTION__ . ': Excepción capturada: ' . $e->getMessage();
			return $error;
		}
	}

	public function getMisionesIndefinidas() {
		try {
			$url = CONSTANTS::SERVERAPI . 'getMisionesIndefinidas';
			$params = [
				'token' => $this->token
			];

			$resultPOST = $this->controller->sendCurlPOST($url, $params);

			// LOG
			$this->controller->setCMBPLOG($this->token, 'SERVICE', 'getMisionesIndefinidas', $resultPOST->status, '');

			return $resultPOST;
		} catch(Exception $e) {
			$error = __FUNCTION__ . ': Excepción capturada: ' . $e->getMessage();
			return $error;
		}
	}

	public function getSnapAcualMisionCumplimiento($idmision) {
		try {
			$url = CONSTANTS::SERVERAPI . 'getSnapAcualMisionCumplimiento';
			$params = [
				'token' => $this->token,
				'idmision' => $idmision,
				'project' => ''
			];

			$resultPOST = $this->controller->sendCurlPOST($url, $params);

			// LOG
			$this->controller->setCMBPLOG($this->token, 'SERVICE', 'getSnapAcualMisionCumplimiento', $resultPOST->status, '');

			return $resultPOST;
		} catch(Exception $e) {
			$error = __FUNCTION__ . ': Excepción capturada: ' . $e->getMessage();
			return $error;
		}
	}

	public function startServiceMisionesIndefinidas($start) {
		try {
			$service = new Service();

			$returnMisionesIndefinidas = 'OK';

			// LOG
			$this->controller->setCMBPLOG($this->token, 'SERVICE', 'startServiceMisionesIndefinidas', $start, '');

			// Abtenemos las misiones indefinidas para procesarlas
			$service->LogToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE, 'Llamada a getMisionesIndefinidas');
			$missionsIndefinidas = $this->getMisionesIndefinidas();
			$service->LogToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE, 'Resultado de getMisionesIndefinidas: ' . $missionsIndefinidas->status);
			if($missionsIndefinidas->status == 'KO') {
				$returnMisionesIndefinidas = 'getMisionesIndefinidas KO';
			}

			// Misiones con cupo
			if($missionsIndefinidas->status == 'OK' && count($missionsIndefinidas->result) > 0) {
				// Por cada una de las misiones indefinidas
				$service->LogToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE, 'Misiones Indefinidas > 0');

				foreach($missionsIndefinidas->result as $missionsIndefinidas) {
					// Ejecutamos snap de cumplimiento para cada mision indefinida
					$service->LogToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE, 'Llamada a getSnapAcualMisionCumplimiento');
					$idmision = $missionsIndefinidas->stampMision;
					if($idmision != '') {
						$missionsIndefinidasSnap = $this->getSnapAcualMisionCumplimiento($idmision);
					}
					$service->LogToFile(CONSTANTS::REGISTER_LOGS_SERVICE_FILE, 'Resultado de getSnapAcualMisionCumplimiento: ' . $missionsIndefinidas->status);
					if($missionsIndefinidas->status == 'KO') {
						$returnMisionesIndefinidas = 'getSnapAcualMisionCumplimiento KO';
					}
				}
			}

		} catch(Exception $e) {
			$error = __FUNCTION__ . ': Excepción capturada: ' . $e->getMessage();
			return $error;
		}
	}
}