<?php
class AnalyticGraph {
	// Formato de datos
	public function dataFormatOptions($data, $labels, $isTypeM, $type = '', $numPerf) {
		$graph = [
			// Tipo
			'type' => $type,
			// Datos generales
			'data' => $data,
			// Gráfica de respuestas
			'answers' => [],
			// Gráfica de género
			'gender' => [],
			// Gráfica de edad
			'age' => [],
			// Gráfica de estados
			'states' => [],
			// Gráfica de NSE
			'nse' => [],
			// Gráfica de Rango de Edad
			'ageRange' => []
		];

		$dataGraphs = $this->createGraphs($data, $labels, $isTypeM, $numPerf);
		$graph['answers'] = $dataGraphs['answers'];
		$graph['gender'] = $dataGraphs['gender'];
		$graph['age'] = $dataGraphs['age'];
		$graph['states'] = $dataGraphs['states'];
		$graph['nse'] = $dataGraphs['nse'];
		$graph['ageRange'] = $dataGraphs['ageRange'];

		return $graph;
	}

	// Formato de datos
	public function dataFormatOptionsPerf($data, $labels, $isTypeM) {
		$graph = [
			// Datos generales
			'data' => $data,
			// Gráfica de respuestas
			'answers' => []
		];

		$dataGraphs = $this->createGraphsPerf($data, $labels, $isTypeM);
		$graph['answers'] = $dataGraphs['answers'];

		return $graph;
	}

	private function createGraphs($data, $labels, $isTypeM, $numPerf) {
		$dataGraphs = [
			'answers' => [
				'labels' => '',
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'gender' => [
				'labels' => ['Masculino', 'Femenino'],
				'datasets' => [
					'data' => [0, 0],
					'backgroundColor' => ['#FF0000', '#0000FF']
				],
				'type' => '',
				'options' => ''
			],
			'age' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'states' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'nse' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'ageRange' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			]
		];

		if($labels != 'int') {
			// Array de datos de respuesta a 0
			for($i = 0; $i < count($labels); $i++) {
				array_push($dataGraphs['answers']['datasets']['data'], 0);
			}
			$dataGraphs['answers']['labels'] = $labels;
		}

		$others = false;
		$newType = [];
		foreach($data as $val) {
			if($val->tipoPregunta == 'A' || $val->tipoPregunta == 'F' || $val->tipoPregunta == 'H' || $val->tipoPregunta == 'N') {
				$val->answer = $val->answerothers;
				if($val->tipoPregunta == 'N') {
					$val->answer = intval($val->answerothers);
				}
			}

			// Preguntas con número
			if($labels == 'int') {
				$exist = array_key_exists($val->answerothers, $newType);
				if($exist) {
					$newType[$val->answerothers]++;
				} else {
					$newType[$val->answerothers] = 1;
				}
			} else {
				// RESPUESTAS
				if(count($labels) == 0) {
					// Respuestas libres
					if(in_array('Others', $dataGraphs['answers']['labels'])) {
						$dataGraphs['answers']['datasets']['data'][0]++;
					} else {
						array_push($dataGraphs['answers']['labels'], 'Others');
						array_push($dataGraphs['answers']['datasets']['data'], 1);
					}
				} else {
					// Respuestas cerradas
					if($val->answer == 'Y') {
						$index = array_search('YES', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'N') {
						$index = array_search('NO', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'U') {
						$index = array_search('UNCERTAIN', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'Masculino' || $val->answer == 'M') {
						$index = array_search('MASCULINO', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'Femenino' || $val->answer == 'F') {
						$index = array_search('FEMENINO', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'I') {
						$index = array_search('INCREASE', $dataGraphs['answers']['labels']);
					} else if($val->answer == 'S') {
						$index = array_search('SAME', $dataGraphs['answers']['labels']);
					} else if(($val->answer == 'D')) {
						$index = array_search('DECREASE', $dataGraphs['answers']['labels']);
					} else {
						if($val->answer == '-oth-') {
							if(!$others) {
								$others = true;
								array_push($dataGraphs['answers']['labels'], 'Otros');
								array_push($dataGraphs['answers']['datasets']['data'], 0);
							}
							$index = array_search('Otros', $dataGraphs['answers']['labels']);
						} else {
							$subIndex = 0;
							foreach($dataGraphs['answers']['labels'] as $elem) {
								if (trim($elem) == trim($val->answer)) {
									break;
								}
								$subIndex++;
							}
							$index = $subIndex;
							//$index = array_search(trim($val->answer), $dataGraphs['answers']['labels']);
							
						}
					}
					$dataGraphs['answers']['datasets']['data'][$index]++;
				}

				// Ordenación por cantidad de respuestas
				//array_multisort($dataGraphs['answers']['datasets']['data'], SORT_DESC, $dataGraphs['answers']['labels']);

				// Añadido de la etiqueta 'Otros' para los casos donde se encuentren valores '-oth-'
				if(in_array('-oth-', $dataGraphs['answers']['labels'])) {
					$clave = array_search('-oth-', $dataGraphs['answers']['labels']);
					$dataGraphs['answers']['labels'][$clave] = 'Otros';
				}

				// GÉNERO
				if($val->perf003 === 'M' || $val->perf003 === 'Masculino') {
					$dataGraphs['gender']['datasets']['data'][0]++;
				} else if($val->perf003 === 'F' || $val->perf003 === 'Femenino') {
					$dataGraphs['gender']['datasets']['data'][1]++;
				}

				// EDAD
				if($val->perf002 != 'n/d' && $val->perf002 != '') {
					if(in_array($val->perf002, $dataGraphs['age']['labels'])) {
						$index = array_search($val->perf002, $dataGraphs['age']['labels']);
						$dataGraphs['age']['datasets']['data'][$index]++;
					} else {
						array_push($dataGraphs['age']['labels'], $val->perf002);
						array_push($dataGraphs['age']['datasets']['data'], 1);
					}
				}

				// RANGO EDAD
				if($val->perf002Range !='n/d' && $val->perf002 != '') {
					if(in_array($val->perf002Range, $dataGraphs['ageRange']['labels'])) {
						$index = array_search($val->perf002Range, $dataGraphs['ageRange']['labels']);
						$dataGraphs['ageRange']['datasets']['data'][$index]++;
					} else {
						array_push($dataGraphs['ageRange']['labels'], $val->perf002Range);
						array_push($dataGraphs['ageRange']['datasets']['data'], 1);
					}
				}

				// ESTADO
				if($val->perf001 != 'n/d') {
					if(in_array($val->perf001, $dataGraphs['states']['labels'])) {
						$index = array_search($val->perf001, $dataGraphs['states']['labels']);
						$dataGraphs['states']['datasets']['data'][$index]++;
					} else {
						array_push($dataGraphs['states']['labels'], $val->perf001);
						array_push($dataGraphs['states']['datasets']['data'], 1);
					}
				}

				// NSE
				if($val->perf004 != 'n/d') {
					if(in_array($val->perf004, $dataGraphs['nse']['labels'])) {
						$index = array_search($val->perf004, $dataGraphs['nse']['labels']);
						$dataGraphs['nse']['datasets']['data'][$index]++;
					} else {
						array_push($dataGraphs['nse']['labels'], $val->perf004);
						array_push($dataGraphs['nse']['datasets']['data'], 1);
					}
				}
			}
		}

		if($labels == 'int') {
			$dataGraphs['answers']['labels'] = [];
			foreach($newType as $key => $value) {
				array_push($dataGraphs['answers']['labels'], $key);
				array_push($dataGraphs['answers']['datasets']['data'], $value);
			}
		}

		// Cambio a Porcentajes - respuestas
		if($isTypeM) {
			$users = [];
			foreach($data as $row) {
				if(!in_array($row->userEmail, $users)) {
					array_push($users, $row->userEmail);
				}
			}
			$totalAnswers = count($users);
		} else {
			$totalAnswers = array_sum($dataGraphs['answers']['datasets']['data']);
		}

		$dataAnswersTemp = [];
		$answersSize = count($dataGraphs['answers']['labels']);
		for($i = 0; $i < $answersSize; $i++) {
			if($totalAnswers == 0) {
				array_push($dataAnswersTemp, 0);
				continue;
			}

			$answerPercent = round($dataGraphs['answers']['datasets']['data'][$i] * 100 / $totalAnswers, 1);
			array_push($dataAnswersTemp, $answerPercent);
		}
		$dataGraphs['answers']['datasets']['data'] = $dataAnswersTemp;

		// Cambio a Porcentajes - genero
		$totalGender = array_sum($dataGraphs['gender']['datasets']['data']);
		$dataGenderTemp = [];
		$genderSize = count($dataGraphs['gender']['labels']);
		for($i = 0; $i < $genderSize; $i++) {
			if(isset($totalGender) && $totalGender > 0) {
				$genderPercent = round($dataGraphs['gender']['datasets']['data'][$i] * 100 / $totalGender, 1);
				array_push($dataGenderTemp, $genderPercent);
			} else {
				array_push($dataGenderTemp, 0);
			}
		}
		$dataGraphs['gender']['datasets']['data'] = $dataGenderTemp;

		// Cambio a Porcentajes - edades
		$totalAges = array_sum($dataGraphs['age']['datasets']['data']);
		$dataAgeTemp = [];
		$ageSize = count($dataGraphs['age']['labels']);
		for($i = 0; $i < $ageSize; $i++) {
			$agePercent = round($dataGraphs['age']['datasets']['data'][$i] * 100 / $totalAges, 1);
			array_push($dataAgeTemp, $agePercent);
		}
		$dataGraphs['age']['datasets']['data'] = $dataAgeTemp;

		// Cambio a Porcentajes - rango de edades
		$totalAgesRange = array_sum($dataGraphs['ageRange']['datasets']['data']);
		$dataAgeRangeTemp = [];
		$ageRangeSize = count($dataGraphs['ageRange']['labels']);
		for($i = 0; $i < $ageRangeSize; $i++) {
			$ageRangePercent = round($dataGraphs['ageRange']['datasets']['data'][$i] * 100 / $totalAgesRange, 1);
			array_push($dataAgeRangeTemp, $ageRangePercent);
		}
		$dataGraphs['ageRange']['datasets']['data'] = $dataAgeRangeTemp;

		array_multisort($dataGraphs['ageRange']['labels'], $dataGraphs['ageRange']['datasets']['data']);

		// Cambio a Porcentajes - estados
		$totalStates = array_sum($dataGraphs['states']['datasets']['data']);
		$dataStatesTemp = [];
		$statesSize = count($dataGraphs['states']['labels']);
		for($i = 0; $i < $statesSize; $i++) {
			$statePercent = round($dataGraphs['states']['datasets']['data'][$i] * 100 / $totalStates, 1);
			array_push($dataStatesTemp, $statePercent);
		}
		$dataGraphs['states']['datasets']['data'] = $dataStatesTemp;

		// Cambio a Porcentajes - nse
		$totalNSE = array_sum($dataGraphs['nse']['datasets']['data']);
		$dataNSETemp = [];
		$NSESize = count($dataGraphs['nse']['labels']);
		for($i = 0; $i < $NSESize; $i++) {
			$NSEPercent = round($dataGraphs['nse']['datasets']['data'][$i] * 100 / $totalNSE, 1);
			array_push($dataNSETemp, $NSEPercent);
		}
		$dataGraphs['nse']['datasets']['data'] = $dataNSETemp;

		// Orden de valores de edad
		array_multisort($dataGraphs['age']['labels'], $dataGraphs['age']['datasets']['data']);
		// Modificación para valores con '+'
		if(isset($dataGraphs['age']['labels'][0]) && strpos($dataGraphs['age']['labels'][0], '+') === 0) {
			$firstLabel = array_shift($dataGraphs['age']['labels']);
			$firstData = array_shift($dataGraphs['age']['datasets']['data']);
			array_push($dataGraphs['age']['labels'], $firstLabel);
			array_push($dataGraphs['age']['datasets']['data'], $firstData);
		}

		// Orden de valores de estados
		array_multisort($dataGraphs['states']['labels'], $dataGraphs['states']['datasets']['data']);

		// Orden de valores de NSE
		array_multisort($dataGraphs['nse']['labels'], $dataGraphs['nse']['datasets']['data']);

		// FORMATOS
		$dataGraphs['answers']['type'] = 'bar';
		$dataGraphs['gender']['type'] = 'pie';
		$dataGraphs['age']['type'] = 'bar';
		$dataGraphs['states']['type'] = 'bar';
		$dataGraphs['nse']['type'] = 'bar';
		$dataGraphs['ageRange']['type'] = 'bar';

		// OPCIONES
		$optionsPie = '{
			"layout": {
				"padding": {
					"top": -26
				}
			},
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"position": "right",
				"onClick": false
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$optionsBar = '{
			"layout": {
				"padding": {
					"top": -26
				}
			},
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": true,
						"autoSkip": false
					}
				}],
				"yAxes": [{
					"display": false,
					"ticks": {
						"fontSize": 14,
						"beginAtZero": true
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$optionsBarWhitoutXLabels = '{
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": false
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$dataGraphs['answers']['options'] = $optionsBar;
		$dataGraphs['gender']['options'] = $optionsPie;
		$dataGraphs['age']['options'] = $optionsBar;
		$dataGraphs['states']['options'] = $optionsBar;
		$dataGraphs['nse']['options'] = $optionsBar;
		$dataGraphs['ageRange']['options'] = $optionsBar;

		return $dataGraphs;
	}

	private function createGraphsPerf($data, $labels, $isTypeM) {
		$dataGraphs = [
			'answers' => [
				'labels' => '',
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			]
		];

		// Array de datos de respuesta a 0
		for($i = 0; $i < count($labels); $i++) {
			array_push($dataGraphs['answers']['datasets']['data'], 0);
		}
		$dataGraphs['answers']['labels'] = $labels;

		$others = false;
		foreach($data as $val) {
			// RESPUESTAS
			if(count($labels) == 0) {
				// Respuestas libres
				if(in_array('Others', $dataGraphs['answers']['labels'])) {
					$dataGraphs['answers']['datasets']['data'][0]++;
				} else {
					array_push($dataGraphs['answers']['labels'], 'Others');
					array_push($dataGraphs['answers']['datasets']['data'], 1);
				}
			} else {
				// Respuestas cerradas
				if($val->answer == 'Y') {
					$index = array_search('YES', $dataGraphs['answers']['labels']);
				} else if($val->answer == 'N') {
					$index = array_search('NO', $dataGraphs['answers']['labels']);
				} else if(($val->answer == 'Masculino')) {
					$index = array_search('MASCULINO', $dataGraphs['answers']['labels']);
					// En caso de que no se encuentre en el array de labels el valor de 'MASCULINO'
					if(!$index) {
						$index = array_search($val->answer, $dataGraphs['answers']['labels']);
					}
				} else if(($val->answer == 'Femenino')) {
					$index = array_search('FEMENINO', $dataGraphs['answers']['labels']);
					// En caso de que no se encuentre en el array de labels el valor de 'FEMENINO'
					if(!$index) {
						$index = array_search($val->answer, $dataGraphs['answers']['labels']);
					}
				} else {
					if($val->answer == '-oth-') {
						if(!$others) {
							$others = true;
							array_push($dataGraphs['answers']['labels'], '-oth-');
							array_push($dataGraphs['answers']['datasets']['data'], 0);
						}
						$index = array_search('-oth-', $dataGraphs['answers']['labels']);
					} else {
						$index = array_search($val->answer, $dataGraphs['answers']['labels']);
					}
				}
				$dataGraphs['answers']['datasets']['data'][$index]++;
			}
		}

		// Ordenación por cantidad de respuestas
		array_multisort($dataGraphs['answers']['datasets']['data'], SORT_DESC, $dataGraphs['answers']['labels']);

		// Cambio a Porcentajes - respuestas
		if($isTypeM) {
			$users = [];
			foreach ($data as $row) {
				if(!in_array($row->userEmail, $users)) {
					array_push($users, $row->userEmail);
				}
			}
			$totalAnswers = count($users);
		} else {
			$totalAnswers = array_sum($dataGraphs['answers']['datasets']['data']);
		}

		$dataAnswersTemp = [];
		$answersSize = count($dataGraphs['answers']['labels']);
		for($i = 0; $i < $answersSize; $i++) {
			$answerPercent = round($dataGraphs['answers']['datasets']['data'][$i] * 100 / $totalAnswers, 1);
			array_push($dataAnswersTemp, $answerPercent);
		}
		$dataGraphs['answers']['datasets']['data'] = $dataAnswersTemp;

		// FORMATOS
		$dataGraphs['answers']['type'] = 'bar';

		// OPCIONES
		$optionsBar = '{
			"layout": {
				"padding": {
					"top": 26
				}
			},
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": true,
						"autoSkip": false
					}
				}],
				"yAxes": [{
					"display": false,
					"ticks": {
						"fontSize": 14,
						"beginAtZero": true
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$optionsBarWhitoutXLabels = '{
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": false
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$dataGraphs['answers']['options'] = $optionsBar;

		return $dataGraphs;
	}

	public function dataFormatOptionsPpt($data, $labels, $isTypeM) {
		$graph = [
			// Gráfica de respuestas
			'answers' => [],
			// Gráfica de género
			'gender' => [],
			// Gráfica de edad
			'age' => [],
			// Gráfica de edad por rangos
			'ageRange' => [],
			// Gráfica de estados
			'states' => [],
			'question' => $data[0]->question
		];

		$dataGraphs = $this->createGraphsPpt($data, $labels, $isTypeM);
		$graph['answers'] = $dataGraphs['answers'];
		$graph['gender'] = $dataGraphs['gender'];
		$graph['age'] = $dataGraphs['age'];
		$graph['ageRange'] = $dataGraphs['ageRange'];
		$graph['states'] = $dataGraphs['states'];

		return $graph;
	}

	public function dataFormatOptionsPptPerf($data, $labels, $isTypeM) {
		$graph = [
			// Gráfica de respuestas
			'answers' => [],
			'question' => $data[0]->question
		];

		$dataGraphs = $this->createGraphsPpt($data, $labels, $isTypeM);
		$graph['answers'] = $dataGraphs['answers'];
		$graph['gender'] = $dataGraphs['gender'];
		$graph['age'] = $dataGraphs['age'];
		$graph['states'] = $dataGraphs['states'];

		return $graph;
	}

	private function createGraphsPpt($data, $labels, $isTypeM) {
		$dataGraphs = [
			'answers' => [
				'labels' => '',
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'others' => [],
				'type' => '',
				'options' => ''
			],
			'gender' => [
				'labels' => ['Masculino', 'Femenino'],
				'datasets' => [
					'data' => [0, 0],
					'backgroundColor' => ['#FF0000', '#0000FF']
				],
				'type' => '',
				'options' => ''
			],
			'age' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'ageRange' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			],
			'states' => [
				'labels' => [],
				'datasets' => [
					'data' => [],
					'backgroundColor' => '#6c4675'
				],
				'type' => '',
				'options' => ''
			]
		];

		// Array de datos de respuesta a 0
		for($i = 0; $i < count($labels); $i++) {
			array_push($dataGraphs['answers']['datasets']['data'], 0);
		}
		$dataGraphs['answers']['labels'] = $labels;

		foreach($data as $val) {
			$sanit = htmlspecialchars($val->answerothers);
			$sanit = trim($sanit);
			$sanit = preg_replace("/[\r\n|\n|\r]+/", ' ', $sanit);

			array_push($dataGraphs['answers']['others'], $sanit);

			// RESPUESTAS
			if(count($labels) == 0) {
				// Respuestas libres
				if(in_array('Others', $dataGraphs['answers']['labels'])) {
					$dataGraphs['answers']['datasets']['data'][0]++;
				} else {
					array_push($dataGraphs['answers']['labels'], 'Others');
					array_push($dataGraphs['answers']['datasets']['data'], 1);
				}
			} else {
				// Respuestas cerradas
				if($val->answer == 'Y') {
					$index = array_search('YES', $dataGraphs['answers']['labels']);
				} else if($val->answer == 'N') {
					$index = array_search('NO', $dataGraphs['answers']['labels']);
				} else if(($val->answer == 'Masculino')) {
					$index = array_search('MASCULINO', $dataGraphs['answers']['labels']);
				} else if(($val->answer == 'Femenino')) {
					$index = array_search('FEMENINO', $dataGraphs['answers']['labels']);
				} else {
					$index = array_search($val->answer, $dataGraphs['answers']['labels']);
				}
				$dataGraphs['answers']['datasets']['data'][$index]++;
			}

			// GÉNERO
			if($val->perf003 === 'M' || $val->perf003 === 'Masculino') {
				$dataGraphs['gender']['datasets']['data'][0]++;
			} else if($val->perf003 === 'F') {
				$dataGraphs['gender']['datasets']['data'][1]++;
			}

			// EDAD
			if($val->perf002 != 'n/d') {
				if(in_array($val->perf002, $dataGraphs['age']['labels'])) {
					$index = array_search($val->perf002, $dataGraphs['age']['labels']);
					$dataGraphs['age']['datasets']['data'][$index]++;
				} else {
					array_push($dataGraphs['age']['labels'], $val->perf002);
					array_push($dataGraphs['age']['datasets']['data'], 1);
				}
			}

			// RANGO EDAD
			if($val->perf002Range != 'n/d') {
				if(in_array($val->perf002Range, $dataGraphs['ageRange']['labels'])) {
					$index = array_search($val->perf002Range, $dataGraphs['ageRange']['labels']);
					$dataGraphs['age']['datasets']['data'][$index]++;
				} else {
					array_push($dataGraphs['ageRange']['labels'], $val->perf002Range);
					array_push($dataGraphs['ageRange']['datasets']['data'], 1);
				}
			}

			// ESTADO
			if($val->perf001 != 'n/d') {
				if(in_array($val->perf001, $dataGraphs['states']['labels'])) {
					$index = array_search($val->perf001, $dataGraphs['states']['labels']);
					$dataGraphs['states']['datasets']['data'][$index]++;
				} else {
					array_push($dataGraphs['states']['labels'], $val->perf001);
					array_push($dataGraphs['states']['datasets']['data'], 1);
				}
			}
		}

		// Cambio a Porcentajes - respuestas
		if($isTypeM) {
			$users = [];
			foreach($data as $row) {
				if(!in_array($row->userEmail, $users)) {
					array_push($users, $row->userEmail);
				}
			}
			$totalAnswers = count($users);
		} else {
			$totalAnswers = array_sum($dataGraphs['answers']['datasets']['data']);
		}
		$dataAnswersTemp = [];
		$answersSize = count($dataGraphs['answers']['labels']);
		for($i = 0; $i < $answersSize; $i++) {
			$answerPercent = round($dataGraphs['answers']['datasets']['data'][$i] * 100 / $totalAnswers, 1);
			array_push($dataAnswersTemp, $answerPercent);
		}
		$dataGraphs['answers']['datasets']['data'] = $dataAnswersTemp;

		// Cambio a Porcentajes - genero
		$totalGender = array_sum($dataGraphs['gender']['datasets']['data']);
		$dataGenderTemp = [];
		$genderSize = count($dataGraphs['gender']['labels']);
		for($i = 0; $i < $genderSize; $i++) {
			if($totalGender == 0) {
				$genderPercent = 0;
			} else {
				$genderPercent = round($dataGraphs['gender']['datasets']['data'][$i] * 100 / $totalGender, 1);
			}

			array_push($dataGenderTemp, $genderPercent);
		}
		$dataGraphs['gender']['datasets']['data'] = $dataGenderTemp;

		// Cambio a Porcentajes - edades
		$totalAges = array_sum($dataGraphs['age']['datasets']['data']);
		$dataAgeTemp = [];
		$ageSize = count($dataGraphs['age']['labels']);
		for($i = 0; $i < $ageSize; $i++) {
			$agePercent = round($dataGraphs['age']['datasets']['data'][$i] * 100 / $totalAges, 1);
			array_push($dataAgeTemp, $agePercent);
		}
		$dataGraphs['age']['datasets']['data'] = $dataAgeTemp;

		// Cambio a Porcentajes - estados
		$totalStates = array_sum($dataGraphs['states']['datasets']['data']);
		$dataStatesTemp = [];
		$statesSize = count($dataGraphs['states']['labels']);
		for($i = 0; $i < $statesSize; $i++) {
			$statePercent = round($dataGraphs['states']['datasets']['data'][$i] * 100 / $totalStates, 1);
			array_push($dataStatesTemp, $statePercent);
		}
		$dataGraphs['states']['datasets']['data'] = $dataStatesTemp;

		// Orden de valores de edad
		array_multisort($dataGraphs['age']['labels'], $dataGraphs['age']['datasets']['data']);
		// Modificación para valores con '+'
		if(strpos($dataGraphs['age']['labels'][0], '+') === 0) {
			$firstLabel = array_shift($dataGraphs['age']['labels']);
			$firstData = array_shift($dataGraphs['age']['datasets']['data']);
			array_push($dataGraphs['age']['labels'], $firstLabel);
			array_push($dataGraphs['age']['datasets']['data'], $firstData);
		}

		// Cambio a Porcentajes - rango de edades
		$totalAgeRange = array_sum($dataGraphs['ageRange']['datasets']['data']);
		$dataAgeRangeTemp = [];
		$ageRangeSize = count($dataGraphs['ageRange']['labels']);
		for($i = 0; $i < $ageRangeSize; $i++) {
			$ageRangePercent = round($dataGraphs['ageRange']['datasets']['data'][$i] * 100 / $totalAgeRange, 1);
			array_push($dataAgeRangeTemp, $ageRangePercent);
		}

		$dataGraphs['ageRange']['datasets']['data'] = $dataAgeRangeTemp;
		// Orden de rango de edades
		array_multisort($dataGraphs['ageRange']['labels'], $dataGraphs['ageRange']['datasets']['data']);

		// Orden de valores de estados
		array_multisort($dataGraphs['states']['labels'], $dataGraphs['states']['datasets']['data']);

		// FORMATOS
		$dataGraphs['answers']['type'] = 'bar';
		$dataGraphs['gender']['type'] = 'pie';
		$dataGraphs['age']['type'] = 'bar';
		$dataGraphs['ageRange']['type'] = 'bar';
		$dataGraphs['states']['type'] = 'bar';

		// OPCIONES
		$optionsPie = '{
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"position": "right",
				"onClick": false
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$optionsBar = '{
			"layout": {
				"padding": {
					"top": 26
				}
			},
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": true,
						"autoSkip": false
					}
				}],
				"yAxes": [{
					"display": false,
					"ticks": {
						"fontSize": 14,
						"beginAtZero": true
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$optionsBarWhitoutXLabels = '{
			"responsive": true,
			"maintainAspectRatio": false,
			"legend": {
				"display": false,
				"onClick": false
			},
			"scales": {
				"xAxes": [{
					"ticks": {
						"display": false
					}
				}]
			},
			"title": {
				"display": false,
				"text": "",
				"fontSize": 16
			}
		}';

		$dataGraphs['answers']['options'] = $optionsBar;
		$dataGraphs['gender']['options'] = $optionsPie;
		$dataGraphs['age']['options'] = $optionsBar;
		$dataGraphs['ageRange']['options'] = $optionsBar;
		$dataGraphs['states']['options'] = $optionsBar;
		return $dataGraphs;
	}
}