<?php
require_once(dirname(__FILE__) . '/../../vendor/autoload.php');
require_once(dirname(__FILE__) . '/../customConfig/Constants.php');
require_once(dirname(__FILE__) . '/../../vendor/Spout/Autoloader/autoload.php');
set_time_limit(CONSTANTS::SET_TIME_LIMIT);

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpPresentation\Style\Fill;
use PhpOffice\PhpPresentation\IOFactory;
use PhpOffice\PhpPresentation\PhpPresentation;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Area;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Bar;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Bar3D;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Line;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Pie;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Pie3D;
use PhpOffice\PhpPresentation\Shape\Chart\Type\Scatter;
use PhpOffice\PhpPresentation\Shape\Chart\Series;
use PhpOffice\PhpPresentation\Style\Alignment;
use PhpOffice\PhpPresentation\Style\Border;
use PhpOffice\PhpPresentation\Style\Color;
use PhpOffice\PhpPresentation\Style\Shadow;
use PhpOffice\PhpPresentation\Style\Font;
use PhpOffice\PhpPresentation\Shape\Drawing;
use PhpOffice\PhpPresentation\Shape\RichText\Paragraph;
use PhpOffice\PhpPresentation\Style\Bullet;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;
use Box\Spout\Writer\WriterFactory;
use Box\Spout\Common\Type;
use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
use Box\Spout\Common\Entity\Style\CellAlignment;

class GenerateTableExcel {
	private $fontFamily = 'Arial';
	
	public function printExcelFromResultOrdered($data, $cabeceras, $nameExcel, $dataraw = false) {
		//por defecto $dataraw es falso y se busca ->result
		try {
			// Excel
			$spreadsheet = new Spreadsheet();
			$sheet = $spreadsheet->getActiveSheet();

			$cabeceras = explode(',', $cabeceras);

			$col = 0;
			foreach($cabeceras as $field) {
				$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col, 1, $field);
				$col++;
			}
			// Fetching the table data
			$row = 2;
			$allData = $data->result;
			if($dataraw == true) $allData = $data;
			foreach($allData as $data) {
				$col = 0;
				foreach($cabeceras as $field) {
					$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data->{$field});
					$col++;
				}
				$row++;
			}

			// Estilos encabezados
			$letra = $spreadsheet->getActiveSheet()->getHighestColumn();
			$spreadsheet->getActiveSheet()->getStyle('A1:' . $letra . '1')->applyFromArray(
				[
					'fill' => [
						'type' => Fill::FILL_SOLID,
						'color' => [
							'rgb' => 'E5E4E2'
						]
					],
					'font' => [
						'bold' => true
					]
				]
			);

			// Autoajustar celdas
			$column = 'A';
			while($column != $letra) {
				$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
				$column++;
			}

			$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);

			$date = new \DateTime();
			$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/tmp/' . $date->format('Y') . '/' . $date->format('m') . '/' . $date->format('d');

			if(!file_exists($carpeta)) {
				mkdir($carpeta, 0777, true);
			}

			$filename = $nameExcel . '.xlsx';

			$writer = new Xlsx($spreadsheet);
			$writer->save($carpeta . '/' . $filename);

		} catch(Exception $e) {
			$filename = false;
		}

		return $carpeta . '/' . $filename;
	}

	// Nueva librería de creación de excel
	public function printExcelFromResultOrderedNew($data, $cabeceras, $nameExcel) {
		try {
			// Array de cabeceras, en este caso también sirven como parámetros
			$cabeceras = explode(',', $cabeceras);

			// Creación de carpeta donde almacenar el archivo excel
			$date = new \DateTime();
			$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/tmp/' . $date->format('Y') . '/' . $date->format('m') . '/' . $date->format('d');

			if(!file_exists($carpeta)) {
				mkdir($carpeta, 0777, true);
			}

			// Archivo excel
			$filename = $nameExcel . '.xlsx';
			$spreadsheet = new Spreadsheet();
			$writer = new Xlsx($spreadsheet);
			$writer->save($carpeta . '/' . $filename);

			$writer = WriterEntityFactory::createXLSXWriter();
			$writer->openToFile($carpeta . '/' . $filename);

			// Cabeceras
			$style = (new StyleBuilder())->setFontBold()->build();
			$rowFromValues = WriterEntityFactory::createRowFromArray($cabeceras, $style);
			$writer->addRow($rowFromValues);

			// Cuerpo
			foreach($data as $value) {
				$row = [];

				foreach($cabeceras as $param) {
					array_push($row, $value->$param);
				}

				$rowFromValues = WriterEntityFactory::createRowFromArray($row);
				$writer->addRow($rowFromValues);
			}

			$writer->close();
		} catch(Exception $e) {
			$filename = false;
		}

		return $carpeta . '/' . $filename;
	}

	public function printExcelFromResult($data, $nameExcel) {
		try {
			$cabeceras = '';
			foreach($data as $key => $val) {
				foreach($val as $objKey => $value) {
					foreach($value as $keyAux => $valueAux) {
						if($cabeceras == '') {
							$cabeceras = 'X,' . $keyAux;
						} else {
							$cabeceras = $cabeceras . ',' . $keyAux;
						}
					}
					break;
				}
			}

			// Excel
			$spreadsheet = new Spreadsheet();
			$sheet = $spreadsheet->getActiveSheet();

			$cabeceras = explode(',', $cabeceras);

			$col = 0;
			foreach($cabeceras as $field) {
				$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col, 1, $field);
				$col++;
			}
			// Fetching the table data
			$row = 2;
			foreach($data->result as $data) {
				$col = 0;
				foreach($cabeceras as $field) {
					$spreadsheet->getActiveSheet()->setCellValueByColumnAndRow($col, $row, $data->{$field});
					$col++;
				}
				$row++;
			}

			// Estilos encabezados
			$letra = $spreadsheet->getActiveSheet()->getHighestColumn();
			$spreadsheet->getActiveSheet()->getStyle('A1:' . $letra . '1')->applyFromArray(
				[
					'fill' => [
						'type' => Fill::FILL_SOLID,
						'color' => [
							'rgb' => 'E5E4E2'
						]
					],
					'font' => [
						'bold' => true
					]
				]
			);

			// Autoajustar celdas
			$column = 'A';
			while($column != $letra) {
				$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
				$column++;
			}

			$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);

			$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/' . $nameExcel;

			if(!file_exists($carpeta)) {
				mkdir($carpeta, 0777, true);
			}

			$filename = $nameExcel . '.xlsx';

			$writer = new Xlsx($spreadsheet);
			$writer->save($carpeta . '/' . $filename);

		} catch(Exception $e) {
			$filename = false;
		}

		return $filename;
	}

	public function printExcel($data, $cabeceras, $parametros, $nameExcel) {
		try {
			$cabeceras = explode(',', $cabeceras);
			$parametros = explode(',', $parametros);

			// Excel
			$spreadsheet = new Spreadsheet();
			$sheet = $spreadsheet->getActiveSheet();
			$datosGenerales = [];

			array_push($datosGenerales, $cabeceras);

			foreach($data as $value) {
				$row = [];
				foreach($parametros as $param) {
					array_push($row, $value->$param);
				}
				array_push($datosGenerales, $row);
			}

			$spreadsheet->getActiveSheet()
				->fromArray(
					$datosGenerales,// The data to set
					NULL,			// Array values with this value will not be set
					'A1'			// Top left coordinate of the worksheet range where
									// we want to set these values (default is A1)
				);

			// Estilos encabezados
			$letra = $spreadsheet->getActiveSheet()->getHighestColumn();
			$spreadsheet->getActiveSheet()->getStyle('A1:' . $letra . '1')->applyFromArray(
				[
					'fill' => [
						'type' => Fill::FILL_SOLID,
						'color' => [
							'rgb' => 'E5E4E2'
						]
					],
					'font' => [
						'bold' => true
					]
				]
			);

			// Autoajustar celdas
			$column = 'A';
			while($column != $letra) {
				$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
				$column++;
			}

			$spreadsheet->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);

			$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/' . $nameExcel;

			if(!file_exists($carpeta)) {
				mkdir($carpeta, 0777, true);
			}

			$filename = $nameExcel . '.xlsx';

			$writer = new Xlsx($spreadsheet);
			$writer->save($carpeta . '/' . $filename);

		} catch(Exception $e) {
			$filename = false;
		}

		return $filename;
	}

	public function printExcelPassiveTracking($data, $cabeceras, $parametros, $nameExcel, $bExcel, $bPPT, $graphs, $idTenant) {
		try {
			// Objeto ZIP
			$zip = new ZipArchive();

			// Guardar reporte en un zip
			// Carpeta donde guardar los elementos a comprimir
			$folder = CONSTANTS::PATH_EXPORT_WORD . '/passive_tracking/';
			if(!file_exists($folder)) { // Si no existe, se crea
				mkdir($folder, 0777, true);
			}

			if($bExcel === true) {
				$cabeceras = explode(',', $cabeceras);
				$parametros = explode(',', $parametros);
				$datosGenerales = [];
				$cabecerasGenerales = $cabeceras;

				// Creación del archivo
				$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/passive_tracking';

				if(!file_exists($carpeta)) {
					mkdir($carpeta, 0777, true);
				}

				$filename = $nameExcel . '.xlsx';
				$filename = str_replace(' ', '_', $filename);

				$spreadsheet = new Spreadsheet();
				$writer = new Xlsx($spreadsheet);
				$writer->save($carpeta . '/' . $filename);

				$writer = WriterEntityFactory::createXLSXWriter();
				$writer->openToFile($carpeta . '/' . $filename);

				$style = (new StyleBuilder())->setFontBold()->build();

				$sheet = $writer->getCurrentSheet();
				$sheet->setName('General');

				// Añadido de los títulos a las cabeceras extras
				array_push($cabecerasGenerales, 'GPS Last Date');
				array_push($cabecerasGenerales, 'GPS Last Latitude');
				array_push($cabecerasGenerales, 'GPS Last Longitude');
				array_push($cabecerasGenerales, 'GPS Last Altitude');
				array_push($cabecerasGenerales, 'GPS Last Accuracy');
				array_push($cabecerasGenerales, 'Devices Brands');
				array_push($cabecerasGenerales, 'Devices');
				array_push($cabecerasGenerales, 'OS\'s');
				array_push($cabecerasGenerales, 'Last Battery');
				array_push($cabecerasGenerales, 'Last Network');
				array_push($cabecerasGenerales, 'Apps');

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasGenerales, $style);
				$writer->addRow($rowFromValues);

				array_push($datosGenerales, $cabecerasGenerales);

				// --- Simplifiación del excel para mostrar datos relevantes --- //
				foreach($data as $value) {
					$row = [];
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					// Última localización
					$lastLocation = end($value->gps);
					array_push($row, $lastLocation->date);
					array_push($row, $lastLocation->latitude);
					array_push($row, $lastLocation->longitude);
					array_push($row, $lastLocation->altitude);
					array_push($row, $lastLocation->accuracy);

					// Marcas de los dispositivos utilizados, Nombres de los dispositivos y Sistemas Operativos
					$sBrands = '';
					$brands = [];
					$sDevices = '';
					$devices = [];
					$sSOs = '';
					$SOs = [];

					foreach($value->device as $device) {
						array_push($brands, $device->manufacturer);
						array_push($devices, $device->model);
						array_push($SOs, $device->platform);
					}
					$brands = array_unique($brands);
					$devices = array_unique($devices);
					$SOs = array_unique($SOs);

					foreach($brands as $brand) {
						$sBrands .= $brand . ', ';
					}
					foreach($devices as $device) {
						$sDevices .= $device . ', ';
					}
					foreach($SOs as $SO) {
						$sSOs .= $SO . ', ';
					}
					$sBrands = substr($sBrands, 0 , -2);
					$sDevices = substr($sDevices, 0 , -2);
					$sSOs = substr($sSOs, 0 , -2);

					array_push($row, $sBrands);
					array_push($row, $sDevices);
					array_push($row, $sSOs);

					// Último nivel de batería
					$lastLBattery = end($value->battery);
					array_push($row, $lastLBattery->date . ', ' . $lastLBattery->charging . ', ' . $lastLBattery->level);

					// Última red
					$lastLNetwork = end($value->network);
					array_push($row, $lastLNetwork->date . ', ' . $lastLNetwork->type);

					// Apps
					$sApps = '';
					$apps = [];

					foreach($value->apps as $app) {
						array_push($apps, $app->appName);
					}
					$apps = array_unique($apps);

					foreach($apps as $app) {
						$sApps .= $app . ', ';
					}
					$sApps = substr($sApps, 0 , -2);

					array_push($row, $sApps);

					$rowFromValues = WriterEntityFactory::createRowFromArray($row);
					$writer->addRow($rowFromValues);

					array_push($datosGenerales, $row);

					$rowFromValues = WriterEntityFactory::createRowFromArray($row);
					$writer->addRow($rowFromValues);
				}

				// Segundo TAB - GPS
				$newSheet = $writer->addNewSheetAndMakeItCurrent();
				$sheet = $writer->getCurrentSheet();
				$sheet->setName('GPS');

				$datosGPS = [];
				$cabecerasGPS = $cabeceras;
				array_push($cabecerasGPS, 'GPS Date');
				array_push($cabecerasGPS, 'GPS Latitude');
				array_push($cabecerasGPS, 'GPS Longitude');
				array_push($cabecerasGPS, 'GPS Altitude');
				array_push($cabecerasGPS, 'GPS Accuracy');
				array_push($datosGPS, $cabecerasGPS);

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasGPS, $style);
				$writer->addRow($rowFromValues);

				// Todos los datos
				foreach($data as $value) {
					$row = [];
					// Datos perf del usuario
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					$first = true;

					// Datos GPS
					foreach($value->gps as $gps) {
						$rowGPS = [];
						foreach($parametros as $param) {
							// Si es el primero no tiene que añadir espacios vacíos
							if(!$first) {
								array_push($rowGPS, '');
							}
						}
						array_push($rowGPS, $gps->date);
						array_push($rowGPS, $gps->latitude);
						array_push($rowGPS, $gps->longitude);
						array_push($rowGPS, $gps->altitude);
						array_push($rowGPS, $gps->accuracy);
						// El primero dato se junta en la misma row del usuario, esto evita que ese quede un espacio vacío
						if($first) {
							foreach($rowGPS as $rowGPSValues) {
								array_push($row, $rowGPSValues);
							}
							array_push($datosGPS, $row);
							$rowFromValues = WriterEntityFactory::createRowFromArray($row);
							$writer->addRow($rowFromValues);
							$first = false;
						} else {
							array_push($datosGPS, $rowGPS);
							$rowFromValues = WriterEntityFactory::createRowFromArray($rowGPS);
							$writer->addRow($rowFromValues);
						}
					}
				}

				// Tercer TAB - Dispositivo/Marca/Sistema Operativo
				$newSheet = $writer->addNewSheetAndMakeItCurrent();
				$sheet = $writer->getCurrentSheet();
				$sheet->setName('Devices');

				$datosDevice = [];
				$cabecerasDevice = $cabeceras;
				array_push($cabecerasDevice, 'Date');
				array_push($cabecerasDevice, 'Model');
				array_push($cabecerasDevice, 'Manufacturer');
				array_push($cabecerasDevice, 'OS');
				array_push($datosDevice, $cabecerasDevice);

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasDevice, $style);
				$writer->addRow($rowFromValues);

				// Todos los datos
				foreach($data as $value) {
					$row = [];
					// Datos perf del usuario
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					$first = true;

					// Datos del Dispositivo
					foreach($value->device as $device) {
						$rowDevice = [];
						foreach($parametros as $param) {
							// Si es el primero no tiene que añadir espacios vacíos
							if(!$first) {
								array_push($rowDevice, '');
							}
						}
						array_push($rowDevice, $device->date);
						array_push($rowDevice, $device->model);
						array_push($rowDevice, $device->manufacturer);
						array_push($rowDevice, $device->platform);
						// El primero dato se junta en la misma row del usuario, esto evita que ese quede un espacio vacío
						if($first) {
							foreach($rowDevice as $rowDeviceValues) {
								array_push($row, $rowDeviceValues);
							}
							array_push($datosDevice, $row);
							$rowFromValues = WriterEntityFactory::createRowFromArray($row);
							$writer->addRow($rowFromValues);
							$first = false;
						} else {
							array_push($datosDevice, $rowDevice);
							$rowFromValues = WriterEntityFactory::createRowFromArray($rowDevice);
							$writer->addRow($rowFromValues);
						}
					}
				}

				// Cuarto TAB - Batería
				$newSheet = $writer->addNewSheetAndMakeItCurrent();
				$sheet = $writer->getCurrentSheet();
				$sheet->setName('Battery');

				$datosBattery = [];
				$cabecerasBattery = $cabeceras;
				array_push($cabecerasBattery, 'Date');
				array_push($cabecerasBattery, 'Charging');
				array_push($cabecerasBattery, 'Level');
				array_push($datosBattery, $cabecerasBattery);

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasBattery, $style);
				$writer->addRow($rowFromValues);
				// Todos los datos
				foreach($data as $value) {
					$row = [];
					// Datos perf del usuario
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					$first = true;

					// Datos del Dispositivo
					foreach($value->battery as $battery) {
						$rowBattery = [];
						foreach($parametros as $param) {
							// Si es el primero no tiene que añadir espacios vacíos
							if(!$first) {
								array_push($rowBattery, '');
							}
						}
						array_push($rowBattery, $battery->date);
						array_push($rowBattery, $battery->charging);
						array_push($rowBattery, $battery->level);
						// El primero dato se junta en la misma row del usuario, esto evita que ese quede un espacio vacío
						if($first) {
							foreach($rowBattery as $rowBatteryValues) {
								array_push($row, $rowBatteryValues);
							}
							array_push($datosBattery, $row);
							$rowFromValues = WriterEntityFactory::createRowFromArray($row);
							$writer->addRow($rowFromValues);
							$first = false;
						} else {
							array_push($datosBattery, $rowBattery);
							$rowFromValues = WriterEntityFactory::createRowFromArray($rowBattery);
							$writer->addRow($rowFromValues);
						}
					}
				}

				// Quinto TAB - Red
				$newSheet = $writer->addNewSheetAndMakeItCurrent();
				$sheet = $writer->getCurrentSheet();
				$sheet->setName('Network');

				$datosNetwork = [];
				$cabecerasNetwork = $cabeceras;
				array_push($cabecerasNetwork, 'Date');
				array_push($cabecerasNetwork, 'Type');
				array_push($datosNetwork, $cabecerasNetwork);

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasNetwork, $style);
				$writer->addRow($rowFromValues);
				// Todos los datos
				foreach($data as $value) {
					$row = [];
					// Datos perf del usuario
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					$first = true;

					// Datos del Dispositivo
					foreach($value->network as $network) {
						$rowNetwork = [];
						foreach($parametros as $param) {
							// Si es el primero no tiene que añadir espacios vacíos
							if(!$first) {
								array_push($rowNetwork, '');
							}
						}
						array_push($rowNetwork, $network->date);
						array_push($rowNetwork, $network->type);
						// El primero dato se junta en la misma row del usuario, esto evita que ese quede un espacio vacío
						if($first) {
							foreach($rowNetwork as $rowNetworkValues) {
								array_push($row, $rowNetworkValues);
							}
							array_push($datosNetwork, $row);
							$rowFromValues = WriterEntityFactory::createRowFromArray($row);
							$writer->addRow($rowFromValues);

							$first = false;
						} else {
							array_push($datosNetwork, $rowNetwork);
							$rowFromValues = WriterEntityFactory::createRowFromArray($rowNetwork);
							$writer->addRow($rowFromValues);
						}
					}
				}

				// Sexto TAB - Apps
				$newSheet = $writer->addNewSheetAndMakeItCurrent();
				$sheet = $writer->getCurrentSheet();
				$sheet->setName('Apps');

				$datosApps = [];
				$cabecerasApps = $cabeceras;
				array_push($cabecerasApps, 'Name');
				array_push($datosApps, $cabecerasApps);

				$rowFromValues = WriterEntityFactory::createRowFromArray($cabecerasApps, $style);
				$writer->addRow($rowFromValues);
				// Todos los datos
				foreach($data as $value) {
					$row = [];
					// Datos perf del usuario
					foreach($parametros as $param) {
						array_push($row, $value->$param);
					}

					$first = true;

					// Datos del Dispositivo
					foreach($value->apps as $app) {
						$rowApps = [];
						foreach($parametros as $param) {
							// Si es el primero no tiene que añadir espacios vacíos
							if(!$first) {
								array_push($rowApps, '');
							}
						}
						array_push($rowApps, $app->appName);
						// El primero dato se junta en la misma row del usuario, esto evita que ese quede un espacio vacío
						if($first) {
							foreach($rowApps as $rowAppsValues) {
								array_push($row, $rowAppsValues);
							}
							array_push($datosApps, $row);
							$rowFromValues = WriterEntityFactory::createRowFromArray($row);
							$writer->addRow($rowFromValues);
							$first = false;
						} else {
							array_push($datosApps, $rowApps);
							$rowFromValues = WriterEntityFactory::createRowFromArray($rowApps);
							$writer->addRow($rowFromValues);
						}
					}
				}

				$writer->close(); // Cierre excel nueva librería

				// Creación del archivo
				$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/passive_tracking';

				if(!file_exists($carpeta)) {
					mkdir($carpeta, 0777, true);
				}

				$filename = $nameExcel . '.xlsx';
				$filename = str_replace(' ', '_', $filename);

				$zip->open($folder . 'Passive_Tracking.zip', ZipArchive::CREATE);
				$zip->addFile($carpeta . '/' . $filename, 'Passive_Tracking.xlsx');
			}

			if($bPPT === true) {
				// Create new PHPPresentation object
				$objPHPPresentation = new PhpPresentation();
				$objPHPPresentation->getLayout()->setDocumentLayout('screen16x9');

				// Set properties
				$objPHPPresentation->getDocumentProperties()->setCreator('PHPOffice');

				// Remove first slide
				$objPHPPresentation->removeSlideByIndex(0);

				// Set Style
				$oFill = new Fill();
				$oFill->setFillType(Fill::FILL_SOLID)->setStartColor(new Color('000000')); //Fondo

				$oShadow = new Shadow();
				$oShadow->setVisible(true)->setDirection(45)->setDistance(10);

				// Generar todas las diapositivas
				GenerateTableExcel::createTitle($objPHPPresentation, $nameExcel, $idTenant);
				GenerateTableExcel::combinedImages($objPHPPresentation, $graphs[0], $graphs[1], 'Age', 'Gender', $idTenant);
				GenerateTableExcel::imageB64($objPHPPresentation, '', $graphs[2], $idTenant);
				GenerateTableExcel::imageB64($objPHPPresentation, '', $graphs[3], $idTenant);
				GenerateTableExcel::combinedImages($objPHPPresentation, $graphs[4], $graphs[5], 'Devices', 'Network', $idTenant);
				GenerateTableExcel::imageB64($objPHPPresentation, '', $graphs[6], $idTenant);

				for($i=7; $i < count($graphs); $i++) {
					GenerateTableExcel::imageB64($objPHPPresentation, '', $graphs[$i], $idTenant);
				}

				$carpeta = CONSTANTS::PATH_EXPORT_WORD . '/passive_tracking';

				if(!file_exists($carpeta)) {
					mkdir($carpeta, 0777, true);
				}
				$fecha = date_create();

				$filename = 'Passive_Tracking.pptx';

				$filename = str_replace(' ', '_', $filename);

				$oWriterPPTX = IOFactory::createWriter($objPHPPresentation, 'PowerPoint2007');
				$oWriterPPTX->save($carpeta . '/' . $filename);

				$excel = new GenerateExcel;

				$zip->open($folder . 'Passive_Tracking.zip', ZipArchive::CREATE);
				$zip->addFile($carpeta . '/' . $filename, 'Passive_Tracking.pptx');
			}

			$filename = 'Passive_Tracking.zip';
		} catch(Exception $e) {
			$filename = false;
		}

		return $filename;
	}

	public function imageB64(PhpPresentation $objPHPPresentation, $title, $image, $idTenant) {
		global $oFill;
		global $oShadow;
		// Create templated slide
		$currentSlide = GenerateTableExcel::createTemplatedSlide($objPHPPresentation, $title, $idTenant);
		$image = str_replace('image/png', 'image/jpeg', $image);

		// Add a file drawing (JPEG) to the slide
		$shape = new Drawing\Base64();
		$shape->setName('Word Cloud')
			->setDescription('Word Cloud')
			->setData($image)
			->setResizeProportional(false)
			->setHeight(400)
			->setWidth(800)
			->setOffsetX(70)
			->setOffsetY(110)
		;
		$currentSlide->addShape($shape);
	}

	public function createTemplatedSlide($objPHPPresentation, $title, $idTenant) {
		// Create slide
		$slide = $objPHPPresentation->createSlide();

		$oShapeDrawing = new Drawing\File();
		$oShapeDrawing->setName('PHPPresentation logo')
			->setDescription('PHPPresentation logo')
			->setPath(CONSTANTS::PATH_EXPORT_WORD . '/tenants/' . $idTenant . '/plantilla.PNG')
			->setHeight(800)
			->setWidth(960)
			->setOffsetX(0)
			->setOffsetY(0);

		$slide->addShape($oShapeDrawing);

		$shape = $slide->createRichTextShape()
			->setHeight(300)
			->setWidth(900)
			->setOffsetX(10)
			->setOffsetY(10);
		$shape->getActiveParagraph()->getAlignment()->setHorizontal(Alignment::HORIZONTAL_LEFT);

		$textRun = $shape->createTextRun($title);
		$textRun->getFont()->setBold(true)
			->setSize(12)
			->setColor(new Color('ffffff'))
			->setName($this->fontFamily);

		return $slide;
	}

	public function combinedImages(PhpPresentation $objPHPPresentation, $firstImage, $secondImage, $title1, $title2, $idTenant) {
		global $oFill;
		global $oShadow;
		// Create templated slide
		$currentSlide = GenerateTableExcel::createTemplatedSlide($objPHPPresentation, '', $idTenant);

		$firstImage = str_replace('image/png', 'image/jpeg', $firstImage);
		$secondImage = str_replace('image/png', 'image/jpeg', $secondImage);
		// Add a file drawing (JPEG) to the slide

		// Edad
		$shapeAge = new Drawing\Base64();
		$shapeAge->setName($title1)
			->setDescription($title1)
			->setData($firstImage)
			->setResizeProportional(false)
			->setHeight(400)
			->setWidth(500)
			->setOffsetX(50)
			->setOffsetY(90)
		;

		// Género
		$shapeGender = new Drawing\Base64();
		$shapeGender->setName($title2)
			->setDescription($title2)
			->setData($secondImage)
			->setResizeProportional(false)
			->setHeight(400)
			->setWidth(275)
			->setOffsetX(625)
			->setOffsetY(90)
		;

		$currentSlide->addShape($shapeAge);
		$currentSlide->addShape($shapeGender);
	}

	public function createTitle($objPHPPresentation, $title, $idTenant) {
		// Create slide
		$slide = $objPHPPresentation->createSlide();

		$oShapeDrawing = new Drawing\File();

		$oShapeDrawing->setName('PHPPresentation logo')
			->setDescription('PHPPresentation logo')
			->setPath(CONSTANTS::PATH_EXPORT_WORD . '/tenants/' . $idTenant . '/plantilla_portada.PNG')
			->setHeight(800)
			->setWidth(960)
			->setOffsetX(0)
			->setOffsetY(0);

		$slide->addShape($oShapeDrawing);

		$shape = $slide->createRichTextShape()
			->setHeight(600)
			->setWidth(900)
			->setOffsetX(10)
			->setOffsetY(50);
		$shape->getActiveParagraph()->getAlignment()
			->setHorizontal(Alignment::HORIZONTAL_CENTER)
			->setVertical(Alignment::HORIZONTAL_CENTER);

		$textRun = $shape->createTextRun($title);
		$textRun->getFont()->setBold(true)
			->setSize(50)
			->setColor(new Color('ffffff'))
			->setName($this->fontFamily);

		// Añadir fecha
		$shape = $slide->createRichTextShape()
			->setHeight(100)
			->setWidth(300)
			->setOffsetX(700)
			->setOffsetY(400);
		$shape->getActiveParagraph()->getAlignment()
			->setHorizontal(Alignment::HORIZONTAL_CENTER)
			->setVertical(Alignment::HORIZONTAL_CENTER);

		$meses_ES = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
		$meses_EN = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
		$month = str_replace($meses_EN, $meses_ES, date('F'));
		$year = date('Y');
		$textRun = $shape->createTextRun($month . ', ' . $year);
		$textRun->getFont()->setBold(false)
			->setName($this->fontFamily)
			->setSize(20)
			->setColor(new Color('ffffff'));

		return $slide;
	}
}