let RolesBackendNewController = {
	addOnPermissionsFlag: false,
	addOnPermissions: [],
	addOnFlag: false,
	addOns: '',
	seccionFlag: false,
	secciones: '',
	permissions: [],
	addOnsIndex: '',
	idAddOn: '',
	idAddOnIndex: '',

	reset() {
		let self = this;

		self.addOnPermissionsFlag = false;
		self.addOnPermissions = [];
		self.addOnFlag = false;
		self.addOns = '';
		self.seccionFlag = false;
		self.secciones = '';
		self.permissions = [];
		self.addOnsIndex = '';
		self.idAddOn = '';
		self.idAddOnIndex = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);

		// Ocultar la sección Permisos AddOn para CPGs que no sean 0
		let idCPG = user.idCPG;
		if(idCPG != '0') {
			$('#addOnP').hide();
		}

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1278 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'backRoles',
			save: 'saveRoles'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#saveRoles').addClass('main-button');

		// Botones secundarios
		$('#backRoles').addClass('secondary-button');

		self.loadLang();

		// Crear HTML de permisos
		stcmbackend.rolesBackend.createPermissionsSection(self);

		self.applyEvents();

		stcmbackend.rolesBackend.tableAddOnPermissions(self);

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		let arrayStrong = ['RSC123'];
		pf.rsc.translateByTagHTMLFormat('strong', arrayStrong);

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.acceptTitle').attr('title', pf.const.language.RSC141);
	},

	applyEvents() {
		let self = this;

		// Guardar nuevo rol
		$('#saveRoles').on('click', function() {
			let rol = $('#rolName').val().trim();
			if(rol == '') {
				let warningTitle = pf.const.language.RSC1278;
				let warningContent = pf.const.language.RSC265;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			} else {
				self.newAdminRoleMenu(rol);
			}
		});

		stcmbackend.rolesBackend.applyEvents(self);
	},

	newAdminRoleMenu(rol) {
		let self = this;

		let parameters = {
			role: rol,
			addOnPermissions: JSON.stringify(self.addOnPermissions)
		};

		let size = self.permissions.length;
		for(let i = 0; i < size; i++) {
			parameters[self.permissions[i].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].switchID).prop('checked') === true ? 1 : 0);

			let sizeB = self.permissions[i].subSections.length;
			for(let j = 0; j < sizeB; j++) {
				parameters[self.permissions[i].subSections[j].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].subSections[j].switchID).prop('checked') === true ? 1 : 0);

				let sizeC = self.permissions[i].subSections[j].subSections.length;
				for(let k = 0; k < sizeC; k++) {
					parameters[self.permissions[i].subSections[j].subSections[k].switchID.replace('rp_', '')] = ($('#' + self.permissions[i].subSections[j].subSections[k].switchID).prop('checked') === true ? 1 : 0);
				}
			}
		}

		ajaxComunCallWithCallback('newAdminRoleMenu', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1278;
				let successContent = pf.const.language.RSC266;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!roles_backend';
			}
		});
	}
};