stcmbackend.rolesBackend = {
	applyEvents(self) {
		// Vover a Roles
		$('#backRoles').on('click', function() {
			window.location.href = '#!roles_backend';
		});

		// Añadir permisos de AddOn
		$('#newPerm').off().on('click', function() {
			let obj = {
				idAddon: '',
				nameAddon: '',
				idSection: '',
				visible: 0
			};
			self.addOnPermissions.push(obj);
			stcmbackend.rolesBackend.tableAddOnPermissions(self);
		});

		// Control de switchs
		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.pSwitch').prop('checked', this.checked);
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.pSwitch').on('click', function() {
			let id = $(this).attr('id');
			let checked = $(this).prop('checked');

			// Control para activar padres
			if(checked) {
				if($(this).hasClass('usersSW')) {
					// Comunidad > Usuarios
					$('#rp_usuarios').prop('checked', true);
					$('#rp_backendshowcommunity').prop('checked', true);
				} else if($(this).hasClass('segmentationsSW')) {
					// Comunidad > Segmentaciones
					$('#rp_segmentaciones').prop('checked', true);
					$('#rp_backendshowcommunity').prop('checked', true);
				} else if($(this).hasClass('communitySW')) {
					// Comunidad
					$('#rp_backendshowcommunity').prop('checked', true);
				} else if($(this).hasClass('notificationsSW')) {
					// Notificaciones
					$('#rp_backendshownotificaciones').prop('checked', true);
				} else if($(this).hasClass('operationsProductsSW')) {
					// Operar > Productos
					$('#rp_collapse_productos').prop('checked', true);
					$('#rp_backendshowoperations').prop('checked', true);
				} else if($(this).hasClass('operationsProjectsSW')) {
					// Operar > Proyectos
					$('#rp_collapse_proyectos').prop('checked', true);
					$('#rp_backendshowoperations').prop('checked', true);
				} else if($(this).hasClass('operationsMissionsSW')) {
					// Operar > Misiones
					$('#rp_collapse_misiones').prop('checked', true);
					$('#rp_backendshowoperations').prop('checked', true);
				} else if($(this).hasClass('operationsSurveyGeneratorSW')) {
					// Operar > Formulario encuestas
					$('#rp_collapse_encuestas').prop('checked', true);
					$('#rp_backendshowoperations').prop('checked', true);
				} else if($(this).hasClass('operationsSW')) {
					// Operar
					$('#rp_backendshowoperations').prop('checked', true);
				} else if($(this).hasClass('analyticsCommunitySW')) {
					// Analytics > Comunidad
					$('#rp_collapse_analyticcomunidad').prop('checked', true);
					$('#rp_backendshowanalytics').prop('checked', true);
				} else if($(this).hasClass('samplingSW')) {
					// Analytics > Muestreo
					$('#rp_collapse_muestreo').prop('checked', true);
					$('#rp_backendshowanalytics').prop('checked', true);
				} else if($(this).hasClass('operationalSW')) {
					// Analytics > Operativo
					$('#rp_collapse_operativo').prop('checked', true);
					$('#rp_backendshowanalytics').prop('checked', true);
				} else if($(this).hasClass('analyticsSW')) {
					// Analytics
					$('#rp_backendshowanalytics').prop('checked', true);
				} else if($(this).hasClass('rewardsRemunerationSW')) {
					// Recompensas > Pagos
					$('#rp_collapse_pagos').prop('checked', true);
					$('#rp_backendshowrewards').prop('checked', true);
				} else if($(this).hasClass('rewardsCatalogueSW')) {
					// Recompensas > Catálogos
					$('#rp_collapse_catalogorecompensas').prop('checked', true);
					$('#rp_backendshowrewards').prop('checked', true);
				} else if($(this).hasClass('rewardsSW')) {
					// Recompensas
					$('#rp_backendshowrewards').prop('checked', true);
				} else if($(this).hasClass('storesSW')) {
					// Items > tiendas
					$('#rp_backendshowStores').prop('checked', true);
					$('#rp_backendshowConsumo').prop('checked', true);
				} else if($(this).hasClass('consumoSW')) {
					// Items
					$('#rp_backendshowConsumo').prop('checked', true);
				} else if($(this).hasClass('functionalExtensionSW')) {
					// Extesión funcional
					$('#rp_backendshowintegraciones').prop('checked', true);
				} else if($(this).hasClass('tenantsSW')) {
					// Multi tenant
					$('#rp_backendshowtenants').prop('checked', true);
				} else if($(this).hasClass('CPGSW')) {
					// CPG
					$('#rp_backendshowcpg').prop('checked', true);
				} else if($(this).hasClass('clientsSW')) {
					// Clientes
					$('#rp_backendshowclients').prop('checked', true);
				} else if($(this).hasClass('administratorsBESW')) {
					// Administradores BackEnd
					$('#rp_collapse_administradores').prop('checked', true);
				} else if($(this).hasClass('settingsSW')) {
					// Ajustes
					$('#rp_backendshowajustes').prop('checked', true);
				} else if($(this).hasClass('configurationSW')) {
					// Configuración
					$('#rp_collapse_configuracion').prop('checked', true);
				}
			}

			// Control de elementos de sección
			switch(id) {
				case 'rp_backendshowcommunity':
					$('.communitySW').prop('checked', this.checked);
				break;
				case 'rp_usuarios':
					if(!checked) {
						$('.usersSW').prop('checked', this.checked);
					}
				break;
				case 'rp_segmentaciones':
					if(!checked) {
						$('.segmentationsSW').prop('checked', this.checked);
					}
				break;
				case 'rp_backendshownotificaciones':
					$('.notificationsSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowoperations':
					$('.operationsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_productos':
					$('.operationsProductsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_proyectos':
					$('.operationsProjectsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_misiones':
					$('.operationsMissionsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_encuestas':
					$('.operationsSurveyGeneratorSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowanalytics':
					$('.analyticsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_analyticcomunidad':
					$('.analyticsCommunitySW').prop('checked', this.checked);
				break;
				case 'rp_collapse_muestreo':
					$('.samplingSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_operativo':
					$('.operationalSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowrewards':
					$('.rewardsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_pagos':
					$('.rewardsRemunerationSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_catalogorecompensas':
					$('.rewardsCatalogueSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowConsumo':
					$('.consumoSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowStores':
					$('.storesSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowintegraciones':
					$('.functionalExtensionSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowtenants':
					$('.tenantsSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowcpg':
					$('.CPGSW').prop('checked', this.checked);
				break;
				case 'rp_backendshowclients':
					$('.clientsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_administradores':
					$('.administratorsBESW').prop('checked', this.checked);
				break;
				case 'rp_backendshowajustes':
					$('.settingsSW').prop('checked', this.checked);
				break;
				case 'rp_collapse_configuracion':
					$('.configurationSW').prop('checked', this.checked);
				break;
			}

			// Switch Comunidad
			if($('.communitySW:checked').length == 0) {
				$('#rp_backendshowcommunity').prop('checked', false);
			}

			// Switch Notificaciones
			if($('.notificationsSW:checked').length == 0) {
				$('#rp_backendshownotificaciones').prop('checked', false);
			}

			// Switch Operar > Productos
			if($('.operationsProductsSW:checked').length == 0) {
				$('#rp_collapse_productos').prop('checked', false);
			}

			// Switch Operar > Proyectos
			if($('.operationsProjectsSW:checked').length == 0) {
				$('#rp_collapse_proyectos').prop('checked', false);
			}

			// Switch Operar > Misiones
			if($('.operationsMissionsSW:checked').length == 0) {
				$('#rp_collapse_misiones').prop('checked', false);
			}

			// Switch Operar > Formulario encuestas
			if($('.operationsSurveyGeneratorSW:checked').length == 0) {
				$('#rp_collapse_encuestas').prop('checked', false);
			}

			// Switch Operar
			if($('.operationsSW:checked').length == 0) {
				$('#rp_backendshowoperations').prop('checked', false);
			}

			// Switch Analytics > Comunidad
			if($('.analyticsCommunitySW:checked').length == 0) {
				$('#rp_collapse_analyticcomunidad').prop('checked', false);
			}

			// Switch Analytics > Muestreos
			if($('.samplingSW:checked').length == 0) {
				$('#rp_collapse_muestreo').prop('checked', false);
			}

			// Switch Analytics > Operativo
			if($('.operationalSW:checked').length == 0) {
				$('#rp_collapse_operativo').prop('checked', false);
			}

			// Switch Analytics
			if($('.analyticsSW:checked').length == 0) {
				$('#rp_backendshowanalytics').prop('checked', false);
			}

			// Switch Recompensas > Pagos
			if($('.rewardsRemunerationSW:checked').length == 0) {
				$('#rp_collapse_pagos').prop('checked', false);
			}

			// Switch Recompensas > Catálogos
			if($('.rewardsCatalogueSW:checked').length == 0) {
				$('#rp_collapse_catalogorecompensas').prop('checked', false);
			}

			// Switch Recompensas
			if($('.rewardsSW:checked').length == 0) {
				$('#rp_backendshowrewards').prop('checked', false);
			}

			// Switch Consumo > Tiendas
			if($('.storesSW:checked').length == 0) {
				$('#rp_backendshowStores').prop('checked', false);
			}

			// Switch Consumo
			if($('.consumoSW:checked').length == 0) {
				$('#rp_backendshowConsumo').prop('checked', false);
			}

			// Switch Extensión funcional
			if($('.functionalExtensionSW:checked').length == 0) {
				$('#rp_backendshowintegraciones').prop('checked', false);
			}

			// Switch Multi tenant
			if($('.tenantsSW:checked').length == 0) {
				$('#rp_backendshowtenants').prop('checked', false);
			}

			// Switch CPG
			if($('.CPGSW:checked').length == 0) {
				$('#rp_backendshowcpg').prop('checked', false);
			}

			// Switch Clientes
			if($('.clientsSW:checked').length == 0) {
				$('#rp_backendshowclients').prop('checked', false);
			}

			// Switch Administradores BackEnd
			if($('.administratorsBESW:checked').length == 0) {
				$('#rp_collapse_administradores').prop('checked', false);
			}

			// Switch Ajustes
			if($('.settingsSW:checked').length == 0) {
				$('#rp_backendshowajustes').prop('checked', false);
			}

			// Switch Configuración
			if($('.configurationSW:checked').length == 0) {
				$('#rp_collapse_configuracion').prop('checked', false);
			}

			// Switch general
			if($('.pSwitch').length == $('.pSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}
		});
	},

	createPermissionsSection(self) {
		self.permissions = [
			{
				name: pf.const.language.RSC2044,
				switchID: 'rp_backendshowcommunity',
				collapseID: 'communityCollapse',
				childsClass: 'communitySW',
				subSections: [
					{
						name: pf.const.language.RSC2,
						switchID: 'rp_usuarios',
						collapseID: 'usersCollapse',
						childsClass: 'usersSW',
						subSections: [
							{
								name: pf.const.language.RSC1947,
								switchID: 'rp_addUsers'
							}
						]
					}, {
						name: pf.const.language.RSC325,
						switchID: 'rp_usuarios_importar',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC17,
						switchID: 'rp_roles',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, 
					// {
					// 	name: pf.const.language.RSC1741,
					// 	switchID: 'rp_segmentaciones',
					// 	collapseID: 'segmentationsCollapse',
					// 	childsClass: 'segmentationsSW',
					// 	subSections: [
					// 		{
					// 			name: pf.const.language.RSC1910,
					// 			switchID: 'rp_editsegmentations'
					// 		},
					// 		{
					// 			name: pf.const.language.RSC1973,
					// 			switchID: 'rp_segmentaciones_automatizadas'
					// 		}
					// 	]
					// },
					{
						name: pf.const.language.RSC6,
						switchID: 'rp_grupos',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC12,
						switchID: 'rp_difusion',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC11,
				switchID: 'rp_backendshownotificaciones',
				collapseID: 'notificationsCollapse',
				childsClass: 'notificationsSW',
				subSections: [
					{
						name: pf.const.language.RSC9,
						switchID: 'rp_notificaciones',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC24,
						switchID: 'rp_notificaciones_consejeros',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2171,
						switchID: 'rp_notificaciones_consejeros_telf',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1876,
						switchID: 'rp_notificaciones_pre_consejeros',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1835,
						switchID: 'rp_notificaciones_cola',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2234,
						switchID: 'rp_pop_ups',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC2045,
				switchID: 'rp_backendshowoperations',
				collapseID: 'operationsCollapse',
				childsClass: 'operationsSW',
				subSections: [
					{
						name: pf.const.language.RSC2048,
						switchID: 'rp_collapse_productos',
						collapseID: 'productsCollapse',
						childsClass: 'operationsProductsSW',
						subSections: [
							{
								name: pf.const.language.RSC3,
								switchID: 'rp_productos'
							}, {
								name: pf.const.language.RSC566,
								switchID: 'rp_templates'
							}
						]
					}, {
						name: pf.const.language.RSC10,
						switchID: 'rp_collapse_proyectos',
						collapseID: 'projectsCollapse',
						childsClass: 'operationsProjectsSW',
						subSections: [
							{
								name: pf.const.language.RSC3,
								switchID: 'rp_proyectos'
							}, {
								name: pf.const.language.RSC23,
								switchID: 'rp_expulsion'
							}
						]
					}, {
						name: pf.const.language.RSC14,
						switchID: 'rp_collapse_misiones',
						collapseID: 'missionsCollapse',
						childsClass: 'operationsMissionsSW',
						subSections: [
							{
								name: pf.const.language.RSC9,
								switchID: 'rp_misiones'
							}, {
								name: pf.const.language.RSC338,
								switchID: 'rp_misiones_type'
							}, {
								name: pf.const.language.RSC28,
								switchID: 'rp_cumplimiento'
							}, {
								name: pf.const.language.RSC960,
								switchID: 'rp_misiones_cola'
							}, {
								name: pf.const.language.RSC2746,
								switchID: 'rp_misiones_urls'
							}, {
								name: pf.const.language.RSC2357,
								switchID: 'rp_alta_misiones'
							}, {
								name: pf.const.language.RSC2358,
								switchID: 'rp_edicion_misiones'
							}, {
								name: pf.const.language.RSC2359,
								switchID: 'rp_borrado_misiones'
							}
						]
					}, {
						name: pf.const.language.RSC13,
						switchID: 'rp_collapse_encuestas',
						collapseID: 'surveyFormCollapse',
						childsClass: 'operationsSurveyGeneratorSW',
						subSections: [
							{
								name: pf.const.language.RSC25,
								switchID: 'rp_generador_encuestas'
							}, {
								name: pf.const.language.RSC1404,
								switchID: 'rp_rotaciones'
							}
						]
					}
				]
			}, {
				name: pf.const.language.RSC66,
				switchID: 'rp_backendshowanalytics',
				collapseID: 'analyticsCollapse',
				childsClass: 'analyticsSW',
				subSections: [
					{
						name: pf.const.language.RSC2044,
						switchID: 'rp_collapse_analyticcomunidad',
						collapseID: 'communityCollapse',
						childsClass: 'analyticsCommunitySW',
						subSections: [
							{
								name: pf.const.language.RSC32,
								switchID: 'rp_asesores'
							}, {
								name: pf.const.language.RSC34,
								switchID: 'rp_word_cloud'
							}, {
								name: pf.const.language.RSC36,
								switchID: 'rp_conversaciones'
							}, {
								name: pf.const.language.RSC39,
								switchID: 'rp_catalogacion'
							}, {
								name: pf.const.language.RSC519,
								switchID: 'rp_licencias'
							}, {
								name: pf.const.language.RSC611,
								switchID: 'rp_perfilacionsinfinalizar'
							}, {
								name: pf.const.language.RSC1804,
								switchID: 'rp_stores'
							}
						]
					}, {
						name: pf.const.language.RSC2046,
						switchID: 'rp_collapse_muestreo',
						collapseID: 'samplingCollapse',
						childsClass: 'samplingSW',
						subSections: [
							{
								name: pf.const.language.RSC35,
								switchID: 'rp_muestreo'
							}, {
								name: pf.const.language.RSC2426,
								switchID: 'rp_muestreo_dinamico'
							},{
								name: pf.const.language.RSC963,
								switchID: 'rp_muestreodetallado'
							}, {
								name: pf.const.language.RSC1796,
								switchID: 'rp_muestreodetallado_maz'
							}, {
								name: pf.const.language.RSC1874,
								switchID: 'rp_muestreodetallado_maz_seg'
							}, {
								name: pf.const.language.RSC2361,
								switchID: 'rp_muestreodetalladocomparativo'
							}, {
								name: pf.const.language.RSC45,
								switchID: 'rp_muestreocomparativo'
							}
						]
					}, {
						name: pf.const.language.RSC2047,
						switchID: 'rp_collapse_operativo',
						collapseID: 'operationalCollapse',
						childsClass: 'operationalSW',
						subSections: [
							{
								name: pf.const.language.RSC33,
								switchID: 'rp_cumplimientos'
							}, {
								name: pf.const.language.RSC37,
								switchID: 'rp_inversion'
							}, {
								name: pf.const.language.RSC1831,
								switchID: 'rp_kpi_surveys'
							}, {
								name: pf.const.language.RSC2753,
								switchID: 'rp_tiempo_respuesta'
							}
						]
					}, {
						name: pf.const.language.RSC612,
						switchID: 'rp_cdp',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1065,
						switchID: 'rp_cubos',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1271,
						switchID: 'rp_passiveTracking',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2346,
						switchID: 'rp_diferenciassignificativas',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2347,
						switchID: 'rp_plantillas_reportes',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC1901,
				switchID: 'rp_backendshowrewards',
				collapseID: 'rewardsCollapse',
				childsClass: 'rewardsSW',
				subSections: [
					{
						name: pf.const.language.RSC16,
						switchID: 'rp_collapse_pagos',
						collapseID: 'remunerationCollapse',
						childsClass: 'rewardsRemunerationSW',
						subSections: [
							{
								name: pf.const.language.RSC30,
								switchID: 'rp_pagos'
							}, {
								name: pf.const.language.RSC31,
								switchID: 'rp_pagos_archivo'
							}, {
								name: pf.const.language.RSC504,
								switchID: 'rp_pagos_detalle'
							}, {
								name: pf.const.language.RSC1330,
								switchID: 'rp_pagos_automatizados'
							}
						]
					}, {
						name: pf.const.language.RSC1885,
						switchID: 'rp_collapse_catalogorecompensas',
						collapseID: 'catalogsCollapse',
						childsClass: 'rewardsCatalogueSW',
						subSections: [
							{
								name: pf.const.language.RSC1967,
								switchID: 'rp_articulos_catalogo'
							}, {
								name: pf.const.language.RSC1885,
								switchID: 'rp_catalogos'
							}
						]
					}
				]
			}, {
				name: pf.const.language.RSC618,
				switchID: 'rp_backendshowConsumo',
				collapseID: 'consumoCollapse',
				childsClass: 'consumoSW',
				subSections: [
					{
						name: pf.const.language.RSC1892,
						switchID: 'rp_backendshowitems',
						collapseID: 'itemsCollapse',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2473,
						switchID: 'rp_backendshowStores',
						collapseID: 'storesCollapse',
						childsClass: 'storesSW',
						subSections: [
							{
								name: pf.const.language.RSC3,
								switchID: 'rp_show_all_stores',
								collapseID: '',
								childsClass: '',
								subSections: []
							}, {
								name: pf.const.language.RSC2475,
								switchID: 'rp_show_stores_type',
								collapseID: '',
								childsClass: '',
								subSections: []
							}
						]
					}
				]
			}, {
				name: pf.const.language.RSC22,
				switchID: 'rp_backendshowintegraciones',
				collapseID: 'functionalExtensionCollapse',
				childsClass: 'functionalExtensionSW',
				subSections: [
					{
						name: pf.const.language.RSC44,
						switchID: 'rp_html',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1246,
						switchID: 'rp_addons',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2393,
						switchID: 'rp_voiceAssistant',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC2416,
						switchID: 'rp_hashtag',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC1539,
				switchID: 'rp_backendshowtenants',
				collapseID: 'tenantCollapse',
				childsClass: 'tenantsSW',
				subSections: [
					{
						name: pf.const.language.RSC3,
						switchID: 'rp_tenant',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC519,
						switchID: 'rp_tenant_licenses',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC1716,
				switchID: 'rp_backendshowcpg',
				collapseID: 'CPGCollapse',
				childsClass: 'CPGSW',
				subSections: [
					{
						name: pf.const.language.RSC3,
						switchID: 'rp_cpg',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC519,
						switchID: 'rp_cpg_licenses',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC2363,
				switchID: 'rp_backendshowclients',
				collapseID: 'clientsCollapse',
				childsClass: 'clientsSW',
				subSections: [
					{
						name: pf.const.language.RSC3,
						switchID: 'rp_show_all_clients',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC21,
				switchID: 'rp_collapse_administradores',
				collapseID: 'backEndAdministratorsCollapse',
				childsClass: 'administratorsBESW',
				subSections: [
					{
						name: pf.const.language.RSC3,
						switchID: 'rp_administradores_backend',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC17,
						switchID: 'rp_roles_backend',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC1354,
				switchID: 'rp_backendshowajustes',
				collapseID: 'settingsCollapse',
				childsClass: 'settingsSW',
				subSections: [
					{
						name: pf.const.language.RSC2134,
						switchID: 'rp_welcometour',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC42,
						switchID: 'rp_dominios_embebidos',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC43,
						switchID: 'rp_bots',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC38,
						switchID: 'rp_definicion_catalogacion_asesores',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC515,
						switchID: 'rp_perfilacion',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1520,
						switchID: 'rp_formulario_registro',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC549,
						switchID: 'rp_paises',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC551,
						switchID: 'rp_idiomas',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC553,
						switchID: 'rp_perfiles',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1838,
						switchID: 'rp_exclusiones_wordcloud',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}, {
				name: pf.const.language.RSC20,
				switchID: 'rp_collapse_configuracion',
				collapseID: 'configurationCollapse',
				childsClass: 'configurationSW',
				subSections: [
					{
						name: pf.const.language.RSC41,
						switchID: 'rp_configuracion',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC623,
						switchID: 'rp_funcionalidades_app',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC19,
						switchID: 'rp_logs',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC466,
						switchID: 'rp_rsc',
						collapseID: '',
						childsClass: '',
						subSections: []
					}, {
						name: pf.const.language.RSC1942,
						switchID: 'rp_table_information',
						collapseID: '',
						childsClass: '',
						subSections: []
					}
				]
			}
		];

		let secctionsContent = '';
		let size = self.permissions.length;
		for(let i = 0; i < size; i++) {
			secctionsContent += `
				<div class="m-0 p-0 mb-3">
					<div class="card border-bottom-0">
						<div class="card-header d-flex align-items-center">
							<strong>${self.permissions[i].name}</strong>

							<button type="button" class="btn btn-link text-body text-decoration-none arrow" data-toggle="collapse" data-target="#${self.permissions[i].collapseID}" data-arrow="left" data-sub="1">
								${stcmbackend.svg.chevronRight}
							</button>

							<div class="custom-control custom-switch ml-auto">
								<input id="${self.permissions[i].switchID}" type="checkbox" class="custom-control-input pSwitch">
								<label for="${self.permissions[i].switchID}" class="custom-control-label c-pointer"></label>
							</div>
						</div>

						<div id="${self.permissions[i].collapseID}" class="card-body p-0 collapse">
			`;

			let sizeB = self.permissions[i].subSections.length;
			for(let j = 0; j < sizeB; j++) {
				let sizeC = self.permissions[i].subSections[j].subSections.length;

				if(sizeC > 0) {
					secctionsContent += `
						<div class="card border-top-0 border-right-0 border-left-0">
							<div class="card-header d-flex align-items-center border-0">
								<span>${self.permissions[i].subSections[j].name}</span>

								<button type="button" class="btn btn-link text-body text-decoration-none arrow py-0" data-toggle="collapse" data-target="#${self.permissions[i].subSections[j].collapseID}" data-arrow="down" data-sub="2">
									${stcmbackend.svg.chevronDown}
								</button>

								<div class="custom-control custom-switch ml-auto">
									<input id="${self.permissions[i].subSections[j].switchID}" type="checkbox" class="custom-control-input pSwitch ${self.permissions[i].childsClass}">
									<label for="${self.permissions[i].subSections[j].switchID}" class="custom-control-label c-pointer"></label>
								</div>
							</div>

							<div id="${self.permissions[i].subSections[j].collapseID}" class="card-body pb-0 border-0 collapse show">
					`;

					for(let k = 0; k < sizeC; k++) {
						secctionsContent += `
							<div class="form-group d-flex pl-3">
								<span>${self.permissions[i].subSections[j].subSections[k].name}</span>
								<div class="custom-control custom-switch d-inline-block ml-auto">
									<input id="${self.permissions[i].subSections[j].subSections[k].switchID}" type="checkbox" class="custom-control-input pSwitch ${self.permissions[i].childsClass} ${self.permissions[i].subSections[j].childsClass}">
									<label for="${self.permissions[i].subSections[j].subSections[k].switchID}" class="custom-control-label c-pointer"></label>
								</div>
							</div>
						`;
					}

					secctionsContent += `
							</div>
						</div>
					`;
				} else {
					secctionsContent += `
						<div class="card border-0">
							<div class="card-header d-flex align-items-center">
								<span>${self.permissions[i].subSections[j].name}</span>

								<div class="custom-control custom-switch ml-auto">
									<input id="${self.permissions[i].subSections[j].switchID}" type="checkbox" class="custom-control-input pSwitch ${self.permissions[i].childsClass}">
									<label for="${self.permissions[i].subSections[j].switchID}" class="custom-control-label c-pointer"></label>
								</div>
							</div>
						</div>
					`;
				}
			}

			secctionsContent += `
						</div>
					</div>
				</div>
			`;
		}

		$('#resultTable').html(secctionsContent);
	},

	tableAddOnPermissions(self) {
		if(self.addOnPermissionsFlag) {
			$('#tableAddOnPermissions').dataTable().fnDestroy();
		} else {
			self.addOnPermissionsFlag = true;
		}

		let table = `
			<table id="tableAddOnPermissions" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC1246}">${pf.const.language.RSC1246}</th>
						<th scope="col" title="${pf.const.language.RSC122}">
							${pf.const.language.RSC122}
							<span class="float-right">${pf.const.language.RSC278}:</span>
						</th>
						<th scope="col" title="${pf.const.language.RSC1071}">
							<div class="custom-control custom-switch">
								<input id="allSwitchsAO" type="checkbox" class="custom-control-input">
								<label for="allSwitchsAO" class="custom-control-label c-pointer"></label>
							</div>
						</th>
						<th scope="col" title=""></th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.addOnPermissions.length;
		if(size < 1) {
			let obj = {
				idAddon: '',
				nameAddon: '',
				idSection: '',
				visible: 0
			};
			self.addOnPermissions.push(obj);
			size = 1;
		}

		for(let i = 0; i < size; i++) {
			let idAddon = self.addOnPermissions[i].idAddon;
			let nameAddon = self.addOnPermissions[i].nameAddon;
			let idSection = self.addOnPermissions[i].idSection;
			let disabled = idAddon == '' ? 'disabled' : '';
			let visible = self.addOnPermissions[i].visible == '1' ? 'checked' : '';

			table += `
				<tr data-id="${i}">
					<td class="text-truncate p-1">
						<span class="d-none">${nameAddon}</span>
						<div class="form-group mb-0">
							<div class="input-group new-input-style">
								<input id="AddonSelect_${i}" type="text" class="form-control" placeholder="${pf.const.language.RSC1246}" value="${nameAddon}" title="${nameAddon}" disabled>
								<div class="input-group-append">
									<button id="btn-Addon_${i}" type="button" class="btn btn-outline-secondary btn-Addon" data-toggle="modal" data-target="#modalAddon">
										${stcmbackend.svg.threeDots}
									</button>
								</div>
							</div>
						</div>
					</td>
					<td class="text-truncate p-1">
						<span class="d-none">${idSection}</span>
						<div class="form-group mb-0">
							<div class="input-group new-input-style">
								<input id="SeccionSelect_${i}" type="text" class="form-control" placeholder="${pf.const.language.RSC122}" value="${idSection}" title="${idSection}" disabled>
								<div class="input-group-append">
									<button id="btn-Seccion_${i}" type="button" class="btn btn-outline-secondary btn-Seccion" data-toggle="modal" data-target="#modalSeccion" ${disabled}>
										${stcmbackend.svg.threeDots}
									</button>
								</div>
							</div>
						</div>
					</td>
					<td class="text-center">
						<div class="custom-control custom-switch">
							<input id="def_${i}" type="checkbox" class="custom-control-input uSwitchAO" ${visible}>
							<label id="label_${i}" for="def_${i}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
					<td class="text-center" title="${pf.const.language.RSC226}">
						<span class="c-pointer deletePermisoObj">
							${stcmbackend.svg.bigTrash}
						</span>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#addOnCollapse').html(table);

		let tableAddOnPermissions = $('#tableAddOnPermissions').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			autoWidth: false,
			columnDefs: [
				{width: '55px', targets: 2},
				{width: '30px', targets: 3}
			],
			ordering: false,
			order: [[0, 'asc'], [1, 'asc']],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1557,
				className: 'd-none',
				title: pf.const.language.RSC1557,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		// Ocultar botones de tabla
		hideTableButtons('tableAddOnPermissions');

		// Exportar tabla
		$('#exportAddOn').off().on('click', function() {
			$('#addOnCollapse .buttons-excel').trigger('click');
		});

		if($('.uSwitchAO').length == $('.uSwitchAO:checked').length) {
			$('#allSwitchsAO').prop('checked', true);
		} else {
			$('#allSwitchsAO').prop('checked', false);
		}

		stcmbackend.rolesBackend.tableAddOnPermissionsEvents(self);
	},

	tableAddOnPermissionsEvents(self) {
		// Modal de AddOns
		$('.btn-Addon').off().on('click', function() {
			self.addOnsIndex = $(this).attr('id').replace('btn-Addon_', '');
			if(self.addOnFlag) {
				$('#tableAddon').dataTable().fnDestroy();
			} else {
				self.addOnFlag = true;
			}

			ajaxComunCallWithCallback('getAllAddOnsEnabled', {}, function(ajaxReturn) {
				if(ajaxReturn) {
					self.addOns = ajaxReturn.result;

					// Modal de AddOns
					stcmbackend.rolesBackend.renderAddOns(self.addOnsIndex, self);
				}
			});
		});

		// Modal de Secciones
		$('.btn-Seccion').off().on('click', function() {
			self.idAddOnIndex = $(this).attr('id').replace('btn-Seccion_', '');
			self.idAddOn = self.addOnPermissions[self.idAddOnIndex].idAddon;
			if(self.seccionFlag) {
				$('#tableSecciones').dataTable().fnDestroy();
			} else {
				self.seccionFlag = true;
			}

			let parameters = {
				idAddon: self.idAddOn
			};
			ajaxComunCallWithCallback('getAllAddOnsSection', parameters, function(ajaxReturn) {
				if(ajaxReturn) {
					self.secciones = ajaxReturn.result;

					// Modal de Secciones
					stcmbackend.rolesBackend.renderSecciones(self.idAddOnIndex, self);
				}
			});
		});

		// Visible
		$('.uSwitchAO').off().on('change', function() {
			let index = $(this).attr('id').replace('def_', '');
			if($(this).prop('checked')) {
				self.addOnPermissions[index].visible = 1;
			} else {
				self.addOnPermissions[index].visible = 0;
			}
		});

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchsAO').on('click', function() {
			$('.uSwitchAO').prop('checked', this.checked);
			let visible = (this.checked ? 1 : 0);
			for(let i = 0; i < self.addOnPermissions.length; i++) {
				self.addOnPermissions[i].visible = visible;
			}
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitchAO').on('click', function() {
			if($('.uSwitchAO').length == $('.uSwitchAO:checked').length) {
				$('#allSwitchsAO').prop('checked', true);
			} else {
				$('#allSwitchsAO').prop('checked', false);
			}
		});

		// Eliminar registro
		$('.deletePermisoObj').off().on('click', function() {
			let index = $(this).parent().parent().data('id');
			self.addOnPermissions.splice(index, 1);
			stcmbackend.rolesBackend.tableAddOnPermissions(self);
		});
	},

	renderAddOns(index, self) {
		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC1247}">${pf.const.language.RSC1247}</th>
					<th scope="col" title="${pf.const.language.RSC355}">${pf.const.language.RSC355}</th>
					<th scope="col" title="${pf.const.language.RSC1248}">${pf.const.language.RSC1248}</th>
					<th scope="col" title="${pf.const.language.RSC1249}">${pf.const.language.RSC1249}</th>
					<th scope="col" title="${pf.const.language.RSC1250}">${pf.const.language.RSC1250}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC1343}">${pf.const.language.RSC1343}</th>
				</tr>
			</thead>

			<thead class="filtersAddOns">
				<tr>
					<td>name</td>
					<td>description</td>
					<td>pais</td>
					<td>path</td>
					<td>url</td>
					<td>function</td>
					<td>params</td>
					<td>var</td>
					<td>enabled</td>
					<td>icono</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.addOns.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.addOns[i].country != '' && allowedCountries.indexOf(self.addOns[i].country) == -1) {
				continue;
			}

			table += `
				<tr class="c-pointer" data-id="${self.addOns[i].id}" data-name="${self.addOns[i].addon_name}">
					<td class="text-truncate" title="${self.addOns[i].addon_name}">${self.addOns[i].addon_name}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_description}">${self.addOns[i].addon_description}</td>
					<td class="text-truncate" title="${self.addOns[i].country}">${self.addOns[i].country}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_path}">${self.addOns[i].addon_path}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_url}">${self.addOns[i].addon_url}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_function}">${self.addOns[i].addon_function}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_function_params}">${self.addOns[i].addon_function_params}</td>
					<td class="text-truncate" title="${self.addOns[i].addon_var}">${self.addOns[i].addon_var}</td>
					<td class="text-center">
						<span class="d-none">${(self.addOns[i].addon_enabled == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.addOns[i].addon_enabled == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center" title="${self.addOns[i].addon_icon}">
						<i class="fa ${self.addOns[i].addon_icon}" aria-hidden="true"></i>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableAddon').html(table);

		// Setup - add a text input to each footer cell
		$('#tableAddon .filtersAddOns td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'enabled') {
				value = optionsSelectAllYesNo();
			} else if(title == 'icono') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableAddon = $('#tableAddon').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '60px', targets: 2},
				{width: '60px', targets: 8},
				{width: '40px', targets: 9}
			],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableAddon');

		// Apply the search
		applyTheSearch(tableAddon, 'filtersAddOns');

		$('#tableAddon tbody').off().on('click', 'tr', function() {
			let idAddon = $(this).data('id');
			let nameAddon = $(this).data('name');
			self.addOnPermissions[index].idAddon = idAddon;
			self.addOnPermissions[index].nameAddon = nameAddon;
			self.addOnPermissions[index].idSection = '';
			$('#AddonSelect_' + index).val(nameAddon);
			$('#AddonSelect_' + index).attr('title', nameAddon);
			$('#SeccionSelect_' + index).val('');
			$('#btn-Seccion_' + index).prop('disabled', false);
			$('#closeSAddon').trigger('click');
		});
	},

	renderSecciones(index, self) {
		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC122}">${pf.const.language.RSC122}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
				</tr>
			</thead>

			<thead class="filtersSecciones">
				<tr>
					<td>selector</td>
					<td>selector</td>
					<td>idSection</td>
					<td>description</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Secciones registradas
		let secReg = [];
		for(let i = 0; i < self.addOnPermissions.length; i++) {
			if(self.addOnPermissions[index].idAddon == self.addOnPermissions[i].idAddon && self.addOnPermissions[i].idSection != '') {
				secReg.push(self.addOnPermissions[i].idSection.toString());
			}
		}

		let size = self.secciones.length;
		for(let i = 0; i < size; i++) {
			let checked = '';
			if(secReg.indexOf(self.secciones[i].idSection.toString()) != -1) {
				checked = 'checked';
			}

			table += `
				<tr data-id="${i}" data-section="${self.secciones[i].idSection}">
					<td class="text-center">
						<div class="div-single-selection">
							<input type="checkbox" class="selection" ${checked}>
						</div>
					</td>
					<td class="text-truncate" title="${self.secciones[i].idSection}">${self.secciones[i].idSection}</td>
					<td class="text-truncate" title="${self.secciones[i].description}">${self.secciones[i].description}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableSecciones').html(table);

		// Setup - add a text input to each footer cell
		$('#tableSecciones .filtersSecciones td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'selector') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		tableSecciones = $('#tableSecciones').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0}
			],
			aaSorting: [],
			lengthChange: false
		});

		setTimeout(function() {
			tableSecciones.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableSecciones');

		// Apply the search
		applyTheSearch(tableSecciones, 'filtersSecciones');

		stcmbackend.rolesBackend.tableArticlesEvents(self);

		$('#tableSecciones').on('draw.dt', function() {
			stcmbackend.rolesBackend.tableArticlesEvents(self);
		});

		// Selección de múltiples secciones
		$('#selectSecciones').off().on('click', function() {
			$('#closeSecciones').trigger('click');

			setTimeout(function() {
				tableSecciones.destroy();

				let idAddon = self.addOnPermissions[index].idAddon;
				let nameAddon = self.addOnPermissions[index].nameAddon;
				let objsRemove = [];

				// Eliminar los objetos del mismo AddOn
				let objArray = [];
				for(let i = 0; i < self.addOnPermissions.length; i++) {
					if(self.addOnPermissions[i].idAddon == idAddon) {
						objArray.push(i);
					}
				}
				objsRemove = self.addOnPermissions.splice(objArray[0], objArray.length);

				$('#tableSecciones tr').each(function() {
					let cheked = $(this).find('.selectionSeleccion');

					if(cheked.prop('checked')) {
						let idSection = $(this).data('section');
						let visible = 0;

						for(let i = 0; i < objsRemove.length; i++) {
							if(idSection == objsRemove[i].idSection) {
								visible = objsRemove[i].visible;
							}
						}

						let obj = {
							idAddon: idAddon,
							nameAddon: nameAddon,
							idSection: idSection.toString(),
							visible: visible
						};
						self.addOnPermissions.push(obj);
					}
				});

				stcmbackend.rolesBackend.tableAddOnPermissions(self);
			}, 300);
		});
	},

	tableArticlesEvents(self) {
		inputControl();

		// Seleccionar por tr
		$('#tableSecciones tbody tr').off().on('click', function() {
			let index = $(this).data('index');
			let checked = $(this).find('.selection').prop('checked');

			if(!checked) {
				self.articles[index].checked = 1;
				$(this).find('.selection').prop('checked', true);
			} else {
				self.articles[index].checked = 0;
				$(this).find('.selection').prop('checked', false);
			}

			inputControl();
		});

		// Seleccionar por checbox
		$('.selection').off().on('change', function() {
			let index = $(this).data('index');
			let checked = $(this).prop('checked');

			if(checked) {
				self.articles[index].checked = 0;
				$(this).prop('checked', false);
			} else {
				self.articles[index].checked = 1;
				$(this).prop('checked', true);
			}

			inputControl();
		});

		// Marcar desmarcar todo
		$('.globalSelection').off().on('change', function() {
			if(this.checked) {
				$('.selection').each(function() {
					if(!$(this).prop('checked')) {
						$(this).prop('checked', false);
						$(this).trigger('change');
					}
				});
			} else {
				$('.selection').each(function() {
					if($(this).prop('checked')) {
						$(this).prop('checked', true);
						$(this).trigger('change');
					}
				});
			}
		});

		function inputControl() {
			// Estado del input global con respecto a los inputs en página
			if($('.selection').length == $('.selection:checked').length && $('.selection').length > 0) {
				$('.globalSelection').prop('checked', true);
			} else {
				$('.globalSelection').prop('checked', false);
			}
		}
	}
};