let CardGeneratorController = {
	reportList: $('#reportList'),
	init: false,

	setEvents: ()=>{
		let self = CardGeneratorController;
		$('#clearNotifications').off().on('click', ()=>{
			self.clearNotifications();
		});
	},

	// Añade una notificación al cajón de notis. Se debe pasar un objeto notificacion con los
	// atributos id, title, name, subtitle y cancelbutton(que determinará si la noti presenta o no botón de cancelar) (lanzar un reporte para ver ejemplo)
	addNotification: (notification)=>{
		let self = CardGeneratorController;

		if(!self.init) {
			self.init = true;
			self.setEvents();
		}

		$('#show-generating-reports').css('visibility', 'visible');
		let cancelButton = '';
		if(notification.cancelButton) {
			cancelButton = `
				<div class="mt-4 mx-0">
					<div id="buttonWrapper${notification.id}" class="text-right">
						<button id="cancelDowload${notification.id}" type="button" class="btn new-style-cancel">${pf.const.language.RSC57}</button>
					</div>
				</div>
			`;
		}

		$('#reportList').append(
			`<div id="${notification.id}" class="list-group-item dowload-card-item runningReport p-3">
				<div class="d-flex row align-items-center mx-0">
					<div id="statusIcon">
						${stcmbackend.svg.hourglassWithoutColor}
					</div>

					<div>
						<p class="list-group-item-text mb-0">
							<strong id="downloadCardTitle_${notification.id}">${notification.title} - ${notification.name}</strong>
							<br>
							<span id="downloadCardText_${notification.id}" class="downloadCardText">
								${notification.subtitle}
							<span>
						</p>
					</div>
				</div>
				${cancelButton}
			</div>`
		);

		CardGeneratorController.updateIcon();
		CardGeneratorController.showOnScreenNotification(notification.id, pf.const.language.RSC54, 'cogs');
	},

	// Añade una notificación al cajón de notis. Se debe pasar un objeto notificacion con los
	// atributos id, title, name, subtitle y cancelbutton(que determinará si la noti presenta o no botón de cancelar) (lanzar un reporte para ver ejemplo)
	addNotificationWithText: (notification, text)=>{
		let self = CardGeneratorController;

		if(!self.init) {
			self.init = true;
			self.setEvents();
		}

		$('#show-generating-reports').css('visibility', 'visible');
		let cancelButton = '';
		if(notification.cancelButton) {
			cancelButton = `
				<div class="mt-4 mx-0">
					<div id="buttonWrapper${notification.id}" class="text-right">
						<button id="cancelDowload${notification.id}" type="button" class="btn new-style-cancel">${pf.const.language.RSC57}</button>
					</div>
				</div>
			`;
		}

		$('#reportList').append(
			`<div id="${notification.id}" class="list-group-item dowload-card-item runningReport p-3">
				<div class="d-flex row align-items-center mx-0">
					<div id="statusIcon">
						${stcmbackend.svg.hourglassWithoutColor}
					</div>

					<div>
						<p class="list-group-item-text mb-0">
							<strong id="downloadCardTitle_${notification.id}">${notification.title} - ${notification.name}</strong>
							<br>
							<span id="downloadCardText_${notification.id}" class="downloadCardText">
								${notification.subtitle}
							<span>
						</p>
					</div>
				</div>
				${cancelButton}
			</div>`
		);

		CardGeneratorController.updateIcon();
		CardGeneratorController.showOnScreenNotification(notification.id, text, 'cogs');
	},

	showOnScreenNotification: (id, text, icon)=>{
		$('#onScreenNotificationWrapper').append(
			`<div id="onScreenNotif_${id}" class="card card-border-top card-border-top-success onScreenNotificationCard">
				<div class="closeCard" idNotif="${id}"><i class="fa fa-times"></i></div>
				<div class="card-body" >
					<i class="fa fa-${icon} mr-2"></i>
					${text} 
				</div>
			</div>`
		);

		$(`#onScreenNotif_${id}`).slideToggle(150, ()=>{});
		$('.closeCard').off().click(function() {
			let id = $(this).attr('idNotif');
			$(`#onScreenNotif_${id}`).remove();
		});

		//después de 3 segundos borra la noti
		setTimeout(()=>{
			$(`#onScreenNotif_${id}`).hide('fast', function() {
				$(`#onScreenNotif_${id}`).remove();
			});
		},3000);
	},

	updateIcon:()=>{
		if($('.runningReport').length > 0) {
			$('.progress-line-wrapper').show();
		} else {
			$('.progress-line-wrapper').hide();
		}

		CardGeneratorController.updateBadge();
	},

	updateBadge:()=>{
		if($('.dowload-card-item').length > 0) {
			$('.report-badge').text($('.dowload-card-item').length);
			$('.report-badge').show();
			if($('#dowloadGeneratedReport').length > 0) {
				$('.report-badge').addClass('background-color-main');
			} else {
				$('.report-badge').removeClass('background-color-main');
			}
		} else {
			$('.report-badge').hide();
		}
	},

	deleteNotification:(notificationId)=>{
		$('#reportList').find(`#${notificationId}`).remove();
		if($('.dowload-card-item').length < 1) {
			$('#show-generating-reports').css('visibility', 'hidden');
			$('#dowloadCard').hide();
		}
		CardGeneratorController.updateIcon();
	},

	clearNotifications:()=>{
		let self = CardGeneratorController;
		
		$('#reportList .dowload-card-item').each(function() {
			if($(this).find('#cancelGeneratedReport').length > 0) {
				$(this).find('#cancelGeneratedReport').trigger('click');
			} else if(!$(this).hasClass('runningReport')) {
				self.deleteNotification($(this).attr('id'));
			}
		});
	}
};