let DiferenciasSignificativasController = {
	poll: '',
	question: '',
	idPoll: '',
	questionFlag: false,
	questionId: [],
	questionIdIn: [],
	resultPercent: '',
	muestra: '',

	reset() {
		let self = this;

		self.poll = '';
		self.question = '';
		self.idPoll = '';
		self.questionFlag = false;
		self.questionId = [];
		self.questionIdIn = [];
		self.resultPercent = '';
		self.muestra = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2346);

		// Reducción de Header
		headerSectionHeight(0);

		// Opciones de header
		let jsonsubopt = {
			survey: 'poll',
			question: 'question',
			export: {
				id: 'exportTables',
				disabled: true
			}
		};

		let nav = `
			<div class="d-flex justify-content-end">
				${createSubOptionSurvey(jsonsubopt.survey)}
				${createSubOptionQuestion(jsonsubopt.question)}
				${createSubOptionExport(jsonsubopt.export.id, jsonsubopt.export.disabled)}
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botones secundarios
		$('#exportTables').addClass('secondary-button');

		$('#previewTable').hide();

		// Placeholder 'Misión'
		$('#poll').attr('placeholder', pf.const.language.RSC177);

		self.loadLang();
		self.applyEvents();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTables').attr('title', pf.const.language.RSC47);
		$('.acceptTitle').attr('title', pf.const.language.RSC141);
	},

	applyEvents() {
		let self = this;

		// Encuestas
		$('#searchPoll').on('click', function() {
			if(self.poll === '') {
				ajaxComunCallWithCallback('getAllSurveys', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						self.poll = ajaxReturn.result;

						self.renderPoll();
					}
				});
			} else {
				$('#pollTable').modal('show', true);
			}
		});

		// Preguntas
		$('#searchQuestion').on('click', function() {
			if(self.question === '') {
				let parameters = {
					survey: self.idPoll
				};
				ajaxComunCallWithCallback('getQuestionsSurvey', parameters, function(ajaxReturn) {
					if(ajaxReturn) {
						self.question = ajaxReturn.result;

						self.renderQuests();
					}
				});
			} else {
				$('#questTable').modal('show', true);
			}
		});

		// Exportar en excel
		$('#exportTables').off().on('click', function() {
			self.exportAsExcel();
		});
	},

	renderPoll() {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
					<th scope="col" title="${pf.const.language.RSC112}">${pf.const.language.RSC112}</th>
					<th scope="col" title="${pf.const.language.RSC113}">${pf.const.language.RSC113}</th>
					<th scope="col" title="${pf.const.language.RSC114}">${pf.const.language.RSC114}</th>
					<th scope="col" title="${pf.const.language.RSC115}">${pf.const.language.RSC115}</th>
					<th scope="col" title="${pf.const.language.RSC116}">${pf.const.language.RSC116}</th>
					<th scope="col" title="${pf.const.language.RSC117}">${pf.const.language.RSC117}</th>
					<th scope="col" title="${pf.const.language.RSC118}">${pf.const.language.RSC118}</th>
				</tr>
			</thead>

			<thead class="filtersPoll">
				<tr>
					<td>sid</td>
					<td>surveyls_title</td>
					<td>datecreated</td>
					<td>active</td>
					<td>perfilacion</td>
					<td>startdate</td>
					<td>expires</td>
					<td>remuneracion</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.poll.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr id="sid${self.poll[i].sid}" class="c-pointer">
					<td class="text-truncate" title="${self.poll[i].sid}">${self.poll[i].sid}</td>
					<td class="pollName text-truncate" title="${self.poll[i].surveyls_title}">${self.poll[i].surveyls_title}</td>
					<td class="text-truncate" title="${self.poll[i].datecreated}">${self.poll[i].datecreated}</td>
					<td class="text-center">
						<span class="d-none">${(self.poll[i].active == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(self.poll[i].active == '1' ? 'checked' : '')}></td>
					<td class="text-center">
						<span class="d-none">${(self.poll[i].perfilacion == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(self.poll[i].perfilacion == '1' ? 'checked' : '')}></td>
					<td class="text-truncate" title="${self.poll[i].startdate}">${self.poll[i].startdate}</td>
					<td class="text-truncate" title="${self.poll[i].expires}">${self.poll[i].expires}</td>
					<td class="text-truncate text-center">${self.poll[i].remuneracion}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tablePoll').html(table);

		// Setup - add a text input to each footer cell
		$('#tablePoll .filtersPoll td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'active' || title == 'perfilacion') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tablePoll = $('#tablePoll').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '45px', targets: 0},
				{width: '60px', targets: 3},
				{width: '85px', targets: 4},
				{width: '110px', targets: 7}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tablePoll.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tablePoll');

		// Apply the search
		applyTheSearch(tablePoll, 'filtersPoll');

		$('#tablePoll tbody').off().on('click', 'tr', function() {
			$('#searchQuestion').prop('disabled', false);

			// Placeholder 'Pregunta'
			$('#question').val('');
			$('#question').attr('placeholder', pf.const.language.RSC109);

			self.question = '';
			self.idPoll = $(this).prop('id').replace('sid', '');

			let name = $(this).find('.pollName').text();
			$('#poll').val(name);
			$('#tablePoll tbody tr').css('outline-width', 'initial');
			$('#tablePoll tbody tr').css('outline-style', 'none');
			$('#tablePoll tbody tr').css('outline-color', '#000');
			$('#tablePoll tbody tr').css('font-weight', 'normal');
			$(this).css('outline-width', 'thin');
			$(this).css('outline-style', 'solid');
			$(this).css('outline-color', '#f00');
			$(this).css('font-weight', 'bold');
			$('#closePool').trigger('click');
		});
	},

	renderQuests() {
		let self = this;

		if(self.questionFlag) {
			$('#tableQuest').dataTable().fnDestroy();
		} else {
			self.questionFlag = true;
		}

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC1316}">${pf.const.language.RSC1316}</th>
					<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
					<th scope="col" title="${pf.const.language.RSC122}">${pf.const.language.RSC122}</th>
					<th scope="col" title="${pf.const.language.RSC111}">${pf.const.language.RSC111}</th>
				</tr>
			</thead>

			<thead class="filtersQuest">
				<tr>
					<td>reports</td>
					<td>columnName</td>
					<td>section</td>
					<td>question</td>
				</tr>
			</thead>

			<tbody>
		`;

		// IDs de preguntas
		self.questionId = [];
		self.questionIdIn = [];

		let size = self.question.length;
		for(let i = 0; i < size; i++) {
			let question = self.question[i].question.replace('/...', '');

			if(self.question[i].type == 'L') {
				table += `
					<tr>
						<td class="text-center">
							<input type="checkbox" class="selectionQuest" data-index="${(i)}">
						</td>
						<td class="selectQ c-pointer" title="${self.question[i].columnName}">${self.question[i].columnName}</td>
						<td class="selectQ c-pointer" title="${self.question[i].group_name}">${self.question[i].group_name}</td>
						<td class="selectQ c-pointer" title="${question}">${question}</td>
					</tr>
				`;
				self.questionId.push(self.question[i]);
			}
		}

		table += `
			</tbody>
		`;

		$('#tableQuest').html(table);

		// Setup - add a text input to each footer cell
		$('#tableQuest .filtersQuest td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'reports') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableQuest = $('#tableQuest').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '30px', orderable: false, targets: 0},
				{width: '45px', targets: 1}
			],
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableQuest.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableQuest');

		// Apply the search
		applyTheSearch(tableQuest, 'filtersQuest');

		// Selección por línea
		$('.selectQ').on('click', function() {
			// Disparar selección por input
			$(this).parent().find('.selectionQuest').trigger('click');
		});

		// Selección por input
		$('.selectionQuest').off().on('click', function() {
			let index = $(this).data('index');

			if($(this).prop('checked')) {
				self.questionIdIn.push(self.question[index]);
			} else {
				for(let i = 0; i < self.questionIdIn.length; i++) {
					if(self.questionIdIn[i].columnName == self.question[index].columnName) {
						self.questionIdIn.splice(i, 1);
						break;
					}
				}
			}
		});

		$('#accept').off().on('click', function() {
			$('#closeQuest').trigger('click');

			if(self.question.length > 0) {
				// Cargar tablas
				self.questionArray = '';
				for(var i = 0; i < self.questionIdIn.length; ++i) {
					self.questionArray += self.questionIdIn[i].qid2 + ':' + self.questionIdIn[i].type + ',';
				}

				self.questionArray = self.questionArray.slice(0, -1);

				let parameters = {
					survey: self.idPoll,
					questions: self.questionArray
				};
				ajaxComunCallWithCallback('getIfQuestionsAreEquals', parameters, function(ajaxReturn) {
					if(ajaxReturn) {
						if(ajaxReturn.result != 'Questions seems to be equals') {
							self.answers = ajaxReturn.result.answers;

							self.getDataForTables();
						} else {
							let errorTitle = pf.const.language.RSC61;
							let errorContent = ajaxReturn.result;
							pf.utils.showInfoDialog(errorTitle, errorContent);
						}
					}
				});
			}
		});
	},

	getDataForTables() {
		let self = this;

		self.questionArray = '';
		for(let i = 0; i < self.questionIdIn.length; ++i) {
			self.questionArray += self.questionIdIn[i].columnName + ':' + self.questionIdIn[i].type + ',';
		}

		self.questionArray = self.questionArray.slice(0, -1);

		let parameters = {
			survey: self.idPoll,
			pregunta: self.questionArray
		};
		ajaxComunCallWithCallback('getAnalyticsDiferenciasSignificativas', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				if(ajaxReturn.status == 'OK') {
					self.resultPercent = ajaxReturn.result;
					self.muestra = ajaxReturn.muestra;

					self.printDetailsTable();
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = ajaxReturn.result;
					pf.utils.showInfoDialog(errorTitle, errorContent);
				}
			}
		});	
	},

	printDetailsTable() {
		let self = this;

		let datadetailtables = `
			<div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
				<div class="card-body"></div>
			</div>
		`;
		$('#datadetailtables').html(datadetailtables);
		addLoader();

		self.renderPreviewTable();
		$('#exportTables').prop('disabled', false);
		self.renderT2B();
		self.renderTB();
		self.renderL2B();
		removeAllLoaders();
	},

	renderPreviewTable() {
		let self = this;

		$('#previewTable').show();
		let headersRes = self.renderTableHeaders(pf.const.language.RSC155);

		let table = headersRes.table;

		let j = 0;
		Object.keys(self.answers).forEach(function(key) {
			let answer = self.answers[key];
			let answerStr = answer.answer;
			let answerCode = answer.code;

			table += `<tr id="sid${j}">`;
			table += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

			self.questionIdIn.forEach(function(obj) {
				let value = self.resultPercent[obj.columnName][answerCode];
				table += `<td class="text-truncate text-center" strtype="text" title="${value}%" style='mso-number-format: "\@";'>${value}%</td>`;
			});

			table += `</tr>`;

			j++;
		});

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		$('#previewTable #datadetailtables .card-body').append(table);
	},

	renderT2B() {
		let self = this;

		$('#previewTable').show();
		let headersRes = self.renderTableHeaders('T2B');

		let table = headersRes.table;

		let j = 0;
		Object.keys(self.questionIdIn).forEach(function(key) {
			let question = self.question[key];
			let questionStr = question.question;
			let questionColumnName = question.columnName;

			table += `<tr id="sid${j}">`;
			table += `<td class="text-truncate" strtype="text" title="${questionStr}" style='mso-number-format: "\@";'>${questionStr}</td>`;

			let index = 0;
			self.questionIdIn.forEach(function(obj) {
				if(questionColumnName != obj.columnName) {
					let first = self.resultPercent[questionColumnName];
					let t2bCalcFirst = 0;

					let second = self.resultPercent[obj.columnName];
					let t2bCalcSecond = 0;
					if(Object.keys(first).length > 2) {
						for(var x = 0; x < 2; ++x) {
							let code = Object.keys(first)[x];
							t2bCalcFirst += first[code];
						}
						t2bCalcFirst = t2bCalcFirst / 100;
					}

					if(Object.keys(second).length > 2) {
						for(var x = 0; x < 2; ++x) {
							let code = Object.keys(second)[x];
							t2bCalcSecond += second[code];
						}
						t2bCalcSecond = t2bCalcSecond / 100;
					}

					let desviacionEstandar = 1.96
					let differenceBetweenfirstsecond = Math.abs(t2bCalcSecond) - t2bCalcFirst; //NAT no sabemos si debe ser positivo, parece que si
					if(self.muestra < 100) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
					} else if(differenceBetweenfirstsecond > desviacionEstandar) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`;
					} else {
						let p = (t2bCalcFirst + t2bCalcSecond) / 2;
						let errorEstandar = p * (1 - p);
						let calculoMuestra = (1 / self.muestra) + (1 / self.muestra);
						let raiz = Math.sqrt(errorEstandar * calculoMuestra);
						let result = desviacionEstandar * raiz;
						
						if(self.muestra < 100) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						} else if(result > differenceBetweenfirstsecond) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`;
						} else {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						}
					}
				} else {
					table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
				}

				index = index + 1;
			});

			table += `</tr>`;

			j++;
		});

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		$('#previewTable #datadetailtables .card-body').append(table);
	},
	
	renderTB() {
		let self = this;

		$('#previewTable').show();
		let headersRes = self.renderTableHeaders('TB');

		let table = headersRes.table;

		let j = 0;
		Object.keys(self.questionIdIn).forEach(function(key) {
			let question = self.question[key];
			let questionStr = question.question;
			let questionColumnName = question.columnName;

			table += `<tr id="sid${j}">`;
			table += `<td class="text-truncate" strtype="text" title="${questionStr}" style='mso-number-format: "\@";'>${questionStr}</td>`;

			let index = 0;
			self.questionIdIn.forEach(function(obj) {
				if(questionColumnName != obj.columnName) {
					let first = self.resultPercent[questionColumnName];
					let tbCalcFirst = 0;

					let second = self.resultPercent[obj.columnName];
					let tbCalcSecond = 0;
					if(Object.keys(first).length > 1) {
						for(var x = 0; x < 1; ++x) {
							let code = Object.keys(first)[x];
							tbCalcFirst += first[code];
						}
						tbCalcFirst = tbCalcFirst / 100;
					}

					if(Object.keys(second).length > 1) {
						for(var x = 0; x < 1; ++x) {
							let code = Object.keys(second)[x];
							tbCalcSecond += second[code];
						}
						tbCalcSecond = tbCalcSecond / 100;
					}

					let desviacionEstandar = 1.96
					let differenceBetweenfirstsecond = Math.abs(tbCalcSecond) - tbCalcFirst; //NAT no sabemos si debe ser positivo, parece que si
					if(self.muestra < 100) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
					} else if(differenceBetweenfirstsecond > desviacionEstandar) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`;
					} else {
						let p = (tbCalcFirst + tbCalcSecond) / 2;
						let errorEstandar = p * (1 - p);
						let calculoMuestra = (1 / self.muestra) + (1 / self.muestra);
						let raiz = Math.sqrt(errorEstandar * calculoMuestra);
						let result = desviacionEstandar * raiz;
						
						if(self.muestra < 100) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						} else if(result > differenceBetweenfirstsecond) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`;
						} else {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						}
					}
				} else {
					table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
				}

				index = index + 1;
			});

			table += `</tr>`;

			j++;
		});

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		$('#previewTable #datadetailtables .card-body').append(table);
	},
	
	renderL2B() {
		let self = this;

		$('#previewTable').show();
		let headersRes = self.renderTableHeaders('L2B');

		let table = headersRes.table;

		let j = 0;
		Object.keys(self.questionIdIn).forEach(function(key) {
			let question = self.question[key];
			let questionStr = question.question;
			let questionColumnName = question.columnName;

			table += `<tr id="sid${j}">`;
			table += `<td class="text-truncate" strtype="text" title="${questionStr}" style='mso-number-format: "\@";'>${questionStr}</td>`;

			let index = 0;
			self.questionIdIn.forEach(function(obj) {
				if(questionColumnName != obj.columnName) {
					let first = self.resultPercent[questionColumnName];
					let l2bCalcFirst = 0;

					let second = self.resultPercent[obj.columnName];
					let l2bCalcSecond = 0;
					if(Object.keys(first).length > 2) {
						for(var x = Object.keys(first).length - 1; x >= Object.keys(first).length - 2; --x) {
							let code = Object.keys(first)[x];
							l2bCalcFirst += first[code];
						}
						l2bCalcFirst = l2bCalcFirst / 100;
					}

					if(Object.keys(second).length > 2) {
						for(var x = Object.keys(second).length - 1; x >= Object.keys(second).length - 2; --x) {
							let code = Object.keys(second)[x];
							l2bCalcSecond += second[code];
						}
						l2bCalcSecond = l2bCalcSecond / 100;
					}

					let desviacionEstandar = 1.96
					let differenceBetweenfirstsecond = Math.abs(l2bCalcSecond) - l2bCalcFirst; //NAT no sabemos si debe ser positivo, parece que si
					if(self.muestra < 100) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
					} else if(differenceBetweenfirstsecond > desviacionEstandar) {
						table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`; 
					} else {
						let p = (l2bCalcFirst + l2bCalcSecond) / 2;
						let errorEstandar = p * (1 - p);
						let calculoMuestra = (1 / self.muestra) + (1 / self.muestra);
						let raiz = Math.sqrt(errorEstandar * calculoMuestra);
						let result = desviacionEstandar * raiz;

						if(self.muestra < 100) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						} else if(result > differenceBetweenfirstsecond) {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'>X</td>`;
						} else {
							table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
						}
					}
				} else {
					table += `<td class="text-truncate text-center" strtype="text" title="" style='mso-number-format: "\@";'></td>`;
				}

				index = index + 1;
			});

			table += `</tr>`;

			j++;
		});

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		$('#previewTable #datadetailtables .card-body').append(table);
	},

	renderTableHeaders(title) {
		let self = this;

		let table = `
			<table id="tablePreview" class="table table-hover">
				<thead>`;
				table += `<tr>${title}</tr>`;
				table += `<tr>`;
						table += `<th></th>`;

						for(let i = 0; i < self.questionIdIn.length; ++i) {
							table += `<th class="text-center" title="${self.questionIdIn[i].question}">${self.questionIdIn[i].question}</th>`;
						}

				table +=
					`</tr>
				</thead>
			<tbody>
		`;

		return {'table': table};
	},

	s2ab(s) {
		var buf = new ArrayBuffer(s.length);
		var view = new Uint8Array(buf);
		for(var i=0; i!=s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
		return buf;
	},

	create_gap_rows(ws, nrows) {
		var ref = XLSX.utils.decode_range(ws['!ref']);	// get original range
		ref.e.r += nrows;								// add to ending row
		ws['!ref'] = XLSX.utils.encode_range(ref);		// reassign row
		removeLoader();
	},

	exportAsExcel() {
		let self = this;

		var tables = $('#datadetailtables table[id^="tablePreview"]');
		var wb = XLSX.utils.book_new();

		var ws = XLSX.utils.table_to_sheet(tables[0]);
		for(var i = 1; i < tables.length; ++i) {
			self.create_gap_rows(ws, 4);
			XLSX.utils.sheet_add_dom(ws, tables[i], {origin: -1});
		}

		//change cell format to %
		Object.entries(ws).forEach(function(obj) {
			// Valor
			value = obj[1].v;
			if(typeof(value) !== 'undefined' && value != '') {
				valuestr = value.toString();
				if(valuestr.indexOf('%') !== -1) {
					// Fórmula
					obj[1].z = '#,##0.00"%"';
					// Tipo
					obj[1].t = 'n';
					if(valuestr != 'NaN%') {
						obj[1].v = parseFloat(valuestr.replace('%', ''));
					} else {
						obj[1].v = 0;
					}
				}
			}
		});

		XLSX.utils.book_append_sheet(wb, ws, pf.const.language.RSC965);

		var wbout = XLSX.write(wb, {bookType:'xlsx', bookSST:true, type: 'binary'});

		module$FileSaver.saveAs(new Blob([self.s2ab(wbout)],{type:'application/octet-stream'}), $('#poll').val() + '.xlsx');
	}
};