let MuestreoDetalladoController = {
	isPerf: null,
	poll: '',
	idPoll: '',
	numPregPerf: '',
	country: '',
	printed: 0,
	numPrintTables: stcm.const.NumTablasPrintar,
	currentPage: 0,
	totalPages: 1,
	totalTables: 0,
	previewTables: '',
	countQuestions: 0,
	groupSize: 5,
	consumer: 0,
	dateFormat: '',
	suffix: '',
	loadError: false,

	reset() {
		let self = this;

		self.isPerf = null;
		self.poll = '';
		self.idPoll = '';
		self.numPregPerf = '';
		self.country = '';
		self.printed = 0;
		self.numPrintTables = stcm.const.NumTablasPrintar;
		self.currentPage = 0;
		self.totalPages = 1;
		self.totalTables = 0;
		self.previewTables = 0;
		self.countQuestions = 0;
		self.groupSize = 5;
		self.consumer = 0;
		self.dateFormat = '';
		self.suffix = '';
		self.loadError = false;
	},

	setEvents(suffix = '') {
		let self = this;
		self.reset();
		self.suffix = suffix;

		// Información de administrador
		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let userA = JSON.parse(JSONuser);
		self.dateFormat = userA.formatoFecha;

		// Reducción de Header
		headerSectionHeight(0);

		let jsonsubopt = {};
		let nav = '';
		if(self.suffix === '') {
			// Añadir titulo
			$('#page-title').text(pf.const.language.RSC963);

			// Opciones de header
			jsonsubopt = {
				survey: 'poll',
				country: 'country',
				refresh: {
					id: 'previewTables',
					disabled: true
				},
				export: {
					id: 'exportTables',
					disabled: true
				}
			};

			nav = `
				<div class="d-flex justify-content-end row m-0">
					${createSubOptionSurvey(jsonsubopt.survey)}
					${createSubOptionCountrySimple(jsonsubopt.country)}
					<div>
						<button id="dropdownFilters" type="button" class="btn-nav btn d-flex align-items-center ma-le-5 secondary-button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<span class="ml-1">${pf.const.language.RSC1076}</span>

							<span id="svgContainerPage" class="ml-2">
								<svg class="bi bi-chevron-down" width="12" height="12" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 01.708 0L8 10.293l5.646-5.647a.5.5 0 01.708.708l-6 6a.5.5 0 01-.708 0l-6-6a.5.5 0 010-.708z" clip-rule="evenodd"/>
								</svg>
							</span>
						</button>

						<div id="profileContainerPage" class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownFilters">
							<div class="dropdown-item form-check form-check-inline">
								<input id="ponderacion" type="checkbox" class="form-check-input">
								<label for="ponderacion" class="form-check-label c-pointer">${pf.const.language.RSC1775}</label>
							</div>

							<div class="dropdown-item form-check form-check-inline">
								<input id="validated" type="checkbox" class="form-check-input">
								<label for="validated" class="form-check-label c-pointer">${pf.const.language.RSC2228}</label>
							</div>

							<div class="dropdown-item form-check form-check-inline">
								<input id="hideopenquestions" type="checkbox" class="form-check-input">
								<label for="hideopenquestions" class="form-check-label c-pointer">${pf.const.language.RSC2353}</label>
							</div>

							<div class="lastElement text-right">
								<span id="loadWithFilters" class="main-color-text c-pointer spanDisabled">${pf.const.language.RSC2523}</span>
							</div>
						</div>
					</div>
					${createSubOptionExport(jsonsubopt.export.id, jsonsubopt.export.disabled)}
					${createSubOptionRefresh(jsonsubopt.refresh.id, jsonsubopt.refresh.disabled)}
				</div>
			`;
		} else if(self.suffix === '-me-sam-det') {
			// Opciones de header
			jsonsubopt = {
				refresh: {
					id: 'previewTables',
					disabled: false
				},
				export: {
					id: 'exportTables',
					disabled: true
				}
			};

			nav = `
				<div class="d-flex justify-content-end row m-0">
					<div>
						<button id="dropdownFilters" type="button" class="btn-nav btn d-flex align-items-center ma-le-5 secondary-button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<span class="ml-1">${pf.const.language.RSC1076}</span>

							<span id="svgContainerPage" class="ml-2">
								<svg class="bi bi-chevron-down" width="12" height="12" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 01.708 0L8 10.293l5.646-5.647a.5.5 0 01.708.708l-6 6a.5.5 0 01-.708 0l-6-6a.5.5 0 010-.708z" clip-rule="evenodd"/>
								</svg>
							</span>
						</button>

						<div id="profileContainerPage" class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownFilters">
							<div class="dropdown-item form-check form-check-inline">
								<input id="ponderacion" type="checkbox" class="form-check-input">
								<label for="ponderacion" class="form-check-label c-pointer">${pf.const.language.RSC1775}</label>
							</div>

							<div class="dropdown-item form-check form-check-inline">
								<input id="validated" type="checkbox" class="form-check-input">
								<label for="validated" class="form-check-label c-pointer">${pf.const.language.RSC2228}</label>
							</div>

							<div class="dropdown-item form-check form-check-inline">
								<input id="hideopenquestions" type="checkbox" class="form-check-input">
								<label for="hideopenquestions" class="form-check-label c-pointer">${pf.const.language.RSC2353}</label>
							</div>

							<div class="lastElement text-right">
								<span id="loadWithFilters" class="main-color-text c-pointer">${pf.const.language.RSC2523}</span>
							</div>
						</div>
					</div>
					${createSubOptionExport(jsonsubopt.export.id, jsonsubopt.export.disabled)}
					${createSubOptionRefresh(jsonsubopt.refresh.id, jsonsubopt.refresh.disabled)}
				</div>
			`;
		}

		// Acciones de página (flex-row-reverse)s
		$('#page-actions' + self.suffix).html(nav);

		// Botones secundarios
		$('#exportTables').addClass('secondary-button');
		$('#previewTables').addClass('secondary-button');

		// Eventos de dropdown de página
		dropDownPageEvents();

		$('#poll').attr('placeholder', pf.const.language.RSC177);

		// Control de tamaño
		$('#buttonsContainer button').addClass('px-1');
		$('#buttonsContainer div').addClass('mx-0');

		$('#previewTable').hide();

		$('#datadetailtablestab').html(pf.const.language.RSC965);
		$('#datadetailindextab').html(pf.const.language.RSC964);
		$('#datadetailresulttab').html(pf.const.language.RSC345);

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.numPregPerf = config.numPregPerfEnMostreo;
		self.consumer = sessionStorage.getItem('STCMBackEnd:Consumer');

		self.loadLang();
		self.applyEvents();

		self.setTabEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let countriesDesc = atob(sessionStorage['STCMBackEnd:userCountriesDesc']);
		if(countries.length === 1) {
			$('#country').val(countriesDesc);
			$('#country').data('iso', countries[0]);
			self.country = countries[0];
		}
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// En caso de venir de edición de misiones
		if(self.suffix === '-me-sam-det') {
			$('#exportTables').off().on('click', function() {
				self.exportAsExcel();
			});
		}

		// Encuestas
		$('#searchPoll').on('click', function() {
			// Objeto poll
			if(self.poll === '') {
				let JSONuser = sessionStorage['STCMBackEnd:user'];
				let user = JSON.parse(JSONuser);
				let idCliente = user.idCliente;

				// Parámetro de cliente
				let parameters = {
					idCliente: idCliente
				}
				ajaxComunCallWithCallback('getAllSurveysWithMissions', parameters, function(ajaxReturn) {
					if(ajaxReturn) {
						self.poll = ajaxReturn.result;

						self.renderPoll(self.poll);
					}
				});
			} else {
				$('#pollTable').modal('show', true);
			}
		});

		// País
		let countryModal = new TableCountries(0, 'muestreoDetallado');
		$('#searchCountry').on('click', function() {
			countryModal.setEvents();
		});

		// Cargar datos de página a través de los filtros
		$('#loadWithFilters').on('click', function() {
			// En caso de que esté desactivado
			if($('#loadWithFilters').hasClass('spanDisabled')) {
				return false;
			}

			$('#previewTables').trigger('click');
		});

		// Visualización de todas las tablas de las preguntas
		$('#previewTables').off().on('click', function() {
			// Limpieza de elementos HTML
			let datadetailtables = `
				<div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
					<div class="card-body"></div>
				</div>
			`;
			$('#datadetailtables').html(datadetailtables);
			let datadetailindex = `
				<div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
					<div class="card-body">
						<table id="tablePreviewIndex" class="table table-hover">
							<tbody></tbody>
						</table>
						<table id="tablePreviewIndexHidden" class="table table-hover dis-none">
							<tbody></tbody>
						</table>
					</div>
				</div>
			`;
			$('#datadetailindex').html(datadetailindex);
			let datadetailresult = `
				<div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
					<div class="card-body"></div>
				</div>
			`;
			$('#datadetailresult').html(datadetailresult);

			addLoader();

			let hideopenquestions = ($('#hideopenquestions').prop('checked') ? '1' : '0');

			let parameters = {
				survey: self.idPoll,
				perf: self.isPerf,
				country: self.country,
				numPreguntasPerfilacionEnAnalyticMostreo: self.numPregPerf,
				hideopenquestions: hideopenquestions
			};
			ajaxComunCallWithCallback('getAnalyticsMuestraToExportByPerfQuestion', parameters, function(ajaxReturn) {
				if(ajaxReturn) {
					self.printed = 0;
					self.previewTables = ajaxReturn.result;
					self.requestQueue(0);
					$('#exportTables').prop('disabled', false);
				}
			}, false);
		});
	},

	renderPoll(poll) {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC177}">${pf.const.language.RSC177}</th>
					<th scope="col" title="${pf.const.language.RSC176}">${pf.const.language.RSC176}</th>
					<th scope="col" title="${pf.const.language.RSC114}">${pf.const.language.RSC114}</th>
					<th scope="col" title="${pf.const.language.RSC116}">${pf.const.language.RSC116}</th>
					<th scope="col" title="${pf.const.language.RSC117}">${pf.const.language.RSC117}</th>
					<th scope="col" title="${pf.const.language.RSC549}">${pf.const.language.RSC549}</th>
				</tr>
			</thead>

			<thead class="filtersPoll">
				<tr>
					<td>mision</td>
					<td>proyecto</td>
					<td>active</td>
					<td>startdate</td>
					<td>expires</td>
					<td>country</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		let size = poll.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(poll[i].countries != '' && allowedCountries.indexOf(poll[i].countries) == -1) {
				continue;
			}

			if(poll[i].idmision == '') {
				continue;
			}

			// Formato de fecha, el servicio devuelve AAAA-MM-DD HH:MM:SS
			let startDate = '-';
			let startDateOrder = '';
			if(poll[i].startdate != '') {
				// Para ordenación en columna
				startDateOrder = poll[i].startdate.replace(' ', '');

				let dateTimeArrayStart = poll[i].startdate.split(' ');
				let dateStart = dateTimeArrayStart[0].replace(/-/g, '/');
				if(self.dateFormat === 'DDMMAAAA') {
					startDate = modifyDateFormat(dateStart);
				} else {
					startDate = dateStart;
				}
			}

			let endDate = '-';
			let endDateOrder = '';
			if(poll[i].expires != '') {
				// Para ordenación en columna
				endDateOrder = poll[i].expires.replace(' ', '');

				let dateTimeArrayEnd = poll[i].expires.split(' ');
				let dateEnd = dateTimeArrayEnd[0].replace(/-/g, '/');
				if(self.dateFormat === 'DDMMAAAA') {
					endDate = modifyDateFormat(dateEnd);
				} else {
					endDate = dateEnd;
				}
			}

			table += `
				<tr id="sid${poll[i].sid}" class="c-pointer" data-perf=${poll[i].perfilacion} data-surveyname="${poll[i].surveyls_title}" data-missionname="${poll[i].idmision}">
					<td class="text-truncate" title="${poll[i].idmision}">${poll[i].idmision}</td>
					<td class="text-truncate" title="${poll[i].NombreProyecto}">${poll[i].NombreProyecto}</td>
					<td class="text-center">
						<span class="d-none">${(poll[i].active == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" disabled ${(poll[i].active == '1' ? 'checked' : '')}>
					</td>
					<td class="text-truncate" title="${startDate}">
						<span class="d-none">${startDateOrder}</span>
						${startDate}
					</td>
					<td class="text-truncate" title="${endDate}">
						<span class="d-none">${endDateOrder}</span>
						${endDate}
					</td>
					<td class="country text-truncate" title="${poll[i].countries}">${poll[i].countries}</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tablePoll').html(table);

		// Setup - add a text input to each footer cell
		$('#tablePoll .filtersPoll td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'active' || title == 'perfilacion') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tablePoll = $('#tablePoll').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			columnDefs: [
				{width: '60px', targets: 2}
			],
			autoWidth: false,
			aaSorting: []
		});

		// Prueba de reparación para Beb
		setTimeout(function() {
			tablePoll.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tablePoll');

		// Apply the search
		applyTheSearch(tablePoll, 'filtersPoll');

		$('#tablePoll tbody').off().on('click', 'tr', function() {
			$('#loadSurvey').prop('disabled', true);
			$('#searchQuestion').prop('disabled', false);

			if($('#country').val() !== '') {
				$('#previewTables').prop('disabled', false);
				// Activar botón en filtros
				$('#loadWithFilters').removeClass('spanDisabled');
			}

			$('#question').val('Pregunta');

			self.idPoll = $(this).prop('id').replace('sid', '');
			self.isPerf = $(this).data('perf');
			let name = $(this).data('missionname');
			$('#poll').val(name);
			$('#tablePoll tbody tr').css('outline-width', 'initial');
			$('#tablePoll tbody tr').css('outline-style', 'none');
			$('#tablePoll tbody tr').css('outline-color', '#000');
			$('#tablePoll tbody tr').css('font-weight', 'normal');
			$(this).css('outline-width', 'thin');
			$(this).css('outline-style', 'solid');
			$(this).css('outline-color', '#f00');
			$(this).css('font-weight', 'bold');
			$('#closePool').trigger('click');

			// Exportar a excel todas las preguntas
			// Activación de botón de exportar del navegador
			$('#exportSurvey').prop('disabled', false);
			$('#exportSurvey').off().on('click', function() {
				self.generateExcel();
			});

			$('#exportTables').off().on('click', function() {
				self.exportAsExcel();
			});
		});
	},

	requestQueue(start) {
		let self = this;

		let size = self.previewTables.length;
		let end = start + self.groupSize;
		self.countQuestions = 0;
		if(size < end) {
			end = size;
		}
		for(var i = start; i < end; ++i) {
			var qid = self.previewTables[i].qid;
			var div = $('<tr id="' + qid + '">');
			var divHidden = $('<tr id="' + qid + '">');
			var divHiddenSpace = '<tr><th class="text-left"></th></tr>';
			$('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').append(div);
			$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').append(divHidden);
			$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').append(divHiddenSpace);
			var div = $('<div id="' + qid + '">');
			var divPerc = $('<div id="perc' + qid + '">');
			$('#previewTable #datadetailtables .card-body').append(div);
			$('#previewTable #datadetailtables .card-body').append(divPerc);
			self.requestSingleQuestion(qid, i, size, end);
		}
	},

	printPagination() {
		let self = this;

		if(self.numPrintTables <= 0) {
			return;
		}

		//get total of pages
		self.totalPages = Math.ceil(self.totalTables / self.numPrintTables);
		if(self.totalPages == 1) {
			return;
		}

		//generate menu to navigate between pages
		$('#previewTable #datadetailtables .card-body .pagDetallado').html('');
		var menu = `
			<div class="list-group list-group-horizontal d-flex justify-content-end">
				<a id="pageChangeButton" value="anterior" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton ${((self.currentPage === 0) ? 'disabled' : '')}">${pf.const.language.RSC1061}</a>
		`;
		let block = '';
		let min = 0;
		switch(parseInt(self.currentPage)) {
			case 0:
			case 1:
				min = Math.min(parseInt(self.totalPages)-1, 2);
				for(let i = 0; i <= min; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}

				if(parseInt(self.totalPages) > 4) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}
					
				if(parseInt(self.totalPages)>3) {
					block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
				}

				menu += block;
				break;

			case parseInt((self.totalPages) - 2):
			case parseInt((self.totalPages) - 1):
				block += `<a id="pageChangeButton" value="0" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">1</a>`;
				if(parseInt(self.totalPages) > 4) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}

				min = Math.max(1, parseInt(self.totalPages) - 3);
				for(let i = min; i <= parseInt(self.totalPages) - 1; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}
				menu += block;
				break;
			default:
				block += `<a id="pageChangeButton" value="0" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">1</a>`;
				if(parseInt(self.currentPage) - 1 != 1) {
					block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				}

				min = Math.min(parseInt(self.totalPages) - 1, parseInt(self.currentPage) + 2);
				for(let i = parseInt(self.currentPage) - 1; i < min; ++i) {
					block += `<a id="pageChangeButton" value="${i}" class="c-pointer w-auto d-inline list-group-item list-group-item-action ${((i === 0) ? 'active' : '')} pageChangeButton">${(i + 1)}</a>`;
				}
				if(min == parseInt(self.totalPages) - 1) {
					block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
					menu += block;
					break;
				}
				block += `<div class="w-auto d-inline list-group-item list-group-item-action disabled" > ... </div>`;
				block += `<a id="pageChangeButton" value="${(parseInt(self.totalPages) - 1)}" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton">${parseInt(self.totalPages)}</a>`;
				menu += block;
				break;
		}
		menu += `
				<a id="pageChangeButton" value="siguiente" class="c-pointer w-auto d-inline list-group-item list-group-item-action pageChangeButton ${((self.currentPage === self.totalPages - 1) ? 'disabled' : '')}">${pf.const.language.RSC1530}</a>
			</div>
		`;
		//add menu to html
		$('#previewTable #datadetailtables .card-body .pagDetallado').append(menu);
		//add click event to every menu item
		$('.pageChangeButton').off().click(function(e) {
			e.preventDefault();
			addLoader();
			self.renderPage($(this).attr('value'));
			removeLoader();
		});
	},

	//render page at @param page
	renderPage(page) {
		let self = this;

		switch(page) {
			case 'anterior':
				if(self.currentPage > 0) {
					--self.currentPage;
				}
				break;
			case 'siguiente':
				if(self.currentPage < self.totalPages-1) {
					++self.currentPage;
				}
				break;
			default:
				self.currentPage = page;
				break;
		}
		//display the correct pages
		$('#previewTable #datadetailtables .card-body div').hide();
		$('#previewTable #datadetailtables .card-body div').slice(self.currentPage*self.numPrintTables, self.currentPage*self.numPrintTables + self.numPrintTables).show();
		//add class active
		self.printPagination();

		$('.pageChangeButton.active').removeClass('active');
		$('.pageChangeButton[value="' + self.currentPage + '"]').addClass('active');
		//handle back and forward 
		if(self.currentPage == 0) {
			$(`.pageChangeButton[value="anterior"]`).addClass('disabled');
		} else {
			$(`.pageChangeButton[value="anterior"]`).removeClass('disabled');
		}

		if(self.currentPage == (self.totalPages - 1)) {
			$(`.pageChangeButton[value="siguiente"]`).addClass('disabled');
		} else {
			$(`.pageChangeButton[value="siguiente"]`).removeClass('disabled');
		}

		//scroll to the top
		$('.app-content').scroll();
		$('.app-content').animate({
			scrollTop: 0
		}, 1300);
	},

	requestSingleQuestion(qid, index, total, end) {
		let self = this;

		let token = sessionStorage['STCMBackEnd:token'];
		let reqName = 'getAnalyticsMuestraToExportByPerf' + qid;
		let onlyOKUsers = ($('#validated').prop('checked') ? '1' : '0');

		let form = new FormData();
		form.append('action', 'getAnalyticsMuestraToExportByPerf');
		form.append('token', token);
		form.append('survey', self.idPoll);
		form.append('perf', self.isPerf);
		form.append('country', self.country);
		form.append('pregunta', qid); // only for test
		form.append('numPreguntasPerfilacionEnAnalyticMostreo', self.numPregPerf);
		form.append('onlyOKUsers', onlyOKUsers);

		let reqData = {
			url: stcm.const.serverAPI,
			method: 'POST',
			timeout: stcm.const.AJAX_TIMEOUT,
			processData: false,
			mimeType: 'application/x-www-form-urlencoded',
			contentType: false,
			data: form
		};

		pf.ajax.request(reqName, reqData);
		$(document).off(reqName);
		$(document).on(reqName, function(event, response) {
			if(response.status === 'OK') {
				let printed = false;
				let resp = JSON.parse(response.resData.response);
				if(resp.status === 'OK') {
					if(resp.result.length == 0) {
						self.printed += 1; //porque las de tipo : vienen como array vacío
					}

					Object.keys(resp.result).forEach(function(key) {
						let question = resp.result[key];
						if(key == 'totales' && index == 0) {
							$('#previewTable #datadetailresult .card-body').html('');
							self.renderTableTotal(question);
						} else if(key != 'totales' && key != 'factoresPonderacion') {
							if(typeof(question.answers) !== 'undefined') {
								self.renderPreviewTable(question, resp.result['totales'], resp.result['factoresPonderacion']);
							} else {
								self.renderPreviewTableSQ(question, resp.result['totales'], resp.result['factoresPonderacion']);
							}
							self.printed += 1;
						}
						if(total == self.printed && !printed) {
							printed = true;
							$('#previewTable #datadetailtables .card-body div').hide();
							self.totalTables = $('#previewTable #datadetailtables .card-body div').length;
							section = `<section class="pagDetallado"></section>`;
							$('#previewTable #datadetailtables .card-body').append(section);
							self.renderPage(0);
							removeLoader();

							// Control de errores en el renderizado de tablas
							if(self.loadError) {
								let errorTitle = pf.const.language.RSC963;
								let errorContent = pf.const.language.RSC2642;
								pf.utils.showInfoDialog(errorTitle, errorContent);

								self.loadError = false;
							}

							$('#exportTables').prop('disabled', false);
						}
					});

					self.countQuestions++;
					if(end <= total && self.countQuestions == self.groupSize) {
						self.requestQueue(end);
					}
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = resp.result;
					pf.utils.showInfoDialog(errorTitle, errorContent);
					if(resp.result == 'Not authorized') {
						pf.ajax.setWindowLocationIndex();
					}
				}
			} else {
				let errorTitle = pf.const.language.RSC61;
				let errorContent = response.result;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				if(response.result == 'Not authorized') {
					pf.ajax.setWindowLocationIndex();
				}
			}
		});
	},

	renderTableTotal(totales) {
		let self = this;

		let headersGenero = totales.genero || [];
		let headersEdad = totales.edad || [];
		let headersSec = totales.sec || [];
		let headersRegion = totales.region || [];
		let headersConsumo = totales.consumo || [];

		let total = 0;

		let tableinit = `
			<table id="tableTotalResult" class="table table-hover">
				<thead>
					<tr>
						<th></th>
		`;
		tableinit += `<th title="${pf.const.language.RSC345}">${pf.const.language.RSC345}</th><th></th>`;
		tableinit += `
					</tr>
				</thead>
				<tbody>
					<tr>
						<td class="text-truncate" title="${pf.const.language.RSC345}"><strong>${pf.const.language.RSC345}</strong></td>
		`;

		let table = '';

		let length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersGenero[i].genero}"><strong>${headersGenero[i].genero}</strong></td>
					<td class="text-truncate" title="${headersGenero[i].value}">${headersGenero[i].value}</td>
					<td class="text-truncate" title="${headersGenero[i].porc}%">${headersGenero[i].porc}%</td>
				</tr>
			`;
			total += headersGenero[i].value;
		}

		length = headersEdad.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersEdad[i].edad}"><strong>${headersEdad[i].edad}</strong></td>
					<td class="text-truncate" title="${headersEdad[i].value}">${headersEdad[i].value}</td>
					<td class="text-truncate" title="${headersEdad[i].porc}%">${headersEdad[i].porc}%</td>
				</tr>
			`;
		}

		length = headersSec.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersSec[i].sec}"><strong>${headersSec[i].sec}</strong></td>
					<td class="text-truncate" title="${headersSec[i].value}">${headersSec[i].value}</td>
					<td class="text-truncate" title="${headersSec[i].porc}%">${headersSec[i].porc}%</td>
				</tr>
			`;
		}

		length = headersRegion.length;
		for(let i = 0; i < length; ++i) {
			table += `
				<tr>
					<td class="text-truncate" title="${headersRegion[i].region}"><strong>${headersRegion[i].region}</strong></td>
					<td class="text-truncate" title="${headersRegion[i].value}">${headersRegion[i].value}</td>
					<td class="text-truncate" title="${headersRegion[i].porc}%">${headersRegion[i].porc}%</td>
				</tr>
			`;
		}

		if(self.consumer == '1') {
			length = headersConsumo.length;
			for(let i = 0; i < length; ++i) {
				var textConsumo = '';
				if(headersConsumo[i].questionConsumo == '1') {
					textConsumo = pf.const.language.RSC1899;
				} else if(headersConsumo[i].questionConsumo == '0') {
					textConsumo = pf.const.language.RSC1900;
				}
				table += `
					<tr>
						<td class="text-truncate" title="${textConsumo}"><strong>${textConsumo}</strong></td>
						<td class="text-truncate" title="${headersConsumo[i].value}">${headersConsumo[i].value}</td>
						<td class="text-truncate" title="${headersConsumo[i].porc}%">${headersConsumo[i].porc}%</td>
					</tr>
				`;
			}
		}

		table += `
				</tbody>
			</table>
		`;

		table = tableinit + `<td class="text-truncate" title="${total}"><strong>${total}</strong></td><td class="text-truncate"><strong></strong></td></tr>` + table;

		$('#previewTable #datadetailresult .card-body').append(table);
	},

	renderTTBLTB(tableElem) {
		// Añadido T2B y L2B para preguntas tipo L
		// T2B
		let numberOfRows = $(tableElem).find('tbody tr').length - 1; //restamos 1 por la fila del total
		let top1Porc = $(tableElem).find('#sidpercent0');
		let top2Porc = $(tableElem).find('#sidpercent1');
		let trPorc = `<tr class="text-truncate" strtype="text">`;
		for(let i = 0; i < top1Porc.children().length; i++) {
			let element1 = top1Porc.children()[i];
			let element2 = top2Porc.children()[i];
			if(i == 0) {
				trPorc += `<td class="text-truncate" strtype="text">T2B</td>`;
			} else {
				text1 = $(element1).attr('title') != null ? $(element1).attr('title').slice(0, -1) : 0;
				text2 = $(element2).attr('title') != null ? $(element2).attr('title').slice(0, -1) : 0;
				let suma = parseFloat(text1) + parseFloat(text2);
				if(i == 1) {
					trPorc += `<td class="text-truncate" strtype="text"><strong>${suma.toFixed(2)}%</strong></td>`;
				} else {
					trPorc += `<td class="text-truncate" strtype="text">${suma.toFixed(2)}%</td>`;
				}
			}
		}
		trPorc += '</tr>';

		// L2B
		let low1Porc = $(tableElem).find('#sidpercent' + (numberOfRows - 1));
		let low2Porc = $(tableElem).find('#sidpercent' + (numberOfRows - 2));
		let trLowPorc = `<tr class="text-truncate" strtype="text">`;
		for(let i = 0; i < low1Porc.children().length; i++) {
			let element1 = low1Porc.children()[i];
			let element2 = low2Porc.children()[i];
			if(i == 0) {
				trLowPorc += `<td class="text-truncate" strtype="text">L2B</td>`;
			} else {
				text1 = $(element1).attr('title') != null ? $(element1).attr('title').slice(0, -1) : 0;
				text2 = $(element2).attr('title') != null ? $(element2).attr('title').slice(0, -1) : 0;
				let suma = parseFloat(text1) + parseFloat(text2);
				if(i == 1) {
					trLowPorc += `<td class="text-truncate" strtype="text"><strong>${suma.toFixed(2)}%</strong></td>`;
				} else {
					trLowPorc += `<td class="text-truncate" strtype="text">${suma.toFixed(2)}%</td>`;
				}
			}
		}
		trLowPorc += '</tr>';

		return {'TTB': trPorc, 'LTB': trLowPorc};
	},

	renderPreviewTable(question, arrayTotales, arrayFactoresPonderacion) {
		let self = this;

		$('#previewTable').show();
		let qType = question.type;

		let totalUsers = question.numAnswersTotal;
		let totalGeneroPorc = question.answers[0].totalGeneroPorc;

		let headersGenero = question.answers[0].genero || [];
		let headersEdad = question.answers[0].edad || [];
		let headersSec = question.answers[0].sec || [];
		let headersRegion = question.answers[0].region || [];
		let headersConsumo = question.answers[0].consumo || [];

		let total = headersGenero.length + headersEdad.length + headersSec.length + headersRegion.length + 2;
		if(self.consumer == '1') {
			total += headersConsumo.length;
		}
		let headersRes = self.renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo);

		let tableindex = `<th class="text-left w-100" title="${question.question}">${question.question}</th>`;
		let tableindexHidden = `<th class="text-left w-100" title="${question.question}">${question.question}</th>`;

		let table = headersRes.table;
		let tablePercent = headersRes.table;
		let tablePercentTTBLTB = headersRes.table;

		let j = 0;
		let totalArrayRes = headersRes.totalArrayRes;
		let totalPonderated = 0;
		if($('#ponderacion').is(':checked') && qType == 'T') {
			Object.keys(question.answers).forEach(function(key) {
				let genero = question.answers[key].genero || [];
				totalPonderated += self.getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion);
			});
		}

		Object.keys(question.answers).forEach(function(key) {
			let answer = question.answers[key];
			let answerStr = answer.answer;
			if(typeof(answer.answer) === 'undefined') {
				answerStr = answer.question;
			}

			if(answerStr == '') {
				answerStr = answer.code;
			}

			if(answerStr != '') {
				table += `<tr id="sid${j}">`;
				table += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				tablePercent += `<tr id="sidpercent${j}">`;
				tablePercent += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				tablePercentTTBLTB += `<tr id="sidpercent${j}">`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

				let genero = question.answers[key].genero || [];
				let edad = question.answers[key].edad || [];
				let sec = question.answers[key].sec || [];
				let region = question.answers[key].region || [];
				let consumo = question.answers[key].consumo || [];
				let numUsers = question.answers[key].numUsers || 0;

				var calculateRes = self.renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, question.numAnswersTotal, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated);
				table += calculateRes.table + `</tr>`;
				tablePercent += calculateRes.tablePercent + `</tr>`;
				tablePercentTTBLTB += calculateRes.tablePercentTTBLTB + `</tr>`;
				totalArrayRes = calculateRes.totalArrayRes;
				j++;
			}
		});

		let result = self.renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion);
		table += result.table;
		tablePercent += result.table;
		tablePercentTTBLTB += result.table;

		table += `
				</tbody>
			</table>
			</br></br>
		`;

		tablePercent += `
				</tbody>
			</table>
			</br></br>
		`;

		var elemTablePerc = self.renderCalculatePercent(tablePercent, totalUsers);

		$('#previewTable #datadetailtables .card-body').find('#' + question.qid).append(table);
		$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePerc);
		if(qType == 'L') {
			let TTBLTB = self.renderTTBLTB(tablePercentTTBLTB);
			tablePercentTTBLTB += TTBLTB.TTB;
			tablePercentTTBLTB += TTBLTB.LTB;
			tablePercentTTBLTB += `
					</tbody>
				</table>
				</br></br>
			`;
			var elemTablePercTTBLTB = self.renderCalculatePercent(tablePercentTTBLTB,totalUsers);
			$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePercTTBLTB);
		}
		$('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').find('#' + question.qid).append(tableindex);
		$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid).append(tableindexHidden);
		$('.dataTables_filter').hide();
	},

	renderPreviewTableSQ(question, arrayTotales, arrayFactoresPonderacion) {
		let self = this;

		// En caso de que el array sq esté vacío
		if(question && question.sq.length <= 0) {
			self.loadError = true;

			return false;
		}

		$('#previewTable').show();
		let qType = question.type;

		let totalUsers = question.sq[0].answers[0].numUsers;
		let totalGeneroPorc = question.sq[0].answers[0].totalGeneroPorc;

		let headersGenero = question.sq[0].answers[0].genero || [];
		let headersEdad = question.sq[0].answers[0].edad || [];
		let headersSec = question.sq[0].answers[0].sec || [];
		let headersRegion = question.sq[0].answers[0].region || [];
		let headersConsumo = question.sq[0].answers[0].consumo || [];

		let total = headersGenero.length + headersEdad.length + headersSec.length + headersRegion.length + 2;
		if(self.consumer == '1') {
			total += headersConsumo.length;
		}
		let headersRes = self.renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo);

		let table = '';
		let tablePercent = '';

		let j = 0;
		Object.keys(question.sq).forEach(function(keysq) {
			table += headersRes.table;
			tablePercent += headersRes.table;

			let answer = question.sq[keysq];
			table += `<tr><th class="text-left" colspan="${total}" title="${answer.question}">${answer.question}</th></tr>`;
			tablePercent += `<tr><th class="text-left" colspan="${total}" title="${answer.question}">${answer.question}</th></tr>`;

			let tableindex = `<tr><th class="text-left w-100" title="${question.question + ' ' + answer.question}">${question.question + ' ' + answer.question}</th></tr>`;
			$(tableindex).insertBefore($('#previewTable #datadetailindex .card-body #tablePreviewIndex tbody').find('#' + question.qid));
			$(tableindex).insertBefore($('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid));

			let totalArrayRes = headersRes.totalArrayRes;
			let totalPonderated = 0;
			if($('#ponderacion').is(':checked') && qType == 'T') {
				Object.keys(answer.answers).forEach(function(key) {
					let genero = answer.answers[key].genero || [];
					totalPonderated += self.getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion);
				});
			}
			Object.keys(answer.answers).forEach(function(key) {
				let answerStr = answer.answers[key].answer;
				if(typeof(answer.answers[key].answer) === 'undefined') {
					answerStr = answer.answers[key].question;
				}

				if(answerStr != '') {
					table += `<tr id="sid${j}">`;
					table += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

					tablePercent += `<tr id="sidpercent${j}">`;
					tablePercent += `<td class="text-truncate" strtype="text" title="${answerStr}" style='mso-number-format: "\@";'>${answerStr}</td>`;

					let genero = answer.answers[key].genero || [];
					let edad = answer.answers[key].edad || [];
					let sec = answer.answers[key].sec || [];
					let region = answer.answers[key].region || [];
					let consumo = answer.answers[key].consumo || [];
					let numUsers = answer.answers[key].numUsers || 0;

					var calculateRes = self.renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, totalUsers, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated);
					table += calculateRes.table + `</tr>`;
					tablePercent += calculateRes.tablePercent + `</tr>`;
					totalArrayRes = calculateRes.totalArrayRes;
					j++;
				}
			});

			let result = self.renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion);
			table += result.table;
			tablePercent += result.table;
			totalArrayRes = result.totalArrayRes;

			if(question.type == ':') {
				table += '</tbody></table></br></br>';
				tablePercent += '</tbody></table></br></br>';
			}
		});

		$('#previewTable #datadetailindex .card-body #tablePreviewIndexHidden tbody').find('#' + question.qid).remove();

		if(question.type != ':') {
			table += `
					</tbody>
				</table>
				</br></br>
			`;

			tablePercent += `
					</tbody>
				</table>
				</br></br>
			`;
		}

		var elemTablePerc = self.renderCalculatePercent(tablePercent, totalUsers);
		$('#previewTable #datadetailtables .card-body').find('#' + question.qid).append(table);
		$('#previewTable #datadetailtables .card-body').find('#perc' + question.qid).append(elemTablePerc);

		$('.dataTables_filter').hide();
	},

	renderTableHeaders(question, total, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo) {
		let self = this;

		let totalArrayRes = [];

		let table = `
			<table id="tablePreview${question.row}" class="table table-hover">
				<thead>
					<tr><th class="text-left" colspan="${total}" title="${question.question}">${question.question}</th></tr>
					<tr>`;
						table += `<th></th>`;
						table += `<th></th>`;

						let length = headersGenero.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC151}">${pf.const.language.RSC151}</th>`;

						length = headersEdad.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC565}">${pf.const.language.RSC565}</th>`;

						length = headersSec.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC598}">${pf.const.language.RSC598}</th>`;

						length = headersRegion.length;
						table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>`;

						if(self.consumer == '1') {
							length = headersConsumo.length;
							table += `<th class="text-center" colspan="${length}" title="${pf.const.language.RSC618}">${pf.const.language.RSC618}</th>`;
						}
					table += `
					</tr>
					<tr>`;
						table += `<th></th>`;
						table += `<th title="${pf.const.language.RSC345}">${pf.const.language.RSC345}</th>`;

						length = headersGenero.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersGenero[i].genero}">${headersGenero[i].genero}</th>`;
							totalArrayRes[headersGenero[i].genero] = 0;
						}

						length = headersEdad.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersEdad[i].edad}">${headersEdad[i].edad}</th>`;
							totalArrayRes[headersEdad[i].edad] = 0;
						}

						length = headersSec.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersSec[i].sec}">${headersSec[i].sec}</th>`;
							totalArrayRes[headersSec[i].sec] = 0;
						}

						length = headersRegion.length;
						for(let i = 0; i < length; ++i) {
							table += `<th title="${headersRegion[i].regionABI}">${headersRegion[i].regionABI}</th>`;
							totalArrayRes[headersRegion[i].regionABI] = 0;
						}

						if(self.consumer == '1') {
							length = headersConsumo.length;
							for(let i = 0; i < length; ++i) {
								if(headersConsumo[i].questionConsumo == '1') {
									table += `<th title="${pf.const.language.RSC1899}">${pf.const.language.RSC1899}</th>`;
								} else if(headersConsumo[i].questionConsumo == '0') {
									table += `<th title="${pf.const.language.RSC1900}">${pf.const.language.RSC1900}</th>`;
								}
								totalArrayRes[headersConsumo[i].questionConsumo] = 0;
							}
						}
					table +=
					`</tr>
				</thead>` +
				// TODO: FIltros
				//	<thead class="filtersPoll">
				//		<tr>
				//			<td>remuneracion</td>
				//		</tr>
				// </thead>
				`<tbody>
		`;

		return {'table': table, 'totalArrayRes': totalArrayRes};
	},

	formatPonderacionesIfChecked(arrayFactoresPonderacion, key, key2, value) {
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			var factorponderacion = arrayFactoresPonderacion[key][key2];
			value = value * factorponderacion;
			value = parseFloat(value.toFixed(2));
		}
		return value;
	},

	formatPonderacionesIfCheckedTotales(value) {
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			value = value.toFixed(2);
		}
		return value;
	},

	formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, numAnswersTotal) {
		let totalPorc = 0;
		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			totalPorc = (parseFloat(total) * 100) / parseFloat(numAnswersTotal);
			if(qType == 'M' || qType == 'S') {
				totalPorc = (parseFloat(total) * 100) / parseFloat(numUsers);
			}
		} else {
			totalPorc = (parseInt(total) * 100) / parseInt(numAnswersTotal);
			if(qType == 'M' || qType == 'S') {
				totalPorc = (parseInt(total) * 100) / parseInt(numUsers);
			}
		}
		return totalPorc;
	},

	formatPonderacionesIfCheckedPercent(qType, porcentaje, value, total, arrayFactoresPonderacion, key, key2) {
		let self = this;

		let result = 0;

		//mirar si se ha marcado el check de ponderación
		if($('#ponderacion').is(':checked')) {
			let valuePond = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, key, key2, value);
			result = ((valuePond*100)/total).toFixed(2);
		} else {
			result = porcentaje.toFixed(2);
		}
		return result;
	},

	singlePercentTTBLTB(a, b) {
		if(b == 0) {
			return 0;
		}

		return ((a/b) * 100).toFixed(2);
	},

	renderCalculateData(genero, edad, sec, region, consumo, totalArrayRes, numAnswersTotal, qType, arrayTotales, numUsers, arrayFactoresPonderacion, totalPonderated) {
		let self = this;

		let table = '';
		let total = 0;
		let totalPorc = 0;
		let tablePercent = '';
		let tablePercentTTBLTB = '';
		let partialPercent = 0;
		let partialPercentTTBLTB = 0;
		let totalGrouped = 0;

		let length = genero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', genero[i].genero, genero[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, genero[i].porc, genero[i].value, arrayTotales.genero[i].value, arrayFactoresPonderacion, 'genero', genero[i].genero);
				partialPercentTTBLTB = self.singlePercentTTBLTB(genero[i].value, arrayTotales.genero[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[genero[i].genero] = parseInt(totalArrayRes[genero[i].genero]) + parseInt(genero[i].value);
			total += value;
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, genero[i].porc, genero[i].value, totalGrouped, arrayFactoresPonderacion, 'genero', genero[i].genero);
				partialPercentTTBLTB = self.singlePercentTTBLTB(genero[i].value, arrayTotales.genero[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = edad.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'edad', edad[i].edad, edad[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, edad[i].porc, edad[i].value, arrayTotales.edad[i].value, arrayFactoresPonderacion, 'edad', edad[i].edad);
				partialPercentTTBLTB = self.singlePercentTTBLTB(edad[i].value, arrayTotales.edad[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[edad[i].edad] = parseInt(totalArrayRes[edad[i].edad]) + parseInt(edad[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, edad[i].porc, edad[i].value, totalGrouped, arrayFactoresPonderacion, 'edad', edad[i].edad);
				partialPercentTTBLTB = self.singlePercentTTBLTB(edad[i].value, arrayTotales.edad[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = sec.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'sec', sec[i].sec, sec[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, sec[i].porc, sec[i].value, arrayTotales.sec[i].value, arrayFactoresPonderacion, 'sec', sec[i].sec);
				partialPercentTTBLTB = self.singlePercentTTBLTB(sec[i].value, arrayTotales.sec[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[sec[i].sec] = parseInt(totalArrayRes[sec[i].sec]) + parseInt(sec[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, sec[i].porc, sec[i].value, totalGrouped, arrayFactoresPonderacion, 'sec', sec[i].sec);
				partialPercentTTBLTB = self.singlePercentTTBLTB(sec[i].value, arrayTotales.sec[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		length = region.length;
		totalGrouped = 0;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'region', region[i].regionABI, region[i].value);
			table += `<td class="text-truncate" title="${value}">${value}</td>`;

			if(!$('#ponderacion').is(':checked')) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, region[i].porc, region[i].value, arrayTotales.region[i].value, arrayFactoresPonderacion, 'region', region[i].regionABI);
				partialPercentTTBLTB = self.singlePercentTTBLTB(region[i].value, arrayTotales.region[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}

			totalArrayRes[region[i].regionABI] = parseInt(totalArrayRes[region[i].regionABI]) + parseInt(region[i].value);
			totalGrouped += value;
		}

		if($('#ponderacion').is(':checked')) {
			for(let i = 0; i < length; ++i) {
				partialPercent = self.formatPonderacionesIfCheckedPercent(qType, region[i].porc, region[i].value, totalGrouped, arrayFactoresPonderacion, 'region', region[i].regionABI);
				partialPercentTTBLTB = self.singlePercentTTBLTB(region[i].value, arrayTotales.region[i].value);
				tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
			}
		}

		if(self.consumer == '1') {
			length = consumo.length;
			totalGrouped = 0;
			for(let i = 0; i < length; ++i) {
				let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo, consumo[i].value);
				table += `<td class="text-truncate" title="${value}">${value}</td>`;

				if(!$('#ponderacion').is(':checked')) {
					partialPercent = self.formatPonderacionesIfCheckedPercent(qType, consumo[i].porc, consumo[i].value, arrayTotales.consumo[i].value, arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo);
					partialPercentTTBLTB = self.singlePercentTTBLTB(consumo[i].value, arrayTotales.consumo[i].value);
					tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
					tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercentTTBLTB}" title="${partialPercentTTBLTB}%"></td>`;
				}

				totalArrayRes[consumo[i].questionConsumo] = parseInt(totalArrayRes[consumo[i].questionConsumo]) + parseInt(consumo[i].value);
				totalGrouped += value;
			}

			if($('#ponderacion').is(':checked')) {
				for(let i = 0; i < length; ++i) {
					partialPercent = self.formatPonderacionesIfCheckedPercent(qType, consumo[i].porc, consumo[i].value, totalGrouped, arrayFactoresPonderacion, 'consumo', consumo[i].questionConsumo);
					partialPercentTTBLTB = self.singlePercentTTBLTB(consumo[i].value, arrayTotales.consumo[i].value);
					tablePercent += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
					tablePercentTTBLTB += `<td class="text-truncate" strtype="text" data-val="${partialPercent}" title="${partialPercent}%"></td>`;
				}
			}
		}

		total = self.formatPonderacionesIfCheckedTotales(total);
		//cambio requerido por Alex a fecha 24/08/2021 para calcular los porcentajes por columnas
		if($('#ponderacion').is(':checked') && qType == 'T') {
			totalPorc = self.formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, totalPonderated);
		} else {
			totalPorc = self.formatPonderacionesIfCheckedTotalesPercent(qType, total, numUsers, numAnswersTotal);
		}

		if(totalPorc == undefined) {
			totalPorc = 0;
		}

		table = `<td class="text-truncate" title="${total}"><strong>${total}</strong></td>` + table;
		tablePercent = `<td class="text-truncate" strtype="text" title="${totalPorc.toFixed(2)}%"><strong>${totalPorc.toFixed(2)}%</strong></td>` + tablePercent;
		tablePercentTTBLTB = `<td class="text-truncate" strtype="text" title="${totalPorc.toFixed(2)}%"><strong>${totalPorc.toFixed(2)}%</strong></td>` + tablePercentTTBLTB;

		return {'table': table, 'totalArrayRes': totalArrayRes, 'tablePercent': tablePercent, 'tablePercentTTBLTB': tablePercentTTBLTB};
	},

	getCalculateDataPonderated(genero, totalArrayRes, arrayFactoresPonderacion) {
		let self = this;

		let length = genero.length;
		for(let i = 0; i < length; ++i) {
			totalArrayRes[genero[i].genero] = parseInt(totalArrayRes[genero[i].genero]) + parseInt(genero[i].value);
		}

		let result = self.calculateTotalDataPonderated(totalArrayRes, genero, arrayFactoresPonderacion);

		for(let i = 0; i < length; ++i) {
			totalArrayRes[genero[i].genero] = 0;
		}

		return result;
	},

	renderCalculatePercent(tablePercent,totalUsers) {
		var elemTablePerc = $(tablePercent);
		var totalRow = elemTablePerc.find('tr[id^="totalRow"] td');
		elemTablePerc.find('tr[id^="sidpercent"]').each(function() {
			var index = 0;
			$(this).find('td').each(function() {
				if(typeof($(this).attr('data-val')) !== 'undefined') {
					var calcPerc = $(this).attr('data-val');
					if($(this).attr('data-val') == 0) {
						calcPerc = 0;
					}
					$(this).text(calcPerc + '%');
				}
				++index;
			});
		});

		return elemTablePerc;
	},

	renderTotalData(totalArrayRes, headersGenero, headersEdad, headersSec, headersRegion, headersConsumo, arrayFactoresPonderacion) {
		let self = this;

		let tableTotal = `<tr id="totalRow"><td class="text-truncate" title="${pf.const.language.RSC345}"><strong>${pf.const.language.RSC345}</strong></td>`;
		let table = '';
		let total = 0;

		length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', headersGenero[i].genero, totalArrayRes[headersGenero[i].genero]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			total += value;
			totalArrayRes[headersGenero[i].genero] = 0;
		}

		length = headersEdad.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'edad', headersEdad[i].edad, totalArrayRes[headersEdad[i].edad]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersEdad[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersEdad[i].edad] = 0;
		}

		length = headersSec.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'sec', headersSec[i].sec, totalArrayRes[headersSec[i].sec]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersSec[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersSec[i].sec] = 0;
		}

		length = headersRegion.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'region', headersRegion[i].regionABI, totalArrayRes[headersRegion[i].regionABI]);
			table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
			totalArrayRes[headersRegion[i].genero] = 0;
		}
		for(let i = 0; i < length; ++i) {
			totalArrayRes[headersRegion[i].regionABI] = 0;
		}

		if(self.consumer == '1') {
			length = headersConsumo.length;
			for(let i = 0; i < length; ++i) {
				let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'consumo', headersConsumo[i].questionConsumo, totalArrayRes[headersConsumo[i].questionConsumo]);
				table += `<td class="text-truncate" title="${value}"><strong>${value}</strong></td>`;
				totalArrayRes[headersConsumo[i].genero] = 0;
			}
			for(let i = 0; i < length; ++i) {
				totalArrayRes[headersConsumo[i].questionConsumo] = 0;
			}
		}

		table = tableTotal + `<td class="text-truncate" title="${total}"><strong>${total}</strong></td>${table}</tr>`;

		return {'table': table, 'totalArrayRes': totalArrayRes};
	},

	calculateTotalDataPonderated(totalArrayRes, headersGenero, arrayFactoresPonderacion) {
		let self = this;
		let total = 0;

		length = headersGenero.length;
		for(let i = 0; i < length; ++i) {
			let value = self.formatPonderacionesIfChecked(arrayFactoresPonderacion, 'genero', headersGenero[i].genero, totalArrayRes[headersGenero[i].genero]);
			total += value;
		}

		return total;
	},

	setTabEvents() {
		$('#datadetailtablestab').click(function() {
			$('#datadetailindextab, #datadetailresulttab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').show();
			$('#datadetailindex').hide();
			$('#datadetailresult').hide();
		});

		$('#datadetailindextab').click(function() {
			$('#datadetailtablestab, #datadetailresulttab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').hide();
			$('#datadetailindex').show();
			$('#datadetailresult').hide();
		});

		$('#datadetailresulttab').click(function() {
			$('#datadetailindextab, #datadetailtablestab').removeClass('activeTB');
			$(this).addClass('activeTB');
			$('#datadetailtables').hide();
			$('#datadetailindex').hide();
			$('#datadetailresult').show();
		});
	},

	generateExcelTables() {
		if('ActiveXObject' in window) {
			alert('This is Internet Explorer!');
		} else {
			var cache = {};
			var tmpl = function tmpl(str, data) {
				var fn = !/\W/.test(str) ? cache[str] = cache[str] || tmpl(document.getElementById(str).innerHTML) :
				new Function('obj',
								"var p=[],print=function(){p.push.apply(p,arguments);};" +
								"with(obj){p.push('" +
								str.replace(/[\r\t\n]/g, " ")
								.split("{{").join("\t")
								.replace(/((^|}})[^\t]*)'/g, "$1\r")
								.replace(/\t=(.*?)}}/g, "',$1,'")
								.split("\t").join("');")
								.split("}}").join("p.push('")
								.split("\r").join("\\'") + "');}return p.join('');");
				return data ? fn(data) : fn;
			};
			var tableToExcel = (function() {
				var uri = 'data:application/vnd.ms-excel;base64,',
					template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{{=worksheet}}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body>{{for(var i=0; i<tables.length;i++){ }}<table>{{=tables[i]}}</table><table></table><table></table><table></table><table></table>{{ } }}</body></html>',
					base64 = function(s) {
						return window.btoa(unescape(encodeURIComponent(s)));
					},
					format = function(s, c) {
						return s.replace(/{(\w+)}/g, function(m, p) {
							return c[p];
						});
					};
				return function(tableList, name) {
					if(!tableList.length > 0 && !tableList[0].nodeType) {
						table = document.getElementById(table);
					}
					var tables = [];
					for(var i = 0; i < tableList.length; i++) {
						tables.push(tableList[i].innerHTML);
					}
					var ctx = {
						worksheet: name || 'Worksheet',
						tables: tables
					};

					var link = document.createElement('a');
					link.download = $('#poll' + self.suffix).val() + '.xls';
					link.href = uri + base64(tmpl(template, ctx));
					link.click();
				};
			})();
			tableToExcel($('table[id^="tablePreview"]'), 'one');
		}
	},

	s2ab(s) {
		var buf = new ArrayBuffer(s.length);
		var view = new Uint8Array(buf);
		for(var i=0; i!=s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
		return buf;
	},

	create_gap_rows(ws, nrows) {
		var ref = XLSX.utils.decode_range(ws['!ref']);	// get original range
		ref.e.r += nrows;								// add to ending row
		ws['!ref'] = XLSX.utils.encode_range(ref);		// reassign row
		removeLoader();
	},

	exportAsExcel() {
		let self = this;

		var tables = $('#datadetailtables table[id^="tablePreview"]');
		var wb = XLSX.utils.book_new();

		//Hoja preguntas
		var tableindex = $('#tablePreviewIndexHidden');
		if(tableindex.length > 0) {
			var wsindex = XLSX.utils.table_to_sheet(tableindex[0]);
			XLSX.utils.book_append_sheet(wb, wsindex, pf.const.language.RSC964);
		}

		var ws = XLSX.utils.table_to_sheet(tables[0]);
		for(var i = 1; i < tables.length; ++i) {
			self.create_gap_rows(ws, 4);
			XLSX.utils.sheet_add_dom(ws, tables[i], {origin: -1});
		}

		//change cell format to %
		Object.entries(ws).forEach(function(obj) {
			// Valor
			value = obj[1].v;
			if(typeof(value) !== 'undefined' && value != '') {
				valuestr = value.toString();
				if(valuestr.indexOf('%') !== -1) {
					// Fórmula
					obj[1].z = '#,##0.00"%"';
					// Tipo
					obj[1].t = 'n';
					if(valuestr != 'NaN%') {
						obj[1].v = parseFloat(valuestr.replace('%', ''));
					} else {
						obj[1].v = 0;
					}
				}
			}
		});

		XLSX.utils.book_append_sheet(wb, ws, pf.const.language.RSC965);

		//Hoja totales
		var tabletotal = $('#tableTotalResult');
		if(tabletotal.length > 0) {
			var wstotal = XLSX.utils.table_to_sheet(tabletotal[0]);
			XLSX.utils.book_append_sheet(wb, wstotal, pf.const.language.RSC345);
		}

		var wbout = XLSX.write(wb, {bookType:'xlsx', bookSST:true, type: 'binary'});

		module$FileSaver.saveAs(new Blob([self.s2ab(wbout)],{type:'application/octet-stream'}), $('#poll' + self.suffix).val() + '.xlsx');
	},

	clickEvents(data) {
		let self = this;

		if($('#poll').val() !== '') {
			$('#previewTables').prop('disabled', false);
			// Activar botón en filtros
			$('#loadWithFilters').removeClass('spanDisabled');
		}
		$('#country').val(data.descripcion);
		$('#country').data('iso', data.isocode);
		self.country = data.isocode;
	}
};