class UpdateGraphs {
	constructor(data, filter) {
		this.data = data;
		this.filter = filter;
		this.dataFiltered = [];
	}

	// Filtrado de registros
	filterData() {
		let size = this.data.length;
		// Loop en registros
		for(let i = 0; i < size; i++) {
			let filter = false;
			let element;
			// Loop en filtros
			for(element in this.filter) {
				if((this.filter[element] !== '' && this.data[i][element] !== '') || this.filter[element] === '-') {
					// Pasar a minúscula los valores de filtro
					let elementValue = this.filter[element].toLowerCase();
					if(element == 'consejero' || element == 'staff' || element == 'clabe' || element == 'enabled') {
						if(elementValue == 'no') {
							elementValue = '0';
						} else if(elementValue == 'si') {
							elementValue = '1';
						}
					} else if(element == 'visualizar') {
						continue;
					}

					// Pasar a cadena y minúscula los valores de registro
					let value = '';
					if(this.data[i][element] == null || this.data[i][element] == '') {
						value = '-';
					} else {
						if(element == 'consejero' || element == 'staff' || element == 'clabe' || element == 'enabled') {
							value = this.data[i][element].toString();
						} else {
							value = this.data[i][element].toString().toLowerCase();
						}
					}

					// Comprobación de registros
					if(value.includes(elementValue)) {
						filter = true;
					} else {
						filter = false;
						break;
					}
				} else if(this.filter[element] == '') {
					filter = true;
				} else {
					filter = false;
					break;
				}
			}
			if(filter) {
				this.dataFiltered.push(this.data[i]);
			}
		}
	}

	updateAnswersData(answersLabelsData) {
		let newData = [];
		// Añadir tantos espacios como labels hay
		let labelsSize = answersLabelsData.labels.length;
		for(let l = 0; l < labelsSize; l++) {
			newData.push(0);
		}
		// Aumentar el número según selección
		let size = this.dataFiltered.length;
		for(let i = 0; i < size; i++) {
			let answer = this.dataFiltered[i].answer;

			// Control para las preguntas tipo 'Y'
			if(answer == 'Y') {
				answer = 'YES';
			} else if(answer == 'N') {
				answer = 'NO';
			}

			let index = answersLabelsData.labels.indexOf(answer);
			newData[index]++;
		}
		// Pasar valores a porcentajes
		let newDataPercent = [];
		let totalValue = 0;
		for(let p = 0; p < newData.length; p++) {
			totalValue += newData[p];
		}

		if(totalValue > 0) {
			for(let tp = 0; tp < newData.length; tp++) {
				let percent = (newData[tp] * 100 / totalValue).toFixed(1);
				if(parseInt(percent) == parseFloat(percent)) {
					percent = parseInt(percent);
				}
				newDataPercent.push(percent);
			}
		} else {
			newDataPercent = newData;
		}

		return newDataPercent;
	}

	updateGenderData(genderLabelsData) {
		let newData = [];
		// Añadir tantos espacios como labels hay
		let labelsSize = genderLabelsData.labels.length;
		for(let l = 0; l < labelsSize; l++) {
			newData.push(0);
		}
		// Aumentar el número según selección
		let size = this.dataFiltered.length;
		for(let i = 0; i < size; i++) {
			let answer = this.dataFiltered[i].perf003;
			let index = genderLabelsData.labels.indexOf(answer);
			newData[index]++;
		}
		// Pasar valores a porcentajes
		let newDataPercent = [];
		let totalValue = 0;
		for(let p = 0; p < newData.length; p++) {
			totalValue += newData[p];
		}

		if(totalValue > 0) {
			for(let tp = 0; tp < newData.length; tp++) {
				let percent = (newData[tp] * 100 / totalValue).toFixed(1);
				if(parseInt(percent) == parseFloat(percent)) {
					percent = parseInt(percent);
				}
				newDataPercent.push(percent);
			}
		} else {
			newDataPercent = newData;
		}
		return newDataPercent;
	}

	updateAgeData(ageLabelsData) {
		let newData = [];
		// Añadir tantos espacios como labels hay
		let labelsSize = ageLabelsData.labels.length;
		for(let l = 0; l < labelsSize; l++) {
			newData.push(0);
		}
		// Aumentar el número según selección
		let size = this.dataFiltered.length;
		for(let i = 0; i < size; i++) {
			let answer = this.dataFiltered[i].perf002Range;
			let index = ageLabelsData.labels.indexOf(answer);
			newData[index]++;
		}
		// Pasar valores a porcentajes
		let newDataPercent = [];
		let totalValue = 0;
		for(let p = 0; p < newData.length; p++) {
			totalValue += newData[p];
		}

		if(totalValue > 0) {
			for(let tp = 0; tp < newData.length; tp++) {
				let percent = (newData[tp] * 100 / totalValue).toFixed(1);
				if(parseInt(percent) == parseFloat(percent)) {
					percent = parseInt(percent);
				}
				newDataPercent.push(percent);
			}
		} else {
			newDataPercent = newData;
		}
		return newDataPercent;
	}

	updateStateData(stateLabelsData) {
		let newData = [];
		// Añadir tantos espacios como labels hay
		let labelsSize = stateLabelsData.labels.length;
		for(let l = 0; l < labelsSize; l++) {
			newData.push(0);
		}
		// Aumentar el número según selección
		let size = this.dataFiltered.length;
		for(let i = 0; i < size; i++) {
			let answer = this.dataFiltered[i].perf001;
			let index = stateLabelsData.labels.indexOf(answer);
			newData[index]++;
		}
		// Pasar valores a porcentajes
		let newDataPercent = [];
		let totalValue = 0;
		for(let p = 0; p < newData.length; p++) {
			totalValue += newData[p];
		}

		if(totalValue > 0) {
			for(let tp = 0; tp < newData.length; tp++) {
				let percent = (newData[tp] * 100 / totalValue).toFixed(1);
				if(parseInt(percent) == parseFloat(percent)) {
					percent = parseInt(percent);
				}
				newDataPercent.push(percent);
			}
		} else {
			newDataPercent = newData;
		}
		return newDataPercent;
	}

	updateNSEData(NSELabelsData) {
		let newData = [];
		// Añadir tantos espacios como labels hay
		let labelsSize = NSELabelsData.labels.length;
		for(let l = 0; l < labelsSize; l++) {
			newData.push(0);
		}
		// Aumentar el número según selección
		let size = this.dataFiltered.length;
		for(let i = 0; i < size; i++) {
			let answer = this.dataFiltered[i].perf004;
			let index = NSELabelsData.labels.indexOf(answer);
			newData[index]++;
		}
		// Pasar valores a porcentajes
		let newDataPercent = [];
		let totalValue = 0;
		for(let p = 0; p < newData.length; p++) {
			totalValue += newData[p];
		}

		if(totalValue > 0) {
			for(let tp = 0; tp < newData.length; tp++) {
				let percent = (newData[tp] * 100 / totalValue).toFixed(1);
				if(parseInt(percent) == parseFloat(percent)) {
					percent = parseInt(percent);
				}
				newDataPercent.push(percent);
			}
		} else {
			newDataPercent = newData;
		}
		return newDataPercent;
	}
}