let DefinicionCatalogacionAsesoresController = {
	catalogs: null,
	rangoDesde: '',
	rangoHasta: '',
	catalogacion: '',

	setEvents() {
		let self = DefinicionCatalogacionAsesoresController;

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC38);

		// Opciones de header
		let jsonsubopt = {
			save: 'btn-setCatalog',
			new: 'btn-send'
		};

		let nav = `
			<div class="row mx-0">
				${createSubOptionNew(jsonsubopt.new)}
				${createSubOptionSave(jsonsubopt.save)}
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#btn-send svg').css('width', '24px');
		$('#btn-send svg').css('height', '24px');

		// Botón principal
		$('#btn-setCatalog').addClass('main-button');

		// Botones secundarios
		$('#btn-send').addClass('secondary-button');

		self.loadLanguage();

		ajaxComunCallWithCallback('getCatalogacionesM', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.catalogs = ajaxReturn.result;
				self.renderCatalogs();
			}
		});

		$('#btn-send').click(function() {
			self.addCatalogs();
		});

		$('#btn-setCatalog').click(function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1989;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.setCatalogs();
			}, function() {});
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	setCatalogs() {
		let self = DefinicionCatalogacionAsesoresController;

		// Actualizar objeto catalogos
		for(let i = 0; i < self.catalogs.length; i++) {
			// Actualizar objeto
			self.catalogs[i].rangoDesde = $('input[data-id=' + i + '][data-name=rangoDesde]').val();
			self.catalogs[i].rangoHasta = $('input[data-id=' + i + '][data-name=rangoHasta]').val();
			self.catalogs[i].catalogacion = $('input[data-id=' + i + '][data-name=catalogacion]').val();
			// Actualizar spans
			$('span[data-id=' + i + '][data-name=rangoDesde]').html(self.catalogs[i].rangoDesde);
			$('span[data-id=' + i + '][data-name=rangoHasta]').html(self.catalogs[i].rangoHasta);
			$('span[data-id=' + i + '][data-name=catalogacion]').html(self.catalogs[i].catalogacion);
		}

		let parameters = {
			catalogs: JSON.stringify(self.catalogs)
		};
		ajaxComunCallWithCallback('setCatalogacionM', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let errorTitle = pf.const.language.RSC78;
				let errorContent = pf.const.language.RSC106;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				self.renderCatalogs();
			}
		});
	},

	addCatalogs() {
		let self = DefinicionCatalogacionAsesoresController;

		let content = `
				<label for="rangoDesde" class="fw-500">${pf.const.language.RSC363}</label>
				<div class="input-group mb-3">
					<input id="rangoDesde" type="number" class="form-control minMax" value="${self.rangoDesde}" placeholder="" aria-label="" aria-describedby="basic-addon2a" min="0" max="100">
					<div class="input-group-append">
						<span id="basic-addon2a" class="input-group-text">%</span>
					</div>
				</div>

				<label for="rangoHasta" class="fw-500">${pf.const.language.RSC365}</label>
				<div class="input-group">
					<input id="rangoHasta" type="number" class="form-control minMax" value="${self.rangoHasta}" placeholder="" aria-label="" aria-describedby="basic-addon2b" min="0" max="100">
					<div class="input-group-append">
						<span id="basic-addon2b" class="input-group-text">%</span>
					</div>
				</div>

				<label for="catalogacion" class="fw-500">${pf.const.language.RSC187}</label>
				<input id="catalogacion" type="text" class="form-control" autofocus="autofocus" value="${self.catalogacion}">

				<script>
					// Limitación de valores numéricos
					$('.minMax').off().on('blur', function() {
						let value = $(this).val();

						if(value < 0) {
							$(this).val('0');
						} else if(value > 100) {
							$(this).val('100');
						}
					});

					// Pintar texto de label
					changeLabelsColor();
				</script>
			`;

		let objInfo = {
			accept: {
				text: pf.const.language.RSC93
			},
			cancel: {
				text: pf.const.language.RSC57
			}
		};

		let alertTitle = pf.const.language.RSC1634;
		pf.utils.showInfoDialogAcceptCancel(alertTitle, content, objInfo, function() {
			self.rangoDesde = $('#rangoDesde').val();
			self.rangoHasta = $('#rangoHasta').val();
			self.catalogacion = $('#catalogacion').val();
			if($('#rangoDesde').val() == '' || $('#rangoHasta').val() == '' || $('#catalogacion').val() == '') {
				let alertTitle = pf.const.language.RSC93;
				let alertText = pf.const.language.RSC101;
				let alertBtn = pf.const.language.RSC141;
				pf.utils.showInfoDialog(alertTitle, alertText, alertBtn);
			} else {
				// Llamar al servicio de añadir catalogo
				let catalog = {
					'rangoDesde': self.rangoDesde,
					'rangoHasta': self.rangoHasta,
					'catalogacion': self.catalogacion
				};
				self.saveNewCatalog(catalog);
			}
		}, function() {});
	},

	saveNewCatalog(catalog) {
		let self = DefinicionCatalogacionAsesoresController;

		let parameters = {
			catalog: JSON.stringify(catalog)
		};
		ajaxComunCallWithCallback('saveNewCatalogM', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.catalogs.push(catalog);
				self.rangoDesde = '';
				self.rangoHasta = '';
				self.catalogacion = '';
				self.renderCatalogs();
			}
		});
	},

	renderCatalogs() {
		let self = DefinicionCatalogacionAsesoresController;

		let render = `
			<table id="example" class="table table-hover tRegs">
				<thead>
					<tr class="table-light">
						<th scope="col" title="${pf.const.language.RSC363}">${pf.const.language.RSC363}</th>
						<th scope="col" title="${pf.const.language.RSC365}">${pf.const.language.RSC365}</th>
						<th scope="col" title="${pf.const.language.RSC187}">${pf.const.language.RSC187}</th>
						<th scope="col"></th>
					</tr>
				</thead>

				<tbody>
		`;

		$.each(self.catalogs, function(i, value) {
			render += `
				<tr class="table-light">
					<td>
						<span class="d-none" data-name="rangoDesde" data-id="${i}">${self.catalogs[i].rangoDesde}</span>
						<div class="input-group input-group-sm ">
							<input type="number" class="form-control numMinMax" value="${self.catalogs[i].rangoDesde}" data-name="rangoDesde" data-id="${i}" placeholder="" aria-label="" aria-describedby="basic-addon2c" min="0" max="100">
							<div class="input-group-append">
								<span id="basic-addon2c" class="input-group-text">%</span>
							</div>
						</div>
					</td>
					<td>
						<span class="d-none" data-name="rangoHasta" data-id="${i}">${self.catalogs[i].rangoHasta}</span>
						<div class="input-group input-group-sm">
							<input type="number" class="form-control numMinMax" value="${self.catalogs[i].rangoHasta}" data-name="rangoHasta" data-id="${i}" placeholder="" aria-label="" aria-describedby="basic-addon2d" min="0" max="100">
							<div class="input-group-append">
								<span id="basic-addon2d" class="input-group-text">%</span>
							</div>
						</div>
					</td>
					<td>
						<span class="d-none" data-name="catalogacion" data-id="${i}">${self.catalogs[i].catalogacion}</span>
						<input class="form-control form-control-sm" data-name="catalogacion" data-id="${i}" value="${self.catalogs[i].catalogacion}">
					</td>
					<td class="remove-catalog text-center" data-id="${i}">
						<span class="c-pointer circle-container" data-id="${i}">
							${stcmbackend.svg.trash}
						</span>
					</td>
				</tr>
			`;
		});

		render += `
				</tbody>
			</table>
		`;

		// Print catalogs
		$('#resultTable').html(render);

		let table = $('#example').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			scrollCollapse: true,
			scroller: false,
			paging: true,
			autoWidth: false,
			columnDefs: [
				{width: '75px', targets: 0},
				{width: '75px', targets: 1},
				{width: '30px', orderable: false, targets: 3}
			],
			aaSorting: [],
			lengthChange: false,
			buttons: ['excel']
		});

		// Ocultar botones de tabla
		hideTableButtons('example');

		$('#btn-actions').html(table.buttons().container());

		// Dar estilo al boton de excel
		$('.buttons-excel').removeClass('btn-secondary');
		$('.buttons-excel').addClass('secondary-button ma-le-5');
		$('.buttons-excel').attr('title', pf.const.language.RSC47);

		$('.buttons-excel').html(
			stcmbackend.svg.download +
			`<span>${pf.const.language.RSC47}</span>`
		);

		self.tableEvents();

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents();
		});
	},

	tableEvents() {
		let self = this;

		// Limitación de valores numéricos
		$('.numMinMax').off().on('blur', function() {
			let value = $(this).val();

			if(value < 0) {
				$(this).val('0');
			} else if(value > 100) {
				$(this).val('100');
			}
		});

		// Llamar a la funcion para borrar catalog
		$('.remove-catalog').off().on('click', function() {
			let id = $(this).attr('data-id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC95;
			let alertText = pf.const.language.RSC291;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.catalogs.splice(id, 1);
				self.renderCatalogs(id);
			}, function() {});
		});
	}
};