let FuncionalidadesAPPController = {
	language: '',
	functionalities: '',
	config: {},

	reset() {
		let self = this;

		self.language = pf.const.language_table;
		self.functionalities = '';
		self.config = {};
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC623);

		// Opciones de header
		let jsonsubopt = {
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		self.loadLang();
		self.applyEvents();

		// Petición de funcionalidades
		self.getSystemConfig();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		// Guardado de nuevas funcionalidades
		$('#save').click(function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC78;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.setSystemConfig();
			}, function() {});
		});
	},

	getSystemConfig() {
		let self = this;

		ajaxComunCallWithCallback('getSystemConfig', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.functionalities = ajaxReturn.result;
				self.printFunctionalities();
			}
		});
	},

	printFunctionalities() {
		let self = this;

		let table = `
			<table id="tableFunctionalities" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC624}">${pf.const.language.RSC624}</th>
						<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					</tr>
				</thead>

				<thead class="filtersFunctionalities">
					<tr>
						<td>functionality</td>
						<td>enabled</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.functionalities.length;
		for(let i = 0; i < size; i++) {
			if(self.functionalities[i].id == 'URLPoliticas' || self.functionalities[i].id == 'URLSurveys' || self.functionalities[i].id == 'URLVideoCalls') {
				continue;
			}

			self.config[self.functionalities[i].name] = self.functionalities[i].enabled;

			let name = '';
			switch(self.functionalities[i].name) {
				case 'encryption':
					name = pf.const.language.RSC625;
					break;
				case 'sendcredit':
					name = pf.const.language.RSC626;
					break;
				case 'authbypass':
					name = pf.const.language.RSC627;
					break;
				case 'register':
					name = pf.const.language.RSC558;
					break;
				case 'profilingtest':
					name = pf.const.language.RSC398;
					break;
				case 'habits':
					name = pf.const.language.RSC629;
					break;
				case 'wallet':
					name = pf.const.language.RSC630;
					break;
				case 'imagetag':
					name = pf.const.language.RSC954;
					break;
				case 'videotag':
					name = pf.const.language.RSC955;
					break;
				case 'bots':
					name = pf.const.language.RSC43;
					break;
				case 'backendshowusuarios':
					name = pf.const.language.RSC631;
					break;
				case 'backendshowgrupos':
					name = pf.const.language.RSC632;
					break;
				case 'backendshowroles':
					name = pf.const.language.RSC633;
					break;
				case 'backendshownotificaciones':
					name = pf.const.language.RSC634;
					break;
				case 'backendshowlistasdifusion':
					name = pf.const.language.RSC635;
					break;
				case 'backendshowencuestas':
					name = pf.const.language.RSC636;
					break;
				case 'backendshowlogs':
					name = pf.const.language.RSC637;
					break;
				case 'backendshowconfiguracion':
					name = pf.const.language.RSC638;
					break;
				case 'backendshowapi':
					name = pf.const.language.RSC639;
					break;
				case 'backendshowproject':
					name = pf.const.language.RSC640;
					break;
				case 'backendshowintegraciones':
					name = pf.const.language.RSC641;
					break;
				case 'backendshowqna':
					name = pf.const.language.RSC642;
					break;
				case 'backendshowpagos':
					name = pf.const.language.RSC643;
					break;
				case 'backendshowanalytics':
					name = pf.const.language.RSC644;
					break;
				case 'backendshowmisiones':
					name = pf.const.language.RSC645;
					break;
				case 'medicalHistory':
					name = pf.const.language.RSC646;
					break;
				case 'referrals':
					name = pf.const.language.RSC647;
					break;
				case 'pinning':
					name = pf.const.language.RSC648;
					break;
				case 'market':
					name = pf.const.language.RSC984;
					break;
				case 'privacyscreen':
					name = pf.const.language.RSC995;
					break;
				case 'capture':
					name = pf.const.language.RSC1002;
					break;
				case 'passivetracking':
					name = pf.const.language.RSC1271;
					break;
				case 'securepassword':
					name = pf.const.language.RSC1323;
					break;
				case 'missionscenter':
					name = pf.const.language.RSC1363;
					break;
				case 'forceusertracking':
					name = pf.const.language.RSC1471;
					break;
				case 'externalvalidation':
					name = pf.const.language.RSC1513;
					break;
				case 'multitenant':
					name = pf.const.language.RSC1539;
					break;
				case 'multicpg':
					name = pf.const.language.RSC1716;
					break;
				case 'avatarsecurity':
					name = pf.const.language.RSC1731;
					break;
				case 'usersavesession':
					name = pf.const.language.RSC1784;
					break;
				case 'workingwithgdpr':
					name = pf.const.language.RSC1840;
					break;
				case 'showmenutext':
					name = pf.const.language.RSC1884;
					break;
				case 'backendshowrewards':
					name = pf.const.language.RSC1905;
					break;
				case 'workingwithconsumer':
					name = pf.const.language.RSC1906;
					break;
				case 'workingwithClients':
					name = pf.const.language.RSC2362;
					break;
				default:
					continue;
			}

			table += `
				<tr data-id="${self.functionalities[i].id}">
					<td class="desc" title="${name}">${name}</td>

					<td class="pl-0">
						<span class="d-none">${(self.functionalities[i].enabled == 1 ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<div class="custom-control custom-switch">
							<input id="fun_${self.functionalities[i].name}" type="checkbox" class="custom-control-input uSwitch functionalities" ${(self.functionalities[i].enabled == 1 ? 'checked' : '')}>
							<label for="fun_${self.functionalities[i].name}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#resultTable').html(table);

		// Setup - add a text input to each footer cell
		$('#tableFunctionalities .filtersFunctionalities td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'enabled') {
				value = optionsSelectAllYesNo();
			}

			$(this).html(value);
		});

		let tableFunctionalities = $('#tableFunctionalities').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			columnDefs: [
				{width: '60px', targets: 1}
			],
			autoWidth: false,
			aaSorting: [],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC551,
				className: 'btn secondary-button ma-le-5',
				title: pf.const.language.RSC623,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		$('.dataTables_filter').hide();

		$('#btn-actions').html(tableFunctionalities.buttons().container());

		// Dar estilo al boton de excel
		$('.buttons-excel').removeClass('btn-secondary');
		$('.buttons-excel').attr('title', pf.const.language.RSC47);

		$('.buttons-excel').html(
			stcmbackend.svg.download +
			`<span>${pf.const.language.RSC47}</span>`
		);

		// Apply the search
		applyTheSearch(tableFunctionalities, 'filtersFunctionalities');

		// Eventos
		self.applyEventsTable();
	},

	applyEventsTable() {
		let self = this;

		$('.functionalities').off().on('change', function() {
			let name = $(this).attr('id').replace('fun_', '');
			let enable = '0';
			if($(this).prop('checked')) {
				enable = '1';
			}

			if(name == 'register' && enable == '1') {
				let objInfo = {
					accept: {
						text: pf.const.language.RSC141
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC623;
				let alertText = pf.const.language.RSC1662;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.config[name] = enable;
					$('#fun_multitenant').prop('checked', false);
					self.config['multitenant'] = '0';
				}, function() {
					$('#fun_register').prop('checked', false);
				});
			} else if(name == 'multitenant' && enable == '1') {
				let objInfo = {
					accept: {
						text: pf.const.language.RSC141
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC623;
				let alertText = pf.const.language.RSC1661;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.config[name] = enable;
					$('#fun_register').prop('checked', false);
					self.config['register'] = '0';
				}, function() {
					$('#fun_multitenant').prop('checked', false);
				});
			} else {
				self.config[name] = enable;
			} 
		});
	},

	setSystemConfig() {
		let self = this;

		let parameters = {
			config: JSON.stringify(self.config)
		};
		ajaxComunCallWithCallback('setSystemConfig', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let confirmTitle = pf.const.language.RSC78;
				let confirmContent = pf.const.language.RSC106;
				pf.utils.showInfoDialog(confirmTitle, confirmContent);
				loadHTML('inc/configuracion/funcionalidades_app.html', 'wrapper', FuncionalidadesAPPController);
			}
		});
	}
};