let PaisesController = {
	language: '',
	country: null,

	reset() {
		let self = this;

		self.language = pf.const.language_table;
		self.country = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC549);

		self.loadLang();

		ajaxComunCallWithCallback('getPaises', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.country = ajaxReturn.result;
				self.printCountries();
			}
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	printCountries() {
		let self = this;

		let table = `
			<table id="tableCountries" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title=""></th>
						<th scope="col" title="ISO">ISO</th>
						<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
						<th scope="col" title="${pf.const.language.RSC616}">${pf.const.language.RSC616}</th>
						<th scope="col" title="${pf.const.language.RSC953}">${pf.const.language.RSC953}</th>
						<th scope="col" title="${pf.const.language.RSC971}">${pf.const.language.RSC971}</th>
						<th scope="col" title="${pf.const.language.RSC595}">${pf.const.language.RSC595}</th>
						<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					</tr>
				</thead>

				<thead class="filtersCountry">
					<tr>
						<td>edit</td>
						<td>iso</td>
						<td>pais</td>
						<td>zone</td>
						<td>currency</td>
						<td>currencySymbol</td>
						<td>predefinido</td>
						<td>activo</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.country.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${i}">
					<td class="text-truncate text-center" title="${pf.const.language.RSC225}">
						<span class="c-pointer edit" data-iso="${self.country[i].isocode}">
							${stcmbackend.svg.pencil}
						</span>
					</td>
					<td class="text-truncate desc" title="${self.country[i].isocode}">
						${(self.country[i].isocode != '' ? self.country[i].isocode : '-')}
					</td>
					<td class="text-truncate desc" title="${self.country[i].descripcion}">
						${(self.country[i].descripcion != '' ? self.country[i].descripcion : '-')}
					</td>
					<td class="text-truncate" title="${(self.country[i].zone != '' ? self.country[i].zone : '')}">
						${(self.country[i].zone != '' ? self.country[i].zone : '-')}
					</td>
					<td class="text-truncate" title="${(self.country[i].currency || '')}">
						${(self.country[i].currency || '-')}
					</td>
					<td class="text-truncate" title="${(self.country[i].currency_symbol || '')}">
						${(self.country[i].currency_symbol || '-')}
					</td>
					<td class="pl-0">
						<span class="d-none">${(self.country[i].default == 1 ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<div class="custom-control custom-switch">
							<input id="def_${i}" type="checkbox" class="custom-control-input uSwitch" ${(self.country[i].default == 1 ? 'checked' : '')} disabled>
							<label for="def_${i}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
					<td class="pl-0">
						<span class="d-none">${(self.country[i].enabled == 1 ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<div class="custom-control custom-switch">
							<input id="country_${i}" type="checkbox" class="custom-control-input uSwitch" ${(self.country[i].enabled == 1 ? 'checked' : '')} disabled>
							<label for="country_${i}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#resultTable').html(table);

		// Setup - add a text input to each footer cell
		$('#tableCountries .filtersCountry td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'activo' || title === 'predefinido') {
				value = optionsSelectAllYesNo();
			} else if(title === 'edit') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let tableCountries = $('#tableCountries').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			columnDefs: [
				{width: '30px', orderable: false, targets: 0},
				{width: '45px', targets: 1},
				{width: '85px', targets: 4},
				{width: '85px', targets: 5},
				{width: '75px', targets: 6},
				{width: '60px', targets: 7}
			],
			scrollCollapse: true,
			scroller: false,
			paging: true,
			autoWidth: false,
			aaSorting: [],
			lengthChange: false,
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC549,
				className: 'btn secondary-button ma-le-5',
				title: pf.const.language.RSC549,
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6, 7]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		$('.dataTables_filter').hide();

		$('#btn-actions').html(tableCountries.buttons().container());

		// Dar estilo al boton de excel
		$('.buttons-excel').removeClass('btn-secondary');
		$('.buttons-excel').attr('title', pf.const.language.RSC47);

		$('.buttons-excel').html(
			stcmbackend.svg.download +
			`<span>${pf.const.language.RSC47}</span>`
		);

		// Apply the search
		applyTheSearch(tableCountries, 'filtersCountry');

		// Eventos
		self.applyEventsTable();
		$('#tableCountries').on('draw.dt', function() {
			self.applyEventsTable();
		});
	},

	applyEventsTable() {
		// Editar
		$('.edit').off().on('click', function() {
			let iso = $(this).data('iso');
			sessionStorage.setItem('editCountryIso', btoa(iso));
			window.location.href = '#!paises_edit';
		});
	}
};