let PerfilacionController = {
	user: null,
	language: '',
	profiling: '',
	dataGender: '',
	genderTotalPercent: 0,
	genterTotalLicenses: 0,
	dataState: '',
	stateTotalPercent: 0,
	stateTotalLicenses: 0,
	dataAge: '',
	ageTotalPercent: 0,
	ageTotalLicenses: 0,
	dataPerfSec: '',
	dataPerfRegion: '',
	dataIntegration: '',
	loaders: {},
	allowedCountries: '',
	// Arrays de borrado múltiple
	arrayDelMultGender: [],
	arrayDelMultState: [],
	arrayDelMultAge: [],
	arrayDelMultPerfSec: [],
	arrayDelMultPerfRegion: [],
	arrayDelMultIntegration: [],

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.profiling = '';
		self.dataGender = '';
		self.genderTotalPercent = 0;
		self.genterTotalLicenses = 0;
		self.dataState = '';
		self.stateTotalPercent = 0;
		self.stateTotalLicenses = 0;
		self.dataAge = '';
		self.ageTotalPercent = 0;
		self.ageTotalLicenses = 0;
		self.dataPerfSec = '';
		self.dataPerfRegion = '';
		self.dataIntegration = '';
		self.loaders = {
			getPerfEstados: false,
			getPerfEdad: false,
			getPerfGenero: false,
			getPerfSec: false,
			getPerfRegion: false,
			getLicenciasDiscriminantes: false
		};
		self.allowedCountries = '';
		// Arrays de borrado múltiple
		self.arrayDelMultGender = [];
		self.arrayDelMultState = [];
		self.arrayDelMultAge = [];
		self.arrayDelMultPerfSec = [];
		self.arrayDelMultPerfRegion = [];
		self.arrayDelMultIntegration = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC515);

		// Opciones de header
		let jsonsubopt = {
			distribute: 'distribute'
		};

		let nav = `
			${createSubOptionDistribute(jsonsubopt.distribute)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#distribute svg').css('width', '16px');
		$('#distribute svg').css('height', '16px');

		// Botón principal
		$('#distribute').addClass('main-button');

		// Obtener países permitidos
		self.allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));

		self.loadLang();

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.profiling = config.TipoPerfilacion;

		addLoader();
		self.requestPerfGender();
		self.requestPerfState();
		self.requestPerfAge();
		if(self.profiling == 3) {
			self.getPerfSec();
			self.getPerfRegion();
			self.getLicenciasDiscriminantes();
		} else {
			self.loaders.getPerfSec = true;
			self.loaders.getPerfRegion = true;
			self.loaders.getLicenciasDiscriminantes = true;
			$('#distribute').removeClass('d-none');
			$('#page-actions').removeClass('d-none');
			$('#page-actions').addClass('d-flex');
			$('#secPerfSec').hide();
			$('#secPerfRegion').hide();
			$('#integration').hide();
		}

		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
		$('.newTitle').attr('title', pf.const.language.RSC7);
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		$('#distribute').on('click', function() {
			self.runLicenseDistribution();
		});

		// Nuevo género
		$('#newGender').on('click', function() {
			if(self.profiling == 3) {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('gender'));
				window.location.href = '#!perfilacion_new';
			} else if(self.genderTotalPercent >= 100) {
				let warningTitle = pf.const.language.RSC516;
				let warningContent = pf.const.language.RSC531;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			} else {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('gender'));
				sessionStorage.setItem('totalPercentGender', btoa(self.genderTotalPercent));
				sessionStorage.setItem('totalLicensesGender', btoa(self.genterTotalLicenses));
				window.location.href = '#!perfilacion_new';
			}
		});

		// Nuevo estado
		$('#newState').on('click', function() {
			if(self.profiling == 3) {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('state'));
				window.location.href = '#!perfilacion_new';
			} else if(self.stateTotalPercent >= 100) {
				let warningTitle = pf.const.language.RSC517;
				let warningContent = pf.const.language.RSC531;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			} else {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('state'));
				sessionStorage.setItem('totalPercentState', btoa(self.stateTotalPercent));
				sessionStorage.setItem('totalLicensesState', btoa(self.stateTotalLicenses));
				window.location.href = '#!perfilacion_new';
			}
		});

		// Nueva edad
		$('#newAge').on('click', function() {
			if(self.profiling == 3) {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('age'));
				window.location.href = '#!perfilacion_new';
			} else if(self.ageTotalPercent >= 100) {
				let warningTitle = pf.const.language.RSC518;
				let warningContent = pf.const.language.RSC531;
				pf.utils.showInfoDialog(warningTitle, warningContent);
			} else {
				sessionStorage.setItem('profiling', self.profiling);
				sessionStorage.setItem('profilingType', btoa('age'));
				sessionStorage.setItem('totalPercentAge', btoa(self.ageTotalPercent));
				sessionStorage.setItem('totalLicensesAge', btoa(self.ageTotalLicenses));
				window.location.href = '#!perfilacion_new';
			}
		});

		// Nueva PerfSec
		$('#newPerfSec').on('click', function() {
			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('PerfSec'));
			window.location.href = '#!perfilacion_new';
		});

		// Nueva PerfRegion
		$('#newPerfRegion').on('click', function() {
			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('PerfRegion'));
			window.location.href = '#!perfilacion_new';
		});

		// Nueva Integración
		$('#newIntegration').on('click', function() {
			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('Integration'));
			window.location.href = '#!perfilacion_new';
		});
	},

	requestPerfGender() {
		let self = this;

		ajaxComunCallWithCallback('getPerfGenero', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataGender = ajaxReturn.result;

				if(self.profiling == 3) {
					self.renderGenderDataABI();
				} else {
					let size = self.dataGender.length;
					for(let i = 0; i < size; i++) {
						self.genderTotalPercent += parseFloat(self.dataGender[i].porcentaje);
						self.genterTotalLicenses += parseFloat(self.dataGender[i].licencias);
					}

					// Tabla de resultados
					self.renderGenderData();
				}

				self.loaders.getPerfGenero = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderGenderDataABI() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataGender)) {
			self.dataGender = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>
					<th scope="col" title="${pf.const.language.RSC601}">${pf.const.language.RSC601}</th>
					<th scope="col" title="${pf.const.language.RSC151}">${pf.const.language.RSC151}</th>
					<th scope="col" title="${pf.const.language.RSC519}">${pf.const.language.RSC519}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersGender">
				<tr>
					<td>selector</td>
					<td>country</td>
					<td>region</td>
					<td>regionABI</td>
					<td>gender</td>
					<td>licecias</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataGender.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataGender[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTG" title="${self.dataGender[i].pais}">${self.dataGender[i].pais}</td>
					<td class="text-truncate c-pointer editRowTG" title="${self.dataGender[i].region}">${self.dataGender[i].region}</td>
					<td class="text-truncate c-pointer editRowTG" title="${self.dataGender[i].regionABI}">${self.dataGender[i].regionABI}</td>
					<td class="text-truncate c-pointer editRowTG" title="${self.dataGender[i].genero}">${self.dataGender[i].genero}</td>
					<td class="text-center c-pointer editRowTG" title="${self.dataGender[i].licencias}">${self.dataGender[i].licencias}</td>
					<td class="text-center">
						<div id="dropdownActions${i}tg" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}tg" data-id="${i}">
							<p class="dropdown-item editRowTG">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTG">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableGender').html(table);

		// Setup - add a text input to each footer cell
		$('#tableGender .filtersGender td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let genderTable = $('#tableGender').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 6}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC516,
				exportOptions: {
					columns: [1, 2, 3, 4, 5]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableGender');

		// Exportar tabla
		$('#exportGender').off().on('click', function() {
			$('#genderTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(genderTable, 'filtersGender');

		self.genderABIDataEvents();

		$('#genderTable').on('draw.dt', function() {
			self.genderABIDataEvents();
		});
	},

	genderABIDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableGender ');

		// Editar perfilación por género
		$('.editRowTG').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('gender'));
			sessionStorage.setItem('Gender', btoa(self.dataGender[id].genero));
			sessionStorage.setItem('pais', btoa(self.dataGender[id].pais));
			sessionStorage.setItem('region', btoa(self.dataGender[id].region));
			sessionStorage.setItem('licencias', btoa(self.dataGender[id].licencias));
			sessionStorage.setItem('regionABI', btoa(self.dataGender[id].regionABI));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por género
		$('.deleteRowTG').off().on('click', function() {
			let id = $(this).parent().data('id');

			let genderToDelete = {
				genero: self.dataGender[id].genero,
				pais: self.dataGender[id].pais,
				region: self.dataGender[id].region
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('gender', genderToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tableGender .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultGender.push(id);
			} else {
				let index = self.arrayDelMultGender.indexOf(id);
				self.arrayDelMultGender.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultGender.length > 0) {
				$('#multSelecDeleteGT').removeClass('d-none');
			} else {
				$('#multSelecDeleteGT').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tableGender .deleteSelection').length == $('#tableGender .deleteSelection:checked').length && $('#tableGender .deleteSelection').length > 0) {
				$('#tableGender .globalSelection').prop('checked', true);
			} else {
				$('#tableGender .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeleteGT').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('gender');
			}, function() {});
		});
	},

	renderGenderData() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataGender)) {
			self.dataGender = [];
		}

		// Quita el decimal cuando este es 0
		let totalPercent = parseFloat(self.genderTotalPercent).toFixed(1);
		let totalPercentArray = totalPercent.split('.');
		if(totalPercentArray[1] == 0) {
			totalPercent = totalPercentArray[0];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC151}">${pf.const.language.RSC151}</th>
					<th scope="col" title="${pf.const.language.RSC520}">${pf.const.language.RSC520}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersGender">
				<tr>
					<td>selector</td>
					<td>gender</td>
					<td>percentage</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
				<tr>
					<td></td>
					<td>
						${pf.const.language.RSC345}
					</td>
					<td>
						${totalPercent}
					</td>
					<td></td>
				</tr>
		`;

		let size = self.dataGender.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="gender c-pointer editRow" title="${self.dataGender[i].genero}">${self.dataGender[i].genero}</td>
					<td class="c-pointer editRow" title="${self.dataGender[i].porcentaje}">${self.dataGender[i].porcentaje}</td>
					<td class="text-center">
						<div id="dropdownActions${i}tg" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}tg" data-id="${i}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableGender').html(table);

		// Setup - add a text input to each footer cell
		$('#tableGender .filtersGender td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let genderTable = $('#tableGender').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '80px', targets: 2},
				{width: '60px', orderable: false, targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC516,
				exportOptions: {
					columns: [1, 2]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableGender');

		// Exportar tabla
		$('#exportGender').off().on('click', function() {
			$('#genderTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(genderTable, 'filtersGender');

		self.genderDataEvents();

		$('#genderTable').on('draw.dt', function() {
			self.genderDataEvents();
		});
	},

	genderDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableGender ');

		// Editar perfilación por género
		$('.editGender').off().on('click', function() {
			let id = $(this).parent().parent().find('.gender').text();

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('gender'));
			sessionStorage.setItem('idGender', btoa(id));
			sessionStorage.setItem('totalPercentGender', btoa(self.genderTotalPercent));
			sessionStorage.setItem('totalLicensesGender', btoa(self.genderTotalLicenses));
			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por género
		$('.deleteGender').off().on('click', function() {
			let id = $(this).parent().parent().find('.gender').text();

			self.deleteProfiling(id, 'gender');
		});
	},

	requestPerfState() {
		let self = this;

		ajaxComunCallWithCallback('getPerfEstados', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataState = ajaxReturn.result;
				if(self.profiling == 3) {
					self.renderStateDataABI();
				} else {
					let size = self.dataState.length;
					for(let i = 0; i < size; i++) {
						self.stateTotalPercent += parseFloat(self.dataState[i].porcentaje);
						self.stateTotalLicenses += parseFloat(self.dataState[i].licencias);
					}

					// Tabla de resultados
					self.renderStateData();
				}

				self.loaders.getPerfEstados = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderStateDataABI() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataState)) {
			self.dataState = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>
					<th scope="col" title="${pf.const.language.RSC601}">${pf.const.language.RSC601}</th>
					<th scope="col" title="${pf.const.language.RSC608}">${pf.const.language.RSC608}</th>
					<th scope="col" title="${pf.const.language.RSC564}">${pf.const.language.RSC564}</th>
					<th scope="col" title="${pf.const.language.RSC607}">${pf.const.language.RSC607}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersState">
				<tr>
					<td>selector</td>
					<td>country</td>
					<td>region</td>
					<td>regionABI</td>
					<td>regionABIAux</td>
					<td>state</td>
					<td>city</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataState.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataState[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].pais}">${self.dataState[i].pais}</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].region}">${self.dataState[i].region}</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].regionABI}">${self.dataState[i].regionABI}</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].regionABIAux}">${self.dataState[i].regionABIAux}</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].estado}">${self.dataState[i].estado}</td>
					<td class="text-truncate c-pointer editRowTS" title="${self.dataState[i].ciudad}">${self.dataState[i].ciudad}</td>
					<td class="text-center">
						<div id="dropdownActions${i}ts" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}ts" data-id="${i}">
							<p class="dropdown-item editRowTS">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTS">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableState').html(table);

		// Setup - add a text input to each footer cell
		$('#tableState .filtersState td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let stateTable = $('#tableState').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 7}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC517,
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableState');

		// Exportar tabla
		$('#exportState').off().on('click', function() {
			$('#stateTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(stateTable, 'filtersState');

		self.stateABIDataEvents();

		$('#stateTable').on('draw.dt', function() {
			self.stateABIDataEvents();
		});
	},

	stateABIDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableState ');

		// Editar perfilación por estado
		$('.editRowTS').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('state'));
			sessionStorage.setItem('estado', btoa(self.dataState[id].estado));
			sessionStorage.setItem('pais', btoa(self.dataState[id].pais));
			sessionStorage.setItem('region', btoa(self.dataState[id].region));
			sessionStorage.setItem('ciudad', btoa(self.dataState[id].ciudad));
			sessionStorage.setItem('regionABI', btoa(self.dataState[id].regionABI));
			sessionStorage.setItem('regionABIAux', btoa(self.dataState[id].regionABIAux));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por estado
		$('.deleteRowTS').off().on('click', function() {
			let id = $(this).parent().data('id');

			let stateToDelete = {
				estado: self.dataState[id].estado,
				pais: self.dataState[id].pais,
				region: self.dataState[id].region,
				ciudad: self.dataState[id].ciudad
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('state', stateToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tableState .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultState.push(id);
			} else {
				let index = self.arrayDelMultState.indexOf(id);
				self.arrayDelMultState.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultState.length > 0) {
				$('#multSelecDeleteST').removeClass('d-none');
			} else {
				$('#multSelecDeleteST').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tableState .deleteSelection').length == $('#tableState .deleteSelection:checked').length && $('#tableState .deleteSelection').length > 0) {
				$('#tableState .globalSelection').prop('checked', true);
			} else {
				$('#tableState .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeleteST').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('state');
			}, function() {});
		});
	},

	renderStateData() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataState)) {
			self.dataState = [];
		}

		// Quita el decimal cuando este es 0
		let totalPercent = parseFloat(self.stateTotalPercent).toFixed(1);
		let totalPercentArray = totalPercent.split('.');
		if(totalPercentArray[1] == 0) {
			totalPercent = totalPercentArray[0];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC153}">${pf.const.language.RSC153}</th>
					<th scope="col" title="${pf.const.language.RSC520}">${pf.const.language.RSC520}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersState">
				<tr>
					<td>selector</td>
					<td>state</td>
					<td>percentage</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
				<tr>
					<td></td>
					<td>
						${pf.const.language.RSC345}
					</td>
					<td>
						${totalPercent}
					</td>
					<td></td>
				</tr>
		`;

		let size = self.dataState.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="state c-pointer editRow" title="${self.dataState[i].estado}">${self.dataState[i].estado}</td>
					<td class="c-pointer editRow" title="${self.dataState[i].porcentaje}">${self.dataState[i].porcentaje}</td>
					<td class="text-center">
						<div id="dropdownActions${i}ts" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}ts" data-id="${i}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableState').html(table);

		// Setup - add a text input to each footer cell
		$('#tableState .filtersState td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let stateTable = $('#tableState').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '95px', targets: 2},
				{width: '60px', orderable: false, targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC517,
				exportOptions: {
					columns: [1, 2, 3]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableState');

		// Exportar tabla
		$('#exportState').off().on('click', function() {
			$('#stateTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(stateTable, 'filtersState');

		self.stateDataEvents();

		$('#stateTable').on('draw.dt', function() {
			self.stateDataEvents();
		});
	},

	stateDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableState ');

		// Editar perfilación por estado
		$('.editState').off().on('click', function() {
			let id = $(this).parent().parent().find('.state').text();

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('state'));
			sessionStorage.setItem('idState', btoa(id));
			sessionStorage.setItem('totalPercentState', btoa(self.stateTotalPercent));
			sessionStorage.setItem('totalLicensesState', btoa(self.stateTotalLicenses));
			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por estado
		$('.deleteState').off().on('click', function() {
			let id = $(this).parent().parent().find('.state').text();

			self.deleteProfiling(id, 'state');
		});
	},

	requestPerfAge() {
		let self = this;

		ajaxComunCallWithCallback('getPerfEdad', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataAge = ajaxReturn.result;

				if(self.profiling == 3) {
					self.renderAgeDataABI();
				} else {
					let size = self.dataAge.length;
					for(let i = 0; i < size; i++) {
						self.ageTotalPercent += parseFloat(self.dataAge[i].porcentaje);
						self.ageTotalLicenses += parseFloat(self.dataAge[i].licencias);
					}

					// Tabla de resultados
					self.renderAgeData();
				}

				self.loaders.getPerfEdad = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderAgeDataABI() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataAge)) {
			self.dataAge = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>
					<th scope="col" title="${pf.const.language.RSC601}">${pf.const.language.RSC601}</th>
					<th scope="col" title="${pf.const.language.RSC152}">${pf.const.language.RSC152}</th>
					<th scope="col" title="min">min</th>
					<th scope="col" title="max">max</th>
					<th scope="col" title="${pf.const.language.RSC519}">${pf.const.language.RSC519}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersAge">
				<tr>
					<td>selector</td>
					<td>country</td>
					<td>region</td>
					<td>regionABI</td>
					<td>age</td>
					<td>min</td>
					<td>max</td>
					<td>licencias</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataAge.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataAge[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTA" title="${self.dataAge[i].pais}">${self.dataAge[i].pais}</td>
					<td class="text-truncate c-pointer editRowTA" title="${self.dataAge[i].region}">${self.dataAge[i].region}</td>
					<td class="text-truncate c-pointer editRowTA" title="${self.dataAge[i].regionABI}">${self.dataAge[i].regionABI}</td>
					<td class="text-center c-pointer editRowTA" title="${self.dataAge[i].edad}">${self.dataAge[i].edad}</td>
					<td class="text-center c-pointer editRowTA" title="${self.dataAge[i].min}">${self.dataAge[i].min}</td>
					<td class="text-center c-pointer editRowTA" title="${self.dataAge[i].max}">${self.dataAge[i].max}</td>
					<td class="text-center c-pointer editRowTA" title="${self.dataAge[i].licencias}">${self.dataAge[i].licencias}</td>
					<td class="text-center">
						<div id="dropdownActions${i}ta" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}ta" data-id="${i}">
							<p class="dropdown-item editRowTA">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTA">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableAge').html(table);
		// Setup - add a text input to each footer cell
		$('#tableAge .filtersAge td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let ageTable = $('#tableAge').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 8}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC518,
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6, 7]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableAge');

		// Exportar tabla
		$('#exportAge').off().on('click', function() {
			$('#ageTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(ageTable, 'filtersAge');

		self.ageABIDataEvents();

		$('#ageTable').on('draw.dt', function() {
			self.ageABIDataEvents();
		});
	},

	ageABIDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableAge ');

		// Editar perfilación por edad
		$('.editRowTA').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('age'));
			sessionStorage.setItem('edad', btoa(self.dataAge[id].edad));
			sessionStorage.setItem('pais', btoa(self.dataAge[id].pais));
			sessionStorage.setItem('region', btoa(self.dataAge[id].region));
			sessionStorage.setItem('regionABI', btoa(self.dataAge[id].regionABI));
			sessionStorage.setItem('min', btoa(self.dataAge[id].min));
			sessionStorage.setItem('max', btoa(self.dataAge[id].max));
			sessionStorage.setItem('licencias', btoa(self.dataAge[id].licencias));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por género
		$('.deleteRowTA').off().on('click', function() {
			let id = $(this).parent().data('id');

			let ageToDelete = {
				edad: self.dataAge[id].edad,
				pais: self.dataAge[id].pais,
				region: self.dataAge[id].region
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('age', ageToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tableAge .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultAge.push(id);
			} else {
				let index = self.arrayDelMultAge.indexOf(id);
				self.arrayDelMultAge.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultAge.length > 0) {
				$('#multSelecDeleteAT').removeClass('d-none');
			} else {
				$('#multSelecDeleteAT').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tableAge .deleteSelection').length == $('#tableAge .deleteSelection:checked').length && $('#tableAge .deleteSelection').length > 0) {
				$('#tableAge .globalSelection').prop('checked', true);
			} else {
				$('#tableAge .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeleteAT').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('age');
			}, function() {});
		});
	},

	renderAgeData() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataAge)) {
			self.dataAge = [];
		}

		// Quita el decimal cuando este es 0
		let totalPercent = parseFloat(self.ageTotalPercent).toFixed(1);
		let totalPercentArray = totalPercent.split('.');
		if(totalPercentArray[1] == 0) {
			totalPercent = totalPercentArray[0];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC152}">${pf.const.language.RSC152}</th>
					<th scope="col" title="${pf.const.language.RSC520}">${pf.const.language.RSC520}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersAge">
				<tr>
					<td>selector</td>
					<td>age</td>
					<td>percentage</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
				<tr>
					<td></td>
					<td>
						${pf.const.language.RSC345}
					</td>
					<td>
						${totalPercent}
					</td>
					<td></td>
				</tr>
		`;

		let size = self.dataAge.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="age c-pointer editRow" title="${self.dataAge[i].edad}">${self.dataAge[i].edad}</td>
					<td class="c-pointer editRow" title="${self.dataAge[i].porcentaje}">${self.dataAge[i].porcentaje}</td>
					<td class="text-center">
						<div id="dropdownActions${i}ta" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}ta" data-id="${i}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableAge').html(table);

		// Setup - add a text input to each footer cell
		$('#tableAge .filtersAge td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let ageTable = $('#tableAge').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '80px', targets: 2},
				{width: '60px', orderable: false, targets: 3}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC518,
				exportOptions: {
					columns: [1, 2]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableAge');

		// Exportar tabla
		$('#exportAge').off().on('click', function() {
			$('#ageTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(ageTable, 'filtersAge');

		self.ageDataEvents();

		$('#ageTable').on('draw.dt', function() {
			self.ageDataEvents();
		});
	},

	ageDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableAge ');

		// Editar perfilación por edad
		$('.editAge').off().on('click', function() {
			let id = $(this).parent().parent().find('.age').text();

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('age'));
			sessionStorage.setItem('idAge', btoa(id));
			sessionStorage.setItem('totalPercentAge', btoa(self.ageTotalPercent));
			sessionStorage.setItem('totalLicensesAge', btoa(self.ageTotalLicenses));
			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por edad
		$('.deleteAge').off().on('click', function() {
			let id = $(this).parent().parent().find('.age').text();

			self.deleteProfiling(id, 'age');
		});
	},

	deleteProfiling(id, type) {
		let reqName = '';
		let parameters = {};
		switch(type) {
			case 'gender':
				reqName = 'deletePerfGenero';
				parameters = {
					id: id,
					genero: id,
					pais: '',
					region: ''
				};
				break;
			case 'state':
				reqName = 'deletePerfEstados';
				parameters = {
					id: id,
					estado: id,
					pais: '',
					region: '',
					ciudad: ''
				};
				break;
			case 'age':
				reqName = 'deletePerfEdad';
				parameters = {
					id: id,
					edad: id,
					pais: '',
					region: ''
				};
				break;
		}

		ajaxComunCallWithCallback(reqName, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC515;
				let successContent = pf.const.language.RSC522;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/configuracion/perfilacion.html', 'wrapper', PerfilacionController);
			}
		});
	},

	runLicenseDistribution() {
		ajaxComunCallWithCallback('distributeLicencesByPercentage', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC515;
				let successContent = pf.const.language.RSC525;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/configuracion/perfilacion.html', 'wrapper', PerfilacionController);
			}
		});
	},

	getPerfSec() {
		let self = this;

		ajaxComunCallWithCallback('getPerfSec', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataPerfSec = ajaxReturn.result;
				self.renderPerfSecABI();

				self.loaders.getPerfSec = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderPerfSecABI() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataPerfSec)) {
			self.dataPerfSec = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>
					<th scope="col" title="sec">sec</th>
					<th scope="col" title="min">min</th>
					<th scope="col" title="max">max</th>
					<th scope="col" title="${pf.const.language.RSC519}">${pf.const.language.RSC519}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersPerfSec">
				<tr>
					<td>selector</td>
					<td>pais</td>
					<td>region</td>
					<td>sec</td>
					<td>min</td>
					<td>max</td>
					<td>licencias</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataPerfSec.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataPerfSec[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTPS" title="${self.dataPerfSec[i].pais}">${self.dataPerfSec[i].pais}</td>
					<td class="text-truncate c-pointer editRowTPS" title="${self.dataPerfSec[i].region}">${self.dataPerfSec[i].region}</td>
					<td class="text-truncate c-pointer editRowTPS" title="${self.dataPerfSec[i].sec}">${self.dataPerfSec[i].sec}</td>
					<td class="text-center c-pointer editRowTPS" title="${self.dataPerfSec[i].min}">${self.dataPerfSec[i].min}</td>
					<td class="text-center c-pointer editRowTPS" title="${self.dataPerfSec[i].max}">${self.dataPerfSec[i].max}</td>
					<td class="text-center c-pointer editRowTPS" title="${self.dataPerfSec[i].licencias}">${self.dataPerfSec[i].licencias}</td>
					<td class="text-center">
						<div id="dropdownActions${i}tps" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}tps" data-id="${i}">
							<p class="dropdown-item editRowTPS">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTPS">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tablePerfSec').html(table);

		// Setup - add a text input to each footer cell
		$('#tablePerfSec .filtersPerfSec td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let PerfSecTable = $('#tablePerfSec').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 7}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: 'PerfSec',
				exportOptions: {
					columns: [1, 2, 3, 4, 5, 6]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tablePerfSec');

		// Exportar tabla
		$('#exportPerfSec').off().on('click', function() {
			$('#PerfSecTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(PerfSecTable, 'filtersPerfSec');

		self.PerfSecDataEvents();

		$('#PerfSecTable').on('draw.dt', function() {
			self.PerfSecDataEvents();
		});
	},

	PerfSecDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tablePerfSec ');

		// Editar perfilación por PerfSec
		$('.editRowTPS').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('PerfSec'));
			sessionStorage.setItem('pais', btoa(self.dataPerfSec[id].pais));
			sessionStorage.setItem('region', btoa(self.dataPerfSec[id].region));
			sessionStorage.setItem('sec', btoa(self.dataPerfSec[id].sec));
			sessionStorage.setItem('min', btoa(self.dataPerfSec[id].min));
			sessionStorage.setItem('max', btoa(self.dataPerfSec[id].max));
			sessionStorage.setItem('licencias', btoa(self.dataPerfSec[id].licencias));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por PerfSec
		$('.deleteRowTPS').off().on('click', function() {
			let id = $(this).parent().data('id');

			let PerfSecToDelete = {
				sec: self.dataPerfSec[id].sec,
				pais: self.dataPerfSec[id].pais,
				region: self.dataPerfSec[id].region
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('PerfSec', PerfSecToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tablePerfSec .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultPerfSec.push(id);
			} else {
				let index = self.arrayDelMultPerfSec.indexOf(id);
				self.arrayDelMultPerfSec.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultPerfSec.length > 0) {
				$('#multSelecDeletePST').removeClass('d-none');
			} else {
				$('#multSelecDeletePST').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tablePerfSec .deleteSelection').length == $('#tablePerfSec .deleteSelection:checked').length && $('#tablePerfSec .deleteSelection').length > 0) {
				$('#tablePerfSec .globalSelection').prop('checked', true);
			} else {
				$('#tablePerfSec .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeletePST').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('PerfSec');
			}, function() {});
		});
	},

	getPerfRegion() {
		let self = this;

		ajaxComunCallWithCallback('getPerfRegion', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataPerfRegion = ajaxReturn.result;
				self.renderPerfRegionABI();

				self.loaders.getPerfRegion = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderPerfRegionABI() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataPerfRegion)) {
			self.dataPerfRegion = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC597}">${pf.const.language.RSC597}</th>
					<th scope="col" title="${pf.const.language.RSC601}">${pf.const.language.RSC601}</th>
					<th scope="col" title="${pf.const.language.RSC519}">${pf.const.language.RSC519}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersPerfRegion">
				<tr>
					<td>selector</td>
					<td>pais</td>
					<td>region</td>
					<td>regionABI</td>
					<td>licencias</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataPerfRegion.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataPerfRegion[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTPR" title="${self.dataPerfRegion[i].pais}">${self.dataPerfRegion[i].pais}</td>
					<td class="text-truncate c-pointer editRowTPR" title="${self.dataPerfRegion[i].region}">${self.dataPerfRegion[i].region}</td>
					<td class="text-truncate c-pointer editRowTPR" title="${self.dataPerfRegion[i].regionABI}">${self.dataPerfRegion[i].regionABI}</td>
					<td class="text-center c-pointer editRowTPR" title="${self.dataPerfRegion[i].licencia}">${self.dataPerfRegion[i].licencias}</td>
					<td class="text-center">
						<div id="dropdownActions${i}tpr" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}tpr" data-id="${i}">
							<p class="dropdown-item editRowTPR">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTPR">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tablePerfRegion').html(table);

		// Setup - add a text input to each footer cell
		$('#tablePerfRegion .filtersPerfRegion td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let PerfRegionTable = $('#tablePerfRegion').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 5}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: 'PerfRegion',
				exportOptions: {
					columns: [1, 2, 3, 4]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tablePerfRegion');

		// Exportar tabla
		$('#exportPerfRegion').off().on('click', function() {
			$('#PerfRegionTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(PerfRegionTable, 'filtersPerfRegion');

		self.PerfRegionDataEvents();

		$('#PerfRegionTable').on('draw.dt', function() {
			self.PerfRegionDataEvents();
		});
	},

	PerfRegionDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tablePerfRegion ');

		// Editar perfilación por PerfRegion
		$('.editRowTPR').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('PerfRegion'));
			sessionStorage.setItem('pais', btoa(self.dataPerfRegion[id].pais));
			sessionStorage.setItem('region', btoa(self.dataPerfRegion[id].region));
			sessionStorage.setItem('regionABI', btoa(self.dataPerfRegion[id].regionABI));
			sessionStorage.setItem('licencias', btoa(self.dataPerfRegion[id].licencias));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por género
		$('.deleteRowTPR').off().on('click', function() {
			let id = $(this).parent().data('id');

			let PerfRegionToDelete = {
				region: self.dataPerfRegion[id].region,
				pais: self.dataPerfRegion[id].pais,
				regionABI: self.dataPerfRegion[id].regionABI
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('PerfRegion', PerfRegionToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tablePerfRegion .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultPerfRegion.push(id);
			} else {
				let index = self.arrayDelMultPerfRegion.indexOf(id);
				self.arrayDelMultPerfRegion.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultPerfRegion.length > 0) {
				$('#multSelecDeletePRT').removeClass('d-none');
			} else {
				$('#multSelecDeletePRT').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tablePerfRegion .deleteSelection').length == $('#tablePerfRegion .deleteSelection:checked').length && $('#tablePerfRegion .deleteSelection').length > 0) {
				$('#tablePerfRegion .globalSelection').prop('checked', true);
			} else {
				$('#tablePerfRegion .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeletePRT').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('PerfRegion');
			}, function() {});
		});
	},

	getLicenciasDiscriminantes() {
		let self = this;

		ajaxComunCallWithCallback('getLicenciasDiscriminantes', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.dataIntegration = ajaxReturn.result;
				self.renderLicenciasDiscriminantes();

				self.loaders.getLicenciasDiscriminantes = true;
				spinnerControl(self.loaders);
			}
		}, false);
	},

	renderLicenciasDiscriminantes() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.dataIntegration)) {
			self.dataIntegration = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC600}">${pf.const.language.RSC600}</th>
					<th scope="col" title="${pf.const.language.RSC619}">${pf.const.language.RSC619}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersIntegration">
				<tr>
					<td>selector</td>
					<td>pais</td>
					<td>licenciasOcupadas</td>
					<td>licenciasNoOcupadas</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.dataIntegration.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.allowedCountries.indexOf(self.dataIntegration[i].pais) == -1) {
				continue;
			}

			table += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRowTI" title="${self.dataIntegration[i].pais}">${self.dataIntegration[i].pais}</td>
					<td class="text-truncate c-pointer editRowTI" title="${self.dataIntegration[i].licencias_cumple}">${self.dataIntegration[i].licencias_cumple}</td>
					<td class="text-truncate c-pointer editRowTI" title="${self.dataIntegration[i].licencias_no_cumple}">${self.dataIntegration[i].licencias_no_cumple}</td>
					<td class="text-center">
						<div id="dropdownActions${i}ti" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}ti" data-id="${i}">
							<p class="dropdown-item editRowTI">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow deleteRowTI">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#tableIntegration').html(table);

		// Setup - add a text input to each footer cell
		$('#tableIntegration .filtersIntegration td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let integrationTable = $('#tableIntegration').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 4}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: null,
				filename: pf.const.language.RSC617,
				exportOptions: {
					columns: [1, 2, 3]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('tableIntegration');

		// Exportar tabla
		$('#exportIntegration').off().on('click', function() {
			$('#integrationTable .buttons-excel').trigger('click');
		});

		// Apply the search
		applyTheSearch(integrationTable, 'filtersIntegration');

		self.integrationDataEvents();

		$('#integrationTable').on('draw.dt', function() {
			self.integrationDataEvents();
		});
	},

	integrationDataEvents() {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions('#tableIntegration ');

		// Editar integración
		$('.editRowTI').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('profiling', self.profiling);
			sessionStorage.setItem('profilingType', btoa('Integration'));
			sessionStorage.setItem('pais', btoa(self.dataIntegration[id].pais));
			sessionStorage.setItem('cumple', btoa(self.dataIntegration[id].licencias_cumple));
			sessionStorage.setItem('nocumple', btoa(self.dataIntegration[id].licencias_no_cumple));

			window.location.href = '#!perfilacion_edit';
		});

		// Eliminar perfilación por género
		$('.deleteRowTI').off().on('click', function() {
			let id = $(this).parent().data('id');

			let IntegrationToDelete = {
				pais: self.dataIntegration[id].pais,
				cumple: self.dataIntegration[id].licencias_cumple,
				nocumple: self.dataIntegration[id].licencias_no_cumple
			};

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2519;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('Integration', IntegrationToDelete);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('#tableIntegration .deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMultIntegration.push(id);
			} else {
				let index = self.arrayDelMultIntegration.indexOf(id);
				self.arrayDelMultIntegration.splice(index, 1);
			}

			// Eventos de los inputs individuales
			if(self.arrayDelMultIntegration.length > 0) {
				$('#multSelecDeleteIT').removeClass('d-none');
			} else {
				$('#multSelecDeleteIT').addClass('d-none');
			}
		
			// Estado del input global con respecto a los inputs en página
			if($('#tableIntegration .deleteSelection').length == $('#tableIntegration .deleteSelection:checked').length && $('#tableIntegration .deleteSelection').length > 0) {
				$('#tableIntegration .globalSelection').prop('checked', true);
			} else {
				$('#tableIntegration .globalSelection').prop('checked', false);
			}
		});

		// Función de borrado múltiple
		$('#multSelecDeleteIT').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC515;
			let alertText = pf.const.language.RSC2520;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteProfilingABI('Integration');
			}, function() {});
		});
	},

	deleteProfilingABI(type, obj = false) {
		let self = this;

		let reqName = '';
		let profiles = [];

		switch(type) {
			case 'gender':
				reqName = 'deletePerfGenero';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultGender.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							genero: self.dataGender[self.arrayDelMultGender[i]].genero,
							pais: self.dataGender[self.arrayDelMultGender[i]].pais,
							region: self.dataGender[self.arrayDelMultGender[i]].region
						};
						profiles.push(obj);
					}
					self.arrayDelMultGender = [];
				}
				break;
			case 'state':
				reqName = 'deletePerfEstados';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultState.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							estado: self.dataState[self.arrayDelMultState[i]].estado,
							pais: self.dataState[self.arrayDelMultState[i]].pais,
							ciudad: self.dataState[self.arrayDelMultState[i]].ciudad,
							region: self.dataState[self.arrayDelMultState[i]].region
						};
						profiles.push(obj);
					}
					self.arrayDelMultState = [];
				}
				break;
			case 'age':
				reqName = 'deletePerfEdad';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultAge.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							edad: self.dataAge[self.arrayDelMultAge[i]].edad,
							pais: self.dataAge[self.arrayDelMultAge[i]].pais,
							region: self.dataAge[self.arrayDelMultAge[i]].region
						};
						profiles.push(obj);
					}
					self.arrayDelMultAge = [];
				}
				break;
			case 'PerfSec':
				reqName = 'deletePerfSec';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultPerfSec.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							sec: self.dataPerfSec[self.arrayDelMultPerfSec[i]].sec,
							pais: self.dataPerfSec[self.arrayDelMultPerfSec[i]].pais,
							region: self.dataPerfSec[self.arrayDelMultPerfSec[i]].region
						};
						profiles.push(obj);
					}
					self.arrayDelMultPerfSec = [];
				}
				break;
			case 'PerfRegion':
				reqName = 'deletePerfRegion';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultPerfRegion.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							region: self.dataPerfRegion[self.arrayDelMultPerfRegion[i]].region,
							pais: self.dataPerfRegion[self.arrayDelMultPerfRegion[i]].pais,
							regionABI: self.dataPerfRegion[self.arrayDelMultPerfRegion[i]].regionABI
						};
						profiles.push(obj);
					}
					self.arrayDelMultPerfRegion = [];
				}
				break;
			case 'Integration':
				reqName = 'deleteLicenciasDiscriminantes';

				if(obj !== false) {
					profiles.push(obj);
				} else {
					let delSize = self.arrayDelMultIntegration.length;
					for(let i = 0; i < delSize; i++) {
						let obj = {
							pais: self.dataIntegration[self.arrayDelMultIntegration[i]].pais,
							cumple: self.dataIntegration[self.arrayDelMultIntegration[i]].cumple,
							nocumple: self.dataIntegration[self.arrayDelMultIntegration[i]].nocumple
						};
						profiles.push(obj);
					}
					self.arrayDelMultIntegration = [];
				}
				break;
		}

		let parameters = {
			profiles: JSON.stringify(profiles)
		};
		ajaxComunCallWithCallback(reqName, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC515;
				let successContent = pf.const.language.RSC522;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/configuracion/perfilacion.html', 'wrapper', PerfilacionController);
			}
		});
	}
};