let PerfilacionEditController = {
	user: null,
	profiling: '',
	profilingType: '',
	profilingActualPercent: '',
	maxValuePercent: 0,
	profilingActualLicenses: '',
	profilingTotalLicenses: '',
	id: '',
	data: '',
	element: '',
	gender3: {},
	state3: {},
	age3: {},
	PerfSec3: {},
	PerfRegion3: {},
	Integration3: {},

	reset() {
		let self = this;

		self.user = null;
		self.profiling = '';
		self.profilingType = '';
		self.profilingActualPercent = '';
		self.maxValuePercent = 0;
		self.profilingActualLicenses = '';
		self.profilingTotalLicenses = '';
		self.id = '';
		self.data = '';
		self.element = '';
		self.gender3 = {};
		self.state3 = {};
		self.age3 = {};
		self.PerfSec3 = {};
		self.PerfRegion3 = {};
		self.Integration3 = {};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC515 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.profiling = sessionStorage.getItem('profiling');
		self.profilingType = atob(sessionStorage.getItem('profilingType'));
		switch(self.profilingType) {
			case 'gender':
				$('#header1').text(pf.const.language.RSC516);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#region').val(atob(sessionStorage.getItem('region')));
					$('#regionABI').val(atob(sessionStorage.getItem('regionABI')));
					$('#secABI').hide();
					$('#regAA').hide();
					$('#esta').hide();
					$('#ciud').hide();
					$('#edad').hide();
					$('#mini').hide();
					$('#maxi').hide();
					$('#gender').val(atob(sessionStorage.getItem('Gender')));
					$('#licensesABI').val(atob(sessionStorage.getItem('licencias')));
					$('#ocup').hide();
					$('#noOcup').hide();
					self.gender3.pais = atob(sessionStorage.getItem('pais'));
					self.gender3.genero = atob(sessionStorage.getItem('Gender'));
					self.gender3.region = atob(sessionStorage.getItem('region'));
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentGender'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesGender'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC151);
					self.id = atob(sessionStorage.getItem('idGender'));
					$('.licensesInput').hide();
				}
				break;
			case 'state':
				$('#header1').text(pf.const.language.RSC517);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#region').val(atob(sessionStorage.getItem('region')));
					$('#regionABI').val(atob(sessionStorage.getItem('regionABI')));
					$('#secABI').hide();
					$('#regionABIAux').val(atob(sessionStorage.getItem('regionABIAux')));
					$('#state').val(atob(sessionStorage.getItem('estado')));
					$('#city').val(atob(sessionStorage.getItem('ciudad')));
					$('#edad').hide();
					$('#mini').hide();
					$('#maxi').hide();
					$('#gene').hide();
					$('#lice').hide();
					$('#ocup').hide();
					$('#noOcup').hide();
					self.state3.pais = atob(sessionStorage.getItem('pais'));
					self.state3.estado = atob(sessionStorage.getItem('estado'));
					self.state3.region = atob(sessionStorage.getItem('region'));
					self.state3.ciudad = atob(sessionStorage.getItem('ciudad'));
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentState'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesState'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC153);
					self.id = atob(sessionStorage.getItem('idState'));
					$('.licensesInput').hide();
				}
				break;
			case 'age':
				$('#header1').text(pf.const.language.RSC518);
				if(self.profiling == 3) {
					$('#typeN').hide();
					$('#region').val(atob(sessionStorage.getItem('region')));
					$('#regionABI').val(atob(sessionStorage.getItem('regionABI')));
					$('#secABI').hide();
					$('#regAA').hide();
					$('#esta').hide();
					$('#ciud').hide();
					$('#age').val(atob(sessionStorage.getItem('edad')));
					$('#min').val(atob(sessionStorage.getItem('min')));
					$('#max').val(atob(sessionStorage.getItem('max')));
					$('#gene').hide();
					$('#licensesABI').val(atob(sessionStorage.getItem('licencias')));
					$('#ocup').hide();
					$('#noOcup').hide();
					self.age3.pais = atob(sessionStorage.getItem('pais'));
					self.age3.edad = atob(sessionStorage.getItem('edad'));
					self.age3.region = atob(sessionStorage.getItem('region'));
				} else {
					$('#type3').hide();
					// Recoger datos totales
					self.profilingActualPercent = atob(sessionStorage.getItem('totalPercentAge'));
					self.profilingActualLicenses = atob(sessionStorage.getItem('totalLicensesAge'));
					// Añadir textos
					$('#elementType').text(pf.const.language.RSC152);
					self.id = atob(sessionStorage.getItem('idAge'));
					$('.licensesInput').hide();
				}
				break;
			case 'PerfSec':
				$('#header1').text('Perfilación por PerfSec');
				$('#typeN').hide();
				$('#region').val(atob(sessionStorage.getItem('region')));
				$('#regA').hide();
				$('#sec').val(atob(sessionStorage.getItem('sec')));
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#min').val(atob(sessionStorage.getItem('min')));
				$('#max').val(atob(sessionStorage.getItem('max')));
				$('#gene').hide();
				$('#ocup').hide();
				$('#noOcup').hide();
				$('#licensesABI').val(atob(sessionStorage.getItem('licencias')));
				self.PerfSec3.pais = atob(sessionStorage.getItem('pais'));
				self.PerfSec3.sec = atob(sessionStorage.getItem('sec'));
				self.PerfSec3.region = atob(sessionStorage.getItem('region'));
				break;
			case 'PerfRegion':
				$('#header1').text('Perfilación por PerfRegion');
				$('#typeN').hide();
				$('#region').val(atob(sessionStorage.getItem('region')));
				$('#regionABI').val(atob(sessionStorage.getItem('regionABI')));
				$('#secABI').hide();
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#mini').hide();
				$('#maxi').hide();
				$('#gene').hide();
				$('#licensesABI').val(atob(sessionStorage.getItem('licencias')));
				$('#ocup').hide();
				$('#noOcup').hide();
				self.PerfRegion3.pais = atob(sessionStorage.getItem('pais'));
				self.PerfRegion3.regionABI = atob(sessionStorage.getItem('regionABI'));
				self.PerfRegion3.region = atob(sessionStorage.getItem('region'));
				break;
			case 'Integration':
				$('#header1').text(pf.const.language.RSC617);
				$('#typeN').hide();
				$('#regi').hide();
				$('#regA').hide();
				$('#secABI').hide();
				$('#regAA').hide();
				$('#esta').hide();
				$('#ciud').hide();
				$('#edad').hide();
				$('#mini').hide();
				$('#maxi').hide();
				$('#gene').hide();
				$('#lice').hide();
				$('#ocupadas').val(atob(sessionStorage.getItem('cumple')));
				$('#noOcupadas').val(atob(sessionStorage.getItem('nocumple')));
				self.Integration3.pais = atob(sessionStorage.getItem('pais'));
				self.Integration3.cumple = atob(sessionStorage.getItem('cumple'));
				self.Integration3.nocumple = atob(sessionStorage.getItem('nocumple'));
				break;
		}

		self.loadLang();

		if(self.profiling != 3) {
			self.requestProfiling();
		}

		self.applyEvents();

		$('#country').val(atob(sessionStorage.getItem('pais')));

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	requestProfiling() {
		let self = this;

		let reqName = '';
		switch(self.profilingType) {
			case 'gender':
				reqName = 'getPerfGenero';
				break;
			case 'state':
				reqName = 'getPerfEstados';
				break;
			case 'age':
				reqName = 'getPerfEdad';
				break;
		}

		ajaxComunCallWithCallback(reqName, {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				let size = self.data.length;

				switch(self.profilingType) {
					case 'gender':
						for(let i = 0; i < size; i++) {
							if(self.data[i].genero == self.id) {
								self.element = self.data[i];
								break;
							}
						}
						break;
					case 'state':
						for(let i = 0; i < size; i++) {
							if(self.data[i].estado == self.id) {
								self.element = self.data[i];
								break;
							}
						}
						break;
					case 'age':
						for(let i = 0; i < size; i++) {
							if(self.data[i].edad == self.id) {
								self.element = self.data[i];
								break;
							}
						}
						break;
				}

				// Formulario
				self.renderForm();
			}
		});
	},

	renderForm() {
		let self = this;

		switch(self.profilingType) {
			case 'gender':
				$('#element').val(self.element.genero);
				break;
			case 'state':
				$('#element').val(self.element.estado);
				break;
			case 'age':
				$('#element').val(self.element.edad);
				break;
		}
		$('#licenses').val(self.element.licencias);

		// Porcentaje máximo
		self.maxValuePercent = parseFloat(100 - self.profilingActualPercent + self.element.porcentaje).toFixed(1);
		$('#valueMax').text(pf.const.language.RSC532 + ' ' + self.maxValuePercent);
		$('#percentage').val(self.element.porcentaje);

		// Licencias totales
		self.profilingTotalLicenses = Math.round(100 * self.profilingActualLicenses / self.profilingActualPercent);
	},

	applyEvents() {
		let self = this;

		stcmbackend.perfilacion.sharedEvents(self, 'editPerfilacionCountry');

		// Guardar nueva entrada en registros de perfilación
		$('#save').on('click', function() {
			self.loadProfiling();
		});
	},

	loadProfiling() {
		let self = this;

		let reqName = '';
		let parameters = {};
		switch(self.profilingType) {
			case 'gender':
				reqName = 'editPerfGenero';
				break;
			case 'state':
				reqName = 'editPerfEstados';
				break;
			case 'age':
				reqName = 'editPerfEdad';
				break;
			case 'PerfSec':
				reqName = 'editPerfSec';
				break;
			case 'PerfRegion':
				reqName = 'editPerfRegion';
				break;
			case 'Integration':
				reqName = 'editLicenciasDiscriminantes';
				break;
		}

		if(self.profiling == 3) {
			// Comprobaciones
			let pais = $('#country').val();
			let region = $('#region').val().trim();
			let genero = $('#gender').val().trim();
			let regionABI = $('#regionABI').val().trim();
			let licencias = $('#licensesABI').val().trim();
			let estado = $('#state').val().trim();
			let ciudad = $('#city').val().trim();
			let regionABIAux = $('#regionABIAux').val().trim();
			let edad = $('#age').val().trim();
			let min = $('#min').val().trim();
			let max = $('#max').val().trim();
			let sec = $('#sec').val().trim();
			let cumple = $('#ocupadas').val().trim();
			let nocumple = $('#noOcupadas').val().trim();

			let comprobation = false;

			if(pais === '') {
				$('#country').addClass('is-invalid');
				$('[for="country"]').addClass('is-invalid');
				comprobation = true;
			} else {
				$('#country').removeClass('is-invalid');
				$('[for="country"]').removeClass('is-invalid');
			}
			if(region === '' && self.profilingType != 'Integration') {
				$('#region').addClass('is-invalid');
				$('[for="region"]').addClass('is-invalid');
				comprobation = true;
			} else {
				$('#region').removeClass('is-invalid');
				$('[for="region"]').removeClass('is-invalid');
			}

			switch(self.profilingType) {
				case 'gender':
					if(genero === '') {
						$('#gender').addClass('is-invalid');
						$('[for="gender"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#gender').removeClass('is-invalid');
						$('[for="gender"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						genero: genero,
						regionABI: regionABI,
						licencias: licencias,
						// OLD
						generoOld: self.gender3.genero,
						regionOld: self.gender3.region,
						paisOld: self.gender3.pais
					};

					break;
				case 'state':
					if(estado === '') {
						$('#state').addClass('is-invalid');
						$('[for="state"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#state').removeClass('is-invalid');
						$('[for="state"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						estado: estado,
						ciudad: ciudad,
						regionABI: regionABI,
						regionABIAux: regionABIAux,
						// OLD
						estadoOld: self.state3.estado,
						paisOld: self.state3.pais,
						regionOld: self.state3.region,
						ciudadOld: self.state3.ciudad
					};

					break;
				case 'age':
					if(edad === '') {
						$('#age').addClass('is-invalid');
						$('[for="age"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#age').removeClass('is-invalid');
						$('[for="age"]').removeClass('is-invalid');
					}
					if(min === '') {
						$('#min').addClass('is-invalid');
						$('[for="min"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#min').removeClass('is-invalid');
						$('[for="min"]').removeClass('is-invalid');
					}
					if(max === '') {
						$('#max').addClass('is-invalid');
						$('[for="max"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#max').removeClass('is-invalid');
						$('[for="max"]').removeClass('is-invalid');
					}
					if(min === '') {
						$('#min').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#min').removeClass('is-invalid');
					}
					if(max === '') {
						$('#max').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#max').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						edad: edad,
						min: min,
						max: max,
						regionABI: regionABI,
						licencias: licencias,
						// OLD
						edadOld: self.age3.edad,
						paisOld: self.age3.pais,
						regionOld: self.age3.region
					};

					break;
				case 'PerfSec':
					if(sec === '') {
						$('#sec').addClass('is-invalid');
						$('[for="sec"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#sec').removeClass('is-invalid');
						$('[for="sec"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						sec: sec,
						min: min,
						max: max,
						licencias: licencias,
						// OLD
						secOld: self.PerfSec3.sec,
						paisOld: self.PerfSec3.pais,
						regionOld: self.PerfSec3.region
					};

					break;
				case 'PerfRegion':
					if(regionABI === '') {
						$('#regionABI').addClass('is-invalid');
						$('[for="regionABI"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#regionABI').removeClass('is-invalid');
						$('[for="regionABI"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						regionABI: regionABI,
						licencias: licencias,
						// OLD
						regionABIOld: self.PerfRegion3.regionABI,
						paisOld: self.PerfRegion3.pais,
						regionOld: self.PerfRegion3.region
					};

					break;
				case 'Integration':
					if(cumple === '') {
						$('#ocupadas').addClass('is-invalid');
						$('[for="ocupadas"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#ocupadas').removeClass('is-invalid');
						$('[for="ocupadas"]').removeClass('is-invalid');
					}
					if(nocumple === '') {
						$('#noOcupadas').addClass('is-invalid');
						$('[for="noOcupadas"]').addClass('is-invalid');
						comprobation = true;
					} else {
						$('#noOcupadas').removeClass('is-invalid');
						$('[for="noOcupadas"]').removeClass('is-invalid');
					}

					parameters = {
						pais: pais,
						region: region,
						porcentaje: '',
						cumple: cumple,
						nocumple: nocumple,
						// OLD
						paisOld: self.Integration3.pais
					};

					break;
			}

			if(comprobation) {
				pf.utils.alerts.showCompleteAllFields();
				return false;
			}
		} else {
			let element = $('#element').val().trim();
			// Revisión de que el elemento no esté vacio
			if(element === '') {
				$('#element').addClass('is-invalid');
				$('[for="element"]').addClass('is-invalid');
				pf.utils.alerts.showCompleteAllFields();
				return false;
			}
			switch(self.profilingType) {
				case 'gender':
					parameters = {
						genero: element,
						generoOld: self.id,
						paisOld: '',
						regionOld: '',
						pais: '',
						region: '',
						regionABI: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#licenspercentagees').val()
					};
					break;
				case 'state':
					parameters = {
						estado: element,
						estadoOld: self.id,
						paisOld: '',
						regionOld: '',
						ciudadOld: '',
						pais: '',
						region: '',
						regionABI: '',
						regionABIAux: '',
						ciudad: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#licenspercentagees').val()
					};
					break;
				case 'age':
					parameters = {
						edad: element,
						edadOld: self.id,
						paisOld: '',
						regionOld: '',
						pais: '',
						region: '',
						regionABI: '',
						min: '',
						max: '',
						cumple: '',
						nocumple: '',
						licencias: $('#licenses').val(),
						porcentaje: $('#licenspercentagees').val()
					}
					break;
			}
		}

		ajaxComunCallWithCallback(reqName, parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC515;
				let successContent = pf.const.language.RSC521;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!perfilacion';
			}
		});
	},

	clickEvents(data) {
		$('#country').val(data.isocode);
		$('#countryDelete').show();
	}
};