let PerfilesEditController = {
	profile: null,
	allProfiles: '',

	reset() {
		let self = this;

		self.profile = JSON.parse(atob(sessionStorage.getItem('profile')));
		self.allProfiles = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC553 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
				${createSubOptionSave(jsonsubopt.save)}
				${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Todos los perfiles
		ajaxComunCallWithCallback('getProfiles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.allProfiles = ajaxReturn.result;
			}
		});

		self.getProfile();

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	getProfile() {
		let self = this;

		$('#id').val(self.profile.id);
		$('#descripcion').val(self.profile.descripcion);
		if(self.profile.enabled == 1) {
			$('#enabled').prop('checked', true);
			$('#default').prop('disabled', false);
		}
		if(self.profile.default == 1) {
			$('#default').prop('checked', true);
		}
	},

	applyEvents() {
		let self = this;

		stcmbackend.perfiles.sharedEvents(self);

		$('#save').on('click', function() {
			let objInfo = {
				accept: {
					text: pf.const.language.RSC78
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC78;
			let alertText = pf.const.language.RSC105;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.editProfile();
			}, function() {});
		});
	},

	editProfile() {
		let self = this;

		let value = 0;
		if($('#enabled').prop('checked')) {
			value = 1;
		}
		let profileDef = 0;
		let updateOld = false;
		let profileOld = '';
		if($('#default').prop('checked')) {
			profileDef = 1;
			let size = self.allProfiles.length;
			for(let i = 0; i < size; i++) {
				if(self.allProfiles[i].default == 1 && self.allProfiles[i].id != self.profile.id) {
					updateOld = true;
					profileOld = self.allProfiles[i];
				}
			}
		}

		let parameters = {
			id: $('#id').val(),
			description: $('#descripcion').val(),
			value: value,
			default: profileDef
		};
		ajaxComunCallWithCallback('updateProfile', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				if(updateOld) {
					self.editOldProfile(profileOld.id, profileOld.descripcion, profileOld.enabled, '0');
				} else {
					let successTitle = (pf.const.language.RSC78);
					let successContent = (pf.const.language.RSC106);
					pf.utils.showInfoDialog(successTitle, successContent);
					window.location.href = '#!perfiles';
				}
			}
		});
	},

	// En caso de nuevo perfil predefinido se actualiza el anterior perfil predefinido
	editOldProfile(id, descripcion, enabled, def) {
		let parameters = {
			id: id,
			description: descripcion,
			value: enabled,
			default: def
		};
		ajaxComunCallWithCallback('updateProfile', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = (pf.const.language.RSC78);
				let successContent = (pf.const.language.RSC106);
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!perfiles';
			}
		});
	}
};