stcmbackend.perfilacion = {
	sharedEvents(self, modal) {
		$('#back').on('click', function() {
			window.location.href = '#!perfilacion';
		});

		// País
		let countryModal = new TableCountries(0, modal);
		$('#searchCountry').off().on('click', function() {
			countryModal.setEvents();
		});

		// Control del valor de porcentaje
		$('#percentage').on('blur', function() {
			let valueFixed = parseFloat($('#percentage').val()).toFixed(1);
			if(parseFloat(valueFixed) > parseFloat(self.maxValuePercent)) {
				$('#percentage').val(self.maxValuePercent);
			} else if(parseFloat(valueFixed) < 0.1) {
				$('#percentage').val(0.1);
			} else {
				$('#percentage').val(valueFixed);
			}

			// Cambio del valor de licencias
			let percentNow = $('#percentage').val();
			let licensesVal = Math.round(self.profilingTotalLicenses * percentNow / 100);
			$('#licenses').val(licensesVal);
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});
	}
};