let CPGController = {
	user: null,
	language: '',
	data: '',
	arrayDelMult: [],
	cpgHide: '',

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.data = '';
		self.arrayDelMult = [];
		self.cpgHide = ''
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');
		let cpg = user.idCPG;

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1716);

		// Opciones de header
		let jsonsubopt = {
			new: 'new'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		if(cpg != 0 && cpg != undefined) {
			self.cpgHide = 'd-none';

			// Acciones de página (flex-row-reverse)s
			$('#page-actions').html('');
			$('#page-actions').removeClass('d-flex');
			$('#page-actions').addClass('d-none');
		} else {
			// Acciones de página (flex-row-reverse)s
			$('#page-actions').html(nav);

			$('#new svg').css({'width': '24px', 'height': '24px'});

			// Botón principal
			$('#new').addClass('main-button');
		}

		self.loadLang();
		self.applyEvents();

		ajaxComunCallWithCallback('getAllCPG', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				if(ajaxReturn.result == 'No CPG defined') {
					self.data = [];
				} else {
					self.data = ajaxReturn.result;
				}

				// Tabla de resultados
				self.renderData();
			}
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!cpg_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC366}">${pf.const.language.RSC366}</th>
					<th scope="col" title="${pf.const.language.RSC550}">${pf.const.language.RSC550}</th>
					<th scope="col" title="${pf.const.language.RSC1540}">${pf.const.language.RSC1540}</th>
					<th scope="col" title="${pf.const.language.RSC1541}">${pf.const.language.RSC1541}</th>
					<th scope="col" title="${pf.const.language.RSC1542}">${pf.const.language.RSC1542}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>id</td>
					<td>pais</td>
					<td>razonSocial</td>
					<td>nombreComercial</td>
					<td>identFiscal</td>
					<td>activo</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Obtener países permitidos
		let allowedCountries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			// Control de países permitidos
			if(self.data[i].country != '' && allowedCountries.indexOf(self.data[i].country) == -1) {
				continue;
			}

			table += `
				<tr data-id="${self.data[i].idCPG}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].idCPG}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].idCPG}">${self.data[i].idCPG}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].country}">${self.data[i].country}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].razonSocial}">${self.data[i].razonSocial}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].nombreComercial}">${self.data[i].nombreComercial}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].identFiscal}">${self.data[i].identFiscal}</td>
					<td class="text-center c-pointer editRow">
						<span class="d-none">${(self.data[i].activo == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].activo == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].idCPG}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'activo') {
				value = optionsSelectAllYesNo();
			} else if(title == 'selector' || title == 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '30px', targets: 1},
				{width: '60px', targets: 2},
				{width: '60px', targets: 6},
				{width: '60px', orderable: false, targets: 7}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1716,
				className: 'd-none',
				title: pf.const.language.RSC1716,
				exportOptions: {
					columns: [1, 2, 3, 4, 5]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents(dataTable);
		});
	},

	tableEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar CPG
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idCPG', btoa(id));
			window.location.href = '#!cpg_edit';
		});

		// Borrar CPG
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1716;
			let alertText = pf.const.language.RSC1720;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteCPG(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1716;
			let alertText = pf.const.language.RSC1719;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteCPG();
			}, function() {});
		});
	},

	deleteCPG(id = false) {
		let self = this;

		let cpgs = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			cpgs.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				cpgs.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			cpgs: JSON.stringify(cpgs)
		};
		ajaxComunCallWithCallbackOne('deleteCPG', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let resp = JSON.parse(ajaxReturn.resData.response);
				if(resp.status === 'OK') {
					let successTitle = pf.const.language.RSC1716;
					let successContent = pf.const.language.RSC1721;
					pf.utils.showInfoDialog(successTitle, successContent);
					loadHTML('inc/cpg/cpg.html', 'wrapper', CPGController);
				} else {
					if(resp.codeError == '3') {
						let warningTitle = pf.const.language.RSC1716;
						let warningContent = pf.const.language.RSC1723;
						pf.utils.showInfoDialog(warningTitle, warningContent);
					} else {
						let errorTitle = pf.const.language.RSC61;
						let errorContent = resp.result;
						pf.utils.showInfoDialog(errorTitle, errorContent);
						if(resp.result == 'Not authorized') {
							pf.ajax.setWindowLocationIndex();
						}
					}
				}
			}
		});
	}
};