let CustomersEditController = {
	user: null,
	idCustomer: '',
	customerObj: {},

	reset() {
		let self = this;

		self.user = null;
		self.idCustomer = atob(sessionStorage.getItem('idCustomer'));
		self.customerObj = {
			country: '',
			lenguage: '',
			activo: '',
			razonSocial: '',
			nombreComercial: '',
			identFiscal: '',
			direccion: '',
			poblacion: '',
			provincia: '',
			cp: '',
			telefono: '',
			web: '',
			email: ''
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2363 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		addLoader();
		let parameters = {
			idCustomer: self.idCustomer
		};
		ajaxComunCallWithCallback('getClienteById', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let data = ajaxReturn.result[0];
				self.customerObj = {
					country: data.country,
					lenguage: data.lenguage,
					activo: data.activo,
					razonSocial: data.razonSocial,
					nombreComercial: data.nombreComercial,
					identFiscal: data.identFiscal,
					direccion: data.direccion,
					poblacion: data.poblacion,
					provincia: data.provincia,
					cp: data.cp,
					telefono: data.telefono,
					web: data.web,
					email: data.email
				};

				ajaxComunCallWithCallback('getIdiomas', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						let idiomas = ajaxReturn.result;

						// Búsqueda de idiomas activos y creación de select
						let options = '';
						let size = idiomas.length;
						for(let i = 0; i < size; i++) {
							if(idiomas[i].enabled == 1) {
								options += `<option value="${idiomas[i].isocode}">${idiomas[i].descripcion}</option>`;
							}
						}

						$('#idioma').html(options);
						$('#idioma').val(self.customerObj.lenguage);

						removeLoader();
					}
				}, false);

				// Tabla de resultados
				self.renderForm();
			}
		}, false);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});

		// País
		let countryModal = new TableCountries(0, 'editCustomer');
		$('#searchCountry').off().on('click', function() {
			countryModal.setEvents();
		});

		// Volver a clientes
		$('#back').off().on('click', function() {
			window.location.href = '#!show_all_clients';
		});

		// Editar cliente
		$('#save').off().on('click', function() {
			self.getFormCustomer();
		});
	},

	renderForm() {
		let self = this;

		// País
		$('#pais').val(self.customerObj.country);

		// Activo
		if(self.customerObj.activo == '1') {
			$('#enable').prop('checked', true);
		}

		// Razón social
		$('#razonSocial').val(self.customerObj.razonSocial);

		// Nombre comercial
		$('#nombreComercial').val(self.customerObj.nombreComercial);

		// Identidad fiscal
		$('#identidadFiscal').val(self.customerObj.identFiscal);

		// Dirección
		$('#direccion').val(self.customerObj.direccion);

		// Población
		$('#poblacion').val(self.customerObj.poblacion);

		// Provincia
		$('#provincia').val(self.customerObj.provincia);

		// Código postal
		$('#codigoPostal').val(self.customerObj.cp);

		// Teléfono
		$('#telefono').val(self.customerObj.telefono);

		// Web
		$('#web').val(self.customerObj.web);

		// E-mail
		$('#mail').val(self.customerObj.email);
	},

	getFormCustomer() {
		let self = this;

		let check = true;

		// País
		let country = $('#pais').val();
		if(country == '') {
			check = false;
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}

		// Idioma
		let lenguage = $('#idioma').val();

		// Activo
		let activo = ($('#enable').prop('checked') ? '1' : '0');

		// Razón social
		let razonSocial = $('#razonSocial').val().trim();
		if(razonSocial == '') {
			check = false;
			$('#razonSocial').addClass('is-invalid');
			$('[for="razonSocial"]').addClass('is-invalid');
		} else {
			$('#razonSocial').removeClass('is-invalid');
			$('[for="razonSocial"]').removeClass('is-invalid');
		}

		// Nombre comercial
		let nombreComercial = $('#nombreComercial').val().trim();
		if(nombreComercial == '') {
			check = false;
			$('#nombreComercial').addClass('is-invalid');
			$('[for="nombreComercial"]').addClass('is-invalid');
		} else {
			$('#nombreComercial').removeClass('is-invalid');
			$('[for="nombreComercial"]').removeClass('is-invalid');
		}

		// Identidad fiscal
		let identFiscal = $('#identidadFiscal').val().trim();
		if(identFiscal == '') {
			check = false;
			$('#identidadFiscal').addClass('is-invalid');
			$('[for="identidadFiscal"]').addClass('is-invalid');
		} else {
			$('#identidadFiscal').removeClass('is-invalid');
			$('[for="identidadFiscal"]').removeClass('is-invalid');
		}

		// Dirección
		let direccion = $('#direccion').val().trim();

		// Población
		let poblacion = $('#poblacion').val().trim();

		// Provincia
		let provincia = $('#provincia').val().trim();

		// Código postal
		let cp = $('#codigoPostal').val().trim();

		// Teléfono
		let telefono = $('#telefono').val().trim();
		if(telefono == '') {
			check = false;
			$('#telefono').addClass('is-invalid');
			$('[for="telefono"]').addClass('is-invalid');
		} else {
			$('#telefono').removeClass('is-invalid');
			$('[for="telefono"]').removeClass('is-invalid');
		}

		// Web
		let web = $('#web').val().trim();

		// E-mail
		let email = $('#mail').val().trim();
		if(email == '' || !pf.utils.validateEmail(email)) {
			check = false;
			$('#mail').addClass('is-invalid');
			$('[for="mail"]').addClass('is-invalid');
		} else {
			$('#mail').removeClass('is-invalid');
			$('[for="mail"]').removeClass('is-invalid');
		}

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC2363;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.customerObj = {
				country: country,
				lenguage: lenguage,
				activo: activo,
				razonSocial: razonSocial,
				nombreComercial: nombreComercial,
				identFiscal: identFiscal,
				direccion: direccion,
				poblacion: poblacion,
				provincia: provincia,
				cp: cp,
				telefono: telefono,
				web: web,
				email: email
			};
			self.updateCliente();
		}
	},

	updateCliente() {
		let self = this;

		let parameters = {
			idCustomer: self.idCustomer,
			country: self.customerObj.country,
			lenguage: self.customerObj.lenguage,
			activo: self.customerObj.activo,
			razonSocial: self.customerObj.razonSocial,
			nombreComercial: self.customerObj.nombreComercial,
			identFiscal: self.customerObj.identFiscal,
			direccion: self.customerObj.direccion,
			poblacion: self.customerObj.poblacion,
			provincia: self.customerObj.provincia,
			cp: self.customerObj.cp,
			telefono: self.customerObj.telefono,
			web: self.customerObj.web,
			email: self.customerObj.email
		};

		ajaxComunCallWithCallback('updateCliente', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2363;
				let successContent = pf.const.language.RSC2369;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!show_all_clients';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};