let DifusionNewController = {
	user: null,
	requestType: '',
	users: '',
	admin: '',
	members: [],
	adminModal: null,
	crewObject: null,
	countryFilter: '',

	reset() {
		let self = this;

		self.user = null;
		self.requestType = '';
		self.users = '';
		self.admin = '';
		self.members = [];
		self.adminModal = null;
		self.crewObject = null;
		self.countryFilter = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC12 + ' - ' + pf.const.language.RSC8);

		// Opciones de header
		let jsonsubopt = {
			back: 'backLists',
			save: 'saveList'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#saveList').addClass('main-button');

		// Botones secundarios
		$('#backLists').addClass('secondary-button');

		// Añadir textos
		$('#selectMembers').text(pf.const.language.RSC141);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
		pf.rsc.translateByTag('placeholder');
	},

	applyEvents() {
		let self = this;

		stcmbackend.difusion.sharedEvents(self);

		// Administrador
		self.adminModal = new TableUsers(0, 'DifusionNewAdmin', self.countryFilter, '1', '1', '1');
		self.adminModal.surname = false;
		$('#searchAdmin').off().on('click', function() {
			self.requestType = 'admin';
			self.adminModal.setEvents();
		});

		// Ocultar cubo de basura
		$('#countryDelete').hide();

		// País
		let countryModal = new TableCountries(0, 'newDifusionCountry');
		$('#searchCountry').off().on('click', function() {
			self.requestType = 'country';
			countryModal.setEvents();
		});

		// Miembros
		self.crewObject = new TableUsers(1, 'DifusionNewCrew', self.countryFilter, '1', '1', '1');
		self.crewObject.surname = false;
		$('#searchMembers').off().on('click', function() {
			self.requestType = 'crew';
			self.crewObject.admin = self.admin;
			self.crewObject.setEvents();
		});

		// Guardar nueva Lista de difusion
		$('#saveList').on('click', function() {
			self.createDistributionList();
		});

		// Detectar fichero subido
		$('#inputFile').change(function(evt) {
			stcmbackend.difusion.uploadFile(evt, self, 'newList');
		});

		// Descargar layout
		$('#exportInner').off().on('click', function() {
			window.location = stcm.const.downloads + 'layout_difusion.xls';
		});
	},

	clickEvents(data, dType = null) {
		let self = this;

		if(dType) {
			self.requestType = dType;
		}

		switch(self.requestType) {
			case 'admin':
				self.admin = data.id;
				$('#admin').val(data.nameUser + ' ' + data.userApellidos + ' ' + data.userApellidos2);
				break;
			case 'crew':
				self.members = data;
				tableMembers.setEvents(self.members, 'tableMembersUsers', 'newList');
				break;
			case 'removeMember':
				self.members.splice(data, 1);
				self.crewObject.members = self.members;
				tableMembers.setEvents(self.members, 'tableMembersUsers', 'newList');
				break;
			// Seleccionar país
			case 'country':
				self.countryFilter = data.isocode;
				self.adminModal.admin = null;
				self.adminModal.data = null;
				self.adminModal.country = self.countryFilter;
				self.crewObject.data = null;
				self.crewObject.country = self.countryFilter;
				$('#pais').val(data.isocode);
				$('#countryDelete').show();
				break;
		}
	},

	createDistributionList() {
		let self = this;

		let admin = self.admin;
		if(admin === '') {
			$('#admin').addClass('is-invalid');
			$('#admin-group').addClass('group-invalid');
			$('[for="admin"]').addClass('is-invalid');
			let warningTitle = pf.const.language.RSC12;
			let warningContent = pf.const.language.RSC281;
			pf.utils.showInfoDialog(warningTitle, warningContent);
			return false;
		} else {
			$('#admin').removeClass('is-invalid');
			$('#admin-group').removeClass('group-invalid');
			$('[for="admin"]').removeClass('is-invalid');
		}

		let description = $('#desc').val().trim();
		if(description === '') {
			$('#desc').addClass('is-invalid');
			$('[for="desc"]').addClass('is-invalid');
			let warningTitle = pf.const.language.RSC12;
			let warningContent = pf.const.language.RSC282;
			pf.utils.showInfoDialog(warningTitle, warningContent);
			return false;
		} else {
			$('#desc').removeClass('is-invalid');
			$('[for="desc"]').removeClass('is-invalid');
		}

		let activa = ($('#active').prop('checked') ? 1 : 0);
		let destinatarios = [];
		let size = self.members.length;
		for(let i = 0; i < size; i++) {
			if(destinatarios.indexOf(self.members[i].id) == -1) {
				destinatarios.push(self.members[i].id);
			}
		}

		if(destinatarios.length == 0) {
			$('#members').addClass('is-invalid');
			$('#members-group').addClass('group-invalid');
			let warningTitle = pf.const.language.RSC12;
			let warningContent = pf.const.language.RSC283;
			pf.utils.showInfoDialog(warningTitle, warningContent);
			return false;
		}

		let parameters = {
			admin: admin,
			description: description,
			activa: activa,
			destinatarios: JSON.stringify(destinatarios),
			country: $('#pais').val()
		};
		ajaxComunCallWithCallback('createDistributionList', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC12;
				let successContent = pf.const.language.RSC280;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!difusion';
			}
		});
	}
};