class DocumentsGenerator {
	constructor(values) {
		this.action = values.action;
		this.actionExport = values.actionExport;
		this.token = values.token;
		this.toExport = true;
		this.nameExcel = values.nameExcel;
		this.cabeceras = values.cabeceras;
		this.parametros = values.parametros;
		this.country = (values.country || '');
		this.countryDesc = (values.countryDesc || '');
		this.fechaInicio = (values.fechaInicio || '');
		this.fechaFin = (values.fechaFin || '');
		this.id = (values.id || '');
		this.bExcel = values.bExcel;
		this.bPPT = values.bPPT;
		this.graphs = values.graphs;
		this.idTenant = values.idTenant;
		// Añadir los parámetros que sean necesarios para el servicio
	}

	start() {
		let self = this;

		self.generateExcel();
	}

	generateExcel() {
		let self = this;

		let idReport = Math.floor(Date.now() / 1000);
		let reqLabel = self.action + idReport;

		if(self.action == 'getAnalyticsPassiveTrackingExport') {
			// Aviso en pantalla
			$('#show-generating-reports').css('visibility', 'visible');
			let report = {
				name: pf.const.language.RSC1447,
				id: idReport,
				title: pf.const.language.RSC1941,
				subtitle: pf.const.language.RSC49,
				cancelButton: true
			}
			CardGeneratorController.addNotification(report);
	
			$(`#cancelDowload${idReport}`).off().on('click', (e)=>{
				e.preventDefault();

				CardGeneratorController.deleteNotification(idReport);
			});
		} else {
			// Aviso en pantalla
			CardGeneratorController.showOnScreenNotification(idReport, pf.const.language.RSC1447, 'check-circle');
		}

		let form = new FormData();
		form.append('action', self.action);
		form.append('token', self.token);
		switch(self.action) {
			// Asesores
			case 'getAnalyticsConsejerosToExport':
				$('#show-generating-reports').css('visibility', 'visible');
				form.append('country', self.country);
				form.append('countryDesc', self.countryDesc);
				break;
			// Passive Tracking
			case 'getAnalyticsPassiveTrackingExport':
				form.append('fechaInicio', self.fechaInicio);
				form.append('fechaFin', self.fechaFin);
				form.append('country', self.country);
				form.append('actionExport', self.actionExport);
				form.append('bExcel', self.bExcel);
				form.append('bPPT', self.bPPT);
				form.append('graphs', JSON.stringify(self.graphs));
				form.append('idTenant', self.idTenant);
				break;
			// Cubos
			case 'getBIExecution':
				form.append('id', self.id);
				break;
		}
		form.append('toExport', self.toExport);
		form.append('nameExcel', self.nameExcel);
		form.append('cabeceras', self.cabeceras);
		form.append('parametros', self.parametros);

		let reqData = {
			url: stcm.const.serverAPI,
			method: 'POST',
			timeout: stcm.const.AJAX_TIMEOUT,
			processData: false,
			mimeType: 'application/x-www-form-urlencoded',
			contentType: false,
			data: form
		};

		pf.ajax.request(reqLabel, reqData);
		$(document).off(reqLabel);
		$(document).on(reqLabel, function(event, response) {
			if(response.status === 'OK') {
				let resp = JSON.parse(response.resData.response);
				if(resp.status === 'OK') {
					// Descarga de documento
					if(self.action == 'getAnalyticsConsejerosToExport') {
						// Rutra del archivo de descarga
						//<a id="consejerosExport" href="${stcm.const.downloads + resp.result}" class="btn btn-light ml-2">${pf.const.language.RSC56}</a>
						// Para uso en localhost
						//<a id="consejerosExport" href="https://stcmbackend.sociallabs.biz/API/Downloads/${resp.result}" class="btn btn-light ml-2">${pf.const.language.RSC56}</a>

						$('.report-badge').text('1');
						$('.report-badge').show();

						let downloadExcel = `
							<div class="mt-2">
								<div class="p-2">
									${pf.const.language.RSC32}:
									<a id="consejerosExport" href="${stcm.const.downloads + resp.result}" class="btn btn-light ml-2">${pf.const.language.RSC56}</a>
								</div>
							</div>
						`;
						$('#reportList').html(downloadExcel);

						$('#clearNotifications').off().on('click', function() {
							$('.report-badge').text('');
							$('.report-badge').hide();
							$('#show-generating-reports').css('visibility', 'hidden');
							$('#dowloadCard').hide();
							$('#reportList').html('');
							self.deleteFiles(resp.result);
						});

						$('#consejerosExport').off().on('click', function() {
							$('.report-badge').text('');
							$('.report-badge').hide();
							$('#show-generating-reports').css('visibility', 'hidden');
							$('#dowloadCard').hide();
							$('#reportList').html('');
							setTimeout(function() {
								self.deleteFiles(resp.result);
							}, 1000);
						});
					} else if(self.action == 'getAnalyticsPassiveTrackingExport') {
						$(`#downloadCardTitle_${idReport}`).html(pf.const.language.RSC55 + ' - Passive Tracking');
						$(`#downloadCardText_${idReport}`).html(pf.const.language.RSC1380);
						$(`#${idReport}`).find('#statusIcon').html(stcmbackend.svg.checkCircleWithoutColor);
						$(`#${idReport}`).find('#statusIcon').css('color', 'green');
						$(`#${idReport}`).find(`#buttonWrapper${idReport}`).html(`
							<button id="cancelGeneratedReport" type="button" class="btn new-style-cancel">${pf.const.language.RSC57}</button>
							<button id="dowloadGeneratedReport" type="button" class="btn new-style-accept">${pf.const.language.RSC56}</button>
						`);
						$(`#${idReport}`).removeClass('runningReport');

						CardGeneratorController.updateIcon();
						CardGeneratorController.showOnScreenNotification(idReport, pf.const.language.RSC55, 'check-circle');

						$(`#${idReport}`).find('#dowloadGeneratedReport').off().on('click', ()=>{
							CardGeneratorController.deleteNotification(idReport);
							window.location = stcm.const.downloads + 'passive_tracking/' + resp.result; 
							setTimeout(function() {
								self.deleteAllFiles('passive_tracking');
							}, 2000);
						});
						$(`#${idReport}`).find('#cancelGeneratedReport').off().on('click', ()=>{
							CardGeneratorController.deleteNotification(idReport);
							self.deleteAllFiles('passive_tracking');
						});
					} else {
						switch(self.action) {
							// Cubos
							case 'getBIExecution':
								break;
							default:
								self.deleteAllFiles(self.nameExcel);
								break;
						}

						window.location = stcm.const.downloads + self.nameExcel + '/' + resp.result;						
					}
				} else {
					let errorTitle = pf.const.language.RSC61;
					let errorContent = resp.result;
					pf.utils.showInfoDialog(errorTitle, errorContent);
					if(resp.result == 'Not authorized') {
						pf.ajax.setWindowLocationIndex();
					}
				}
			} else {
				let errorTitle = pf.const.language.RSC61;
				let errorContent = response.result;
				pf.utils.showInfoDialog(errorTitle, errorContent);
				if(response.result == 'Not authorized') {
					pf.ajax.setWindowLocationIndex();
				}
			}
		});
	}

	deleteFiles(filename) {
		let parameters = {
			filename: filename
		};
		ajaxComunCallWithCallbackVoid('deleteFileExcel', parameters);
	}

	deleteAllFiles(filename) {
		let parameters = {
			folder: filename
		};
		ajaxComunCallWithCallbackVoid('deleteFolder', parameters);
	}
};