let RotationListController = {
	rotations: null,
	token: null,
	arrayDelMult: [],

	reset() {
		let self = this;

		self.rotations = null;
		self.token = sessionStorage['STCMBackEnd:token'];
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = RotationListController;
		self.reset();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1404);

		// Opciones de header
		let jsonsubopt = {
			new: 'newRotation'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#newRotation svg').css('width', '24px');
		$('#newRotation svg').css('height', '24px');

		// Botón principal
		$('#newRotation').addClass('main-button');

		self.loadLanguage();

		ajaxComunCallWithCallback('getAllRotacionSurveyQuestions', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.rotations = ajaxReturn.result;

				self.renderRotations();
			}
		});

		$('#newRotation').click(function() {
			window.location.href = '#!rotaciones/nuevo';
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	renderRotations() {
		let self = this;

		let render = `
			<table id="registers" class="table table-hover tRegs">
				<thead>
					<tr>
						<th class="text-center" scope="col" title="">
							<div class="div-global-selection">
								<input type="checkbox" class="globalSelection">
							</div>
						</th>
						<th scope="col" title="${pf.const.language.RSC1405}">${pf.const.language.RSC1405}</th>
						<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
						<th scope="col" title="${pf.const.language.RSC110}">${pf.const.language.RSC110}</th>
						<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
					</tr>
				</thead>

				<thead class="filtersResult">
					<tr>
						<td>selector</td>
						<td>Id</td>
						<td>Descripcion</td>
						<td>Encuesta</td>
						<td>acciones</td>
					</tr>
				</thead>

				<tbody>
		`;

		$.each(self.rotations, function(i, value) {
			render += `
				<tr data-id="${i}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${i}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-ellipsis c-pointer editRow" title="${self.rotations[i].idrotation}"><span data-name="name" data-id="${i}">${self.rotations[i].idrotation}</span></td>
					<td class="text-ellipsis c-pointer editRow" title="${self.rotations[i].description}"><span data-name="name" data-id="${i}">${self.rotations[i].description}</span></td>
					<td class="text-ellipsis c-pointer editRow" title="${self.rotations[i].sid}"><span data-name="empresa" data-id="${i}">${self.rotations[i].sid}</span></td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${i}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		});

		render += `
				</tbody>
			</table>
		`;

		// Print usersAPI
		$('#resultTable').html(render);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'selector' || title === 'acciones') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let excelTitle = pf.const.language.RSC1404;

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			pageLength: 25,
			scrollCollapse: true,
			scroller: false,
			paging: true,
			autoWidth: false,
			aaSorting: [],
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '180px', targets: 1},
				{width: '180px', targets: 3},
				{width: '60px', orderable: false, targets: 4}
			],
			lengthChange: false,
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'btn secondary-button ma-le-5',
				title: excelTitle,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		$('.dataTables_filter').hide();

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		$('#btn-actions').html(dataTable.buttons().container());

		// Dar estilo al boton de excel
		$('.buttons-excel').removeClass('btn-secondary');
		$('.buttons-excel').attr('title', pf.const.language.RSC47);

		$('.buttons-excel').html(
			stcmbackend.svg.download +
			`<span>${pf.const.language.RSC47}</span>`
		);

		self.dataEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.dataEvents(dataTable);
		});
	},

	dataEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar rotación
		$('.editRow').off().click(function() {
			let i = $(this).parent().data('id');

			let id = encodeURI(self.rotations[i].idrotation);
			let description = encodeURI(self.rotations[i].description);
			let survey = encodeURI(self.rotations[i].sid);
			window.location.href = `#!rotaciones/editar/?id=${id}&description=${description}&survey=${survey}`;
		});

		//Eliminar rotacion
		$('.deleteRow').off().click(function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1404;
			let alertText = pf.const.language.RSC1438;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteRotation(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1404;
			let alertText = pf.const.language.RSC1692;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteRotation();
			}, function() {});
		});
	},

	deleteRotation(id = false) {
		let self = this;

		let rotations = [];
		if(id !== false) {
			let obj = {
				survey: self.rotations[id].sid,
				idrotation: self.rotations[id].idrotation
			}
			rotations.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					survey: self.rotations[self.arrayDelMult[i]].sid,
					idrotation: self.rotations[self.arrayDelMult[i]].idrotation
				}
				rotations.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			rotations: JSON.stringify(rotations)
		};
		ajaxComunCallWithCallback('deleteRotacionSurveyQuestions', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let infoTitle = pf.const.language.RSC6;
				let infoContent = pf.const.language.RSC1439;
				pf.utils.showInfoDialog(infoTitle, infoContent);
				loadHTML('inc/encuestas/rotaciones.html', 'wrapper', RotationListController);
			}
		});
	}
};