let GruposNuevoController = {
	users: null,
	config: null,
	token: null,
	members: null,
	bots: null,
	userType: null,
	group: null,
	botConfig: null,
	userClick: null,
	crewObject: null,
	adminModal: null,
	userBot: null,
	userNotif: null,
	countryFilter: '',

	resetData() {
		let self = this;

		self.users = null;
		self.config = null;
		self.token = sessionStorage['STCMBackEnd:token'];
		self.members = [];
		self.bots = null;
		self.userType = null;
		self.group = {
			groupAdmin: null,
			groupName: null,
			participants: []
		};
		self.botConfig = {
			idUserOrGroup: null,
			directLineSecret: null,
			botId: null,
			isGroup: null,
			enabled: null,
			botUser: null,
			numVecesNoMatch: null,
			textoNoMatch: null,
			userNotificarNoMatch: null,
			textoNotificarNoMatch: null,
			saludoInicial: null
		};
		self.adminModal = null;
		self.crewObject = null;
		self.userBot = null;
		self.userNotif = null;
		self.countryFilter = '';
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC6 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'backLists',
			save: 'btn-send'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#btn-send').addClass('main-button');

		// Botones secundarios
		$('#backLists').addClass('secondary-button');

		self.loadLanguage();

		stcmbackend.grupos.sharedEvents(self);

		// País
		let countryModal = new TableCountries(0, 'newGroupCountry');
		$('#searchCountry').off().on('click', function() {
			self.userType = 'country';
			countryModal.setEvents();
		});

		// Cargar usuarios admin
		self.adminModal = new TableUsers(0, 'newGroups', self.countryFilter, 1, 1, 1);
		self.adminModal.surname = false;
		$('#btn-users').click(function() {
			self.userType = 'adminGroup';
			self.adminModal.setEvents();
		});

		// Cargar usuarios para añadir al grupo
		self.crewObject = new TableUsers(1, 'newGroups', self.countryFilter, 1, 1, 1);
		self.crewObject.surname = false;
		$('#btn-addUser').click(function() {
			self.userType = 'addMembers';
			self.crewObject.setEvents();
		});

		// Cargar usuarios bot user
		self.userBot = new TableUsers(0, 'newGroups', self.countryFilter);
		$('#btn-botUser').click(function() {
			self.userType = 'userBot';
			self.userBot.setEvents();
		});

		// Cargar usuarios notificacion
		self.userNotif = new TableUsers(0, 'newGroups', self.countryFilter);
		$('#btn-userNotificarNoMatch').click(function() {
			self.userType = 'userNotif';
			self.userNotif.setEvents();
		});

		$('#btn-bots').click(function() {
			self.userType = 'bots';
			tableBots.setEvents('newGroups');
		});
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
		pf.rsc.translateByTag('placeholder');

		let arrObj = ['RSC300'];
		pf.rsc.translateByTagHTMLFormat('simple', arrObj);
	},

	// Seleccionar usuario de la lista
	addUserGroup(i) {
		let self = this;

		self.members.push(self.users[i]);
		tableMembers.setEvents(self.members, 'tableMembersUsers');
	},

	selectDirectLine(i) {
		let self = this;

		let bot = self.bots[i].directLine;
		let botName = self.bots[i].botName;
		$('#directLineSecret').val(bot);
		$('#botId').val(botName);
	},

	sendGroup() {
		let self = this;

		let adminId = $('#SYSNotifUser').text();
		let participants = [];
		for(let i = 0; i < self.members.length; i++) {
			if(self.members[i].id != adminId) {
				participants.push(self.members[i].id);
			}
		}

		// Comprobar checkboxs
		if($('#saludoInicial').prop('checked')) {
			$('#saludoInicial').val(1);
		} else {
			$('#saludoInicial').val(0);
		}
		if($('#enabled').prop('checked')) {
			$('#enabled').val(1);
		} else {
			$('#enabled').val(0);
		}

		self.group = {
			groupAdmin: $('#SYSNotifUser').text(),
			admin: $('#SYSNotifUserName').val(),
			groupName: $('#groupName').val(),
			participants: participants,
			country: $('#pais').val()
		};

		self.botConfig = {
			directLineSecret: $('#directLineSecret').val(),
			botId: $('#botId').val(),
			isGroup: 1,
			enabled: $('#enabled').val(),
			botUser: $('#botUser').val(),
			numVecesNoMatch: $('#numVecesNoMatch').val(),
			textoNoMatch: $('#textoNoMatch').val(),
			userNotificarNoMatch: $('#userNotificarNoMatch').val(),
			textoNotificarNoMatch: $('#textoNotificarNoMatch').val(),
			SaludoInicial: $('#saludoInicial').val()
		};

		let parameters = {
			group: JSON.stringify(self.group),
			botConfig: JSON.stringify(self.botConfig),
			creation: pf.const.language.RSC1275
		};
		ajaxComunCallWithCallback('newGroup', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC78;
				let successContent = pf.const.language.RSC106;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!grupos';
			}
		});
	},

	clickEvents(data, type = null) {
		let self = this;

		if(type) {
			self.userType = type;
		}
		self.userClick = data;
		switch(self.userType) {
			case 'adminGroup':
				self.crewObject.admin = self.userClick.id;
				$('#SYSNotifUser').text(self.userClick.id);
				let surname1 = '';
				if(self.userClick.userApellidos && self.userClick.userApellidos != 'null') {
					surname1 = self.userClick.userApellidos;
				}

				let surname2 = '';
				if(self.userClick.userApellidos2 && self.userClick.userApellidos2 != 'null') {
					surname2 = self.userClick.userApellidos2;
				}

				$('#SYSNotifUserName').val(self.userClick.nameUser + ' ' + surname1 + ' ' + surname2);
				for(let i=0;i<self.members.length;i++) {
					if(self.userClick.id == self.members[i].id) {
						self.members.splice(i, 1);
						self.crewObject.members = self.members;
						tableMembers.setEvents(self.members, 'tableMembersUsers', 'newGroups');
					}
				}
				break;
			case 'userBot':
				$('#botUser').val(self.userClick.id);
				$('#botUserName').text(self.userClick.nameUser);
				break;
			case 'userNotif':
				$('#userNotificarNoMatch').val(self.userClick.id);
				$('#userNotificarNoMatchName').text(self.userClick.nameUser);
				break;
			case 'bots':
				$('#directLineSecret').val(self.userClick.directLine);
				$('#botId').val(self.userClick.botName);
				break;
			case 'addMembers':
				self.members = data;
				tableMembers.setEvents(self.members, 'tableMembersUsers', 'newGroups');
				break;
			case 'removeMember':
				self.members.splice(data, 1);
				self.crewObject.members = self.members;
				tableMembers.setEvents(self.members, 'tableMembersUsers', 'newGroups');
				break;
			// Seleccionar país
			case 'country':
				$('#pais').val(data.isocode);
				self.countryFilter = data.isocode;
				self.adminModal.admin = null;
				self.adminModal.data = null;
				self.adminModal.country = self.countryFilter;
				self.crewObject.data = null;
				self.crewObject.country = self.countryFilter;
				self.userBot.data = null;
				self.userBot.country = self.countryFilter;
				self.userNotif.data = null;
				self.userNotif.country = self.countryFilter;
				$('#countryDelete').show();
				break;
		}
	}
}