let HtmlEditarController = {
	token: null,
	option: null,
	url: null,
	roles: null,
	allRoles: null,
	id: null,
	parent: null,
	parentList: [],
	parentID: '',
	parentName: '',

	resetData() {
		let self = HtmlEditarController;

		self.token = sessionStorage['STCMBackEnd:token'];
		self.option = null;
		self.url = null;
		self.roles = null;
		self.allRoles = null;
		self.id = null;
		self.parent = null;
		self.parentList = [];
		self.parentID = '';
		self.parentName = '';
	},

	setEvents() {
		let self = HtmlEditarController;
		self.resetData();

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC44 + ' - ' + pf.const.language.RSC225);

		// Obtener extension a editar
		let html = sessionStorage['STCMBackEnd:editHtml'];
		html = JSON.parse(atob(html));
		self.option = html.optionText;
		self.url = html.url;
		self.parentID = html.parent;
		self.roles = html.roles;
		self.id = html.id;
		$('#pais').val(html.country);

		let modal = 'editHTMLCountry';
		stcmbackend.html.setEvents(self, modal);

		if(html.country != '') {
			$('#countryDelete').show();
		}

		// Modal de parent
		$('#btnParent').off().on('click', function() {
			stcmbackend.html.getAllCustomMenuOption(self, false);
		});

		// Guardar
		$('#btn-send').click(function() {
			// Obtener roles seleccionados
			self.getInputs();
			// Comprobar que los campos esta rellenos
			if(self.option.length == 0 || self.url.length == 0 || self.roles.length == 0) {
				if(self.option.length == 0) {
					$('#option').addClass('is-invalid');
					$('[for="option"]').addClass('is-invalid');
				} else {
					$('#option').removeClass('is-invalid');
					$('[for="option"]').removeClass('is-invalid');
				}

				if(self.url.length == 0) {
					$('#url').addClass('is-invalid');
					$('[for="url"]').addClass('is-invalid');
				} else {
					$('#url').removeClass('is-invalid');
					$('[for="url"]').removeClass('is-invalid');
				}

				pf.utils.alerts.showCompleteAllFields();
			} else {
				let objInfo = {
					accept: {
						text: pf.const.language.RSC78
					},
					cancel: {
						text: pf.const.language.RSC57
					}
				};

				let alertTitle = pf.const.language.RSC78;
				let alertText = pf.const.language.RSC105;
				pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
					self.save();
				}, function() {});
			}
		});

		// Printar datos
		self.setInputs();

		// Obtener parent
		if(self.parentID != '') {
			stcmbackend.html.getAllCustomMenuOption(self, true);
		}

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	renderRoles() {
		let self = HtmlEditarController;

		self.allRoles = new TableHtmlRoles();
		self.allRoles.checked = self.roles;
		self.allRoles.setEvents();
	},

	getInputs() {
		let self = HtmlEditarController;

		self.option = $('#option').val();
		self.url = $('#url').val();
		self.parent = $('#parent').val();
		self.roles = self.allRoles.getRoles();
	},

	setInputs() {
		let self = this;

		$('#option').val(self.option);
		$('#url').val(self.url);
		$('#parent').val(self.parent);
	},

	save() {
		let self = HtmlEditarController;

		let parameters = {
			option: self.id,
			optiontext: self.option,
			url: self.url,
			parent: self.parentID,
			roles: JSON.stringify(self.roles),
			country: $('#pais').val()
		};
		ajaxComunCallWithCallback('editCustomMenuById', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				window.location.href = '#!html';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
		$('#countryDelete').show();
	}
};