let ItemsNewController = {
	user: null,
	defaultImage: '',
	maxSize: 0,
	itemImages: [],
	itemImagesFile: [],
	acceptItemImages: [],
	acceptItemImagesFile: [],
	itemObj: {},
	noImgMain: true,
	stores: [],
	storesType: {},

	reset() {
		let self = this;

		self.user = null;
		self.defaultImage = stcm.const.downloads + 'image.png';
		self.maxSize = 0;
		self.itemImages = [];
		self.itemImagesFile = [];
		self.acceptItemImages = [];
		self.acceptItemImagesFile = [];
		self.itemObj = {
			fichaGS1Completa: '',
			pendienteRevision: '',
			barcode: '',
			nombre: '',
			descripcion: '',
			categoria: '',
			subcategoria: '',
			segmento: '',
			subsegmento: '',
			ocasiones: '',
			fabricante: '',
			marca: '',
			submarca: '',
			sabor: '',
			empaque: '',
			contenido: '',
			unidadMedida: '',
			rangoContenido: ''
		};
		self.noImgMain = true;
		self.stores = [];
		self.storesType = {};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2370 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		// Ocultar carrusel
		$('#respCarousel').hide();

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = config.upload_max_filesize_bytes;

		// Imagen por defecto
		self.itemImages[0] = {
			imgPath: self.defaultImage,
			main: '0'
		};

		addLoader();
		ajaxComunCallWithCallback('getAllComercios', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.stores = ajaxReturn.result;

				for(let i = 0; i < self.stores.length; i++) {
					self.stores[i]['selected'] = false;
				}

				ajaxComunCallWithCallback('getAllComerciosType', {}, function(ajaxReturn) {
					if(ajaxReturn) {
						self.storesType = {};

						for(let i = 0; i < ajaxReturn.result.length; i++) {
							self.storesType[ajaxReturn.result[i].id] = ajaxReturn.result[i].descripcion;
						}

						self.renderStores();
						removeLoader();
					}
				}, false);
			}
		}, false);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.acceptTitle').attr('title', pf.const.language.RSC141);
	},

	applyEvents() {
		let self = this;

		// Añadir imágenes
		$('#addImage').off().on('click', function() {
			self.imagesRender();
			$('#modalPictures').modal('show');
		});

		// Aceptar modal de imágenes
		$('#acceptImages').off().on('click', function() {
			$('#modalPictures').modal('hide');
			for(let i = 0; i < self.itemImages.length; i++) {
				let obj = {
					imgPath: self.itemImages[i].imgPath,
					main: self.itemImages[i].main
				};
				self.acceptItemImages[i] = obj;
			}
			self.acceptItemImagesFile = self.itemImagesFile;

			// Mostrar u ocultar carrusel según proceda
			if(self.acceptItemImages.length > 0 && self.acceptItemImages[0].imgPath != self.defaultImage) {
				$('#respCarousel').show();
				self.carousel();
			} else {
				$('#respCarousel').hide();
			}
		});

		// Volver a items
		$('#back').off().on('click', function() {
			window.location.href = '#!show_all_items';
		});

		// Guardar nuevo item
		$('#save').off().on('click', function() {
			self.getFormItem();
		});
	},

	carousel() {
		let self = this;

		let carouselImgs = '';
		let first = true;
		let size = self.acceptItemImages.length;

		for(let i = 0; i < size; i++) {
			if(self.acceptItemImages[i].imgPath == self.defaultImage) {
				continue;
			}

			if(first) {
				carouselImgs += `
					<div class="carousel-item active">
						<img src="${self.acceptItemImages[i].imgPath}" class="img-fluid d-inline-block">
					</div>
				`;

				first = false;
			} else {
				carouselImgs += `
					<div class="carousel-item">
						<img src="${self.acceptItemImages[i].imgPath}" class="img-fluid d-inline-block">
					</div>
				`;
			}
		}

		$('#carouselInner').html(carouselImgs);
		$('.carousel').carousel();
	},

	imagesRender() {
		let self = this;

		let picturesIMG = '';
		let size = self.itemImages.length;
		for(let i = 0; i < size; i++) {
			// Clase para borrar imagen que no se aplica a la imagen por defecto
			let trash = 'deletePicture';

			// Clase para seleccionar imagen principal en caso de que no haya imagen de GS1 o cargar nueva imagen en caso de que sea la de por defecto
			let loadPicture = ' c-pointer selectMain';

			// Estilo para mostrar o no imagen principal
			let selectMain = 'display: none;';

			if(self.itemImages[i].imgPath === self.defaultImage) {
				trash = 'd-none';
				loadPicture = ' c-pointer loadPicture';
			}
			if(self.itemImages[i].main === '_main_') {
				trash = 'd-none';
				loadPicture = '';
				selectMain = '';
			}
			picturesIMG += `
				<div class="col-3 d-flex flex-column">
					<input id="otherPicture_${i}" type="file" class="d-none mb-3 loadPictureInput" accept="image/*" data-index="${i}">
					<div id="otherPicture_${i}IMGdiv" class="d-flex justify-content-center h-100">
						<div class="position-relative">
							<img id="otherPicture_${i}IMG" src="${self.itemImages[i].imgPath}" class="ob-fit-cont border${loadPicture}" alt="img" height="130" width="130" data-index="${i}">
							<div class="btn-eye pos-abs-t6-l6-rad-50" style="${selectMain}">
								${stcmbackend.svg.checkBigCircleWithoutColor}
							</div>
						</div>
					</div>
					<button id="btn_otherPicture_${i}" type="button" class="btn btn-nav ${trash}" data-index="${i}">
						${stcmbackend.svg.trash}
					</button>
				</div>
			`;
		}

		$('#picturesContainer').html(picturesIMG);

		self.imagesEvents();
	},

	imagesEvents() {
		let self = this;

		// Seleccionar imagen principal
		$('.selectMain').off().on('click', function() {
			let index = $(this).data('index');

			for(let i = 0; i < self.itemImages.length; i++) {
				if(i == index) {
					self.itemImages[i].main = '_main_';
				} else {
					self.itemImages[i].main = '0';
				}
			}

			self.imagesRender();
		});

		// Carga de otras imágenes
		$('.loadPicture').off().on('click', function() {
			let index = $(this).data('index');
			$('#otherPicture_' + index).trigger('click');
		});
		$('.loadPictureInput').off().on('change', function(evt) {
			let index = $(this).data('index');
			let file = evt.target.files[0];
			if(file.size > self.maxSize) {
				let alertTitle = pf.const.language.RSC1909;
				let alertText = pf.const.language.RSC1337;
				pf.utils.showInfoDialog(alertTitle, alertText);
			} else {
				self.itemImagesFile[index] = file;
				let src = URL.createObjectURL(evt.target.files[0]);
				self.itemImages[index].imgPath = src;
				if(self.noImgMain) {
					self.noImgMain = false;
					self.itemImages[index].main = '_main_';
				} else {
					self.itemImages[index].main = '0';
				}

				let obj = {
					imgPath: self.defaultImage,
					main: '0'
				};
				self.itemImages.push(obj);

				self.imagesRender();
			}
		});

		// Borrar imágenes secundarias
		$('.deletePicture').off().on('click', function() {
			let index = $(this).data('index');
			$('.otherPicture_' + index).val(null);

			self.itemImages.splice(index, 1);
			self.itemImagesFile.splice(index, 1);

			self.imagesRender();
		});
	},

	renderStores() {
		let self = this;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC1229}">${pf.const.language.RSC1229}</th>
					<th scope="col" title="${pf.const.language.RSC2474}">${pf.const.language.RSC2474}</th>
					<th scope="col">
						<div class="custom-control custom-switch">
							<input id="allSwitchs" type="checkbox" class="custom-control-input">
							<label for="allSwitchs" class="custom-control-label c-pointer"></label>
						</div>
					</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>nombre</td>
					<td>direccion</td>
					<td>idComercioType</td>
					<td>select</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.stores.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${self.stores[i].id}">
					<td class="text-truncate c-pointer editRow" title="${self.stores[i].nombre}">${self.stores[i].nombre}</td>
					<td class="text-truncate c-pointer editRow" title="${self.stores[i].direccion || '-'}">${self.stores[i].direccion || '-'}</td>
					<td class="text-truncate c-pointer editRow" title="${self.storesType[self.stores[i].idComercioType]}">${self.storesType[self.stores[i].idComercioType]}</td>
					<td>
						<div class="custom-control custom-switch">
							<input id="${self.stores[i].id}" type="checkbox" class="custom-control-input uSwitch" data-index="${i}">
							<label for="${self.stores[i].id}" class="custom-control-label c-pointer"></label>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title === 'select') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: pf.const.language_table,
			paging: false,
			autoWidth: false,
			columnDefs: [
				{width: '30px', orderable: false, targets: 3}
			],
			exportOptions: {
				columns: [0, 1, 2]
			},
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC2473,
				className: 'd-none',
				title: pf.const.language.RSC2473,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Exportar tabla
		$('#exportStores').off().on('click', function() {
			$('#storesTableContainer .buttons-excel').trigger('click');
		});

		self.storesTableEvents(dataTable);

		$('#registers').on('draw.dt', function() {
			self.storesTableEvents(dataTable);
		});
	},

	storesTableEvents() {
		let self = this;

		if($('.uSwitch').length == $('.uSwitch:checked').length) {
			$('#allSwitchs').prop('checked', true);
		} else {
			$('#allSwitchs').prop('checked', false);
		}

		// La id del elemento principal modifica los elementos secundarios a través de su clase
		$('#allSwitchs').on('click', function() {
			$('.uSwitch').prop('checked', this.checked);

			let size = self.stores.length;
			for(let i = 0; i < size; i++) {
				self.stores[i].selected = this.checked;
			}
		});

		// Si todos los checkbox están seleccionados, se selecciona el checkbox principal, y viceversa
		$('.uSwitch').on('click', function() {
			if($('.uSwitch').length == $('.uSwitch:checked').length) {
				$('#allSwitchs').prop('checked', true);
			} else {
				$('#allSwitchs').prop('checked', false);
			}

			let index = $(this).data('index');
			self.stores[index].selected = this.checked;
		});
	},

	getFormItem() {
		let self = this;

		let check = true;

		// Código de barras
		let barcode = $('#barcode').val().trim();
		if(barcode == '') {
			check = false;
			$('#barcode').addClass('is-invalid');
			$('[for="barcode"]').addClass('is-invalid');
		} else {
			$('#barcode').removeClass('is-invalid');
			$('[for="barcode"]').removeClass('is-invalid');
		}

		/* // Nombre
		let nombre = $('#nombre').val().trim();
		if(nombre == '') {
			check = false;
			$('#nombre').addClass('is-invalid');
			$('[for="nombre"]').addClass('is-invalid');
		} else {
			$('#nombre').removeClass('is-invalid');
			$('[for="nombre"]').removeClass('is-invalid');
		}

		// Categoría
		let categoria = $('#categoria').val().trim();
		if(categoria == '') {
			check = false;
			$('#categoria').addClass('is-invalid');
			$('[for="categoria"]').addClass('is-invalid');
		} else {
			$('#categoria').removeClass('is-invalid');
			$('[for="categoria"]').removeClass('is-invalid');
		}

		// Marca
		let marca = $('#marca').val().trim();
		if(marca == '') {
			check = false;
			$('#marca').addClass('is-invalid');
			$('[for="marca"]').addClass('is-invalid');
		} else {
			$('#marca').removeClass('is-invalid');
			$('[for="marca"]').removeClass('is-invalid');
		}

		// Contenido
		let contenido = $('#contenido').val().trim();
		if(contenido == '') {
			check = false;
			$('#contenido').addClass('is-invalid');
			$('[for="contenido"]').addClass('is-invalid');
		} else {
			$('#contenido').removeClass('is-invalid');
			$('[for="contenido"]').removeClass('is-invalid');
		} */

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC2370;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.itemObj = {
				fichaGS1Completa: ($('#fichaGS1Completa').prop('checked') ? '1' : '0'),
				pendienteRevision: ($('#pendienteRevision').prop('checked') ? '1' : '0'),
				barcode: $('#barcode').val().trim(),
				nombre: $('#nombre').val().trim(),
				descripcion: $('#descripcion').val().trim(),
				categoria: $('#categoria').val().trim(),
				subcategoria: $('#subcategoria').val().trim(),
				segmento: $('#segmento').val().trim(),
				subsegmento: $('#subsegmento').val().trim(),
				ocasiones: $('#ocasiones').val().trim(),
				fabricante: $('#fabricante').val().trim(),
				marca: $('#marca').val().trim(),
				submarca: $('#submarca').val().trim(),
				sabor: $('#sabor').val().trim(),
				empaque: $('#empaque').val().trim(),
				contenido: $('#contenido').val().trim(),
				unidadMedida: $('#unidadMedida').val(),
				rangoContenido: $('#rangoContenido').val().trim()
			};
			self.setItems();
		}
	},

	setItems() {
		let self = this;

		// Tiendas con el articulo
		let stores = [];
		let size = self.stores.length;
		for(let i = 0; i < size; i++) {
			if(self.stores[i].selected) {
				stores.push(self.stores[i].id);
			}
		}

		let parameters = {
			fichaGS1Completa: self.itemObj.fichaGS1Completa,
			pendienteRevision: self.itemObj.pendienteRevision,
			barcode: self.itemObj.barcode,
			nombre: self.itemObj.nombre,
			descripcion: self.itemObj.descripcion,
			categoria: self.itemObj.categoria,
			subcategoria: self.itemObj.subcategoria,
			segmento: self.itemObj.segmento,
			subsegmento: self.itemObj.subsegmento,
			ocasiones: self.itemObj.ocasiones,
			fabricante: self.itemObj.fabricante,
			marca: self.itemObj.marca,
			submarca: self.itemObj.submarca,
			sabor: self.itemObj.sabor,
			empaque: self.itemObj.empaque,
			contenido: self.itemObj.contenido,
			unidadMedida: self.itemObj.unidadMedida,
			rangoContenido: self.itemObj.rangoContenido,
			acceptItemImages: JSON.stringify(self.acceptItemImages),
			stores: JSON.stringify(stores)
		};

		// Imágenes
		let imgSize = self.acceptItemImagesFile.length;
		for(let i = 0; i < imgSize; i++) {
			parameters['img' + i] = self.acceptItemImagesFile[i];
		}

		ajaxComunCallWithCallback('setItems', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2370;
				let successContent = pf.const.language.RSC2383;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!show_all_items';
			}
		});
	}
};