let StoresTypeEditController = {
	user: null,
	id: '',
	descripcion: '',

	reset() {
		let self = this;

		self.user = null;
		self.id = atob(sessionStorage.getItem('idStoreType'));
		self.descripcion = atob(sessionStorage.getItem('descripcionStoreType'));
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2475 + ' - ' + pf.const.language.RSC225);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		$('#descripcion').val(self.descripcion);

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		// Volver a tipos de tiendas
		$('#back').off().on('click', function() {
			window.location.href = '#!show_stores_type';
		});

		// Editar tipo de tienda
		$('#save').off().on('click', function() {
			self.updateComercioType();
		});
	},

	updateComercioType() {
		let self = this;

		let check = true;
		let descripcion = $('#descripcion').val().trim();
		if(descripcion == '') {
			check = false;
			$('#descripcion').addClass('is-invalid');
			$('[for="descripcion"]').addClass('is-invalid');
		} else {
			$('#descripcion').removeClass('is-invalid');
			$('[for="descripcion"]').removeClass('is-invalid');
		}

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC2475;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);

			return false;
		}

		let parameters = {
			id: self.id,
			descripcion: descripcion
		};
		ajaxComunCallWithCallback('updateComercioType', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC2475;
				let successContent = pf.const.language.RSC2479;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!show_stores_type';
			}
		});
	}
};