stcmbackend.misionesType = {
	sharedEvents(self) {
		// Encuesta
		$('#survey').off().on('change', function() {
			let survey = $('#survey').prop('checked');
			if(survey) {
				$('#searchObjetives').prop('disabled', true);
				$('#order').prop('disabled', true);
				$('#passive').prop('disabled', true);
				$('#videocall').prop('disabled', true);

				// Encuesta seleccionada automáticamente
				self.renderObjetive(self.survey.objetive, self.survey.description);
			} else {
				$('#searchObjetives').prop('disabled', false);
				$('#order').prop('disabled', false);
				$('#passive').prop('disabled', false);
				$('#videocall').prop('disabled', false);

				// Tabla de objetivos de misión sin encuesta
				$('#resultTable').html('');
			}
		});

		// Pedido
		$('#order').off().on('change', function() {
			let order = $('#order').prop('checked');
			if(order) {
				self.order = true;
				$('#table').trigger('order');
				$('#resultTable').html('');

				$('#survey').prop('disabled', true);
				$('#passive').prop('disabled', true);
				$('#videocall').prop('disabled', true);
			} else {
				self.order = false;
				$('#resultTable').html('');
				$('#table').trigger('noOrder');

				$('#survey').prop('disabled', false);
				$('#passive').prop('disabled', false);
				$('#videocall').prop('disabled', false);
			}
		});

		// Passive Tracking
		$('#passive').off().on('change', function() {
			let passive = $('#passive').prop('checked');
			if(passive) {
				$('#searchObjetives').prop('disabled', true);
				$('#resultTable').html('');

				$('#survey').prop('disabled', true);
				$('#order').prop('disabled', true);
				$('#videocall').prop('disabled', true);

				self.renderObjetive(self.passiveTracking.objetive, self.passiveTracking.description);
			} else {
				$('#resultTable').html('');
				$('#searchObjetives').prop('disabled', false);

				$('#survey').prop('disabled', false);
				$('#order').prop('disabled', false);
				$('#videocall').prop('disabled', false);
			}
		});

		// Videollamada
		$('#videocall').off().on('change', function() {
			let videocall = $('#videocall').prop('checked');
			if(videocall) {
				$('#resultTable').html('');

				$('#survey').prop('disabled', true);
				$('#order').prop('disabled', true);
				$('#passive').prop('disabled', true);
			} else {
				$('#resultTable').html('');

				$('#survey').prop('disabled', false);
				$('#order').prop('disabled', false);
				$('#passive').prop('disabled', false);
			}
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});
	}
};