let TenantNewController = {
	user: null,
	language: '',
	maxSize: 0,
	logoPrimario: null,
	logoSecundario: null,
	favicon: null,
	logoWallet: null,
	logoWellcome: null,
	setTenantObj: {},

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.maxSize = 0;
		self.logoPrimario = null;
		self.logoSecundario = null;
		self.favicon = null;
		self.logoWallet = null;
		self.logoWellcome = null;
		self.setTenantObj = {
			country: '',
			lenguage: '',
			activo: '',
			razonSocial: '',
			nombreComercial: '',
			identFiscal: '',
			direccion: '',
			poblacion: '',
			provincia: '',
			cp: '',
			telefono: '',
			web: '',
			email: '',
			numLicencias: '',
			logoPrimario: '',
			logoSecundario: '',
			favicon: '',
			logoWalletApp: '',
			logoWelcomeApp: '',
			colorPrimario: '',
			colorSecundario: ''
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1539 + ' - ' + pf.const.language.RSC7);

		// Opciones de header
		let jsonsubopt = {
			back: 'back',
			save: 'save'
		};

		let nav = `
			${createSubOptionSave(jsonsubopt.save)}
			${createSubOptionBack(jsonsubopt.back)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#back').addClass('secondary-button');

		self.loadLang();

		ajaxComunCallWithCallback('getIdiomas', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let idiomas = ajaxReturn.result;

				// Búsqueda de idiomas activos y creación de select
				let options = '';
				let size = idiomas.length;
				for(let i = 0; i < size; i++) {
					if(idiomas[i].enabled == 1) {
						options += `<option value="${idiomas[i].isocode}">${idiomas[i].descripcion}</option>`;
					}
				}

				$('#idioma').html(options);
			}
		});

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.maxSize = config.upload_max_filesize_bytes;

		self.applyEvents();

		// Imagenes por defecto
		let raiz = stcm.const.downloads + 'tenants/0/';
		$('#logoPrimIMG').attr('src', raiz + 'logo.png?stamp=' + new Date().getTime());
		$('#logoSecIMG').attr('src', raiz + 'logo_home.png?stamp=' + new Date().getTime());
		$('#faviconIMG').attr('src', raiz + 'favicon.ico?stamp=' + new Date().getTime());
		$('#logoWalletIMG').attr('src', raiz + 'wallet_card.png?stamp=' + new Date().getTime());
		$('#logoWellcomeIMG').attr('src', raiz + 'logo_welcome.png?stamp=' + new Date().getTime());

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
	},

	applyEvents() {
		let self = this;

		stcmbackend.tenant.sharedEvents(self, 'newTenantCountry');

		// Apariencia y comportamiento de los inputs tipo 'color'
		inputTypeColorEvents();

		// Guardar nuevo tenant
		$('#save').off().on('click', function() {
			self.getFormTenant();
		});
	},

	getFormTenant() {
		let self = this;

		let check = true;

		// País
		let country = $('#pais').val();
		if(country == '') {
			check = false;
			$('#pais').addClass('is-invalid');
			$('[for="pais"]').addClass('is-invalid');
		} else {
			$('#pais').removeClass('is-invalid');
			$('[for="pais"]').removeClass('is-invalid');
		}

		// Idioma
		let lenguage = $('#idioma').val();

		// Activo
		let activo = ($('#enable').prop('checked') ? '1' : '0');

		// Razón social
		let razonSocial = $('#razonSocial').val().trim();
		if(razonSocial == '') {
			check = false;
			$('#razonSocial').addClass('is-invalid');
			$('[for="razonSocial"]').addClass('is-invalid');
		} else {
			$('#razonSocial').removeClass('is-invalid');
			$('[for="razonSocial"]').removeClass('is-invalid');
		}

		// Nombre comercial
		let nombreComercial = $('#nombreComercial').val().trim();
		if(nombreComercial == '') {
			check = false;
			$('#nombreComercial').addClass('is-invalid');
			$('[for="nombreComercial"]').addClass('is-invalid');
		} else {
			$('#nombreComercial').removeClass('is-invalid');
			$('[for="nombreComercial"]').removeClass('is-invalid');
		}

		// Identidad fiscal
		let identFiscal = $('#identidadFiscal').val().trim();
		if(identFiscal == '') {
			check = false;
			$('#identidadFiscal').addClass('is-invalid');
			$('[for="identidadFiscal"]').addClass('is-invalid');
		} else {
			$('#identidadFiscal').removeClass('is-invalid');
			$('[for="identidadFiscal"]').removeClass('is-invalid');
		}

		// Dirección
		let direccion = $('#direccion').val().trim();

		// Población
		let poblacion = $('#poblacion').val().trim();

		// Provincia
		let provincia = $('#provincia').val().trim();

		// Código postal
		let cp = $('#codigoPostal').val().trim();

		// Teléfono
		let telefono = $('#telefono').val().trim();
		if(telefono == '') {
			check = false;
			$('#telefono').addClass('is-invalid');
			$('[for="telefono"]').addClass('is-invalid');
		} else {
			$('#telefono').removeClass('is-invalid');
			$('[for="telefono"]').removeClass('is-invalid');
		}

		// Web
		let web = $('#web').val().trim();

		// E-mail
		let email = $('#mail').val().trim();
		if(email == '' || !pf.utils.validateEmail(email)) {
			check = false;
			$('#mail').addClass('is-invalid');
			$('[for="mail"]').addClass('is-invalid');
		} else {
			$('#mail').removeClass('is-invalid');
			$('[for="mail"]').removeClass('is-invalid');
		}

		// Número de licencias
		let numLicencias = $('#numLicencias').val();

		// Logo principal
		let logoPrimario = self.logoPrimario;

		// Logo secundario
		let logoSecundario = self.logoSecundario;

		// Favicon
		let favicon = self.favicon;

		// Logo wallet
		let logoWallet = self.logoWallet;

		// Logo wellcome
		let logoWellcome = self.logoWellcome;

		// Color primario
		let colorPrimario = $('#colorPri').val();

		// Color secundario
		let colorSecundario = $('#colorSec').val();

		// Comprobación
		if(!check) {
			let alertTitle = pf.const.language.RSC1539;
			let alertText = pf.const.language.RSC101;
			pf.utils.showInfoDialog(alertTitle, alertText);
		} else {
			self.setTenantObj = {
				country: country,
				lenguage: lenguage,
				activo: activo,
				razonSocial: razonSocial,
				nombreComercial: nombreComercial,
				identFiscal: identFiscal,
				direccion: direccion,
				poblacion: poblacion,
				provincia: provincia,
				cp: cp,
				telefono: telefono,
				web: web,
				email: email,
				numLicencias: numLicencias,
				logoPrimario: logoPrimario,
				logoSecundario: logoSecundario,
				favicon: favicon,
				logoWalletApp: logoWallet,
				logoWelcomeApp: logoWellcome,
				colorPrimario: colorPrimario,
				colorSecundario: colorSecundario
			};
			self.setTenant();
		}
	},

	setTenant() {
		let self = this;

		let parameters = {
			country: self.setTenantObj.country,
			lenguage: self.setTenantObj.lenguage,
			razonSocial: self.setTenantObj.razonSocial,
			nombreComercial: self.setTenantObj.nombreComercial,
			identFiscal: self.setTenantObj.identFiscal,
			direccion: self.setTenantObj.direccion,
			poblacion: self.setTenantObj.poblacion,
			provincia: self.setTenantObj.provincia,
			cp: self.setTenantObj.cp,
			telefono: self.setTenantObj.telefono,
			web: self.setTenantObj.web,
			email: self.setTenantObj.email,
			numLicencias: self.setTenantObj.numLicencias,
			activo: self.setTenantObj.activo,
			colorPrimario: self.setTenantObj.colorPrimario,
			colorSecundario: self.setTenantObj.colorSecundario,
			logoPrimario: self.setTenantObj.logoPrimario,
			logoSecundario: self.setTenantObj.logoSecundario,
			favicon: self.setTenantObj.favicon,
			logoWalletApp: self.setTenantObj.logoWalletApp,
			logoWelcomeApp: self.setTenantObj.logoWelcomeApp,
			urlLogos: stcm.const.downloads + 'tenants/'
		};
		ajaxComunCallWithCallback('setTenant', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1539;
				let successContent = pf.const.language.RSC1554;
				pf.utils.showInfoDialog(successTitle, successContent);
				window.location.href = '#!tenant';
			}
		});
	},

	clickEvents(data) {
		$('#pais').val(data.isocode);
	}
};