let NotificacionesConsejerosController = {
	consejeros: null,
	enviar: null,
	config: null,

	resetData() {
		let self = this;

		self.consejeros = null;
		self.enviar = null;

		// Valores de configuración
		self.config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
	},

	setEvents() {
		let self = this;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC11);

		// Opciones de header
		let jsonsubopt = {
			sendNotif: 'sendNotif'
		};

		let nav = `
			${createSubOptionSendNotif(jsonsubopt.sendNotif)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#sendNotif').addClass('main-button');

		self.loadLanguage();

		// Obtener notificaciones
		self.getConsejeros();

		// Enviar notificaciones
		$('#sendNotif').click(function() {
			let content = `
				<p>${pf.const.language.RSC1294}</p>
				<input id="textNotifImput" type="text" class="form-control" value="${pf.const.language.RSC399}">
				<p class="mt-2">${pf.const.language.RSC1296}</p>
			`;

			$.alert({
				boxWidth: '500px',
				title: '<h3 class="ma-bo-20">' + pf.const.language.RSC574 + '</h3>',
				content: content,
				useBootstrap: false,
				bgOpacity: null,
				theme: 'new-style',
				buttons: {
					accept: {
						text: pf.const.language.RSC377,
						btnClass: 'new-style-accept',
						action() {
							let textNotifImput = $('#textNotifImput').val().trim();

							if(textNotifImput != '') {
								if(textNotifImput != pf.const.language.RSC399) {
									self.editRSC(textNotifImput);
								} else {
									setTimeout(function() {
										self.sendNotif(textNotifImput);
									}, 600);
								}
							} else {
								$('#textNotifImput').addClass('is-invalid');
								return false;
							}
						}
					},
					cancel: {
						text: pf.const.language.RSC57,
						btnClass: 'new-style-cancel',
						action() {
							//
						}
					}
				}
			});
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');
	},

	getConsejeros() {
		let self = this;

		self.consejeros = new TableConsejeros('getConsejerosSinClabe', pf.const.language.RSC376);
		self.consejeros.setEvents();
	},

	editRSC(textNotifImput) {
		let self = this;

		let objectRSC = null;
		let lenguage = sessionStorage['STCMBackEnd:lenguage'];

		let parameters = {
			rsc: '399'
		};
		ajaxComunCallWithCallback('getRSC', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				objectRSC = ajaxReturn.result[0];
				objectRSC[lenguage] = textNotifImput;

				let parameters = {
					rsc: '399',
					system: objectRSC.system,
					country: objectRSC.country,
					app: objectRSC.app
				};

				for(let element in objectRSC) {
					if(element == 'idRSC' || element == 'system' || element == 'country' || element == 'app' || element == 'idTenant' || element == 'idCPG') {
						continue;
					}

					let key = element.toLowerCase();

					parameters[key] = objectRSC[element];
				}

				ajaxComunCallWithCallback('updateRSC', parameters, function(ajaxReturn) {
					if(ajaxReturn) {
						setTimeout(function() {
							self.sendNotif(textNotifImput);
						}, 600);
					}
				}, false);
			}
		}, false);
	},

	sendNotif(textNotifImput) {
		let self = this;

		let parameters = {
			from: self.config.SYSNotifUser,
			emailsToSend: '',
			message: textNotifImput,
			idlist: self.consejeros.listId
		};
		ajaxComunCallWithCallback('postMessageMultiple', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let alertTitle = pf.const.language.RSC381;
				let alertText = pf.const.language.RSC401;
				pf.utils.showInfoDialog(alertTitle, alertText);
			}
		});
	}
};