let PagosController = {
	payments: null,
	exportedPayments: false,
	clabe: false,
	country: '',
	rscDataAll: {},
	startDate: '',
	startTime: '00:00',
	endDate: '',
	endTime: '23:59',

	resetData() {
		let self = PagosController;

		self.payments = null;
		self.exportedPayments = false;
		self.clabe = false;
		self.country = '';
		self.rscDataAll = {};
		self.startDate = '';
		self.startTime = '00:00';
		self.endDate = '';
		self.endTime = '23:59';
	},

	setEvents() {
		let self = PagosController;
		self.resetData();

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC16);

		// Opciones de header
		let jsonsubopt = {
			country: {
				id: 'countryInput',
				deleteBtn: false,
				style: 'style="line-height: initial; padding-top: 1.75rem!important;"'
			},
			startEndDate: {
				class: 'form-group m-0 ml-1',
				style: 'max-width: 145px; line-height: initial;'
			},
			startEndTime: {
				class: 'form-group m-0 ml-1',
				style: 'min-width: 105px; line-height: initial;'
			},
			refresh: {
				id: 'previewTables',
				disabled: true
			},
			export: {
				id: 'export',
				disabled: true
			}
		};

		let nav = `
			<div class="d-flex justify-content-end row m-0">
				${createSubOptionStartEndDateTime(jsonsubopt.startEndDate.class, jsonsubopt.startEndTime.class, jsonsubopt.startEndDate.style, jsonsubopt.startEndTime.style)}
				${createSubOptionCountry(jsonsubopt.country.id, jsonsubopt.country.deleteBtn, jsonsubopt.country.style)}
				<div class="pa-to-28 d-flex align-items-center">
					<div>
						<button id="dropdownFilters" type="button" class="btn-nav btn d-flex align-items-center ma-le-5 secondary-button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<span class="ml-1">${pf.const.language.RSC1076}</span>

							<span id="svgContainerPage" class="ml-2">
								<svg class="bi bi-chevron-down" width="12" height="12" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
									<path fill-rule="evenodd" d="M1.646 4.646a.5.5 0 01.708 0L8 10.293l5.646-5.647a.5.5 0 01.708.708l-6 6a.5.5 0 01-.708 0l-6-6a.5.5 0 010-.708z" clip-rule="evenodd"/>
								</svg>
							</span>
						</button>

						<div id="profileContainerPage" class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownFilters">
							<div class="dropdown-item form-check form-check-inline">
								<input id="filterClabe" type="checkbox" class="form-check-input">
								<label for="filterClabe" class="form-check-label c-pointer">${pf.const.language.RSC360}</label>
							</div>

							<div class="dropdown-item form-check form-check-inline">
								<input id="viewExportedPayments" type="checkbox" class="form-check-input">
								<label for="viewExportedPayments" class="form-check-label c-pointer">${pf.const.language.RSC1772}</label>
							</div>

							<div class="lastElement text-right">
								<span id="loadWithFilters" class="main-color-text c-pointer spanDisabled">${pf.const.language.RSC2523}</span>
							</div>
						</div>
					</div>

					${createSubOptionRefresh(jsonsubopt.refresh.id, jsonsubopt.refresh.disabled)}
					${createSubOptionExport(jsonsubopt.export.id, jsonsubopt.export.disabled)}
				</div>
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		// Botón principal
		$('#export').addClass('main-button');

		// Botones secundarios
		$('#previewTables').addClass('secondary-button');

		// Eventos de dropdown de página
		dropDownPageEvents();

		$('#startTime').parent().hide();
		$('#endTime').parent().hide();

		// Inputs de fecha y hora
		let now = new Date();
		let nYear = now.getFullYear();
		let nMonth = now.getMonth() + 1;
		if(nMonth < 10) {
			nMonth = '0' + nMonth;
		}
		let nDay = now.getDate();
		if(nDay < 10) {
			nDay = '0' + nDay;
		}
		self.today = nYear + '-' + nMonth + '-' + nDay;
		self.startDate = self.today;
		self.endDate = self.today;

		$('#startDate').val(self.startDate);
		$('#startTime').val(self.startTime);
		$('#endDate').val(self.endDate);
		$('#endTime').val(self.endTime);

		$('#resultTableCard').hide();
		$('#hideExportedPayments').hide();

		self.getAllRSC();
		self.loadLanguage();
		self.applyEvents();

		// Control de países permitidos por el administrador si solo hay uno
		let countries = JSON.parse(atob(sessionStorage['STCMBackEnd:userCountries']));
		let countriesDesc = atob(sessionStorage['STCMBackEnd:userCountriesDesc']);
		let disperse_country = sessionStorage['home:disperse_country'];
		let disperse_country_desc = sessionStorage['home:disperse_country_desc'];
		if(countries.length === 1) {
			self.country = countries[0];
			$('#countryInput').val(countriesDesc);
			$('#countryInput').attr('title', countriesDesc);
			$('#previewTables').attr('disabled', false);
		} else if(disperse_country != undefined) {
			self.country = disperse_country;
			$('#countryInput').val(disperse_country_desc);
			$('#countryInput').attr('title', disperse_country_desc);
			$('#previewTables').attr('disabled', false);
			sessionStorage.removeItem('home:disperse_country');
			sessionStorage.removeItem('home:disperse_country_desc');
		}

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLanguage() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// Fecha de inicio
		$('#startDate').on('change', function() {
			self.startDate = $('#startDate').val();
			if(self.startDate > self.endDate) {
				$('#startDate').val(self.endDate);
				self.startDate = $('#startDate').val();
			}
		});

		// Fecha de fin
		$('#endDate').on('change', function() {
			self.endDate = $('#endDate').val();
			if(self.endDate < self.startDate) {
				$('#endDate').val(self.startDate);
				self.endDate = $('#endDate').val();
			}
		});

		// País
		let countryModal = new TableCountries(0, 'pagos');
		$('#searchCountry').on('click', function() {
			countryModal.setEvents();
		});

		// Obtener pagos
		$('#previewTables').on('click', function() {
			$('#resultTableCard').show();
			$('#loadWithFilters').removeClass('spanDisabled');

			self.getPayments();
		});

		// Cargar datos de página a través de los filtros
		$('#loadWithFilters').on('click', function() {
			// En caso de que esté desactivado
			if($('#loadWithFilters').hasClass('spanDisabled')) {
				return false;
			}

			self.payments.setEvents();
		});

		// Filtrar por exportados
		$('#viewExportedPayments').on('change', function() {
			if($('#viewExportedPayments').prop('checked')) {
				self.exportedPayments = true;
				if(self.payments) {
					self.payments.exportedPayments = true;
				}
			} else {
				self.exportedPayments = false;
				if(self.payments) {
					self.payments.exportedPayments = false;
				}
			}
		});

		// Filtrar por CLABE
		$('#filterClabe').on('change', function() {
			if($('#filterClabe').prop('checked')) {
				self.clabe = true;
				if(self.payments) {
					self.payments.clabe = true;
				}
			} else {
				self.clabe = false;
				if(self.payments) {
					self.payments.clabe = false;
				}
			}
		});
	},

	getAllRSC() {
		let self = this;

		ajaxComunCallWithCallback('getAllRSC', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.rscData = ajaxReturn.result;

				// Dicionario completo
				let language = sessionStorage['STCMBackEnd:lenguage'];
				self.rscDataAll = {};
				let size = self.rscData.length;
				for(let i = 0; i < size; i++) {
					if(self.rscData[i].system == 0) {
						self.rscDataAll['RSC' + self.rscData[i].idRSC] = self.rscData[i][language];
					}
				}
			}
		});
	},

	getPayments() {
		let self = PagosController;

		self.payments = new TablePayments();
		self.payments.exportedPayments = self.exportedPayments;
		self.payments.clabe = self.clabe;
		self.payments.setEvents();
	},

	clickEvents(data) {
		let self = this;

		self.country = data.isocode;
		$('#countryInput').val(data.descripcion);
		$('#countryInput').attr('title', data.descripcion);
		$('#previewTables').attr('disabled', false);
	}
};