let ProductoMisionNewController = {
	user: null,
	userMail: '',
	language: '',
	idProduct: null,
	product: null,
	objetive: null,
	usuarioQueNotifica: '',
	descUsuarioQueNotifica: '',
	countryProyect: '',
	country: '',
	requestType: '',
	remindersTableArray: [],
	idmision: null,
	loaders: {},

	reset() {
		let self = this;

		self.user = null;
		self.userMail = '';
		self.language = pf.const.language_table;
		// ID de producto
		self.idProduct = atob(sessionStorage.getItem('idProductToCreate'));
		self.product = null;
		self.objetive = null;
		self.idmision = null;
		self.usuarioQueNotifica = '';
		self.descUsuarioQueNotifica = '';
		self.countryProyect = sessionStorage.getItem('countryProjectProduct');
		self.country = '';
		self.requestType= '';
		self.remindersTableArray = [];
		self.loaders = {
			getPaisesEnabled: false,
			getAllTipoMisionObjetivos: false
		};
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');
		self.userMail = userMail;

		// Valores de configuración
		let config = JSON.parse(atob(sessionStorage.getItem('STCMBackEnd:config')));
		self.usuarioQueNotifica = config.SYSNotifUser;
		self.descUsuarioQueNotifica = config.SYSNotifUserName;

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC2094);

		let isSurvey = atob(sessionStorage.getItem('productToCreateIsSurvey'));

		// Footer
		// Botón de anterior
		$('#previousStep').show();
		$('#previousStep').html(stcmbackend.svg.arrowLeftShortWithoutColor28 + pf.const.language.RSC2095);
		$('#previousStep').attr('title', pf.const.language.RSC2095);

		// Pasos
		let footerSteps = `
			<span class="font-weight-bold d-inline-block mx-3">1. ${pf.const.language.RSC2095}</span>
			<span class="font-weight-bold d-inline-block mx-3 text-decoration main-color-text p-2">2. ${pf.const.language.RSC2094}</span>
			<span class="font-weight-bold d-inline-block mx-3">3. ${pf.const.language.RSC110}</span>
			<span class="font-weight-bold d-inline-block mx-3">4. ${pf.const.language.RSC2096}</span>
			<span class="font-weight-bold d-inline-block mx-3">5. ${pf.const.language.RSC2097}</span>
		`;
		if(isSurvey != '1') {
			footerSteps = `
				<span class="font-weight-bold d-inline-block mx-3">1. ${pf.const.language.RSC2095}</span>
				<span class="font-weight-bold d-inline-block mx-3 text-decoration main-color-text p-2">2. ${pf.const.language.RSC2094}</span>
				<span class="font-weight-bold d-inline-block mx-3">3. ${pf.const.language.RSC2096}</span>
				<span class="font-weight-bold d-inline-block mx-3">4. ${pf.const.language.RSC2097}</span>
			`;
		}
		$('#stepContainer').html(footerSteps);

		// Botón de siguiente
		if(isSurvey != '1') {
			$('#subsequentStep').html(pf.const.language.RSC2096 + stcmbackend.svg.arrowRightShortWithoutColor28);
			$('#subsequentStep').attr('title', pf.const.language.RSC2096);
		} else {
			$('#subsequentStep').html(pf.const.language.RSC110 + stcmbackend.svg.arrowRightShortWithoutColor28);
			$('#subsequentStep').attr('title', pf.const.language.RSC110);
		}

		// Reducción de Header
		headerSectionHeight(0, true);

		// Fecha y hora
		let now = new Date();
		let nYear = now.getFullYear();
		let nMonth = now.getMonth() + 1;
		if(nMonth < 10) {
			nMonth = '0' + nMonth;
		}
		let nDay = now.getDate();
		if(nDay < 10) {
			nDay = '0' + nDay;
		}
		let today = nYear + '-' + nMonth + '-' + nDay;

		$('#startDate').val(today);
		$('#startTime').val('00:00');
		$('#endDate').val(today);
		$('#endTime').val('23:59');

		self.loadLang();
		self.applyEvents();

		addLoader();
		let parameters = {
			idProduct: self.idProduct
		};
		ajaxComunCallWithCallback('getProductsAnaquelByID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.product = ajaxReturn.result[0];

				sessionStorage.setItem('productTemplate', self.product.fileTemplate);

				let parameters = {
					tipomision: self.product.type
				};
				ajaxComunCallWithCallback('getAllTipoMisionObjetivos', parameters, function(ajaxReturn) {
					if(ajaxReturn) {
						self.objetive = ajaxReturn.result[0];

						sessionStorage.setItem('misionObjective', self.objetive);
						sessionStorage.setItem('descMisionObjective', pf.const.language['RSC' + self.objetive.descripcion]);

						// Control de spinner
						self.loaders.getAllTipoMisionObjetivos = true;
						spinnerControl(self.loaders);
					}
				}, false);

				$('#missionTypeInput').val(self.product.type);
			}
		}, false);

		ajaxComunCallWithCallback('getPaisesEnabled', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				let size = ajaxReturn.result.length;
				for(let i = 0; i < size; i++) {
					if(ajaxReturn.result[i].isocode == self.countryProyect) {
						self.country = ajaxReturn.result[i];

						let options = `
							<option value="${ajaxReturn.result[i].currency}">${ajaxReturn.result[i].currency}</option>
							<option value="points">${pf.const.language.RSC1897}</option>
						`;
						$('#currency').html(options);

						$('#projectCountry').val(self.country.isocode);
						break;
					}
				}

				// Control de spinner
				self.loaders.getPaisesEnabled = true;
				spinnerControl(self.loaders);
			}
		}, false);

		self.tableRecordatorios();

		// Collapse
		addEventArrowTableHeader();

		// Pintar texto de label
		changeLabelsColor();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		let arrObj = ['RSC326'];
		pf.rsc.translateByTagHTMLFormat('id', arrObj);

		// TITLES
		$('.addTitle').attr('title', pf.const.language.RSC93);
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		stcmbackend.productoMision.sharedEvents(self, 'newProductMissionCountry');

		// Restricciones de carácteres por tecla para el nombre de misión
		$('#missionName').on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1972, /[a-z0-9_-\s.]/i);

			return result;
		});

		// Restricciones de carácteres por pegado para el nombre de misión
		$('#missionName').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1972, /[^a-z0-9_-\s.]/gi);
		});

		// Añadir recordatorio
		$('#newRecordatorio').off().on('click', function() {
			let obj = {
				date: '',
				time: '',
				message: ''
			};
			self.remindersTableArray.push(obj);
			self.tableRecordatorios();
		});

		// Guardar misión y pasar a encuesta
		$('#subsequentStep').off().on('click', function() {
			// Comprobación de misiones referidas
			let tipomision = $('#missionTypeInput').val();

			if(tipomision == 'Referidos') {
				self.existsMisionBetweenDates();
			} else {
				self.createMission();
			}
		});

		// Volver a Producto / Proyecto
		$('#previousStep').off().on('click', function() {
			window.location.href = '#!producto_proyecto_edit';
		});
	},

	clickEvents(data, dType = null) {
		let self = this;

		if(dType) {
			self.requestType = dType;
		}

		switch(self.requestType) {
			case 'country':
				self.country = data;
				$('#projectCountry').val(self.country.isocode);

				let options = `
					<option value="${self.country.currency}">${self.country.currency}</option>
					<option value="points">${pf.const.language.RSC1897}</option>
				`;
				$('#currency').html(options);
			break;
			default:
			break;
		}
	},

	tableRecordatorios() {
		let self = this;

		let table = `
			<table id="tableReminders" class="table table-hover tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC431}">${pf.const.language.RSC431}</th>
						<th scope="col" title="${pf.const.language.RSC432}">${pf.const.language.RSC432}</th>
						<th scope="col" title="${pf.const.language.RSC421}">${pf.const.language.RSC421}</th>
						<th scope="col" title=""></th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.remindersTableArray.length;
		if(size < 1) {
			let obj = {
				date: '',
				time: '',
				message: ''
			};
			self.remindersTableArray.push(obj);
			size = 1;
		}

		for(let i = 0; i < size; i++) {
			let date = self.remindersTableArray[i].date;
			let time = self.remindersTableArray[i].time;
			let message = self.remindersTableArray[i].message;
			table += `
				<tr data-id="${i}">
					<td class="text-truncate p-1">
						<span id="date${i}" class="d-none">${date}</span>
						<input id="dateInput${i}" type="date" class="form-control dateInput" value="${date}" title="${date}">
					</td>
					<td class="text-truncate p-1">
						<span id="time${i}" class="d-none">${time}</span>
						<input id="timeInput${i}" type="time" class="form-control timeInput" value="${time}" title="${time}">
					</td>
					<td class="text-truncate p-1">
						<span id="message${i}" class="d-none">${message}</span>
						<input id="messageInput${i}" type="text" class="form-control messageInput" value="${message}" title="${message}">
					</td>
					<td class="text-truncate text-center" title="${pf.const.language.RSC226}">
						<span class="c-pointer deleteReminder">
							${stcmbackend.svg.bigTrash}
						</span>
					</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#recordatoriosTable').html(table);

		let tableReminders = $('#tableReminders').DataTable({
			retrieve: true,
			language: self.language,
			paging: false,
			autoWidth: false,
			columnDefs: [
				{width: '160px', targets: 0},
				{width: '90px', targets: 1},
				{width: '30px', targets: 3}
			],
			ordering: false,
			aaSorting: [],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1355,
				className: 'd-none',
				title: pf.const.language.RSC1355,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		// Ocultar botones de tabla
		hideTableButtons('tableReminders');

		// Exportar tabla
		$('#exportRecordatorio').off().on('click', function() {
			$('#recordatoriosTable .buttons-excel').trigger('click');
		});

		self.tableRecordatoriosEvents();
	},

	tableRecordatoriosEvents() {
		let self = this;

		// Input de fecha
		$('.dateInput').off().on('blur', function() {
			let index = $(this).attr('id').replace('dateInput', '');
			let value = $(this).val();
			self.remindersTableArray[index].date = value;
		});

		// Input de hora
		$('.timeInput').off().on('blur', function() {
			let index = $(this).attr('id').replace('timeInput', '');
			let value = $(this).val();
			self.remindersTableArray[index].time = value;
		});

		// Input de mensaje
		$('.messageInput').off().on('blur', function() {
			let index = $(this).attr('id').replace('messageInput', '');
			let value = $(this).val();
			self.remindersTableArray[index].message = value;
		});

		// Eliminar recordatorio
		$('.deleteReminder').off().on('click', function() {
			let index = $(this).parent().parent().data('id');
			self.remindersTableArray.splice(index, 1);
			self.tableRecordatorios();
		});
	},

	existsMisionBetweenDates() {
		let self = this;

		let fechahorainicioArray = $('#startDate').val().split('-');
		let fechainicio = fechahorainicioArray[2] + '/' + fechahorainicioArray[1] + '/' + fechahorainicioArray[0];
		let startTime = $('#startTime').val() + ':00';
		startTime = startTime.substring(0,8);
		let fechahorainicioexec = fechainicio + ' ' + startTime;

		let fechahorafinArray = $('#endDate').val().split('-');
		let fechafin = fechahorafinArray[2] + '/' + fechahorafinArray[1] + '/' + fechahorafinArray[0];
		let endTime = $('#endTime').val() + ':00';
		endTime = endTime.substring(0,8);
		let fechahorafinexec = fechafin + ' ' + endTime;

		let country = $('#projectCountry').val();
		let tipomision = $('#missionTypeInput').val();

		let parameters = {
			fechahorainicioexec: fechahorainicioexec,
			fechahorafinexec: fechahorafinexec,
			country: country,
			tipomision: tipomision
		};
		ajaxComunCallWithCallback('existsMisionBetweenDates', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				if(ajaxReturn.result.length == 0) {
					self.createMission();
				} else {
					let warningTitle = pf.const.language.RSC14;
					let warningContent = pf.const.language.RSC956;
					pf.utils.showInfoDialog(warningTitle, warningContent);
				}
			}
		});
	},

	createMission() {
		let self = this;

		let idmisionValidator = true;
		let idmision = $('#missionName').val().trim();
		self.idmision = idmision;
		// Comprobación de caracteres en el nombre de la misión
		if(!idmision.match(/^[A-Za-z0-9_-\s]+$/)) {
			$('#missionName').addClass('is-invalid');
			$('[for="missionName"]').addClass('is-invalid');

			let title = pf.const.language.RSC78;
			let content = pf.const.language.RSC1341;

			pf.utils.showInfoDialog(title, content);

			return false;
		} else {
			$('#missionName').removeClass('is-invalid');
			$('[for="missionName"]').removeClass('is-invalid');
		}

		// Validación idmision
		if(idmision === '') {
			$('#missionName').addClass('is-invalid');
			$('[for="missionName"]').addClass('is-invalid');
			idmisionValidator = false;
		} else {
			$('#missionName').removeClass('is-invalid');
			$('[for="missionName"]').removeClass('is-invalid');
			idmisionValidator = true;
		}

		let descripcionValidator = true;
		let descripcion = $('#missionDesc').val().trim();
		// Validación descripcion
		if(descripcion === '') {
			$('#missionDesc').addClass('is-invalid');
			$('[for="missionDesc"]').addClass('is-invalid');
			descripcionValidator = false;
		} else {
			$('#missionDesc').removeClass('is-invalid');
			$('[for="missionDesc"]').removeClass('is-invalid');
			descripcionValidator = true;
		}

		let textovalidacion = $('#validationText').val().trim();
		let textoiniciomision = $('#missionStartText').val().trim();
		let textofinmision = $('#missionEndText').val().trim();
		let textomisionok = $('#missionAccomplished').val().trim();
		let textomisionko = $('#missionNoAccomplished').val().trim();

		// Control de fecha/hora inicio/fin
		let startDateEmpty = $('#startDate').val() === '' ? true : false;
		let startTimeEmpty = $('#startTime').val() === '' ? true : false;
		let endDateEmpty = $('#endDate').val() === '' ? true : false;
		let endTimeEmpty = $('#endTime').val() === '' ? true : false;

		let dateTimeEmpty = false;
		if(startDateEmpty) {
			$('#startDate').addClass('is-invalid');
			$('[for="startDate"]').addClass('is-invalid');
			dateTimeEmpty = true;
		} else {
			$('#startDate').removeClass('is-invalid');
			$('[for="startDate"]').removeClass('is-invalid');
		}
		if(startTimeEmpty) {
			$('#startTime').addClass('is-invalid');
			$('[for="startTime"]').addClass('is-invalid');
			dateTimeEmpty = true;
		} else {
			$('#startTime').removeClass('is-invalid');
			$('[for="startTime"]').removeClass('is-invalid');
		}
		if(endDateEmpty) {
			$('#endDate').addClass('is-invalid');
			$('[for="endDate"]').addClass('is-invalid');
			dateTimeEmpty = true;
		} else {
			$('#endDate').removeClass('is-invalid');
			$('[for="endDate"]').removeClass('is-invalid');
		}
		if(endTimeEmpty) {
			$('#endTime').addClass('is-invalid');
			$('[for="endTime"]').addClass('is-invalid');
			dateTimeEmpty = true;
		} else {
			$('#endTime').removeClass('is-invalid');
			$('[for="endTime"]').removeClass('is-invalid');
		}

		let fechahorainicioArray = $('#startDate').val().split('-');
		let startTime = $('#startTime').val() + ':00';
		startTime = startTime.substring(0,8);
		let fechainicio = fechahorainicioArray[2] + '/' + fechahorainicioArray[1] + '/' + fechahorainicioArray[0];
		let fechahorainicioexec = fechainicio + ' ' + startTime;
		let fechahorainicio = fechainicio + '#' + startTime.replace(':', '#') + '#';

		let fechahorafinArray = $('#endDate').val().split('-');
		let endTime = $('#endTime').val() + ':00';
		endTime = endTime.substring(0,8);
		let fechafin = fechahorafinArray[2] + '/' + fechahorafinArray[1] + '/' + fechahorafinArray[0];
		let fechahorafinexec = fechafin + ' ' + endTime;
		let fechahorafin = fechafin + '#' +endTime.replace(':', '#') + '#';

		if(!idmisionValidator || !descripcionValidator || dateTimeEmpty) {
			let title = pf.const.language.RSC78;
			let content = pf.const.language.RSC101;

			pf.utils.showInfoDialog(title, content);

			return false;
		}

		let importe = $('#missionBonus').val().trim();
		let currency = $('#currency').val();
		let country = self.country.isocode;
		let finmisioncupo = $('#numMaxUsers').val();
		let textofinmisioncupo = $('#missionClosed').val().trim();

		// Validación de Recordatorios
		let dateStartControl = new Date($('#startDate').val() + ' ' + $('#startTime').val());
		let dateEndControl = new Date($('#endDate').val() + ' ' + $('#endTime').val());
		let reminders = false;
		let remindersCheck = true;
		let remindersSize = self.remindersTableArray.length;
		let remindersArray = [];
		for(let i = 0; i < remindersSize; i++) {
			if(self.remindersTableArray[i].date == '' || self.remindersTableArray[i].time == '' || self.remindersTableArray[i].message == '') {
				continue;
			} else {
				reminders = true;
				let reminderControl = new Date(self.remindersTableArray[i].date + ' ' + self.remindersTableArray[i].time);
				if(dateStartControl < reminderControl && reminderControl < dateEndControl) {
					reminderString = self.remindersTableArray[i].date + ' ' + self.remindersTableArray[i].time + '#' + self.remindersTableArray[i].message;
					remindersArray.push(reminderString);
					$('#dateInput' + i).removeClass('is-invalid');
					$('#timeInput' + i).removeClass('is-invalid');
				} else {
					remindersCheck = false;
					$('#dateInput' + i).addClass('is-invalid');
					$('#timeInput' + i).addClass('is-invalid');
				}
			}
		}

		if(reminders && !remindersCheck) {
			let title = pf.const.language.RSC1355;
			let content = pf.const.language.RSC1357;

			pf.utils.showInfoDialog(title, content);

			return false;
		}

		let needValidation = ($('#needValidation').prop('checked') ? '1' : '0');

		let parameters = {
			producto_mision: '1',
			id: sessionStorage['idProjectProduct'],
			idmision: idmision,
			descripcion: descripcion,
			textovalidacion: textovalidacion,
			textoiniciomision: textoiniciomision,
			textofinmision: textofinmision,
			textomisionok: textomisionok,
			textomisionko: textomisionko,
			tipomision: self.product.type,
			fechahorainicio: fechahorainicio,
			fechahorainicioexec: fechahorainicioexec,
			fechahorafin: fechahorafin,
			fechahorafinexec: fechahorafinexec,
			importe: importe,
			currency: currency,
			country: country,
			encuesta: self.product.isSurvey,
			order: '0',
			finmisioncupo: finmisioncupo,
			textofinmisioncupo: textofinmisioncupo,
			reminders: JSON.stringify(remindersArray),
			UsuarioQueNotifica: self.usuarioQueNotifica,
			DescUsuarioQueNotifica: self.descUsuarioQueNotifica,
			userMail: self.userMail,
			recordatorios: pf.const.language.RSC1355,
			needValidation: needValidation,
			objetivo: self.objetive.objetivo,
			descobjetivo: self.objetive.descripcion,
			textomisionkoAutoNoCumplimiento: ''
		};
		ajaxComunCallWithCallback('createMision', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				sessionStorage.setItem('stampMissionProduct', ajaxReturn.result);
				sessionStorage.setItem('idMisionProduct', self.idmision);

				// Control de tipo de misión, si no es de encuesta se salta un paso
				if(self.product.isSurvey == '1') {
					window.location.href = '#!producto_encuesta';
				} else {
					// Control nuevo / editar
					if(sessionStorage['editProductProject'] == '1') {
						window.location.href = '#!producto_criterio_edit';
					} else {
						window.location.href = '#!producto_criterio_new';
					}
				}
			}
		});
	}
};