stcmbackend.productoMision = {
	sharedEvents(self, modal) {
		// País
		let countryModal = new TableCountries(0, modal);
		$('#searchCountry').off().on('click', function() {
			self.requestType = 'country';
			countryModal.setEvents();
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});

		// Restricciones de carácter # por tecla para el Texto inicio de misión
		$('#missionStartText').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1999, /[^#]/i);

			return result;
		});

		// Restricciones del carácter # por pegado para el Texto inicio de misión
		$('#missionStartText').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1999, /[#]/gi);
		});

		// Validación
		$('#needValidation').off().on('change', function() {
			let needValidation = $('#needValidation').prop('checked');
			if(needValidation) {
				$('#validation').removeClass('d-none');
			} else {
				$('#validationText').val('');
				$('#validation').addClass('d-none');
			}
		});
	}
};