// JIRA: 3301
class EvidenceValidations {
	constructor(idMision, stampMision, idProject) {
		// ¿Qué propiedades debería incluir el objeto?
		this.idMision = idMision;
		this.stampMision = stampMision;
		this.idProject = idProject;
		this.data = null;
		this.validateCheck = false;
	}

	requestData() {
		let self = this;

		console.log(self.idMision);
		console.log(self.stampMision);
		console.log(self.idProject);

		// ¿Cuál será el nombre del servicio y que parámetros necesitará?

		/* let parameters = {
			survey: self.survey,
			qid: self.qid
		};
		ajaxComunCallWithCallback('servicioParaValidacionDeEvidencias', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		}); */

		// Cuando se tengan los datos se necesitaran al menos:
		/*
			Detalles del usuario (Nombre, Email, País)
			Detalles del proyecto misión (Nombre de proyecto, Nombre de misión, Remuneración, Fecha de inicio, Fecha de fin, País, Objetivo de la investigación)
			¿Cuantas evidencias hay?
			¿Qué número identifica a esta evidencia?
			¿Es la primera evidencia o la última? (para que se visualicen los botones de "atras" o "siguiente" o no)
			Tipo de pregunta ¿Vendrán todas juntas o de una en una?
			Número de pregunta
			Título de pregunta
			Respuesta actual
			¿Hay respuestas anteriores?
		*/

		// Tipos de preguntas posibles segun misión "RFQ - Nuevas validaciones" en plataforma Social
		/*
			3 - "10 Point choice"
			5 - "5 point choice"
			4 - "List drop down with filter"
			! - "List dropdown"
			L - "Listo radio"
			O - "List with comment"
			7 - "Array"
			B - "Array 10 point choice"
			A - "Array 5 point choice"
			; - "Array texts"
			2 - "Birth date"
			9 - "capture barcode"
			| - "File upload"
			G - "Gender"
			8 - "Media display"
			K - "Multiple numerical input"
			N - "Numerical input"
			R - "Ranking"
			7 - "Take photo and upload"
			Y - "Yes/no"
			T - "Long free text"
			Q - "Multiple short text"
			M - "Multiple choice"
			P - "Multiple choice with comments"
			V - "¿reinicio?"
		*/

		let questions = '';

		// Preguntas de texto
		questions = `
			<!-- Caja de preguntas de misión -->
			<div class="he-250 mb-3">
				<!-- Número y nombre de pregunta -->
				<div class="d-flex align-items-center">
					<div class="circle-count">
						<span>${'Número de pregunta'}</span>
					</div>

					<span class="section-title title-secondary">${'Nombre de pregunta'}</span>
				</div>

				<!-- Cuerpo de pregunta -->
				<div class="row mx-0 my-3 he-200">
					<div class="col-6 px-0">
						<div class="edges-evidence mr-1 py-3 px-2 he-100per">
							<!-- Respuesta actual -->
							<p><strong>${pf.const.language.RSC2658}</strong></p>

							<div class="edges-evidence py-3 px-2">
								<!-- Respuestas -->
								<p class="mb-0">${'Respuestas'}</p>
							</div>
						</div>
					</div>

					<!-- Respuestas anteriores -->
					<div class="col-6 px-0">
						<div class="edges-evidence ml-1 py-3 px-2 he-100per">
							<!-- Respuesta actual -->
							<p><strong idRSC="RSC2658">RSC2658</strong></p>

							<div class="edges-evidence py-3 px-2">
								<!-- Respuestas -->
								<p class="mb-0">Respuestas</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		`;

		// Preguntas de multimedia ¿?

		//$('#evidenceToValidate').html(questions);

		self.applyEvents();
		removeLoader();
	}

	applyEvents() {
		let self = this;

		/* if() {

		}
		$('#evBack').removeClass('visible');
		$('#evBack').addClass('invisible');
		$('#evForward').removeClass('visible');
		$('#evForward').addClass('invisible'); */
		
		// Botón de atrás
		$('#evBack').off().on('click', function() {
			console.log('atrás');
		});

		// Botón de siguiente
		$('#evForward').off().on('click', function() {
			console.log('siguiente');
		});

		// Botón de rechazar
		$('#evDecline').off().on('click', function() {
			console.log('rechazar');

			self.rejectEvidence();
		});

		// Botón de validar
		$('#evValidate').off().on('click', function() {
			console.log('validar');

			if(self.validateCheck) {
				// Validar misión
			} else {
				self.validateEvidence();
			}
		});
	}

	rejectEvidence() {
		let self = this;

		// Se necesita un servicio que devuelva los motivos de rechazo para crear el "select selectReasonsForRejection", manteniendo "other"

		let content = `
			<div class="form-group">
				<label for="selectReasonsForRejection" class="fw-500">${pf.const.language.RSC2667}</label>
				<select id="selectReasonsForRejection" class="form-control">
					<!-- Estas opciones se crearán de forma dinámica -->
					<option value="1">1</option>
					<option value="2">2</option>
					<option value="3">3</option>
					<option value="4">4</option>
					<!-- Valor fijo 'Otro' -->
					<option value="other">${pf.const.language.RSC2666}</option>
				</select>
			</div>

			<div id="reasonRejectionInput" class="form-group d-none">
				<input id="reasonRejection" type="text" class="form-control" placeholder="${pf.const.language.RSC2669}">
			</div>

			<div id="reasonRejectionCheck" class="form-check d-none">
				<input id="validateCheck" type="checkbox" class="form-check-input">
				<label for="validateCheck" class="form-check-label">${pf.const.language.RSC2668}</label>
			</div>


			<script>
				$('#selectReasonsForRejection').off().on('change', function() {
					let value = $('#selectReasonsForRejection').val();
					console.log(value);

					if(value === 'other') {
						$('.new-style-accept').prop('disabled', true);
						$('#reasonRejectionInput').removeClass('d-none');
						$('#reasonRejectionCheck').removeClass('d-none');

						$('#reasonRejection').off().on('blur', function() {
							let reasonRejection = $('#reasonRejection').val().trim();

							if(reasonRejection != '') {
								$('.new-style-accept').prop('disabled', false);
							}
						});
					} else {
						$('.new-style-accept').prop('disabled', false);
						$('#reasonRejectionInput').addClass('d-none');
						$('#reasonRejectionCheck').addClass('d-none');
					}
				});
			</script>
		`;

		let objInfo = {
			accept: {
				text: pf.const.language.RSC377
			},
			cancel: {
				text: pf.const.language.RSC57
			}
		};

		let alertTitle = pf.const.language.RSC2661;
		pf.utils.showInfoDialogCustomWidthAcceptCancelNewStyle(alertTitle, content, objInfo, '600px', function() {
			let selectReasonsForRejection = $('#selectReasonsForRejection').val();
			let reasonRejection = $('#reasonRejection').val().trim();
			let validateCheck = $('#validateCheck').prop('checked');

			console.log(selectReasonsForRejection);
			console.log(reasonRejection);
			console.log(validateCheck);

			if(selectReasonsForRejection == 'other') {
				// Se envía un motivo personalizado de rechazo
				if(validateCheck) {
					// Se guarda el nuevo motivo de rechazo
				}
			} else {
				// Se envia un motivo guardado de rechazo
				// Se necesita un servicio de guardado de nuevo rechazo
			}
		}, function() {});
	}

	validateEvidence() {
		let self = this;

		let content = `
			<p>${pf.const.language.RSC2663}</p>

			<div class="form-check">
				<input id="validateCheck" type="checkbox" class="form-check-input">
				<label for="validateCheck" class="form-check-label">${pf.const.language.RSC2664}</label>
			</div>
		`;

		let objInfo = {
			accept: {
				text: pf.const.language.RSC377
			},
			cancel: {
				text: pf.const.language.RSC57
			}
		};

		let alertTitle = pf.const.language.RSC2662;
		pf.utils.showInfoDialogCustomWidthAcceptCancelNewStyle(alertTitle, content, objInfo, '600px', function() {
			if($('#validateCheck').prop('checked')) {
				self.validateCheck = true;
			}
		}, function() {});
	}
}