let ExpulsionController = {
	user: null,
	language: '',
	data: '',

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.data = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC23);

		// Opciones de header
		let jsonsubopt = {
			save: 'save',
			new: 'new'
		};

		let nav = `
			<div class="row mx-0">
				${createSubOptionNew(jsonsubopt.new)}
				${createSubOptionSave(jsonsubopt.save)}
			</div>
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#save').addClass('main-button');

		// Botones secundarios
		$('#new').addClass('secondary-button');

		ajaxComunCallWithCallback('getAllMotivosExpulsionProject', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		self.loadLang();
		self.applyEvents();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
	},

	applyEvents() {
		let self = this;

		// Guardar motivos de expulsión
		$('#save').on('click', function() {
			self.saveExpulsionReasons();
		});

		// Nuevo registro
		$('#new').on('click', function() {
			let obj = {
				id: '',
				motivo: ''
			};
			self.data.push(obj);
			$('#registers').dataTable().fnDestroy();
			self.renderData();
		});
	},

	renderData() {
		let self = this;

		let excelTitle = pf.const.language.RSC23;

		let table = `
			<thead>
				<tr>
					<th scope="col" title="${pf.const.language.RSC382}">${pf.const.language.RSC382}</th>
					<th scope="col" title=""></th>
				</tr>
			</thead>

			<tbody>
		`;

		// Comprobación de array
		if(!Array.isArray(self.data)) {
			self.data = [];
		}

		let size = self.data.length;
		// En caso de que no haya registros
		if(size < 1) {
			let obj = {
				id: '',
				motivo: ''
			};
			self.data.push(obj);
			size = 1;
		}

		for(let i = 0; i < size; i++) {
			table += `
				<tr>
					<td class="text-truncate" title="${self.data[i].motivo}">
						<span class="d-none">${self.data[i].motivo}</span>
						<input type="text" class="form-control expulsionInput ovSpecChars" value="${self.data[i].motivo}">
					</td>
					<td class="text-truncate text-center align-middle" title="${pf.const.language.RSC226}">
						<span class="c-pointer delete">
							${stcmbackend.svg.bigTrash}
						</span>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			aaSorting: [],
			paging: false,
			autoWidth: false,
			ordering: false,
			columnDefs: [
				{width: '30px', targets: 1}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: excelTitle,
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}]
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		// Restricciones de carácteres por tecla
		$('.ovSpecChars').off().on('keypress', function(e) {
			// Parámetros: tecla, warningTitle, warningContent y pattern si no es el general
			let result = characterRestrictionsPerKey(e.keyCode, pf.const.language.RSC375, pf.const.language.RSC1762);

			return result;
		});

		// Restricciones de carácteres por pegado
		$('.ovSpecChars').on('paste', function() {
			// Parámetros: elemento, warningTitle, warningContent y pattern si no es el general
			characterRestrictionsPerPaste($(this), pf.const.language.RSC375, pf.const.language.RSC1762);
		});

		// Modificar motivo de expulsión
		$('.expulsionInput').on('blur', function() {
			let index = $('.expulsionInput').index(this);
			let value = $(this).val();
			self.data[index].motivo = value;
		});

		// Borrar registro
		$('.delete').off().on('click', function() {
			let index = $('.delete').index(this);
			self.data.splice(index, 1);
			$('#registers').dataTable().fnDestroy();
			self.renderData();
		});
	},

	saveExpulsionReasons(id) {
		let self = this;

		let motivos = [];
		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			if(self.data[i].motivo.trim() != '') {
				motivos.push(self.data[i].motivo);
			}
		}

		let parameters = {
			motivos: JSON.stringify(motivos)
		};
		ajaxComunCallWithCallback('deleteAllMotivosExpulsionProject', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC23;
				let successContent = pf.const.language.RSC383;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/proyectos/expulsion.html', 'wrapper', ExpulsionController);
			}
		});
	}
};