let ArticulosCatalogoController = {
	user: null,
	language: '',
	data: '',
	arrayDelMult: [],

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.data = '';
		self.arrayDelMult = [];
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC1892);

		// Opciones de header
		let jsonsubopt = {
			new: 'new',
			export: 'export'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		self.loadLang();
		self.applyEvents();

		// Petición de artículos
		ajaxComunCallWithCallback('getAllRewardsArticles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;

				// Tabla de resultados
				self.renderData();
			}
		});

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		let self = this;

		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!articulos_catalogo_new';
		});
	},

	renderData() {
		let self = this;

		$('#resultTable').show();

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC1898}">${pf.const.language.RSC1898}</th>
					<th scope="col" title="${pf.const.language.RSC123}">${pf.const.language.RSC123}</th>
					<th scope="col" title="${pf.const.language.RSC178}">${pf.const.language.RSC178}</th>
					<th scope="col" title="${pf.const.language.RSC126}">${pf.const.language.RSC126}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>img</td>
					<td>name</td>
					<td>description</td>
					<td>activo</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		// Control para mostrar el botón de eliminación múltiple solo en caso de que haya registros
		let elements = false;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			let imgPrincipalArray = self.data[i].imgPrincipal.split('/');

			// Carpeta
			let raiz = stcm.const.downloads + 'articulos/' + self.data[i].codArt + '/' + imgPrincipalArray[imgPrincipalArray.length - 1];

			table += `
				<tr data-id="${self.data[i].codArt}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].codArt}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-center c-pointer editRow">
						<img src="${raiz}" class="border ob-fit-cont" height="80" width="80">
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].articulo}">${self.data[i].articulo}</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].descripcion}">${self.data[i].descripcion}</td>
					<td class="text-center c-pointer editRow">
						<span class="d-none">${(self.data[i].enabled == '1' ? pf.const.language.RSC120 : pf.const.language.RSC121)}</span>
						<input type="checkbox" class="activa" disabled ${(self.data[i].enabled == '1' ? 'checked' : '')}>
					</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].codArt}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm">`;

			if(title == 'activo') {
				value = optionsSelectAllYesNo();
			} else if(title == 'selector' || title == 'acciones' || title == 'img') {
				value = `<input type="text" class="form-control form-control-sm" disabled>`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '120px', orderable: false, targets: 1},
				{width: '60px', targets: 4},
				{width: '60px', orderable: false, targets: 5}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC1892,
				className: 'd-none',
				title: pf.const.language.RSC1892,
				exportOptions: {
					columns: [2, 3, 4, 5]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			aaSorting: []
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#export').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.tableEvents(dataTable);

		$('#resultTable').on('draw.dt', function() {
			self.tableEvents(dataTable);
		});
	},

	tableEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar articulo
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('idArticle', btoa(id));
			window.location.href = '#!articulos_catalogo_edit';
		});

		// Borrar articulo
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1892;
			let alertText = pf.const.language.RSC1921;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteRewardsArticle(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC1892;
			let alertText = pf.const.language.RSC1920;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				self.deleteRewardsArticle();
			}, function() {});
		});
	},

	deleteRewardsArticle(id = false) {
		let self = this;

		let codArt = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			codArt.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				codArt.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			codArt: JSON.stringify(codArt)
		};
		ajaxComunCallWithCallback('deleteRewardsArticle', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC1892;
				let successContent = pf.const.language.RSC1922;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/recompensas/articulos_catalogo.html', 'wrapper', ArticulosCatalogoController);
			}
		});
	}
};