let RolesController = {
	user: null,
	language: '',
	data: '',
	arrayDelMult: [],
	defaultRole: '',

	reset() {
		let self = this;

		self.user = null;
		self.language = pf.const.language_table;
		self.data = '';
		self.arrayDelMult = [];
		self.defaultRole = '';
	},

	setEvents() {
		let self = this;
		self.reset();

		let JSONuser = sessionStorage['STCMBackEnd:user'];
		let user = JSON.parse(JSONuser);
		let userMail = user.email;
		let user_split = userMail.split('@');
		self.user = user_split[0].replace('.', '_');

		// Reducción de Header
		headerSectionHeight(0);

		// Añadir titulo
		$('#page-title').text(pf.const.language.RSC17);

		// Opciones de header
		let jsonsubopt = {
			new: 'new'
		};

		let nav = `
			${createSubOptionNew(jsonsubopt.new)}
		`;

		// Acciones de página (flex-row-reverse)s
		$('#page-actions').html(nav);

		$('#new svg').css({'width': '24px', 'height': '24px'});

		// Botón principal
		$('#new').addClass('main-button');

		self.loadLang();
		self.applyEvents();

		self.requestRoles();

		// Collapse
		addEventArrowTableHeader();
	},

	loadLang() {
		pf.rsc.translateByTag('text');
		pf.rsc.translateByTag('placeholder');

		// TITLES
		$('.exportTitle').attr('title', pf.const.language.RSC47);
		$('.deleteMultTitle').attr('title', pf.const.language.RSC95);
	},

	applyEvents() {
		// Nuevo
		$('#new').on('click', function() {
			window.location.href = '#!roles_new';
		});
	},

	requestRoles() {
		let self = this;

		ajaxComunCallWithCallback('getAllRoles', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.defaultRole = ajaxReturn.defaultRole;

				// Tabla de resultados
				self.renderData();
			}
		});
	},

	renderData() {
		let self = this;

		// Comprobación de array
		if(!Array.isArray(self.data)) {
			self.data = [];
		}

		let table = `
			<thead>
				<tr>
					<th class="text-center" scope="col" title="">
						<div class="div-global-selection">
							<input type="checkbox" class="globalSelection">
						</div>
					</th>
					<th scope="col" title="${pf.const.language.RSC277}">${pf.const.language.RSC277}</th>
					<th scope="col" title="${pf.const.language.RSC2516}">${pf.const.language.RSC2516}</th>
				</tr>
			</thead>

			<thead class="filtersResult">
				<tr>
					<td>selector</td>
					<td>rol</td>
					<td>acciones</td>
				</tr>
			</thead>

			<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr data-id="${self.data[i].role}">
					<td class="text-center">
						<div class="div-single-selection" data-id="${self.data[i].role}">
							<input type="checkbox" class="deleteSelection">
						</div>
					</td>
					<td class="text-truncate c-pointer editRow" title="${self.data[i].role}">${self.data[i].role}</td>
					<td class="text-center">
						<div id="dropdownActions${i}" class="div-dd-actions c-pointer" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							${stcmbackend.svg.threeDotsVertical18}
						</div>

						<div class="dropdown-menu dropdown-menu-right shadow menu-actions" aria-labelledby="dropdownActions${i}" data-id="${self.data[i].role}">
							<p class="dropdown-item editRow">
								${stcmbackend.svg.pencilWithoutColor}
								<span>${pf.const.language.RSC225}</span>
							</p>
							<p class="dropdown-item deleteRow">
								${stcmbackend.svg.trashWithoutColor}
								<span>${pf.const.language.RSC95}</span>
							</p>
						</div>
					</td>
				</tr>
			`;
		}

		table += `
			</tbody>
		`;

		$('#registers').html(table);

		// Setup - add a text input to each footer cell
		$('#registers .filtersResult td').each(function() {
			let title = $(this).text();
			let value = `<input type="text" class="form-control form-control-sm" disabled>`;

			if(title === 'rol') {
				value = `<input type="text" class="form-control form-control-sm">`;
			}

			$(this).html(value);
		});

		let dataTable = $('#registers').DataTable({
			retrieve: true,
			language: self.language,
			pageLength: 25,
			autoWidth: false,
			columnDefs: [
				{width: '25px', orderable: false, targets: 0},
				{width: '60px', orderable: false, targets: 2}
			],
			dom: 'Bfrtip',
			buttons: [{
				extend: 'excelHtml5',
				text: pf.const.language.RSC129,
				className: 'd-none',
				title: pf.const.language.RSC17,
				exportOptions: {
					columns: [1]
				},
				customize(xlsx) {
					dataTablesExcelCustomize(xlsx);
				}
			}],
			order: [[1, 'asc']]
		});

		// Ocultar botones de tabla
		hideTableButtons('registers');

		// Apply the search
		applyTheSearch(dataTable, 'filtersResult');

		// Exportar tabla
		$('#exportRoles').off().on('click', function() {
			$('#resultTable .buttons-excel').trigger('click');
		});

		self.dataEvents(dataTable);

		$('#registers').on('draw.dt', function() {
			self.dataEvents(dataTable);
		});
	},

	dataEvents(dataTable) {
		let self = this;

		// Eventos del input global
		globalSelectionInputActions();

		// Editar rol
		$('.editRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			sessionStorage.setItem('id', btoa(id));
			window.location.href = '#!roles_edit';
		});

		// Borrar rol
		$('.deleteRow').off().on('click', function() {
			let id = $(this).parent().data('id');

			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC17;
			let alertText = pf.const.language.RSC268;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				// Comprobación de roles
				self.roleStatus(id);
			}, function() {});
		});

		// Array de eliminado múltiple
		$('.deleteSelection').off().on('change', function() {
			let value = $(this).prop('checked');
			let id = $(this).parent().data('id');

			if(value) {
				self.arrayDelMult.push(id);
			} else {
				let index = self.arrayDelMult.indexOf(id);
				self.arrayDelMult.splice(index, 1);
			}

			// Eventos de los inputs individuales
			deleteSelectionInputActions(self.arrayDelMult);
		});

		// Función de borrado múltiple
		$('#multSelecDelete').off().on('click', function() {
			// Aviso de borrado múltiple
			let objInfo = {
				accept: {
					text: pf.const.language.RSC95
				},
				cancel: {
					text: pf.const.language.RSC57
				}
			};

			let alertTitle = pf.const.language.RSC17;
			let alertText = pf.const.language.RSC1687;
			pf.utils.showInfoDialogAcceptCancel(alertTitle, alertText, objInfo, function() {
				// Comprobación de roles
				self.roleStatus();
			}, function() {});
		});
	},

	roleStatus(id = false) {
		let self = this;

		let roles = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			roles.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				roles.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			roles: JSON.stringify(roles)
		};
		ajaxComunCallWithCallback('roleStatus', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let size = ajaxReturn.result.length
				if(size === 0) {
					// Los roles han sido eliminados
					let successTitle = pf.const.language.RSC17;
					let successContent = pf.const.language.RSC267;
					pf.utils.showInfoDialog(successTitle, successContent);
					loadHTML('inc/roles/roles.html', 'wrapper', RolesController);
				} else {
					// Los siguientes roles no se han podido borrar:
					let warningText = `<p>${pf.const.language.RSC1737}</p>`;

					let defaultR = '';
					let inUse = '';
					for(let i = 0; i < size; i++) {
						if(ajaxReturn.result[i].rolStatus.defaultRole == 1) {
							defaultR = ajaxReturn.result[i].rol;
						} else if(ajaxReturn.result[i].rolStatus.inUse == 1) {
							inUse += ajaxReturn.result[i].rol + ', ';
						}
					}

					// Caso de rol por defecto
					if(defaultR !== '') {
						warningText += `<p>${defaultR} - ${pf.const.language.RSC1631}</p>`;
					}

					// Caso de roles en uso
					if(inUse !== '') {
						inUse = inUse.substring(0, inUse.length - 2);
						warningText += `<p>${inUse} - ${pf.const.language.RSC1738}</p>`;
						warningText += `<p>${pf.const.language.RSC1739}</p>`;
						self.arrayDelMult.push(inUse);
					}

					if(defaultR !== '' && inUse === '') {
						let warningTitle = pf.const.language.RSC17;
						let warningContent = warningText;
						pf.utils.showInfoDialog(warningTitle, warningContent);
						loadHTML('inc/roles/roles.html', 'wrapper', RolesController);
					} else {
						let objInfo = {
							accept: {
								text: pf.const.language.RSC95
							},
							cancel: {
								text: pf.const.language.RSC57
							}
						};

						let alertTitle = pf.const.language.RSC17;
						pf.utils.showInfoDialogCustomWidthAcceptCancelNewStyle(alertTitle, warningText, objInfo, '500px', function() {
							self.deleteRole();
						}, function() {
							loadHTML('inc/roles/roles.html', 'wrapper', RolesController);
						});
					}
				}
			}
		});
	},

	deleteRole(id = false) {
		let self = this;

		let roles = [];
		if(id !== false) {
			let obj = {
				id: id
			}
			roles.push(obj);
		} else {
			let delSize = self.arrayDelMult.length;
			for(let i = 0; i < delSize; i++) {
				let obj = {
					id: self.arrayDelMult[i]
				}
				roles.push(obj);
			}
			self.arrayDelMult = [];
		}

		let parameters = {
			roles: JSON.stringify(roles)
		};
		ajaxComunCallWithCallback('deleteRole', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				let successTitle = pf.const.language.RSC17;
				let successContent = pf.const.language.RSC267;
				pf.utils.showInfoDialog(successTitle, successContent);
				loadHTML('inc/roles/roles.html', 'wrapper', RolesController);
			}
		});
	}
};