class TableAnswers {
	constructor(type = 0, actions, survey, questionID) {
		this.type = type;
		this.actionsTable = actions;
		this.survey = survey;
		let qidArray = questionID.split('X');
		this.qid = qidArray.pop();
		this.data = null;
		this.modality = null;
		this.code = '';
		this.answer = '';
	}

	setEvents(modality = 'tableModal') {
		let self = this;

		self.modality = modality;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	}

	requestData() {
		let self = this;

		clearGeneralModal();

		let parameters = {
			survey: self.survey,
			qid: self.qid
		};
		ajaxComunCallWithCallback('getTargetsSurveyByQID', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	}

	renderTable() {
		let self = this;

		let table = `
			<table id="${this.modality}" class="table table-hover tr-pointer tRegs">
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC437}">${pf.const.language.RSC437}</th>
						<th scope="col" title="${pf.const.language.RSC127}">${pf.const.language.RSC127}</th>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			let answer = self.data[i].answer;
			switch(answer) {
				case 'Y':
					answer = pf.const.language.RSC120;
					break;
				case 'N':
					answer = pf.const.language.RSC121;
					break;
				case 'M':
					answer = pf.const.language.RSC556;
					break;
				case 'F':
					answer = pf.const.language.RSC557;
					break;
			}

			let code = self.data[i].code || self.data[i].title;

			table += `
				<tr class="c-pointer check-select" data-answer="${answer}" data-code="${code}">
					<td class="text-center" title="${code}">${code}</td>
					<td class="value" title="${answer}">${answer}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		if(this.modality === 'tableModal') {
			$('#headerModalTitle').text(pf.const.language.RSC150);
			$('#divTableModal').html(table);
		} else {
			$('#resultTable').html(table);
		}

		let tableAnswer = '';
		if(self.modality === 'tableModal') {
			tableAnswer = $('#' + this.modality).DataTable({
				language: pf.const.language_table,
				scrollY: 300,
				scroller: false,
				paging: true,
				pageLength: 25,
				columnDefs: [
					{width: '90px', targets: 0}
				],
				autoWidth: false,
				aaSorting: []
			});
		} else {
			// Si se necesitase el caso de crear la tabla en página
		}

		setTimeout(function() {
			tableAnswer.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons(this.modality);

		if(self.type === 0) {
			// Detectar click
			$('#' + this.modality + ' tbody').off().on('click', 'tr', function() {
				self.answer = $(this).data('answer');
				self.code = $(this).data('code');
				self.eventsTable();
				$('#closeUser').trigger('click');
			});
		} else {
			// Si se necesitase el caso de selección múltiple
		}
	}

	eventsTable() {
		let self = this;

		let response = {
			answer: self.answer,
			code: self.code
		};

		switch(self.actionsTable) {
			case 'KPISurvey':
				KPISurveysController.clickSurvey(response);
				break;
		}
	}
}