let tableBackendAdminRol = {
	data: null,
	actionsTable: null,
	cpgUser: null,

	setEvents(actions, cpgUser = '') {
		let self = this;

		// Acciones tabla
		self.actionsTable = actions;

		// CPG del administrador a tratar
		self.cpgUser = cpgUser;

		self.requestData();
	},

	requestData() {
		let self = this;

		let parameters = {
			cpgUser: self.cpgUser
		};
		ajaxComunCallWithCallback('getAllAdminRolesMenu', parameters, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	},

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC277}">${pf.const.language.RSC277}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>roles</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr class="rol_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td title="${self.data[i].role}">${self.data[i].role}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC17);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersUser td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableUsers = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');

		// Detectar click
		$('.rol_selected').click(function() {
			self.eventsTable($(this).data('id'));
		});
	},

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'newUser':
				AdministradoresNuevoController.clickEvents(self.data[id]);
				break;
			case 'editUser':
				AdministradoresEditarController.clickEvents(self.data[id]);
				break;
		}
	}
};