let tableBots = {
	data: null,
	actionsTable: null,

	setEvents(actions) {
		let self = this;

		// Acciones tabla
		self.actionsTable = actions;

		if(self.data) {
			self.renderTable();
		} else {
			self.requestData();
		}
	},

	requestData() {
		let self = this;

		ajaxComunCallWithCallback('getAllBots', {}, function(ajaxReturn) {
			if(ajaxReturn) {
				self.data = ajaxReturn.result;
				self.renderTable();
			}
		});
	},

	renderTable() {
		let self = this;

		let table = `
			<table id="tableModal" class="table table-hover tr-pointer" >
				<thead>
					<tr>
						<th scope="col" title="${pf.const.language.RSC98}">${pf.const.language.RSC98}</th>
						<th scope="col" title="${pf.const.language.RSC99}">${pf.const.language.RSC99}</th>
					</tr>
				</thead>

				<thead class="filtersUser">
					<tr>
						<td>directLine</td>
						<td>E-botName</td>
					</tr>
				</thead>

				<tbody>
		`;

		let size = self.data.length;
		for(let i = 0; i < size; i++) {
			table += `
				<tr class="bot_selected c-pointer" data-id="${i}" data-dismiss="modal">
					<td title="${self.data[i].directLine}">${self.data[i].directLine}</td>
					<td title="${self.data[i].botName}">${self.data[i].botName}</td>
				</tr>
			`;
		}

		table += `
				</tbody>
			</table>
		`;

		$('#headerModalTitle').text(pf.const.language.RSC98);
		$('#divTableModal').html(table);

		// Setup - add a text input to each footer cell
		$('#tableModal .filtersUser td').each(function() {
			let value = `<input type="text" class="form-control form-control-sm">`;

			$(this).html(value);
		});

		let tableUsers = $('#tableModal').DataTable({
			language: pf.const.language_table,
			scrollY: 300,
			scroller: false,
			paging: true,
			pageLength: 25,
			autoWidth: false,
			aaSorting: []
		});

		setTimeout(function() {
			tableUsers.columns.adjust();
		}, 200);

		// Ocultar botones de tabla
		hideTableButtons('tableModal');

		// Apply the search
		applyTheSearch(tableUsers, 'filtersUser');

		// Detectar click
		$('.bot_selected').click(function() {
			self.eventsTable($(this).data('id'));
		})
	},

	eventsTable(id) {
		let self = this;

		switch(self.actionsTable) {
			case 'newGroups':
				GruposNuevoController.clickEvents(self.data[id]);
				break;
			case 'editGroups':
				GruposEditarController.clickEvents(self.data[id]);
				break;
			case 'editUser':
				UsuariosEditarController.clickEvents(self.data[id]);
				break;
			case 'newUser':
				UsuariosNuevoController.clickEvents(self.data[id]);
				break;
		}
	}
};